/* 
$Id: orange.cc,v 1.1.1.1 2003/07/02 16:32:07 matthias.urban Exp $
*/
/* 
$Log: orange.cc,v $
Revision 1.1.1.1  2003/07/02 16:32:07  matthias.urban
PUMA version 1.0 imported.

Revision 1.4  2002/05/08 14:06:35  murban
Several bugs fixed.

Revision 1.3  2002/01/21 09:03:33  olaf
made generated tables static

Revision 1.2  2001/03/30 11:44:52  olaf
added support for expression type mapping

Revision 1.1.1.1  2000/01/05 12:43:41  murban
New Puma repository created. Puma directory tree imported as initial version.

Revision 1.1  1999/08/26 10:38:55  olaf
Integration of the Orange scanner generator

Revision 1.3  1994/07/06 18:24:55  olaf
Bessere Formatierung.

 * Revision 1.2  1994/07/06  18:23:34  olaf
 * Einf�gen der RCS Id und Log Eintr�ge.
 *
*/

# include "scanner.h"
# include "symbol.h"
# include "charconst.h"
# include "classes.h"
# include "automaton.h"
# include "expr_names.h"
# include <stdio.h>

int  ParseSource (char*& Name, Automaton& Automaton, ExprNames& Exprs,
		  int& NumExprs);
int  ParseClasses (void);
int  ParseClassDef (CharSet& CharClass);
int  ParseTable (char*& Name, Automaton& Automaton, ExprNames& Exprs,
		 int& NumExprs);
int  ParseLookAheadExpr (Automaton& Automaton, int Expr);
int  ParseRegExpr (Automaton& Automaton);
int  ParseCatExprs (Automaton& Automaton);
int  ParseCatExpr (Automaton& Automaton);
int  ParseBasicExpr (Automaton& Automaton);
void ParsingError (char* Expected);
void NormalizeNFA (Automaton& Automaton);
void ConstructDFA (Automaton& NFA, Automaton& DFA, State **ExprTab);
void EpsilonClosure (List& States, List& Closure);
void Move (List& States, ClassId Id, List& Result);
void OptimizeDFA (Automaton& In, Automaton& Out,
		  State **ExprTab, int NumOfExprs);
int  PartitionGroup (List* Group, int& MaxGroup, List& Partitions);
int  InOneGroup (State* State1, State* State2);
void PrintCharMap (char *Name);
void SetStateNumbers (Automaton& Automaton);
void PrintExprTab (char* Name, Automaton& OptimizedDFA,
		   State **ExprTab, int NumOfExprs);
void PrintTransitionTable (char* Name, Automaton& Automaton);
int  MaxSize (State* State);
int PositionState (State* State, int *TransitionTab, int *ControlTab, 
		   int& End);

Token LookAhead;

int main (int argc, char **argv)
 { Automaton NFA, DFA, OptimizedDFA;
   ExprNames Exprs;
   char* Name;
   State **ExprTab;
   int NumOfExprs, CurrExpr;
   
   if (argc != 2)
    { printf ("usage: ttgen filename\n");
      return 1;
    }
   if (BeginScanning (argv[1]) == -1)
    { printf ("ttgen: unable to open source file %s.\n", argv[1]);
      return 1;
    }  

   NextToken(&LookAhead);
   if (ParseSource (Name, NFA, Exprs, NumOfExprs)== -1)
      return 1;
   ExprTab = new State*[NumOfExprs];
   for (CurrExpr = 0; CurrExpr < NumOfExprs; CurrExpr++)
      ExprTab[CurrExpr] = (State*)-1;

/*
   printf ("Map of Char Sets\n");
   PrintClasses ();
   printf ("\nRelationList\n");
   PrintRelationList ();
*/
   NormalizeNFA (NFA);
   ConstructDFA (NFA, DFA, ExprTab);
/*   DFA.Print (); */
   OptimizeDFA (DFA, OptimizedDFA, ExprTab, NumOfExprs);
/*   OptimizedDFA.Print (); */
   PrintCharMap (Name);
   Exprs.print (Name);
   SetStateNumbers (OptimizedDFA);
   PrintExprTab (Name, OptimizedDFA, ExprTab, NumOfExprs);
   PrintTransitionTable (Name, OptimizedDFA);
   delete[] ExprTab;
   DeleteAllSymbols ();
   EndScanning ();
   return 0;
 }

void ParsingError (const char* Expected)
 { printf ("Parsing Error: expected ");
   printf (Expected);
   printf (" instead of ");
   switch (LookAhead.Type)
    { case NAME :
	 printf ("Name %s", GetSymbolText (LookAhead.Index));
	 break;
      case STRING :
         printf ("String \"%s\"", GetSymbolText (LookAhead.Index));
	 break;
      case CHAR :
         printf ("Character \'%s\'", GetSymbolText (LookAhead.Index));
	 break;
      case OPEN_BRACKET :
         printf ("\'(\'");
	 break;
      case CLOSE_BRACKET :
	 printf ("\')\'");
	 break;
      case OPEN_SQUARE_BRACKET :
	 printf ("\'[\'");
	 break;
      case CLOSE_SQUARE_BRACKET :
	 printf ("\']\'");
	 break;
      case COLON :
         printf ("\':\'");
	 break;
      case IS :
	 printf ("\'=\'");
	 break;
      case TO :
	 printf ("\'-\'");
	 break;
      case HASH_MARK :
         printf ("\'#\'");
	 break;
      case MAP_TO :
         printf ("\'=>\'");
	 break;
      case LOOK_AHEAD :
         printf ("\'/\'");
	 break;
      case OR :
	 printf ("\'|\'");
	 break;
      case STAR :
	 printf ("\'*\'");
	 break;
      case PLUS :
         printf ("\'+\'");
	 break;
      case EPSILON :
         printf ("\'E\'");
	 break;
      case TABLE :
         printf ("\'TABLE\'");
	 break;
      case CLASSES :
	 printf ("\'CLASSES\'");
	 break;
      case END :
         printf ("end of file");
	 break;
      case ERROR :
         printf ("invalid token");
         break;
      default :
         printf ("unknown token");
         break;
    }
   printf (" at %02ld,%02ld.\n", 
	   GetSymbolRow (LookAhead.Index),
	   GetSymbolColumn (LookAhead.Index));
 }


int ParseSource (char*& Name, Automaton& Automaton, ExprNames& Exprs,
		 int& NumExprs)
 { 
   if (LookAhead.Type == CLASSES)
    { NextToken(&LookAhead);
      if (ParseClasses ()== -1)
	 return -1;
    }
   if (LookAhead.Type == TABLE)
    { NextToken(&LookAhead);
      if (ParseTable (Name, Automaton, Exprs, NumExprs) == -1)
	 return -1;
    }
   if (LookAhead.Type != END)
    { ParsingError("End");
      return -1;
    }

   return 0;
 }

int ParseClasses (void)
 { CharSet    CharClass;
   TableIndex ClassName;

   if (LookAhead.Type != COLON)
    { ParsingError ("Symbol \':\'");
      return -1;
    }
   NextToken (&LookAhead);
   while (LookAhead.Type == NAME)
    { ClassName = LookAhead.Index;
      NextToken (&LookAhead);
      if (LookAhead.Type != IS)
       { ParsingError ("\'=\'");
	 return -1;
       }
      NextToken (&LookAhead);
      if (ParseClassDef (CharClass) == -1)
          return -1;
      NewClass ((char *)GetSymbolText (ClassName),
		CharClass);
      CharClass.DeleteAll ();
    }
   return 0;
 }

int ParseClassDef (CharSet& CharClass)
 { unsigned char From, To;

   do
    { if (LookAhead.Type != CHAR)
       { ParsingError ("Character Constant");
	 return -1;
       }
      StringToChar (GetSymbolText(LookAhead.Index), From);
      NextToken(&LookAhead);
      if (LookAhead.Type == TO)
       { NextToken (&LookAhead);
	 if (LookAhead.Type != CHAR)
	  { ParsingError ("Second Character Constant");
	    return -1;
	  }
	 StringToChar(GetSymbolText(LookAhead.Index), To);
	 NextToken (&LookAhead);
       }
      else
	 To = From;
      CharClass.Insert (From, To);
    }
   while (LookAhead.Type == CHAR);
   return 0;
 }

int ParseTable (char*& Name, Automaton& BuildAutomaton, ExprNames& Exprs,
		int& NumExprs)
 { Automaton NextAutomaton;

   if (LookAhead.Type != NAME)
    { ParsingError ("Name of Table");
      return -1;
    }
   Name = (char *)GetSymbolText (LookAhead.Index);
   NextToken (&LookAhead);
   if (LookAhead.Type != COLON)
    { ParsingError ("\':\'");
      return -1;
    }
   NextToken (&LookAhead);
   BuildAutomaton.Start = BuildAutomaton.AddState ();
   BuildAutomaton.End   = NULL;  /* mehrere Enden */
   NumExprs = 0;
   do
    { if (ParseLookAheadExpr (NextAutomaton, NumExprs) == -1)
	 return -1;
      if (LookAhead.Type == MAP_TO)
       { NextToken (&LookAhead);
         if (LookAhead.Type != NAME)
	  { ParsingError ("Name for expression");
	    return -1;
	  }
	 Exprs.add ((char*)GetSymbolText (LookAhead.Index));
       }
      else if (LookAhead.Type == HASH_MARK)
       { Exprs.add ((char*)0);
       }
      else
       { ParsingError ("Expression Delimiter \'#\'");
	 return -1;
       }
      BuildAutomaton.ShiftStates (NextAutomaton);
      BuildAutomaton.Start->AddTransition (EPSILON_TRANS, NextAutomaton.Start);
      NextToken (&LookAhead);
      NumExprs++;
    }
   while (LookAhead.Type!=END);
   return 0;
 }

int ParseLookAheadExpr (Automaton& BuildAutomaton, int Expr)
 { Automaton LookAheadAutomaton;

   if (ParseRegExpr (BuildAutomaton) == -1)
      return -1;
   if (LookAhead.Type == LOOK_AHEAD)
    { NextToken (&LookAhead);
      if (ParseRegExpr (LookAheadAutomaton) == -1)
	 return -1;
      BuildAutomaton.ShiftStates (LookAheadAutomaton);
      BuildAutomaton.End->ShiftTransitionList (LookAheadAutomaton.Start);
      BuildAutomaton.End->Type      = NORMAL_STATE;
      BuildAutomaton.End->Expr (Expr);
      BuildAutomaton.End->LookAhead = 1;
      BuildAutomaton.RemoveState (LookAheadAutomaton.Start);
      BuildAutomaton.End = LookAheadAutomaton.End;
      BuildAutomaton.End->Type      = LOOK_AHEAD_END_STATE;
      BuildAutomaton.End->Expr (Expr);
    }
   else
    { BuildAutomaton.End->Type = END_STATE;
      BuildAutomaton.End->Expr (Expr);
    }
   return 0;
 }

int ParseRegExpr (Automaton& BuildAutomaton)
 { Automaton NextAutomaton;
   State* OldStart;
   State* OldEnd;

   if (ParseCatExprs (BuildAutomaton) == -1)
      return -1;
   if (LookAhead.Type != OR)
      return 0;
   OldStart = BuildAutomaton.Start;
   OldEnd   = BuildAutomaton.End;
   BuildAutomaton.Start = BuildAutomaton.AddState ();
   BuildAutomaton.Start->AddTransition (EPSILON_TRANS, OldStart);
   BuildAutomaton.End   = BuildAutomaton.AddState ();
   OldEnd->AddTransition (EPSILON_TRANS, BuildAutomaton.End);
   do
    { NextToken (&LookAhead);
      if (ParseCatExprs (NextAutomaton) == -1)
	 return -1;
      BuildAutomaton.ShiftStates (NextAutomaton);
      BuildAutomaton.Start->AddTransition (EPSILON_TRANS, NextAutomaton.Start);
      NextAutomaton.End->AddTransition (EPSILON_TRANS, BuildAutomaton.End);
    } while (LookAhead.Type == OR);
   return 0;
 }

int ParseCatExprs (Automaton& BuildAutomaton)
 { Automaton NextAutomaton;

   if (ParseCatExpr (BuildAutomaton) == -1)
      return -1;
   while ((LookAhead.Type == STRING)             ||
          (LookAhead.Type == NAME)               ||
	  (LookAhead.Type == EPSILON)            ||
	  (LookAhead.Type == CHAR)               ||
	  (LookAhead.Type == OPEN_BRACKET)       ||
	  (LookAhead.Type == OPEN_SQUARE_BRACKET)   )
    { if (ParseCatExpr (NextAutomaton) == -1)
	 return -1;
      BuildAutomaton.ShiftStates (NextAutomaton);
      BuildAutomaton.End->ShiftTransitionList (NextAutomaton.Start);
      BuildAutomaton.RemoveState (NextAutomaton.Start);
      BuildAutomaton.End = NextAutomaton.End;
    }
   return 0;
 }

int ParseCatExpr (Automaton& BuildAutomaton)
 { State* NewStart;
   State* NewEnd;

   if (ParseBasicExpr (BuildAutomaton) == -1)
      return -1;
   switch (LookAhead.Type)
    { case STAR:
	 NextToken (&LookAhead);
	 BuildAutomaton.End->AddTransition (EPSILON_TRANS, 
					    BuildAutomaton.Start);
	 NewStart = BuildAutomaton.AddState ();
	 NewEnd   = BuildAutomaton.AddState ();
	 NewStart->AddTransition (EPSILON_TRANS, BuildAutomaton.Start);
	 BuildAutomaton.End->AddTransition (EPSILON_TRANS, NewEnd);
	 NewStart->AddTransition (EPSILON_TRANS, NewEnd);
	 BuildAutomaton.Start = NewStart;
	 BuildAutomaton.End   = NewEnd;
	 break;
      case PLUS:
	 NextToken (&LookAhead);
	 BuildAutomaton.End->AddTransition (EPSILON_TRANS, 
					    BuildAutomaton.Start);
	 NewStart = BuildAutomaton.AddState ();
	 NewEnd   = BuildAutomaton.AddState ();
	 NewStart->AddTransition (EPSILON_TRANS, BuildAutomaton.Start);
	 BuildAutomaton.End->AddTransition (EPSILON_TRANS, NewEnd);
	 BuildAutomaton.Start = NewStart;
	 BuildAutomaton.End   = NewEnd;
	 break;
    }
   while ((LookAhead.Type == STAR)||(LookAhead.Type == PLUS))
    { printf ("Ingnored * or + ");
      NextToken (&LookAhead);
    }
   return 0;
 }

int ParseBasicExpr (Automaton& BuildAutomaton)
 { unsigned char NewChar;
   unsigned char* StringScanContext;
   State* NewState;

   switch (LookAhead.Type)
    { case STRING : 
	 BuildAutomaton.Start = BuildAutomaton.End = 
	  BuildAutomaton.AddState ();
	 StringScanContext = GetSymbolText (LookAhead.Index);
	 while ((NewChar = ScanString (StringScanContext)) != '\0')
	  { NewSingleChar (NewChar);
	    NewState = BuildAutomaton.AddState ();
	    BuildAutomaton.End->AddTransition (CHAR_TRANS, NewChar, NewState);
	    BuildAutomaton.End = NewState;
	  }
         NextToken (&LookAhead);
         break;
      case NAME : 
	 BuildAutomaton.Start = BuildAutomaton.AddState ();
	 BuildAutomaton.End   = BuildAutomaton.AddState ();
	 BuildAutomaton.Start->AddTransition (CLASS_NAME_TRANS, (char*)
					      GetSymbolText (LookAhead.Index),
					      BuildAutomaton.End);
         NextToken (&LookAhead);
         break;
      case EPSILON : 
	 BuildAutomaton.Start = BuildAutomaton.AddState ();
	 BuildAutomaton.End   = BuildAutomaton.AddState ();
	 BuildAutomaton.Start->AddTransition (EPSILON_TRANS, 
					      BuildAutomaton.End);
         NextToken (&LookAhead);
         break;
      case CHAR : 
	 if (StringToChar (GetSymbolText (LookAhead.Index),
	     NewChar) == -1)
	  { ParsingError ("Correct Char Const");
	    return -1;
	  }
	 NewSingleChar (NewChar);
	 BuildAutomaton.Start = BuildAutomaton.AddState ();
	 BuildAutomaton.End   = BuildAutomaton.AddState ();
	 BuildAutomaton.Start->AddTransition (CHAR_TRANS, NewChar, 
					      BuildAutomaton.End);
         NextToken (&LookAhead);
         break;
      case OPEN_BRACKET:
	 NextToken (&LookAhead);
	 if (ParseRegExpr (BuildAutomaton) == -1)
	    return -1;
	 if (LookAhead.Type != CLOSE_BRACKET)
	  { ParsingError ("Closing Bracket \')\'");
	    return -1;
	  }
	 NextToken (&LookAhead);
	 break;
      case OPEN_SQUARE_BRACKET:
	 NextToken (&LookAhead);
	 if (ParseRegExpr (BuildAutomaton) == -1)
	    return -1;
	 if (LookAhead.Type != CLOSE_SQUARE_BRACKET)
	  { ParsingError ("Closing Bracket \']\'");
	    return -1;
	  }
	 BuildAutomaton.Start->AddTransition (EPSILON_TRANS, 
					      BuildAutomaton.End);
	 NextToken (&LookAhead);
	 break;
      default:
	 ParsingError ("String, Class Name, Epsilon, Character "
		       "or Opening Bracket");
	 return -1;
    }
   return 0;
 }

void NormalizeNFA (Automaton& BuildAutomaton)
 { ListEntry* StateContext;
   ListEntry* TransitionContext;
   State* CurrState;
   Transition* CurrTransition;
   struct ClassIdEntry* IdContext;
   ClassId Id;

   BuildAutomaton.ScanStates (StateContext);
   while ((CurrState = BuildAutomaton.NextState (StateContext)) != NULL)
    { CurrState->NonEpsilonTransitions.StartScanning (TransitionContext);
      CurrTransition = (Transition*)
       (CurrState->NonEpsilonTransitions.GetNext (TransitionContext));
      if (CurrTransition != NULL)
       { switch (CurrTransition->Type)
	  { case CHAR_TRANS:
	       CurrTransition->Id = FindClassId (CurrTransition->Temp.Char);
	       CurrTransition->Type = CHAR_CLASS_TRANS;
	       break;
	    case CLASS_NAME_TRANS:
	       ScanIds (IdContext, CurrTransition->Temp.Name);
	       FindClassIds (IdContext, CurrTransition->Id);
	       CurrTransition->Type = CHAR_CLASS_TRANS;
	       while (FindClassIds (IdContext, Id))
	          CurrState->AddTransition (CHAR_CLASS_TRANS, Id, 
					    CurrTransition->TransitionState);
	       break;
	  }
       }
    }
 }

void ConstructDFA (Automaton& NFA, Automaton& DFA, State **ExprTab)
 { List StartList;
   List* MoveList;
   DFAStateDescriptor* Closure;
   DFAStateDescriptor* CurrState;
   DFAStateDescriptor* NextState;
   Stack Unmarked;
   Stack Marked;
   ClassId Id;
   ListEntry* Context;
   ListEntry* NFAContext;
   int Found;
   State* NFAState;

   StartList.Append (NFA.Start);
   Closure = new DFAStateDescriptor;
   EpsilonClosure (StartList, Closure->NFAStates);
   Closure->DFAState = DFA.Start = DFA.AddState ();
   Unmarked.Push (Closure);

   while (!Unmarked.Empty ())
    { CurrState = (DFAStateDescriptor *)Unmarked.Pop ();
      Marked.Push (CurrState);
      ScanClassIds ();
      while (NextClassId (Id) != -1)
       { MoveList = new List;
	 Move (CurrState->NFAStates, Id, *MoveList);
	 if (!MoveList->Empty ())
	  { Closure = new DFAStateDescriptor;
	    EpsilonClosure (*MoveList, Closure->NFAStates);
	    delete MoveList;

	    Found = 0;
            Unmarked.StartScanning (Context);
	    while (!Found &&
	           ((NextState = (DFAStateDescriptor*)
		   (Unmarked.GetNext (Context))) != NULL))
	     { if (NextState->NFAStates.IsEqual (Closure->NFAStates))
	          Found = 1;
	     }
            Marked.StartScanning (Context);
	    while (!Found &&
	           ((NextState = (DFAStateDescriptor*)
		   (Marked.GetNext (Context))) != NULL))
	     { if (NextState->NFAStates.IsEqual (Closure->NFAStates))
	          Found = 1;
	     }
	    if (!Found)
	     { Closure->DFAState = DFA.AddState ();
	       Unmarked.Push (Closure);
	       CurrState->DFAState->AddTransition (CHAR_CLASS_TRANS, Id,
		                                   Closure->DFAState);
	     }
	    else
	     { delete Closure;
	       CurrState->DFAState->AddTransition (CHAR_CLASS_TRANS, Id,
		     				   NextState->DFAState);
	     }
	  }
	 else
	    delete MoveList;
       }
    }
   Marked.StartScanning (Context);
   while ((CurrState = (DFAStateDescriptor*)Marked.GetNext (Context)) !=
	  NULL)
    { CurrState->NFAStates.StartScanning (NFAContext);
      while ((NFAState = (State*)(CurrState->NFAStates.GetNext (NFAContext)))
	     != NULL)
       { if (NFAState->LookAhead)
	  { CurrState->DFAState->LookAhead = 1;
	    ExprTab[NFAState->Expr ()] = CurrState->DFAState;
	  }
	 if (NFAState->Type != NORMAL_STATE)
	  { if (CurrState->DFAState->Type != NORMAL_STATE)
	     { if (NFAState->Expr () < CurrState->DFAState->Expr ())
		{ CurrState->DFAState->Expr (NFAState->Expr ());
		  CurrState->DFAState->Type = NFAState->Type;
		}
	     }
	    else
	     { CurrState->DFAState->Expr (NFAState->Expr ());
	       CurrState->DFAState->Type = NFAState->Type;
	     }
	  }
       }
      delete CurrState;
    }
 }

void EpsilonClosure (List& States, List& Closure)
 { Stack       xStack;
   State*      xState;
   ListEntry*  Context;
   Transition* xTransition;

   Closure.CopyEntries (States);
   xStack.PushList (States);

   while (!xStack.Empty ())
    { xState = (State*)(xStack.Pop ());
      xState->EpsilonTransitions.StartScanning (Context);
      while ((xTransition = (Transition*)
	      (xState->EpsilonTransitions.GetNext (Context))) != NULL)
       { if (!Closure.IsIn (xTransition->TransitionState))
	  { Closure.Append (xTransition->TransitionState);
	    xStack.Push (xTransition->TransitionState);
	  }
       }
    }
 }

void Move (List& States, ClassId Id, List& Result)
 { ListEntry* StateContext;
   ListEntry* TransitionContext;
   State* CurrState;
   Transition* CurrTransition;

   States.StartScanning (StateContext);
   while ((CurrState = (State*)(States.GetNext (StateContext))) != NULL)
    { CurrState->NonEpsilonTransitions.StartScanning (TransitionContext);
      while ((CurrTransition = (Transition*)
       (CurrState->NonEpsilonTransitions.GetNext (TransitionContext))) != NULL)
       { if (CurrTransition->Id == Id)
	    Result.Append (CurrTransition->TransitionState);
       }
    }
 }


void OptimizeDFA (Automaton& In, Automaton& Out,
		  State **ExprTab, int NumOfExprs)
 { List        Groups, Partitions, NewPartitions;
   List*       MainGroup;
   List*       EndStateGroup;
   List*       CurrGroup;
   State*      CurrState;
   State*      FirstState;
   ListEntry*  Context1;
   ListEntry*  Context2;
   ListEntry*  Context3;
   int         MaxGroup;
   int         Found;
   int         Changed;
   int         CurrExpr;
   Transition* CurrTransition;
   
   /* Initialisierung */

   MaxGroup = 0;
   MainGroup = new List;
   In.ScanStates (Context1);
   while ((CurrState = In.NextState (Context1)) != NULL)
    { if (CurrState->Type == NORMAL_STATE)
       { CurrState->Group = 0;
	 MainGroup->Append (CurrState);
       }
      else
       { Groups.StartScanning (Context2);
	 Found = 0;
	 while (((CurrGroup = (List *)(Groups.GetNext (Context2))) != NULL) &&
		(!Found))
	  { CurrGroup->StartScanning (Context3);
	    FirstState = (State *)(CurrGroup->GetNext (Context3));
	    if (FirstState->Expr () == CurrState->Expr ())
	     { Found = 1;
	       EndStateGroup = CurrGroup;
	       CurrState->Group = FirstState->Group;
	     }
	  }
	 if (Found)
	    EndStateGroup->Append (CurrState);
	 else
	 { CurrState->Group = ++MaxGroup;
	   EndStateGroup = new List;
	   EndStateGroup->Append (CurrState);
	   Groups.Append (EndStateGroup);
	 }
       }
    }
   Groups.Append (MainGroup);

   /* Partitionieren */

   do
    { Changed = 0;
      Groups.StartScanning (Context1);
      while ((CurrGroup = (List *)(Groups.GetNext (Context1))) != NULL)
       { if (PartitionGroup (CurrGroup, MaxGroup, NewPartitions))
	    Changed = 1;
	 Partitions.ShiftEntries (NewPartitions);
       }      
      Groups.ShiftEntries (Partitions);
    } while (Changed);

   /* Resultat erstellen */

   Groups.StartScanning (Context1);
   while ((CurrGroup = (List *)(Groups.GetNext (Context1))) != NULL)
    { CurrGroup->StartScanning (Context2);
      FirstState = (State *)(CurrGroup->GetNext (Context2));
      FirstState->Representative = FirstState;
      while ((CurrState = (State *)(CurrGroup->GetNext (Context2))) != NULL)
       { CurrState->Representative = FirstState;
	 if (CurrState->LookAhead)
	  { FirstState->LookAhead = 1;
	    for (CurrExpr = 0; CurrExpr < NumOfExprs; CurrExpr++)
	       if (ExprTab[CurrExpr] == CurrState)
		  ExprTab[CurrExpr] = CurrState->Representative;
	  }
	 if (CurrState->Type != NORMAL_STATE)
	  { if (FirstState->Type != NORMAL_STATE)
	     { if (CurrState->Expr () < FirstState->Expr ())
		{ FirstState->Expr (CurrState->Expr ());
		  FirstState->Type = CurrState->Type;
		}
	     }
	    else
	     { FirstState->Expr (CurrState->Expr ());
	       FirstState->Type = CurrState->Type;
	     }
	  }
       }
    }
   Groups.StartScanning (Context1);
   while ((CurrGroup = (List *)(Groups.GetNext (Context1))) != NULL)
    { CurrGroup->StartScanning (Context2);
      FirstState = (State *)(CurrGroup->GetNext (Context2));
      Out.ShiftState (In, FirstState);
      FirstState->NonEpsilonTransitions.StartScanning (Context3);
      while ((CurrTransition = (Transition *)
	      (FirstState->NonEpsilonTransitions.GetNext (Context3))) != NULL)
	 CurrTransition->TransitionState = CurrTransition->TransitionState->Representative;
    }
   Out.Start = In.Start->Representative;
 }

int PartitionGroup (List* Group, int& MaxGroup, List& Partitions)
 { ListEntry* Context;
   List*      OtherGroup;
   State*     FirstState;
   State*     CurrState;

   OtherGroup = new List;
   Group->StartScanning (Context);
   FirstState = (State*)(Group->GetNext (Context));
   while ((CurrState = (State*)(Group->GetNext (Context))) != NULL)
    { if (!InOneGroup (FirstState, CurrState))
       { OtherGroup->Append (CurrState);
	 Group->Remove (CurrState);
         CurrState->Group = MaxGroup + 1;
       }
    }
   if (!OtherGroup->Empty ())
    { MaxGroup++;
      PartitionGroup (OtherGroup, MaxGroup, Partitions);
      Partitions.Append(OtherGroup);
      return 1;
    }
   else
    { delete OtherGroup;
      return 0;
    }
 }

int InOneGroup (State* State1, State* State2)
 { ListEntry*  Context1;
   ListEntry*  Context2;
   Transition* Transition1;
   Transition* Transition2;
   int         IdFound;

   if (State1->NonEpsilonTransitions.Length () !=
       State2->NonEpsilonTransitions.Length ())
      return 0;
   State1->NonEpsilonTransitions.StartScanning (Context1);
   while ((Transition1 = (Transition*)
	   (State1->NonEpsilonTransitions.GetNext (Context1))) != NULL)
    { IdFound = 0;
      State2->NonEpsilonTransitions.StartScanning (Context2);
      while ((Transition2 = (Transition*)
	      (State2->NonEpsilonTransitions.GetNext (Context2))) != NULL)
       { if (Transition1->Id == Transition2->Id)
	  { IdFound = 1;
	    if (Transition1->TransitionState->Group != 
		Transition2->TransitionState->Group)
	       return 0;
	  }
       }
      if (!IdFound)
	 return 0;
    }
   return 1;
 }

void PrintCharMap (char *Name)
 { CharSet       CurrChars;
   int           Id;
   int           CharMap[256];
   int           Char;
   int           Line;

   for (Char = 0; Char < 256; Char++)
      CharMap[Char] = -1;
   ScanClassMap ();
   while (NextEntry (Id, CurrChars) != -1)
      for (Char = 0; Char < 256; Char++)
         if (CurrChars.In ((unsigned char)Char))
	    CharMap[Char] = (int)Id;
   printf ("static char %sMap[256] =\n", Name);
   for (Line = 0; Line < 32; Line++)
      switch (Line)
       { case 0 :
	    printf (" { %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d,\n",
		    CharMap[0], CharMap[1], CharMap[2], CharMap[3],
		    CharMap[4], CharMap[5], CharMap[6], CharMap[7]);
	    break;
	 case 31:
	    printf ("   %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d\n };\n\n",
		    CharMap[248], CharMap[249], CharMap[250], CharMap[251],
		    CharMap[252], CharMap[253], CharMap[254], CharMap[255]);
	    break;
	 default:
	    printf ("   %3d, %3d, %3d, %3d, %3d, %3d, %3d, %3d,\n",
		    CharMap[8 * Line + 0], CharMap[8 * Line + 1], 
		    CharMap[8 * Line + 2], CharMap[8 * Line + 3],
		    CharMap[8 * Line + 4], CharMap[8 * Line + 5],
		    CharMap[8 * Line + 6], CharMap[8 * Line + 7]);
	    break;
       }
 }

void SetStateNumbers (Automaton& Automaton)
 { ListEntry* Context;
   int        Number;
   State*     CurrState;

   Number = 0;
   Automaton.ScanStates (Context);
   while ((CurrState = Automaton.NextState (Context)) != NULL)
      CurrState->Number = Number++;
 }

void PrintExprTab (char* Name, Automaton& OptimizedDFA,
		   State **ExprTab, int NumOfExprs)
 { int        CurrExpr;
   int        Lines, CurrLine;

   for (CurrExpr = 0, Lines = 0; CurrExpr < NumOfExprs; CurrExpr++)
      if (ExprTab[CurrExpr] != (State *)-1)
	 Lines++;

   for (CurrExpr = 0, CurrLine = 0; CurrExpr < NumOfExprs; CurrExpr++)
    { if (ExprTab[CurrExpr] != (State *)-1)
       { if (CurrLine == 0)
	    printf ("static int %sLookAheadTab[][2] =\n { ", Name);
	 else
	    printf ("   ");
	 printf (" { %3d, %3d }", CurrExpr, ExprTab[CurrExpr]->Number);
         if (CurrLine < Lines - 1)
	     printf (",\n");
	 else
	     printf ("\n };\n\n");
	 CurrLine++;
       }
    }
 }

void PrintTransitionTable (char* Name, Automaton& Automaton)
 { ListEntry* Context;
   State*     CurrState;
   int        Size;
   int        TabEnd;
   int        Start;
   int        Count;
   int        Elem;
   int        NumOfStates;
   int        *StartTab;
   int        *TransitionTab;
   int        *ControlTab;

   printf ("static int %sStart = %d;\n\n", Name, Automaton.Start->Number);
   Size = 0;
   NumOfStates = 0;
   Automaton.ScanStates (Context);
   while ((CurrState = Automaton.NextState (Context)) != NULL)
    { Size += MaxSize (CurrState);
      NumOfStates++;
    }
   StartTab      = new int[NumOfStates];
   TransitionTab = new int[Size];
   ControlTab    = new int[Size];
   for (Count = 0; Count < Size; Count++)
    { TransitionTab[Count] = -1;
      ControlTab[Count]    = -1;
    }

   printf ("#ifndef __TTGEN__\n"
	   "#  define __TTGEN__\n\n"
	   "   typedef struct\n"
	   "    { unsigned char Type;\n"
	   "      unsigned char LookAhead;\n"
	   "      int           Expression;\n"
	   "      int           Start;\n"
	   "    } States;\n\n"
	   "#endif\n\n"
	   "static States %sStates[] =\n", Name);
   TabEnd   = 0;
   Automaton.ScanStates (Context);
   while ((CurrState = Automaton.NextState (Context)) != NULL)
    { Start = PositionState (CurrState, TransitionTab, ControlTab, TabEnd);
      StartTab[CurrState->Number] = Start;
      if (CurrState->Number == 0)
         printf (" { ");
      else
	 printf ("   ");
      printf (" { %1d, %1d, %5d, %5d }", CurrState->Type, 
	      CurrState->LookAhead, CurrState->Expr (), Start);
      if (CurrState->Number == NumOfStates - 1)
         printf ("\n };\n");
      else
	 printf (",\n");
    }
   printf ("\n");
   for (Count = 0; Count <= TabEnd; Count += 8)
    { if (Count < 8)
	 printf ("static int %sNext[] =\n"
		 " { ", Name);
      else
	 printf ("   ");
      if (TabEnd - Count >= 8)
	 printf ("%5d, %5d, %5d, %5d, %5d, %5d, %5d, %5d,\n",
		 TransitionTab[Count + 0], TransitionTab[Count + 1],
		 TransitionTab[Count + 2], TransitionTab[Count + 3],
		 TransitionTab[Count + 4], TransitionTab[Count + 5],
		 TransitionTab[Count + 6], TransitionTab[Count + 7]);
      else
	 for (Elem = Count; Elem <= TabEnd; Elem++)
	    if (Elem < TabEnd)
	       printf ("%5d, ", TransitionTab[Elem]);
            else
	       printf ("%5d\n };\n", TransitionTab[Elem]);
    }
   printf ("\n");
   for (Count = 0; Count <= TabEnd; Count += 8)
    { if (Count < 8)
	 printf ("static int %sControl[] =\n"
		 " { ", Name);
      else
	 printf ("   ");
      if (TabEnd - Count >= 8)
	 printf ("%5d, %5d, %5d, %5d, %5d, %5d, %5d, %5d,\n",
		 ControlTab[Count + 0], ControlTab[Count + 1],
		 ControlTab[Count + 2], ControlTab[Count + 3],
		 ControlTab[Count + 4], ControlTab[Count + 5],
		 ControlTab[Count + 6], ControlTab[Count + 7]);
      else
	 for (Elem = Count; Elem <= TabEnd; Elem++)
	    if (Elem < TabEnd)
	       printf ("%5d, ", ControlTab[Elem]);
            else
	       printf ("%5d\n };\n", ControlTab[Elem]);
    }
   printf ("\n");
   delete[] TransitionTab;
   delete[] ControlTab;
   delete[] StartTab;
 }

int MaxSize (State* State)
 { int         MinId, MaxId;
   ListEntry*  Context;
   Transition* CurrTransition;
   
   State->NonEpsilonTransitions.StartScanning (Context);
   CurrTransition = (Transition*)
      (State->NonEpsilonTransitions.GetNext (Context));
   if (CurrTransition == NULL)
      return 0;
   MinId = CurrTransition->Id.GetId ();
   MaxId = CurrTransition->Id.GetId ();
   while ((CurrTransition = (Transition*)
      (State->NonEpsilonTransitions.GetNext (Context))) != NULL)
    { if (CurrTransition->Id.GetId () < MinId)
	 MinId = CurrTransition->Id.GetId ();
      if (CurrTransition->Id.GetId () > MaxId)
	 MaxId = CurrTransition->Id.GetId ();
    }
   return MaxId - MinId + 1;
 }

int PositionState (State* State, int *TransitionTab, int *ControlTab, int& End)
 { int         MinId, MaxId;
   ListEntry*  Context;
   Transition* CurrTransition;
   int         Start;
   int         Pos;
   int         Collision;

   State->NonEpsilonTransitions.StartScanning (Context);
   CurrTransition = (Transition*)
      (State->NonEpsilonTransitions.GetNext (Context));
   if (CurrTransition == NULL)
      return 0;
   MinId = CurrTransition->Id.GetId ();
   while ((CurrTransition = (Transition*)
      (State->NonEpsilonTransitions.GetNext (Context))) != NULL)
      if (CurrTransition->Id.GetId () < MinId)
	 MinId = CurrTransition->Id.GetId ();
   Start = - MinId;
   do
    { State->NonEpsilonTransitions.StartScanning (Context);
      Collision = 0;
      do
       { CurrTransition = (Transition*)
	  (State->NonEpsilonTransitions.GetNext (Context));
	 if (CurrTransition != NULL)
	    if (ControlTab[Start + CurrTransition->Id.GetId ()] != -1)
	       Collision = 1;
       } while (CurrTransition != NULL && (!Collision));
      if (Collision)
	 Start++;
    } while (Collision);
   State->NonEpsilonTransitions.StartScanning (Context);
   while ((CurrTransition = (Transition*)
      (State->NonEpsilonTransitions.GetNext (Context))) != NULL)
    { Pos = Start + CurrTransition->Id.GetId ();
      TransitionTab[Pos] = CurrTransition->TransitionState->Number;
      ControlTab[Pos]    = State->Number;
      if (Pos > End)
	 End = Pos;
    }
   return Start;
 }
