// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/CStructure.h"
#include "Puma/CFunctionInfo.h"
#include "Puma/CAttributeInfo.h"
#include "Puma/CTemplateInfo.h"
#include "Puma/CTemplateParamInfo.h"
#include "Puma/CEnumInfo.h"
#include "Puma/CClassInfo.h"
#include "Puma/CUnionInfo.h"
#include "Puma/CTypedefInfo.h"
#include "Puma/CTypeInfo.h"
#include "Puma/CNamespaceInfo.h"
#include "Puma/CArgumentInfo.h"
#include "Puma/CFileInfo.h"
#include "Puma/CNamespaceInfo.h"
#include "Puma/CMemberAliasInfo.h"
#include "Puma/CUsingInfo.h"
#include <string.h>
#include <assert.h>
#include <iostream>
using namespace std;

namespace Puma {


void CStructure::setShared (CStructure *info) {
  _Shared = info->_Shared;
}

void CStructure::removeRegisterEntry () {
  ObjectsByName::iterator i;
  ObjectInfoList::iterator j;
  
  for (i = ObjectInfoMap ().begin (); i != ObjectInfoMap ().end (); ++i) {
    ObjectInfoList &entry = i->second;
    for (j = entry.begin(); j != entry.end(); ++j)
      (*j)->Unregister (_Shared);
  }
}

void CStructure::removeObjectName (const DString& name, CObjectInfo *info) {
  CStructure::ObjectsByName::iterator sameNameListIter = ObjectInfoMap().find(name);
  if (sameNameListIter != ObjectInfoMap().end()) {
    CStructure::ObjectInfoList& sameNameList = sameNameListIter->second;
    for (CStructure::ObjectInfoList::iterator iter = sameNameList.begin(); iter != sameNameList.end(); iter++) {
      if (*iter == info) {
        sameNameList.erase(iter);
        break;
      }
    }
  }
}

void CStructure::addObjectName (CObjectInfo *info) {
  // This check is only needed if called externally from CObjectInfo->Name(..)
  if (_Shared->_ObjectSet.find(info) != _Shared->_ObjectSet.end()) {
    CObjectInfo* real = info->MemberAliasInfo() !=0 ?info->MemberAliasInfo()->Member(): info;
    real = info;
    if (real && !real->Name().empty()) {
      _Shared->_ObjectMap[real->Name()].push_back(info);
    }
    if (! info->isRegistered(_Shared))
      info->Register (_Shared);
  }        
}

void CStructure::addObject (CObjectInfo *info) {
  //static int indent=0;         
  _Shared->_ObjectSet.insert(info);
  _Objects.append (info); 
  _Shared->addObjectName(info); 
}
 
CStructure::~CStructure () {
//  CObjectInfo *info;
//  for (unsigned i = 0; i < Objects (); i++) {
//    info = Object (i);
////    if (! info->isUser (this)) {      // not only user?
//      if (info->ArgumentInfo ()) {
//        if (info->ArgumentInfo ()->Scope () == this) {
//          info->ArgumentInfo ()->Scope ((CScopeInfo*)0);
//          if (! _DeleteMembersOnly)
//            delete info->ArgumentInfo ();
//        }
//      } else if (info->MemberAliasInfo ()) {
//        if (info->MemberAliasInfo ()->Scope () == this) {
//          info->MemberAliasInfo ()->Scope ((CScopeInfo*)0);
//          if (! _DeleteMembersOnly) 
//            delete info->MemberAliasInfo ();
//        }
//      } else if (info->EnumeratorInfo ()) {
//        if (info->EnumeratorInfo ()->Scope () == this)
//          info->EnumeratorInfo ()->Scope ((CScopeInfo*)0);
//      } else if (info->AttributeInfo ()) {
//        if (info->AttributeInfo ()->Scope () == this) {
//          info->AttributeInfo ()->Scope ((CScopeInfo*)0);
//          if (! _DeleteMembersOnly) 
//            delete info->AttributeInfo ();
//        }
//      } else if (info->EnumInfo ()) {
//        if (info->EnumInfo ()->Scope () == this) {
//          info->EnumInfo ()->Scope ((CScopeInfo*)0);
//          if (! _DeleteMembersOnly)
//            delete info->EnumInfo ();
//        }
//      } else if (info->TypedefInfo ()) {
//        if (info->TypedefInfo ()->Scope () == this) {
//          info->TypedefInfo ()->Scope ((CScopeInfo*)0);
//          if (! _DeleteMembersOnly)
//            delete info->TypedefInfo ();
//        }
//      } 
////    } else
////      info->removeUser (this);
//  }
//  for (unsigned i = 0; i < Usings (); i++) {
//    Using (i)->Scope ((CScopeInfo*)0);
//    if (! _DeleteMembersOnly)
//      delete Using (i);
//  }
}

unsigned CStructure::Functions (const DString& name) const {
  unsigned n = 0;
  for (unsigned i = 0; i < Functions (); i++) 
    if (!Function (i)->Name ().empty() && Function (i)->Name () == name )
      n++;
  return n;
}

unsigned CStructure::Types (const DString& name) const {
  unsigned n = 0;
  for (unsigned i = 0; i < Types (); i++) 
    if (!Type (i)->Name ().empty() && Type (i)->Name () == name)
      n++;
  return n;
}

unsigned CStructure::Objects (const DString& name) const {
  unsigned n = 0;
  for (unsigned i = 0; i < Objects (); i++) 
    if (!Object (i)->Name ().empty() && Object (i)->Name () == name)
      n++;
  return n;
}

unsigned CStructure::Attributes (const DString& name) const {
  unsigned n = 0;
  for (unsigned i = 0; i < Attributes (); i++) 
    if (!Attribute (i)->Name ().empty() && Attribute (i)->Name () == name)
      n++;
  return n;
}

unsigned CStructure::TemplateParams (const DString& name) const {
  unsigned n = 0;
  for (unsigned i = 0; i < TemplateParams (); i++) 
    if (!TemplateParam (i)->Name ().empty() && TemplateParam (i)->Name () == name )
      n++;
  return n;
}

unsigned CStructure::Usings (const DString& name) const {
  unsigned n = 0;
  for (unsigned i = 0; i < Usings (); i++) 
    if (!Using (i)->Name ().empty() && Using (i)->Name () == name)
      n++;
  return n;
}

unsigned CStructure::Namespaces (const DString& name) const {
  unsigned n = 0;
  for (unsigned i = 0; i < Namespaces (); i++) 
    if (!Namespace (i)->Name ().empty() && Namespace (i)->Name () == name)
      n++;
  return n;
}

unsigned CStructure::Friends (const DString& name) const {
  unsigned n = 0;
  for (unsigned i = 0; i < Friends (); i++) 
    if (!Friend (i)->Name ().empty() && Friend (i)->Name () == name)
      n++;
  return n;
}

CFunctionInfo *CStructure::Function (const DString& name, unsigned pos) const {
  unsigned n = 0;
  for (unsigned i = Functions (); i > 0; i--) 
    if (!Function (i-1)->Name ().empty() && Function (i-1)->Name () == name) {
      if (n == pos) 
        return Function (i-1);
      n++;
    }
  return (CFunctionInfo*)0;
}

CObjectInfo *CStructure::Type (const DString& name, unsigned pos) const {
  unsigned n = 0;
  for (unsigned i = Types (); i > 0; i--) 
    if (!Type (i-1)->Name ().empty() && Type (i-1)->Name () == name) {
      if (n == pos) 
        return Type (i-1);
      n++;
    }
  return (CObjectInfo*)0;
}

CObjectInfo *CStructure::Object (const DString& name, unsigned pos) const {
  unsigned n = 0;
  for (unsigned i = Objects (); i > 0; i--) 
    if (!Object (i-1)->Name ().empty() && Object (i-1)->Name () == name) {
      if (n == pos) 
        return Object (i-1);
      n++;
    }
  return (CObjectInfo*)0;
}

CAttributeInfo *CStructure::Attribute (const DString& name, unsigned pos) const {
  unsigned n = 0;
  for (unsigned i = Attributes (); i > 0; i--) 
    if (!Attribute (i-1)->Name ().empty() && Attribute (i-1)->Name () == name) {
      if (n == pos) 
        return Attribute (i-1);
      n++;
    }
  return (CAttributeInfo*)0;
}

CTemplateParamInfo *CStructure::TemplateParam (const DString& name, unsigned pos) const {
  unsigned n = 0;
  for (unsigned i = TemplateParams (); i > 0; i--) 
    if (!TemplateParam (i-1)->Name ().empty() && TemplateParam (i-1)->Name () == name) {
      if (n == pos) 
        return TemplateParam (i-1);
      n++;
    }
  return (CTemplateParamInfo*)0;
}

CUsingInfo *CStructure::Using (const DString& name, unsigned pos) const {
  unsigned n = 0;
  for (unsigned i = Usings (); i > 0; i--) 
    if (!Using (i-1)->Name ().empty() && Using (i-1)->Name () == name) {
      if (n == pos) 
        return Using (i-1);
      n++;
    }
  return (CUsingInfo*)0;
}

CNamespaceInfo *CStructure::Namespace (const DString& name, unsigned pos) const {
  unsigned n = 0;
  for (unsigned i = Namespaces (); i > 0; i--) 
    if (!Namespace (i-1)->Name ().empty() && Namespace (i-1)->Name () == name) {
      if (n == pos) 
        return Namespace (i-1);
      n++;
    }
  return (CNamespaceInfo*)0;
}

CRecord *CStructure::Friend (const DString& name, unsigned pos) const {
  unsigned n = 0;
  for (unsigned i = Friends (); i > 0; i--) 
    if (!Friend (i-1)->Name ().empty() && Friend (i-1)->Name () == name) {
      if (n == pos) 
        return Friend (i-1);
      n++;
    }
  return (CRecord*)0;
}

CFunctionInfo *CStructure::Function (const DString& name, CTypeInfo *info) const {
  for (unsigned i = Functions (); i > 0; i--) 
    if (!Function (i-1)->Name ().empty() && Function (i-1)->Name () == name)
      if (*Function (i-1)->TypeInfo () == *info) 
        return Function (i-1);
  return (CFunctionInfo*)0;
}

void CStructure::addUsing (CUsingInfo *info) { 
  for (unsigned i = Usings (); i > 0; i--) 
    if (Using (i-1) == info) 
      return;
  _Usings.append (info); 
}

void CStructure::addNamespace (CNamespaceInfo *info) { 
  if( info->isRegistered(Structure()) )
          return;
//  for (unsigned i = Namespaces (); i > 0; i--) 
//    if (Namespace (i-1) == info) 
//      return;
  _Namespaces.append (info); 
  addObject (info);
}

void CStructure::addFriend (CRecord *info) { 
  for (unsigned i = Friends (); i > 0; i--) 
    if (Friend (i-1) == info) 
      return;
  _Friends.append (info); 
}

void CStructure::addType (CObjectInfo *info) { 
  if( info->isRegistered(Structure()) )
          return;
//  for (unsigned i = Types (); i > 0; i--) 
//    if (Type (i-1) == info) 
//      return;
  _Types.append (info); 
  addObject (info);
}

void CStructure::addAttribute (CAttributeInfo *info) { 
  if( info->isRegistered(Structure()) )
          return;
//  for (unsigned i = Attributes (); i > 0; i--) 
//    if (Attribute (i-1) == info) 
//      return;
  _Attributes.append (info); 
  addObject (info);
}

void CStructure::addTemplateParam (CTemplateParamInfo *info) { 
  if( info->isRegistered(Structure()) )
          return;
//  for (unsigned i = TemplateParams (); i > 0; i--) 
//   if (TemplateParam (i-1) == info) 
//      return;
  _TemplateParams.append (info); 
  addObject (info);
}

void CStructure::addFunction (CFunctionInfo *info) {
  if( info->isRegistered(Structure()) )
          return;
//  for (unsigned i = Functions (); i > 0; i--) 
//    if (Function (i-1) == info) 
//      return;
  _Functions.append (info); 
  addObject (info);
}

void CStructure::removeAttribute (const CAttributeInfo *info) { 
  CMemberAliasInfo *mainfo;
  if ((mainfo = MemberAlias (info)))
    removeMemberAlias (mainfo);
  else
    for (unsigned i = Attributes (); i > 0; i--) 
      if (Attribute (i-1) == info) {
        _Attributes.remove (i-1); 
        removeObject (info);
        break;
      }
}

void CStructure::removeTemplateParam (const CTemplateParamInfo *info) { 
  for (unsigned i = TemplateParams (); i > 0; i--) 
    if (TemplateParam (i-1) == info) {
      _TemplateParams.remove (i-1); 
      removeObject (info);
      break;
    }
}

void CStructure::removeFunction (const CFunctionInfo *info) { 
  CMemberAliasInfo *mainfo;
  if ((mainfo = MemberAlias (info)))
    removeMemberAlias (mainfo);
  else
    for (unsigned i = Functions (); i > 0; i--) 
      if (Function (i-1) == info) {
        _Functions.remove (i-1); 
        removeObject (info);
        break;
      }
}

void CStructure::removeType (const CObjectInfo *info) { 
  CMemberAliasInfo *mainfo;
  if ((mainfo = MemberAlias (info)))
    removeMemberAlias (mainfo);
  else
    for (unsigned i = Types (); i > 0; i--) 
      if (Type (i-1) == info) {
        _Types.remove (i-1); 
        removeObject (info);
        break;
      }
}

void CStructure::removeObject (const CObjectInfo *info) { 
  for (unsigned i = Objects (); i > 0; i--) 
    if (Object (i-1) == info) {
      // remove from map name->ObjectInfos
      const CObjectInfo* real = info->MemberAliasInfo() !=0 ?info->MemberAliasInfo()->Member(): info;
      // std << "RemoveObject " << real->Name() << " " << (void*)info << " from " << (void*)this << endl;
      if (real->Name())
      {
              ObjectsByName::iterator iter = _Shared->_ObjectMap.find(real->Name());
              //assert(iter != _ObjectMap.end());
              
              if (iter != _Shared->_ObjectMap.end())
              for (ObjectInfoList::iterator liter = iter->second.begin(); liter != iter->second.end(); liter++)
              {
                 if (*liter == info)
                 {
                   iter->second.erase(liter);
                   break;
                 }  
              } 
      }
      _Shared->_ObjectSet.erase((CObjectInfo*)info);
      _Objects.remove (i-1); 
      ((CObjectInfo*)info)->Unregister(Structure());
      break;
    }
}

void CStructure::removeUsing (const CUsingInfo *info) { 
  for (unsigned i = Usings (); i > 0; i--) 
    if (Using (i-1) == info) {
      _Usings.remove (i-1); 
      break;
    }
}

void CStructure::removeNamespace (const CNamespaceInfo *info) { 
  for (unsigned i = Namespaces (); i > 0; i--) 
    if (Namespace (i-1) == info) {
      _Namespaces.remove (i-1); 
      removeObject (info);
      break;
    }
}

void CStructure::removeFriend (const CRecord *info) { 
  for (unsigned i = Friends (); i > 0; i--) 
    if (Friend (i-1) == info) {
      _Friends.remove (i-1); 
      break;
    }
}

void CStructure::removeMemberAlias (const CMemberAliasInfo *info) { 
  for (unsigned i = Objects (); i > 0; i--) 
    if (Object (i-1) == info->ObjectInfo ()) {
      //_Objects.remove (i-1); 
      removeObject (Object (i-1)); 
      for (unsigned j = (unsigned)_Aliases.length (); j > 0; j--) 
        if (_Aliases.lookup (j-1) == info) {
          _Aliases.remove (j-1); 
          break;
        }
      if (info->Member ()) {
        if (info->Member ()->FunctionInfo ()) {
          for (unsigned j = Functions (); j > 0; j--) 
            if (Function (j-1) == info->Member ()) {
              _Functions.remove (j-1); 
              break;
            }
        } else if (info->Member ()->AttributeInfo ()) {
          for (unsigned j = Attributes (); j > 0; j--) 
            if (Attribute (j-1) == info->Member ()) {
              _Attributes.remove (j-1); 
              break;
            }
        } else if (info->Member ()->TypedefInfo () || 
                   info->Member ()->Record () || 
                   info->Member ()->EnumInfo ()) {
          for (unsigned j = Types (); j > 0; j--) 
            if (Type (j-1) == info->Member ()) {
              _Types.remove (j-1); 
              break;
            }
        }
      }
      break;
    }
}

CAttributeInfo *CStructure::newAttribute () {
  CAttributeInfo *info = new CAttributeInfo;
  info->Scope (this);
  info->SemDB (SemDB ());
  addAttribute (info);
  return info;
}

CEnumInfo *CStructure::newEnum () {
  CEnumInfo *info = new CEnumInfo;
  info->Scope (this);
  info->SemDB (SemDB ());
  addType (info);
  return info;
}

CUsingInfo *CStructure::newUsing () {
  CUsingInfo *info = new CUsingInfo;
  info->Scope (this);
  info->SemDB (SemDB ());
  addUsing (info);
  return info;
}

CTypedefInfo *CStructure::newTypedef () {
  CTypedefInfo *info = new CTypedefInfo;
  info->Scope (this);
  info->SemDB (SemDB ());
  addType (info);
  return info;
}

CMemberAliasInfo *CStructure::newMemberAlias (CObjectInfo *oinfo) {
  CMemberAliasInfo *info = new CMemberAliasInfo;
  info->Scope (this);
  info->SemDB (SemDB ());
  addObject (info);
  _Aliases.append (info);
  if (oinfo->FunctionInfo ()) 
    _Functions.append (oinfo->FunctionInfo ()); 
  else if (oinfo->AttributeInfo ()) 
    _Attributes.append (oinfo->AttributeInfo ()); 
  else if (oinfo->TypedefInfo () || oinfo->Record () || oinfo->EnumInfo ())
    _Types.append (oinfo);
  return info;
}

void CStructure::deleteAttribute (const CAttributeInfo *info) {
  for (unsigned i = Attributes (); i > 0; i--) 
    if (Attribute (i-1) == info) {
      removeObject (info);
      Attribute (i-1)->Scope (0);
      if (! Attribute (i-1)->EnumeratorInfo ())
        delete (CAttributeInfo*)_Attributes[i-1];
      _Attributes.remove (i-1); 
      break;
    }
}
 
void CStructure::deleteEnum (const CEnumInfo *info) {
  for (unsigned i = Types (); i > 0; i--) 
    if (Type (i-1) == (CObjectInfo*)info) {
      removeObject (info);
      ((CEnumInfo*)Type (i-1))->Scope (0);
      delete (CEnumInfo*)_Types[i-1];
      _Types.remove (i-1); 
      break;
    }
}

void CStructure::deleteUsing (const CUsingInfo *info) {
  for (unsigned i = Usings (); i > 0; i--) 
    if (Using (i-1) == (CUsingInfo*)info) {
      Using (i-1)->Scope (0);
      delete (CUsingInfo*)_Usings[i-1];
      _Usings.remove (i-1); 
      break;
    }
}

void CStructure::deleteTypedef (const CTypedefInfo *info) {
  for (unsigned i = Types (); i > 0; i--) 
    if (Type (i-1) == (CObjectInfo*)info) {
      removeObject (info);
      ((CTypedefInfo*)Type (i-1))->Scope (0);
      delete (CTypedefInfo*)_Types[i-1];
      _Types.remove (i-1); 
      break;
    }
}

void CStructure::deleteMemberAlias (const CMemberAliasInfo *info) {
  CMemberAliasInfo *mainfo;
  for (unsigned k = Objects (); k > 0; k--) 
    if (Object (k-1) == (CObjectInfo*)info) {
      mainfo = (CMemberAliasInfo*)Object (k-1);
      mainfo->Scope (0);
      if (mainfo->Member ()) {
        if (mainfo->Member ()->FunctionInfo ()) {
          for (unsigned i = Functions (); i > 0; i--) 
            if (Function (i-1) == mainfo->Member ()) {
              _Functions.remove (i-1); 
              break;
            }
        } else if (mainfo->Member ()->AttributeInfo ()) {
          for (unsigned i = Attributes (); i > 0; i--) 
            if (Attribute (i-1) == mainfo->Member ()) {
              _Attributes.remove (i-1); 
              break;
            }
        } else if (mainfo->Member ()->TypedefInfo () || 
                   mainfo->Member ()->Record () || 
                   mainfo->Member ()->EnumInfo ()) {
          for (unsigned i = Types (); i > 0; i--) 
            if (Type (i-1) == mainfo->Member ()) {
              _Types.remove (i-1); 
              break;
            }
        }
      }
      // _Objects.remove (i-1); 
      removeObject (Object (k-1)); 
      for (unsigned j = (unsigned)_Aliases.length (); j > 0; j--) 
        if (_Aliases.lookup (j-1) == info) {
          _Aliases.remove (j-1); 
          break;
        }
      delete mainfo;
      break;
    }
}

CMemberAliasInfo *CStructure::MemberAlias (const CObjectInfo *info) const {
  CMemberAliasInfo *mainfo;
  for (unsigned i = (unsigned)_Aliases.length (); i > 0; i--) {
    mainfo = _Aliases.lookup (i-1);
    if (mainfo->Member () == (CObjectInfo*)info)
      return mainfo;
  }
  return (CMemberAliasInfo*)0;  
}


} // namespace Puma
