// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __TokenStream__
#define __TokenStream__

// Class TokenStream is a unit stack providing a stream of 
// tokens corresponding to the #include hierarchy of the 
// input files. 

#include "Puma/Array.h"
#include "Puma/Unit.h"
#include "Puma/UnitTokenSrc.h"

namespace Puma {


class TokenStream : public PumaTokenSource, public Array<UnitTokenSrc*> {
public:
  TokenStream () : Array<UnitTokenSrc*> (20) {}
  ~TokenStream () {}
        
  // Push a unit on stack (nested include).
  void push (Unit *unit, Token *curr = 0);

  // Get the top unit on stack.
  Unit *top () const;
        
  // Get the next token of the top unit.
  Token *next ();
};


} // namespace Puma

#endif /* __TokenStream__ */
