#include <stdio.h>

// --------------------------- Aspect code -----------------------------

aspect FigureObserver
 {
   pointcut move () =
     execution ("void FigureElement::setXY(int,int)") ||
     execution ("void Point::set%(int)") ||
     execution ("void Line::setP%(Point &)");
public:

   advice move () : after () {
     printf ("moved\n");
   }
 };

// ------------------------------- normal C++ ---------------------------- 
class FigureElement
 {
   public:
      virtual void setXY (int, int) = 0;
 };

class Point : public FigureElement
 {
      int _x;
      int _y;
   public:
      Point (int x, int y) : _x (x), _y (y) {}
      void setXY (int x, int y) { _x = x; _y = y; }
      void setX (int x) { _x = x; }
      void setY (int y) { _y = y; }
      int x () { return _x; }
      int y () { return _y; }
 };

class Line : public FigureElement
 {
      Point p1;
      Point p2;
   public:
      void setXY (int x, int y);
      void setP1 (const Point &p) { p1 = p; }
      void setP2 (const Point &p) { p2 = p; }
 };

void Line::setXY (int x, int y)
 {
   int dx = p2.x () - p1.x ();
   int dy = p2.y () - p1.y ();

   setP1 ((const Point&)Point (x, y));
   setP2 ((const Point&)Point (x + dx, y + dy));
 }

int main ()
 {
   Point p (0, 0);

   p.setXY (3, 2);
   p.setX (10);
   return 0;
 }
