------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS                            --
--                                                                          --
--              G N A T E L I M . A S I S _ U T I L I T I E S               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 1998-2007, AdaCore                      --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to  the  Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by Ada Core Technologies Inc  (http://www.gnat.com) --
--                                                                          --
------------------------------------------------------------------------------

--  This package provides some second-layer ASIS functions needed by GNATELIM

with Asis;

package Gnatelim.Asis_Utilities is

   function Corresponding_Element
     (Element : Asis.Element) return Asis.Element;
   --  Unwinds all possible chains of elements down to the base one

   function Corresponding_Generic_Element_Unwinded
     (Element : Asis.Element) return Asis.Element;
   --  Unwinds all generic instantiations until the topmost generic
   --  declaration (i.e. with real SLOC) is obtained

   function Corresponding_Instance
     (Element : Asis.Element) return Asis.Declaration;
   --  For an Element that Is_Part_Of_Instance, returns the instantiation point
   --  For an Element that is an instance of an instance, returns the
   --  corresponding partial instantiation. Returns Nil_Element in other cases

   function Is_A_Completion (Element : Asis.Element) return Boolean;
   --  Returns True if Element completes a previous declaration.

   function SLOC (E : Asis.Element) return Source_Loc;
   --  Returns the source location of the beginning of a given Element

   function Text_Name_Unwinded (E : Asis.Element) return Wide_String;
   --  Returns the name of the source that contains a given Element.
   --  If it Is_Part_Of_Instance, source of generic is returned

   function Build_Profile
     (Subprogram_Id : Asis.Defining_Name)
      return          String_Loc;
   --  Builds the string that describes the subprogram's parameter/result
   --  profile used to distinguish homonyms in the extended Eliminate
   --  pragma syntax

   function Build_Sloc_Trace
     (Subprogram_Id : Asis.Defining_Name)
      return          String_Loc;
   --  Builds the string that describes the subprogram's location on the
   --  form "file_name:line_number. For subprograms from the instantiations
   --  the chain location_of_instantiation - location_in_template is created.

end Gnatelim.Asis_Utilities;
