#ifndef _META_H
#define _META_H

#include "config.h"

#include <string>
#include <map>
#include <set>
#include <vector>
#include <limits>

#include <fcntl.h>
#include <pthread.h>
#include <strings.h>
#include <stdlib.h>
#include <errno.h>

#include "aclogger.h"


#define EXTREME_MEMORY_SAVING false

#define tStrPos MYSTD::string::size_type 
#define stmiss MYSTD::string::npos
#define UINT unsigned int
#define USHORT unsigned short
#define UCHAR unsigned char

#ifdef WINDOWS
#define WIN32
#define SZPATHSEP "\\"
#define sNEWLINE sCRLF
#define szNEWLINE "\r\n"
#else
#define SZPATHSEP "/"
#define szNEWLINE "\n"
#define sNEWLINE sCR
#endif

// some alternative versions of these flags

#ifndef O_NONBLOCK
#ifdef NOBLOCK
#define O_NONBLOCK NOBLOCK
#else
#ifdef O_NDELAY
#define O_NONBLOCK O_NDELAY
#endif
#endif
#endif

#ifndef O_NONBLOCK
#error "Unknown how to configure non-blocking mode (O_NONBLOCK) on this system"
#endif

#include <sys/socket.h>
#ifndef SO_MAXCONN
#define SO_MAXCONN 250
#endif
#if defined(__linux__)
#include <sys/socketvar.h>
#endif

#define PATHSEP "/"

void set_nb(int fd);
void termsocket(int);

void mkbasedir(const MYSTD::string & path);

int getUUID();

struct ltstring
{
  bool operator()(const MYSTD::string &s1, const MYSTD::string &s2) const
  {
    return strcasecmp(s1.c_str(), s2.c_str()) < 0;
  }
};
/*
struct ltstr
{
  bool operator()(const char* s1, const char* s2) const
  {
    return strcasecmp(s1, s2) < 0;
  }
};
*/

#define SPACECHARS " \f\n\r\t\v"

typedef MYSTD::map<MYSTD::string, MYSTD::string, ltstring> NoCaseStringMap;
typedef MYSTD::map<MYSTD::string, MYSTD::string> tStringMap;

inline void trimFront(MYSTD::string &s, const char *junk=SPACECHARS)
{
	MYSTD::string::size_type pos = s.find_first_not_of(junk);
	if(pos != 0)
		s.erase(0, pos);
}

inline void trimBack(MYSTD::string &s, const char *junk=SPACECHARS)
{
	MYSTD::string::size_type pos = s.find_last_not_of(junk);
	s.erase(pos+1);
}

inline void trimString(MYSTD::string &s, const char *junk=SPACECHARS)
{
	trimBack(s, junk);
	trimFront(s, junk);
}

#define trimLine(x) { trimFront(x); trimBack(x); }

#define startsWith(where, what) (0==(where).compare(0, (what).size(), (what)))
#define endsWith(where, what) ((where).size()>=(what).size() && \
		0==where.compare((where).size()-(what).size(), (what).size(), (what)))
#define startsWithSz(where, what) (0==(where).compare(0, sizeof((what))-1, (what)))
#define endsWithSzAr(where, what) ((where).size()>=(sizeof((what))-1) && \
		0==(where).compare((where).size()-(sizeof((what))-1), (sizeof((what))-1), (what)))


//MYSTD::string sbasename(const char *in);

void trimProto(MYSTD::string & sUri);
tStrPos findHostStart(const MYSTD::string & sUri);

#ifndef _countof
#define _countof(x) sizeof(x)/sizeof(x[0])
#endif

extern MYSTD::string sPathSep, sPathSepUnix, sCR, sCRLF;
extern const char *szPathSep;

const char cPathSepUnix='/';
// TODO: windows port?
#define cPathSep cPathSepUnix


// there is memchr and strpbrk but nothing like the last one acting on specified RAW memory range
static inline char * mempbrk (char * membuf, char const * const needles, size_t len)
{
   for(char *pWhere=membuf ; pWhere<membuf+len ; pWhere++)
      for(const char *pWhat=needles; *pWhat ; pWhat++)
         if(*pWhat==*pWhere)
            return pWhere;
   return NULL;
}

typedef const unsigned char CUCHAR;
typedef MYSTD::vector<MYSTD::string> tStrVec;
typedef MYSTD::set<MYSTD::string> tStrSet;
typedef MYSTD::vector<MYSTD::string>::iterator tStrVecIter;
typedef MYSTD::vector<MYSTD::string>::const_iterator tStrVecIterConst;
/*
template<class T>
bool VectorContains(const MYSTD::vector<T> haystack, const T needle)
{
	for(unsigned long i=0; i<haystack.size();i++)
	{
		if(needle==haystack[i])
			return true;
	}
	return false;
}
*/

// Sometimes I miss Perl...
tStrVec::size_type Tokenize(const MYSTD::string &in, const char *sep, tStrVec & out, bool bAppend=false, MYSTD::string::size_type nStartOffset=0);
void Join(MYSTD::string &out, const MYSTD::string & sep, const tStrVec & tokens);

// TODO: __attribute__((externally_visible))
bool _ParseLine(const MYSTD::string & sIn, MYSTD::string & sOutKey, MYSTD::string & sOutVal);
#define keyEq(a, b) (0 == strcasecmp((a), (b).c_str()))


class tHttpUrl {
public:
	bool SetHttpUrl(MYSTD::string uri);
	/*
	/// The specified url has a path which is a prefix of the one in *this 
	UINT HasPathPrefix(const tHttpUrl &another);
	*/
	MYSTD::string ToURI() const;
	MYSTD::string sHost, sPort, sPath;
	tHttpUrl & operator=(const tHttpUrl &a) 
	{
		sHost=a.sHost; sPort=a.sPort; sPath=a.sPath;
		return *this;
	};
	bool operator==(const tHttpUrl &a) const
	{
		return a.sHost==sHost && a.sPort == sPort && a.sPath == sPath;
	};
	bool operator!=(const tHttpUrl &a) const
	{
		return ! (a==*this);
	}
	tHttpUrl() { sHost=sPort=sPath=""; }
	inline void clear() { sHost=sPort=sPath=""; }
	
	tHttpUrl(const MYSTD::string & host, const MYSTD::string & path)
	: sHost(host), sPort(""), sPath(path)
	{}
	
};

#define POKE(x) while( write(x, "", 1) <0);

#ifndef UINT_MAX
#define UINT_MAX (MYSTD::numeric_limits<UINT>::max())
#endif

typedef struct { 
	const char *name; MYSTD::string *ptr;
	const char *warn; }
MapNameToString;

typedef struct { 
	const char *name; int *ptr;
	const char *warn; int base;}
MapNameToInt;

void appendLong(MYSTD::string &s, long val);

#define OFFT_MAX (std::numeric_limits<off_t>::max())

bool FileCopy(const MYSTD::string &from, const MYSTD::string to);
// kept in pkgimport, to print msgs through it; bool LinkOrCopy(const MYSTD::string &from, const MYSTD::string &to);

MYSTD::string CsBinToString(const uint8_t b[], unsigned short binLength);
bool CsAsciiToBin(const char *a, uint8_t b[], unsigned short binLength);
bool CsEqual(const char *a, uint8_t b[], unsigned short binLength);

MYSTD::string ltos(long n);

void StrSubst(MYSTD::string &contents, const MYSTD::string &from, const MYSTD::string &to);

#define forceclose(fd) { while(0 != ::close(fd)) { if(errno != EINTR) break; }; fd=-1; }
#define checkforceclose(fd) if(fd>=0){ while(0 != ::close(fd)) { if(errno != EINTR) break; }; fd=-1; }
#define checkForceFclose(fh) if(fh) { int fd=fileno(fh); if(0!=::fclose(fh) && errno!=EBADF) forceclose(fd); fh=NULL;}

#define forceShutdownClose(fd) if(fd>=0) { ::shutdown(fd, O_RDWR); while(0 != ::close(fd)) { if(errno != EINTR) break; }; fd=-1; }
// DUDES, who writes TCP implementations... why can this just not be done easy and reliable? Why do we need hacks like termsocket?
// For details, see: http://blog.netherlabs.nl/articles/2009/01/18/the-ultimate-so_linger-page-or-why-is-my-tcp-not-reliable
#define flushShutdownClose(fd) if(fd>=0) { ::termsocket(fd); fd=-1; }


typedef unsigned int FiStatus;

#if SIZEOF_LONG == 8
// _FILE_OFFSET_BITS apparently irrelevant, at least on Linux. But if set, watch out for user's experiments.
#if _FILE_OFFSET_BITS == 32
#error Unsupported: _FILE_OFFSET_BITS == 32 with large long size
#endif

#else // not 64bit arch?

#if 64 == _FILE_OFFSET_BITS
#define OFF_T_FMT "%"PRId64
#endif

#if 32 == _FILE_OFFSET_BITS
#define OFF_T_FMT "%"PRId32
#endif

#endif // !64bit arch

#ifndef OFF_T_FMT // either set above or let the os/compiler deal with the mess
#define OFF_T_FMT "%ld"
#endif

// let the compiler optimize and keep best variant
inline off_t atoofft(const char *p)
{
	if(sizeof(long long) == sizeof(off_t))
		return atoll(p);
	if(sizeof(int) == sizeof(off_t))
		return atoi(p);
	return atol(p);
}

tStrVec ExpandFilePattern(const MYSTD::string &pattern, bool bSorted=false);

#endif // _META_H

