#!/bin/sh -e

VERSION=$2
TAR=../annotation-indexer_$VERSION.orig.tar.gz
DIR=annotation-indexer-$VERSION
mkdir -p $DIR
# Expand the upstream tarball
tar -xzf $TAR -C $DIR --strip-components=1
# Repack excluding stuff we don't need
GZIP=--best tar -c -z -f $TAR --exclude '*.jar' --exclude '*.class' \
    --exclude 'CVS' --exclude '.svn' $DIR
rm -rf $DIR

