/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _NDMP9_H_RPCGEN
#define _NDMP9_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

#define NDMP9VER 9

enum ndmp9_error {
	NDMP9_NO_ERR = 0,
	NDMP9_NOT_SUPPORTED_ERR = 1,
	NDMP9_DEVICE_BUSY_ERR = 2,
	NDMP9_DEVICE_OPENED_ERR = 3,
	NDMP9_NOT_AUTHORIZED_ERR = 4,
	NDMP9_PERMISSION_ERR = 5,
	NDMP9_DEV_NOT_OPEN_ERR = 6,
	NDMP9_IO_ERR = 7,
	NDMP9_TIMEOUT_ERR = 8,
	NDMP9_ILLEGAL_ARGS_ERR = 9,
	NDMP9_NO_TAPE_LOADED_ERR = 10,
	NDMP9_WRITE_PROTECT_ERR = 11,
	NDMP9_EOF_ERR = 12,
	NDMP9_EOM_ERR = 13,
	NDMP9_FILE_NOT_FOUND_ERR = 14,
	NDMP9_BAD_FILE_ERR = 15,
	NDMP9_NO_DEVICE_ERR = 16,
	NDMP9_NO_BUS_ERR = 17,
	NDMP9_XDR_DECODE_ERR = 18,
	NDMP9_ILLEGAL_STATE_ERR = 19,
	NDMP9_UNDEFINED_ERR = 20,
	NDMP9_XDR_ENCODE_ERR = 21,
	NDMP9_NO_MEM_ERR = 22,
	NDMP9_CONNECT_ERR = 23,
	NDMP9_SEQUENCE_NUM_ERR = 24,
	NDMP9_READ_IN_PROGRESS_ERR = 25,
	NDMP9_PRECONDITION_ERR = 26,
	NDMP9_CLASS_NOT_SUPPORTED = 27,
	NDMP9_VERSION_NOT_SUPPORTED = 28,
	NDMP9_EXT_DUPL_CLASSES = 29,
	NDMP9_EXT_DN_ILLEGAL = 30,
};
typedef enum ndmp9_error ndmp9_error;

enum ndmp9_message {
	NDMP9_CONNECT_OPEN = 0x900,
	NDMP9_CONNECT_CLIENT_AUTH = 0x901,
	NDMP9_CONNECT_CLOSE = 0x902,
	NDMP9_CONNECT_SERVER_AUTH = 0x903,
	NDMP9_CONFIG_GET_HOST_INFO = 0x100,
	NDMP9_CONFIG_GET_CONNECTION_TYPE = 0x102,
	NDMP9_CONFIG_GET_AUTH_ATTR = 0x103,
	NDMP9_CONFIG_GET_BUTYPE_INFO = 0x104,
	NDMP9_CONFIG_GET_FS_INFO = 0x105,
	NDMP9_CONFIG_GET_TAPE_INFO = 0x106,
	NDMP9_CONFIG_GET_SCSI_INFO = 0x107,
	NDMP9_CONFIG_GET_SERVER_INFO = 0x108,
	NDMP9_SCSI_OPEN = 0x200,
	NDMP9_SCSI_CLOSE = 0x201,
	NDMP9_SCSI_GET_STATE = 0x202,
	NDMP9_SCSI_SET_TARGET = 0x203,
	NDMP9_SCSI_RESET_DEVICE = 0x204,
	NDMP9_SCSI_RESET_BUS = 0x205,
	NDMP9_SCSI_EXECUTE_CDB = 0x206,
	NDMP9_TAPE_OPEN = 0x300,
	NDMP9_TAPE_CLOSE = 0x301,
	NDMP9_TAPE_GET_STATE = 0x302,
	NDMP9_TAPE_MTIO = 0x303,
	NDMP9_TAPE_WRITE = 0x304,
	NDMP9_TAPE_READ = 0x305,
	NDMP9_TAPE_EXECUTE_CDB = 0x307,
	NDMP9_DATA_GET_STATE = 0x400,
	NDMP9_DATA_START_BACKUP = 0x401,
	NDMP9_DATA_START_RECOVER = 0x402,
	NDMP9_DATA_ABORT = 0x403,
	NDMP9_DATA_GET_ENV = 0x404,
	NDMP9_DATA_STOP = 0x407,
	NDMP9_DATA_LISTEN = 0x409,
	NDMP9_DATA_CONNECT = 0x40a,
	NDMP9_DATA_START_RECOVER_FILEHIST = 0x40b,
	NDMP9_NOTIFY_DATA_HALTED = 0x501,
	NDMP9_NOTIFY_CONNECTED = 0x502,
	NDMP9_NOTIFY_MOVER_HALTED = 0x503,
	NDMP9_NOTIFY_MOVER_PAUSED = 0x504,
	NDMP9_NOTIFY_DATA_READ = 0x505,
	NDMP9_LOG_FILE = 0x602,
	NDMP9_LOG_MESSAGE = 0x603,
	NDMP9_FH_ADD_FILE = 0x703,
	NDMP9_FH_ADD_DIR = 0x704,
	NDMP9_FH_ADD_NODE = 0x705,
	NDMP9_MOVER_GET_STATE = 0xa00,
	NDMP9_MOVER_LISTEN = 0xa01,
	NDMP9_MOVER_CONTINUE = 0xa02,
	NDMP9_MOVER_ABORT = 0xa03,
	NDMP9_MOVER_STOP = 0xa04,
	NDMP9_MOVER_SET_WINDOW = 0xa05,
	NDMP9_MOVER_READ = 0xa06,
	NDMP9_MOVER_CLOSE = 0xa07,
	NDMP9_MOVER_SET_RECORD_SIZE = 0xa08,
	NDMP9_MOVER_CONNECT = 0xa09,
};
typedef enum ndmp9_message ndmp9_message;
extern bool_t xdr_ndmp9_no_arguments();
#define ndmp9_no_arguments int

struct ndmp9_just_error_reply {
	ndmp9_error error;
};
typedef struct ndmp9_just_error_reply ndmp9_just_error_reply;
extern bool_t xdr_ndmp9_u_quad();
#define ndmp9_u_quad unsigned long long

enum ndmp9_validity {
	NDMP9_VALIDITY_INVALID = 0,
	NDMP9_VALIDITY_VALID = 0 + 1,
	NDMP9_VALIDITY_MAYBE_INVALID = 0 + 2,
	NDMP9_VALIDITY_MAYBE_VALID = 0 + 3,
};
typedef enum ndmp9_validity ndmp9_validity;
#define NDMP9_INVALID_U_LONG 0xFFFFFFFFul

struct ndmp9_valid_u_long {
	ndmp9_validity valid;
	u_long value;
};
typedef struct ndmp9_valid_u_long ndmp9_valid_u_long;
#define NDMP9_INVALID_U_QUAD 0xFFFFFFFFFFFFFFFFull

struct ndmp9_valid_u_quad {
	ndmp9_validity valid;
	ndmp9_u_quad value;
};
typedef struct ndmp9_valid_u_quad ndmp9_valid_u_quad;

struct ndmp9_pval {
	char *name;
	char *value;
};
typedef struct ndmp9_pval ndmp9_pval;

enum ndmp9_auth_type {
	NDMP9_AUTH_NONE = 0,
	NDMP9_AUTH_TEXT = 1,
	NDMP9_AUTH_MD5 = 2,
};
typedef enum ndmp9_auth_type ndmp9_auth_type;

struct ndmp9_auth_attr {
	ndmp9_auth_type auth_type;
	union {
		char challenge[64];
	} ndmp9_auth_attr_u;
};
typedef struct ndmp9_auth_attr ndmp9_auth_attr;

struct ndmp9_auth_text {
	char *auth_id;
	char *auth_password;
};
typedef struct ndmp9_auth_text ndmp9_auth_text;

struct ndmp9_auth_md5 {
	char *auth_id;
	char auth_digest[16];
};
typedef struct ndmp9_auth_md5 ndmp9_auth_md5;

struct ndmp9_auth_data {
	ndmp9_auth_type auth_type;
	union {
		struct ndmp9_auth_text auth_text;
		struct ndmp9_auth_md5 auth_md5;
	} ndmp9_auth_data_u;
};
typedef struct ndmp9_auth_data ndmp9_auth_data;

enum ndmp9_addr_type {
	NDMP9_ADDR_LOCAL = 0,
	NDMP9_ADDR_TCP = 1,
	NDMP9_ADDR_AS_CONNECTED = 0x1000,
};
typedef enum ndmp9_addr_type ndmp9_addr_type;

struct ndmp9_tcp_addr {
	u_long ip_addr;
	u_short port;
};
typedef struct ndmp9_tcp_addr ndmp9_tcp_addr;

struct ndmp9_addr {
	ndmp9_addr_type addr_type;
	union {
		ndmp9_tcp_addr tcp_addr;
	} ndmp9_addr_u;
};
typedef struct ndmp9_addr ndmp9_addr;

struct ndmp9_connect_open_request {
	u_short protocol_version;
};
typedef struct ndmp9_connect_open_request ndmp9_connect_open_request;

typedef ndmp9_just_error_reply ndmp9_connect_open_reply;

struct ndmp9_connect_client_auth_request {
	ndmp9_auth_data auth_data;
};
typedef struct ndmp9_connect_client_auth_request ndmp9_connect_client_auth_request;

typedef ndmp9_just_error_reply ndmp9_connect_client_auth_reply;

typedef ndmp9_no_arguments ndmp9_connect_close_request;

typedef ndmp9_no_arguments ndmp9_connect_close_reply;

struct ndmp9_connect_server_auth_request {
	ndmp9_auth_attr client_attr;
};
typedef struct ndmp9_connect_server_auth_request ndmp9_connect_server_auth_request;

struct ndmp9_connect_server_auth_reply {
	ndmp9_error error;
	ndmp9_auth_data server_result;
};
typedef struct ndmp9_connect_server_auth_reply ndmp9_connect_server_auth_reply;

struct ndmp9_butype_info {
	char *butype_name;
	ndmp9_valid_u_long v2attr;
	ndmp9_valid_u_long v3attr;
	ndmp9_valid_u_long v4attr;
	struct {
		u_int default_env_len;
		ndmp9_pval *default_env_val;
	} default_env;
};
typedef struct ndmp9_butype_info ndmp9_butype_info;

struct ndmp9_fs_info {
	char *fs_type;
	char *fs_logical_device;
	char *fs_physical_device;
	ndmp9_valid_u_quad total_size;
	ndmp9_valid_u_quad used_size;
	ndmp9_valid_u_quad avail_size;
	ndmp9_valid_u_quad total_inodes;
	ndmp9_valid_u_quad used_inodes;
	struct {
		u_int fs_env_len;
		ndmp9_pval *fs_env_val;
	} fs_env;
	char *fs_status;
};
typedef struct ndmp9_fs_info ndmp9_fs_info;

struct ndmp9_device_capability {
	char *device;
	ndmp9_valid_u_long v3attr;
	ndmp9_valid_u_long v4attr;
	struct {
		u_int capability_len;
		ndmp9_pval *capability_val;
	} capability;
};
typedef struct ndmp9_device_capability ndmp9_device_capability;

struct ndmp9_device_info {
	char *model;
	struct {
		u_int caplist_len;
		ndmp9_device_capability *caplist_val;
	} caplist;
};
typedef struct ndmp9_device_info ndmp9_device_info;
#define NDMP9_CONFIG_CONNTYPE_LOCAL 0x0001
#define NDMP9_CONFIG_CONNTYPE_TCP 0x0002
#define NDMP9_CONFIG_AUTHTYPE_NONE 0x0001
#define NDMP9_CONFIG_AUTHTYPE_TEXT 0x0002
#define NDMP9_CONFIG_AUTHTYPE_MD5 0x0004

struct ndmp9_config_info {
	ndmp9_error error;
	char *hostname;
	char *os_type;
	char *os_vers;
	char *hostid;
	char *vendor_name;
	char *product_name;
	char *revision_number;
	u_long authtypes;
	u_long conntypes;
	struct {
		u_int butype_info_len;
		ndmp9_butype_info *butype_info_val;
	} butype_info;
	struct {
		u_int fs_info_len;
		ndmp9_fs_info *fs_info_val;
	} fs_info;
	struct {
		u_int tape_info_len;
		ndmp9_device_info *tape_info_val;
	} tape_info;
	struct {
		u_int scsi_info_len;
		ndmp9_device_info *scsi_info_val;
	} scsi_info;
};
typedef struct ndmp9_config_info ndmp9_config_info;

typedef ndmp9_no_arguments ndmp9_config_get_info_request;

struct ndmp9_config_get_info_reply {
	ndmp9_error error;
	ndmp9_config_info config_info;
};
typedef struct ndmp9_config_get_info_reply ndmp9_config_get_info_reply;

typedef ndmp9_no_arguments ndmp9_config_get_host_info_request;

typedef ndmp9_config_get_info_reply ndmp9_config_get_host_info_reply;

typedef ndmp9_no_arguments ndmp9_config_get_connection_type_request;

typedef ndmp9_config_get_info_reply ndmp9_config_get_connection_type_reply;

typedef ndmp9_no_arguments ndmp9_config_get_server_info_request;

typedef ndmp9_config_get_info_reply ndmp9_config_get_server_info_reply;

typedef ndmp9_no_arguments ndmp9_config_get_butype_info_request;

typedef ndmp9_config_get_info_reply ndmp9_config_get_butype_info_reply;

typedef ndmp9_no_arguments ndmp9_config_get_fs_info_request;

typedef ndmp9_config_get_info_reply ndmp9_config_get_fs_info_reply;

typedef ndmp9_no_arguments ndmp9_config_get_tape_info_request;

typedef ndmp9_config_get_info_reply ndmp9_config_get_tape_info_reply;

typedef ndmp9_no_arguments ndmp9_config_get_scsi_info_request;

typedef ndmp9_config_get_info_reply ndmp9_config_get_scsi_info_reply;

struct ndmp9_config_get_auth_attr_request {
	ndmp9_auth_type auth_type;
};
typedef struct ndmp9_config_get_auth_attr_request ndmp9_config_get_auth_attr_request;

struct ndmp9_config_get_auth_attr_reply {
	ndmp9_error error;
	ndmp9_auth_attr server_attr;
};
typedef struct ndmp9_config_get_auth_attr_reply ndmp9_config_get_auth_attr_reply;

struct ndmp9_scsi_open_request {
	char *device;
};
typedef struct ndmp9_scsi_open_request ndmp9_scsi_open_request;

typedef ndmp9_just_error_reply ndmp9_scsi_open_reply;

typedef ndmp9_no_arguments ndmp9_scsi_close_request;

typedef ndmp9_just_error_reply ndmp9_scsi_close_reply;

typedef ndmp9_no_arguments ndmp9_scsi_get_state_request;

struct ndmp9_scsi_get_state_reply {
	ndmp9_error error;
	short target_controller;
	short target_id;
	short target_lun;
};
typedef struct ndmp9_scsi_get_state_reply ndmp9_scsi_get_state_reply;

struct ndmp9_scsi_set_target_request {
	char *device;
	u_short target_controller;
	u_short target_id;
	u_short target_lun;
};
typedef struct ndmp9_scsi_set_target_request ndmp9_scsi_set_target_request;

typedef ndmp9_just_error_reply ndmp9_scsi_set_target_reply;

typedef ndmp9_no_arguments ndmp9_scsi_reset_device_request;

typedef ndmp9_just_error_reply ndmp9_scsi_reset_device_reply;

typedef ndmp9_no_arguments ndmp9_scsi_reset_bus_request;

typedef ndmp9_just_error_reply ndmp9_scsi_reset_bus_reply;

enum ndmp9_scsi_data_dir {
	NDMP9_SCSI_DATA_DIR_NONE = 0,
	NDMP9_SCSI_DATA_DIR_IN = 1,
	NDMP9_SCSI_DATA_DIR_OUT = 2,
};
typedef enum ndmp9_scsi_data_dir ndmp9_scsi_data_dir;

struct ndmp9_execute_cdb_request {
	ndmp9_scsi_data_dir data_dir;
	u_long timeout;
	u_long datain_len;
	struct {
		u_int cdb_len;
		char *cdb_val;
	} cdb;
	struct {
		u_int dataout_len;
		char *dataout_val;
	} dataout;
};
typedef struct ndmp9_execute_cdb_request ndmp9_execute_cdb_request;

struct ndmp9_execute_cdb_reply {
	ndmp9_error error;
	u_char status;
	u_long dataout_len;
	struct {
		u_int datain_len;
		char *datain_val;
	} datain;
	struct {
		u_int ext_sense_len;
		char *ext_sense_val;
	} ext_sense;
};
typedef struct ndmp9_execute_cdb_reply ndmp9_execute_cdb_reply;

typedef ndmp9_execute_cdb_request ndmp9_scsi_execute_cdb_request;

typedef ndmp9_execute_cdb_reply ndmp9_scsi_execute_cdb_reply;

enum ndmp9_tape_open_mode {
	NDMP9_TAPE_READ_MODE = 0,
	NDMP9_TAPE_RDWR_MODE = 1,
	NDMP9_TAPE_RAW_MODE = 2,
};
typedef enum ndmp9_tape_open_mode ndmp9_tape_open_mode;

enum ndmp9_tape_state {
	NDMP9_TAPE_STATE_IDLE = 0,
	NDMP9_TAPE_STATE_OPEN = 1,
	NDMP9_TAPE_STATE_MOVER = 2,
};
typedef enum ndmp9_tape_state ndmp9_tape_state;

struct ndmp9_tape_open_request {
	char *device;
	ndmp9_tape_open_mode mode;
};
typedef struct ndmp9_tape_open_request ndmp9_tape_open_request;

typedef ndmp9_just_error_reply ndmp9_tape_open_reply;

typedef ndmp9_no_arguments ndmp9_tape_close_request;

typedef ndmp9_just_error_reply ndmp9_tape_close_reply;
#define NDMP9_TAPE_STATE_NOREWIND 0x0008
#define NDMP9_TAPE_STATE_WR_PROT 0x0010
#define NDMP9_TAPE_STATE_ERROR 0x0020
#define NDMP9_TAPE_STATE_UNLOAD 0x0040

typedef ndmp9_no_arguments ndmp9_tape_get_state_request;

struct ndmp9_tape_get_state_reply {
	ndmp9_error error;
	u_long flags;
	ndmp9_tape_state state;
	ndmp9_tape_open_mode open_mode;
	ndmp9_valid_u_long file_num;
	ndmp9_valid_u_long soft_errors;
	ndmp9_valid_u_long block_size;
	ndmp9_valid_u_long blockno;
	ndmp9_valid_u_quad total_space;
	ndmp9_valid_u_quad space_remain;
	ndmp9_valid_u_long partition;
};
typedef struct ndmp9_tape_get_state_reply ndmp9_tape_get_state_reply;

enum ndmp9_tape_mtio_op {
	NDMP9_MTIO_FSF = 0,
	NDMP9_MTIO_BSF = 1,
	NDMP9_MTIO_FSR = 2,
	NDMP9_MTIO_BSR = 3,
	NDMP9_MTIO_REW = 4,
	NDMP9_MTIO_EOF = 5,
	NDMP9_MTIO_OFF = 6,
};
typedef enum ndmp9_tape_mtio_op ndmp9_tape_mtio_op;

struct ndmp9_tape_mtio_request {
	ndmp9_tape_mtio_op tape_op;
	u_long count;
};
typedef struct ndmp9_tape_mtio_request ndmp9_tape_mtio_request;

struct ndmp9_tape_mtio_reply {
	ndmp9_error error;
	u_long resid_count;
};
typedef struct ndmp9_tape_mtio_reply ndmp9_tape_mtio_reply;

struct ndmp9_tape_write_request {
	struct {
		u_int data_out_len;
		char *data_out_val;
	} data_out;
};
typedef struct ndmp9_tape_write_request ndmp9_tape_write_request;

struct ndmp9_tape_write_reply {
	ndmp9_error error;
	u_long count;
};
typedef struct ndmp9_tape_write_reply ndmp9_tape_write_reply;

struct ndmp9_tape_read_request {
	u_long count;
};
typedef struct ndmp9_tape_read_request ndmp9_tape_read_request;

struct ndmp9_tape_read_reply {
	ndmp9_error error;
	struct {
		u_int data_in_len;
		char *data_in_val;
	} data_in;
};
typedef struct ndmp9_tape_read_reply ndmp9_tape_read_reply;

typedef ndmp9_execute_cdb_request ndmp9_tape_execute_cdb_request;

typedef ndmp9_execute_cdb_reply ndmp9_tape_execute_cdb_reply;

enum ndmp9_mover_state {
	NDMP9_MOVER_STATE_IDLE = 0,
	NDMP9_MOVER_STATE_LISTEN = 1,
	NDMP9_MOVER_STATE_ACTIVE = 2,
	NDMP9_MOVER_STATE_PAUSED = 3,
	NDMP9_MOVER_STATE_HALTED = 4,
	NDMP9_MOVER_STATE_STANDBY = 5,
};
typedef enum ndmp9_mover_state ndmp9_mover_state;

enum ndmp9_mover_mode {
	NDMP9_MOVER_MODE_READ = 0,
	NDMP9_MOVER_MODE_WRITE = 1,
};
typedef enum ndmp9_mover_mode ndmp9_mover_mode;

enum ndmp9_mover_pause_reason {
	NDMP9_MOVER_PAUSE_NA = 0,
	NDMP9_MOVER_PAUSE_EOM = 1,
	NDMP9_MOVER_PAUSE_EOF = 2,
	NDMP9_MOVER_PAUSE_SEEK = 3,
	NDMP9_MOVER_PAUSE_MEDIA_ERROR = 4,
	NDMP9_MOVER_PAUSE_EOW = 5,
};
typedef enum ndmp9_mover_pause_reason ndmp9_mover_pause_reason;

enum ndmp9_mover_halt_reason {
	NDMP9_MOVER_HALT_NA = 0,
	NDMP9_MOVER_HALT_CONNECT_CLOSED = 1,
	NDMP9_MOVER_HALT_ABORTED = 2,
	NDMP9_MOVER_HALT_INTERNAL_ERROR = 3,
	NDMP9_MOVER_HALT_CONNECT_ERROR = 4,
	NDMP9_MOVER_HALT_MEDIA_ERROR = 5,
};
typedef enum ndmp9_mover_halt_reason ndmp9_mover_halt_reason;

typedef ndmp9_no_arguments ndmp9_mover_get_state_request;

struct ndmp9_mover_get_state_reply {
	ndmp9_error error;
	ndmp9_mover_state state;
	ndmp9_mover_mode mode;
	ndmp9_mover_pause_reason pause_reason;
	ndmp9_mover_halt_reason halt_reason;
	u_long record_size;
	u_long record_num;
	ndmp9_u_quad bytes_moved;
	ndmp9_u_quad seek_position;
	ndmp9_u_quad bytes_left_to_read;
	ndmp9_u_quad window_offset;
	ndmp9_u_quad window_length;
	ndmp9_addr data_connection_addr;
};
typedef struct ndmp9_mover_get_state_reply ndmp9_mover_get_state_reply;

struct ndmp9_mover_listen_request {
	ndmp9_mover_mode mode;
	ndmp9_addr_type addr_type;
};
typedef struct ndmp9_mover_listen_request ndmp9_mover_listen_request;

struct ndmp9_mover_listen_reply {
	ndmp9_error error;
	ndmp9_addr data_connection_addr;
};
typedef struct ndmp9_mover_listen_reply ndmp9_mover_listen_reply;

struct ndmp9_mover_connect_request {
	ndmp9_mover_mode mode;
	ndmp9_addr addr;
};
typedef struct ndmp9_mover_connect_request ndmp9_mover_connect_request;

typedef ndmp9_just_error_reply ndmp9_mover_connect_reply;

struct ndmp9_mover_set_record_size_request {
	u_long record_size;
};
typedef struct ndmp9_mover_set_record_size_request ndmp9_mover_set_record_size_request;

typedef ndmp9_just_error_reply ndmp9_mover_set_record_size_reply;

struct ndmp9_mover_set_window_request {
	ndmp9_u_quad offset;
	ndmp9_u_quad length;
};
typedef struct ndmp9_mover_set_window_request ndmp9_mover_set_window_request;

typedef ndmp9_just_error_reply ndmp9_mover_set_window_reply;

typedef ndmp9_no_arguments ndmp9_mover_continue_request;

typedef ndmp9_just_error_reply ndmp9_mover_continue_reply;

typedef ndmp9_no_arguments ndmp9_mover_abort_request;

typedef ndmp9_just_error_reply ndmp9_mover_abort_reply;

typedef ndmp9_no_arguments ndmp9_mover_stop_request;

typedef ndmp9_just_error_reply ndmp9_mover_stop_reply;

struct ndmp9_mover_read_request {
	ndmp9_u_quad offset;
	ndmp9_u_quad length;
};
typedef struct ndmp9_mover_read_request ndmp9_mover_read_request;

typedef ndmp9_just_error_reply ndmp9_mover_read_reply;

typedef ndmp9_no_arguments ndmp9_mover_close_request;

typedef ndmp9_just_error_reply ndmp9_mover_close_reply;

enum ndmp9_data_operation {
	NDMP9_DATA_OP_NOACTION = 0,
	NDMP9_DATA_OP_BACKUP = 1,
	NDMP9_DATA_OP_RECOVER = 2,
	NDMP9_DATA_OP_RECOVER_FILEHIST = 3,
};
typedef enum ndmp9_data_operation ndmp9_data_operation;

enum ndmp9_data_state {
	NDMP9_DATA_STATE_IDLE = 0,
	NDMP9_DATA_STATE_ACTIVE = 1,
	NDMP9_DATA_STATE_HALTED = 2,
	NDMP9_DATA_STATE_LISTEN = 3,
	NDMP9_DATA_STATE_CONNECTED = 4,
};
typedef enum ndmp9_data_state ndmp9_data_state;

enum ndmp9_data_halt_reason {
	NDMP9_DATA_HALT_NA = 0,
	NDMP9_DATA_HALT_SUCCESSFUL = 1,
	NDMP9_DATA_HALT_ABORTED = 2,
	NDMP9_DATA_HALT_INTERNAL_ERROR = 3,
	NDMP9_DATA_HALT_CONNECT_ERROR = 4,
};
typedef enum ndmp9_data_halt_reason ndmp9_data_halt_reason;

typedef ndmp9_no_arguments ndmp9_data_get_state_request;

struct ndmp9_data_get_state_reply {
	ndmp9_error error;
	ndmp9_data_operation operation;
	ndmp9_data_state state;
	ndmp9_data_halt_reason halt_reason;
	ndmp9_u_quad bytes_processed;
	ndmp9_valid_u_quad est_bytes_remain;
	ndmp9_valid_u_long est_time_remain;
	ndmp9_addr data_connection_addr;
	ndmp9_u_quad read_offset;
	ndmp9_u_quad read_length;
};
typedef struct ndmp9_data_get_state_reply ndmp9_data_get_state_reply;

struct ndmp9_name {
	char *original_path;
	char *destination_path;
	ndmp9_valid_u_quad fh_info;
};
typedef struct ndmp9_name ndmp9_name;

struct ndmp9_data_start_backup_request {
	char *bu_type;
	struct {
		u_int env_len;
		ndmp9_pval *env_val;
	} env;
	ndmp9_addr addr;
};
typedef struct ndmp9_data_start_backup_request ndmp9_data_start_backup_request;

typedef ndmp9_just_error_reply ndmp9_data_start_backup_reply;

struct ndmp9_data_start_recover_request {
	struct {
		u_int env_len;
		ndmp9_pval *env_val;
	} env;
	struct {
		u_int nlist_len;
		ndmp9_name *nlist_val;
	} nlist;
	char *bu_type;
	ndmp9_addr addr;
};
typedef struct ndmp9_data_start_recover_request ndmp9_data_start_recover_request;

typedef ndmp9_just_error_reply ndmp9_data_start_recover_reply;

typedef ndmp9_data_start_recover_request ndmp9_data_start_recover_filehist_request;

typedef ndmp9_data_start_recover_reply ndmp9_data_start_recover_filehist_reply;

typedef ndmp9_no_arguments ndmp9_data_abort_request;

typedef ndmp9_just_error_reply ndmp9_data_abort_reply;

typedef ndmp9_no_arguments ndmp9_data_stop_request;

typedef ndmp9_just_error_reply ndmp9_data_stop_reply;

typedef ndmp9_no_arguments ndmp9_data_get_env_request;

struct ndmp9_data_get_env_reply {
	ndmp9_error error;
	struct {
		u_int env_len;
		ndmp9_pval *env_val;
	} env;
};
typedef struct ndmp9_data_get_env_reply ndmp9_data_get_env_reply;

struct ndmp9_data_listen_request {
	ndmp9_addr_type addr_type;
};
typedef struct ndmp9_data_listen_request ndmp9_data_listen_request;

struct ndmp9_data_listen_reply {
	ndmp9_error error;
	ndmp9_addr data_connection_addr;
};
typedef struct ndmp9_data_listen_reply ndmp9_data_listen_reply;

struct ndmp9_data_connect_request {
	ndmp9_addr addr;
};
typedef struct ndmp9_data_connect_request ndmp9_data_connect_request;

typedef ndmp9_just_error_reply ndmp9_data_connect_reply;

struct ndmp9_notify_data_halted_request {
	ndmp9_data_halt_reason reason;
};
typedef struct ndmp9_notify_data_halted_request ndmp9_notify_data_halted_request;

enum ndmp9_connect_reason {
	NDMP9_CONNECTED = 0,
	NDMP9_SHUTDOWN = 1,
	NDMP9_REFUSED = 2,
};
typedef enum ndmp9_connect_reason ndmp9_connect_reason;

struct ndmp9_notify_connected_request {
	ndmp9_connect_reason reason;
	u_short protocol_version;
	char *text_reason;
};
typedef struct ndmp9_notify_connected_request ndmp9_notify_connected_request;

struct ndmp9_notify_mover_halted_request {
	ndmp9_mover_halt_reason reason;
};
typedef struct ndmp9_notify_mover_halted_request ndmp9_notify_mover_halted_request;

struct ndmp9_notify_mover_paused_request {
	ndmp9_mover_pause_reason reason;
	ndmp9_u_quad seek_position;
};
typedef struct ndmp9_notify_mover_paused_request ndmp9_notify_mover_paused_request;

struct ndmp9_notify_data_read_request {
	ndmp9_u_quad offset;
	ndmp9_u_quad length;
};
typedef struct ndmp9_notify_data_read_request ndmp9_notify_data_read_request;

enum ndmp9_log_type {
	NDMP9_LOG_NORMAL = 0,
	NDMP9_LOG_DEBUG = 1,
	NDMP9_LOG_ERROR = 2,
	NDMP9_LOG_WARNING = 3,
};
typedef enum ndmp9_log_type ndmp9_log_type;

struct ndmp9_log_message_request {
	ndmp9_log_type log_type;
	u_long message_id;
	char *entry;
	ndmp9_valid_u_long associated_message_sequence;
};
typedef struct ndmp9_log_message_request ndmp9_log_message_request;

enum ndmp9_recovery_status {
	NDMP9_RECOVERY_SUCCESSFUL = 0,
	NDMP9_RECOVERY_FAILED_PERMISSION = 1,
	NDMP9_RECOVERY_FAILED_NOT_FOUND = 2,
	NDMP9_RECOVERY_FAILED_NO_DIRECTORY = 3,
	NDMP9_RECOVERY_FAILED_OUT_OF_MEMORY = 4,
	NDMP9_RECOVERY_FAILED_IO_ERROR = 5,
	NDMP9_RECOVERY_FAILED_UNDEFINED_ERROR = 6,
};
typedef enum ndmp9_recovery_status ndmp9_recovery_status;

struct ndmp9_log_file_request {
	char *name;
	ndmp9_recovery_status recovery_status;
};
typedef struct ndmp9_log_file_request ndmp9_log_file_request;

enum ndmp9_file_type {
	NDMP9_FILE_DIR = 0,
	NDMP9_FILE_FIFO = 1,
	NDMP9_FILE_CSPEC = 2,
	NDMP9_FILE_BSPEC = 3,
	NDMP9_FILE_REG = 4,
	NDMP9_FILE_SLINK = 5,
	NDMP9_FILE_SOCK = 6,
	NDMP9_FILE_REGISTRY = 7,
	NDMP9_FILE_OTHER = 8,
};
typedef enum ndmp9_file_type ndmp9_file_type;

struct ndmp9_file_stat {
	ndmp9_file_type ftype;
	ndmp9_valid_u_long mtime;
	ndmp9_valid_u_long atime;
	ndmp9_valid_u_long ctime;
	ndmp9_valid_u_long uid;
	ndmp9_valid_u_long gid;
	ndmp9_valid_u_long mode;
	ndmp9_valid_u_quad size;
	ndmp9_valid_u_long links;
	ndmp9_valid_u_quad node;
	ndmp9_valid_u_quad fh_info;
};
typedef struct ndmp9_file_stat ndmp9_file_stat;

struct ndmp9_file {
	char *unix_path;
	ndmp9_file_stat fstat;
};
typedef struct ndmp9_file ndmp9_file;

struct ndmp9_fh_add_file_request {
	struct {
		u_int files_len;
		ndmp9_file *files_val;
	} files;
};
typedef struct ndmp9_fh_add_file_request ndmp9_fh_add_file_request;

struct ndmp9_dir {
	char *unix_name;
	ndmp9_u_quad node;
	ndmp9_u_quad parent;
};
typedef struct ndmp9_dir ndmp9_dir;

struct ndmp9_fh_add_dir_request {
	struct {
		u_int dirs_len;
		ndmp9_dir *dirs_val;
	} dirs;
};
typedef struct ndmp9_fh_add_dir_request ndmp9_fh_add_dir_request;

struct ndmp9_node {
	ndmp9_file_stat fstat;
};
typedef struct ndmp9_node ndmp9_node;

struct ndmp9_fh_add_node_request {
	struct {
		u_int nodes_len;
		ndmp9_node *nodes_val;
	} nodes;
};
typedef struct ndmp9_fh_add_node_request ndmp9_fh_add_node_request;

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_ndmp9_error (XDR *, ndmp9_error*);
extern  bool_t xdr_ndmp9_message (XDR *, ndmp9_message*);
extern  bool_t xdr_ndmp9_just_error_reply (XDR *, ndmp9_just_error_reply*);
extern  bool_t xdr_ndmp9_validity (XDR *, ndmp9_validity*);
extern  bool_t xdr_ndmp9_valid_u_long (XDR *, ndmp9_valid_u_long*);
extern  bool_t xdr_ndmp9_valid_u_quad (XDR *, ndmp9_valid_u_quad*);
extern  bool_t xdr_ndmp9_pval (XDR *, ndmp9_pval*);
extern  bool_t xdr_ndmp9_auth_type (XDR *, ndmp9_auth_type*);
extern  bool_t xdr_ndmp9_auth_attr (XDR *, ndmp9_auth_attr*);
extern  bool_t xdr_ndmp9_auth_text (XDR *, ndmp9_auth_text*);
extern  bool_t xdr_ndmp9_auth_md5 (XDR *, ndmp9_auth_md5*);
extern  bool_t xdr_ndmp9_auth_data (XDR *, ndmp9_auth_data*);
extern  bool_t xdr_ndmp9_addr_type (XDR *, ndmp9_addr_type*);
extern  bool_t xdr_ndmp9_tcp_addr (XDR *, ndmp9_tcp_addr*);
extern  bool_t xdr_ndmp9_addr (XDR *, ndmp9_addr*);
extern  bool_t xdr_ndmp9_connect_open_request (XDR *, ndmp9_connect_open_request*);
extern  bool_t xdr_ndmp9_connect_open_reply (XDR *, ndmp9_connect_open_reply*);
extern  bool_t xdr_ndmp9_connect_client_auth_request (XDR *, ndmp9_connect_client_auth_request*);
extern  bool_t xdr_ndmp9_connect_client_auth_reply (XDR *, ndmp9_connect_client_auth_reply*);
extern  bool_t xdr_ndmp9_connect_close_request (XDR *, ndmp9_connect_close_request*);
extern  bool_t xdr_ndmp9_connect_close_reply (XDR *, ndmp9_connect_close_reply*);
extern  bool_t xdr_ndmp9_connect_server_auth_request (XDR *, ndmp9_connect_server_auth_request*);
extern  bool_t xdr_ndmp9_connect_server_auth_reply (XDR *, ndmp9_connect_server_auth_reply*);
extern  bool_t xdr_ndmp9_butype_info (XDR *, ndmp9_butype_info*);
extern  bool_t xdr_ndmp9_fs_info (XDR *, ndmp9_fs_info*);
extern  bool_t xdr_ndmp9_device_capability (XDR *, ndmp9_device_capability*);
extern  bool_t xdr_ndmp9_device_info (XDR *, ndmp9_device_info*);
extern  bool_t xdr_ndmp9_config_info (XDR *, ndmp9_config_info*);
extern  bool_t xdr_ndmp9_config_get_info_request (XDR *, ndmp9_config_get_info_request*);
extern  bool_t xdr_ndmp9_config_get_info_reply (XDR *, ndmp9_config_get_info_reply*);
extern  bool_t xdr_ndmp9_config_get_host_info_request (XDR *, ndmp9_config_get_host_info_request*);
extern  bool_t xdr_ndmp9_config_get_host_info_reply (XDR *, ndmp9_config_get_host_info_reply*);
extern  bool_t xdr_ndmp9_config_get_connection_type_request (XDR *, ndmp9_config_get_connection_type_request*);
extern  bool_t xdr_ndmp9_config_get_connection_type_reply (XDR *, ndmp9_config_get_connection_type_reply*);
extern  bool_t xdr_ndmp9_config_get_server_info_request (XDR *, ndmp9_config_get_server_info_request*);
extern  bool_t xdr_ndmp9_config_get_server_info_reply (XDR *, ndmp9_config_get_server_info_reply*);
extern  bool_t xdr_ndmp9_config_get_butype_info_request (XDR *, ndmp9_config_get_butype_info_request*);
extern  bool_t xdr_ndmp9_config_get_butype_info_reply (XDR *, ndmp9_config_get_butype_info_reply*);
extern  bool_t xdr_ndmp9_config_get_fs_info_request (XDR *, ndmp9_config_get_fs_info_request*);
extern  bool_t xdr_ndmp9_config_get_fs_info_reply (XDR *, ndmp9_config_get_fs_info_reply*);
extern  bool_t xdr_ndmp9_config_get_tape_info_request (XDR *, ndmp9_config_get_tape_info_request*);
extern  bool_t xdr_ndmp9_config_get_tape_info_reply (XDR *, ndmp9_config_get_tape_info_reply*);
extern  bool_t xdr_ndmp9_config_get_scsi_info_request (XDR *, ndmp9_config_get_scsi_info_request*);
extern  bool_t xdr_ndmp9_config_get_scsi_info_reply (XDR *, ndmp9_config_get_scsi_info_reply*);
extern  bool_t xdr_ndmp9_config_get_auth_attr_request (XDR *, ndmp9_config_get_auth_attr_request*);
extern  bool_t xdr_ndmp9_config_get_auth_attr_reply (XDR *, ndmp9_config_get_auth_attr_reply*);
extern  bool_t xdr_ndmp9_scsi_open_request (XDR *, ndmp9_scsi_open_request*);
extern  bool_t xdr_ndmp9_scsi_open_reply (XDR *, ndmp9_scsi_open_reply*);
extern  bool_t xdr_ndmp9_scsi_close_request (XDR *, ndmp9_scsi_close_request*);
extern  bool_t xdr_ndmp9_scsi_close_reply (XDR *, ndmp9_scsi_close_reply*);
extern  bool_t xdr_ndmp9_scsi_get_state_request (XDR *, ndmp9_scsi_get_state_request*);
extern  bool_t xdr_ndmp9_scsi_get_state_reply (XDR *, ndmp9_scsi_get_state_reply*);
extern  bool_t xdr_ndmp9_scsi_set_target_request (XDR *, ndmp9_scsi_set_target_request*);
extern  bool_t xdr_ndmp9_scsi_set_target_reply (XDR *, ndmp9_scsi_set_target_reply*);
extern  bool_t xdr_ndmp9_scsi_reset_device_request (XDR *, ndmp9_scsi_reset_device_request*);
extern  bool_t xdr_ndmp9_scsi_reset_device_reply (XDR *, ndmp9_scsi_reset_device_reply*);
extern  bool_t xdr_ndmp9_scsi_reset_bus_request (XDR *, ndmp9_scsi_reset_bus_request*);
extern  bool_t xdr_ndmp9_scsi_reset_bus_reply (XDR *, ndmp9_scsi_reset_bus_reply*);
extern  bool_t xdr_ndmp9_scsi_data_dir (XDR *, ndmp9_scsi_data_dir*);
extern  bool_t xdr_ndmp9_execute_cdb_request (XDR *, ndmp9_execute_cdb_request*);
extern  bool_t xdr_ndmp9_execute_cdb_reply (XDR *, ndmp9_execute_cdb_reply*);
extern  bool_t xdr_ndmp9_scsi_execute_cdb_request (XDR *, ndmp9_scsi_execute_cdb_request*);
extern  bool_t xdr_ndmp9_scsi_execute_cdb_reply (XDR *, ndmp9_scsi_execute_cdb_reply*);
extern  bool_t xdr_ndmp9_tape_open_mode (XDR *, ndmp9_tape_open_mode*);
extern  bool_t xdr_ndmp9_tape_state (XDR *, ndmp9_tape_state*);
extern  bool_t xdr_ndmp9_tape_open_request (XDR *, ndmp9_tape_open_request*);
extern  bool_t xdr_ndmp9_tape_open_reply (XDR *, ndmp9_tape_open_reply*);
extern  bool_t xdr_ndmp9_tape_close_request (XDR *, ndmp9_tape_close_request*);
extern  bool_t xdr_ndmp9_tape_close_reply (XDR *, ndmp9_tape_close_reply*);
extern  bool_t xdr_ndmp9_tape_get_state_request (XDR *, ndmp9_tape_get_state_request*);
extern  bool_t xdr_ndmp9_tape_get_state_reply (XDR *, ndmp9_tape_get_state_reply*);
extern  bool_t xdr_ndmp9_tape_mtio_op (XDR *, ndmp9_tape_mtio_op*);
extern  bool_t xdr_ndmp9_tape_mtio_request (XDR *, ndmp9_tape_mtio_request*);
extern  bool_t xdr_ndmp9_tape_mtio_reply (XDR *, ndmp9_tape_mtio_reply*);
extern  bool_t xdr_ndmp9_tape_write_request (XDR *, ndmp9_tape_write_request*);
extern  bool_t xdr_ndmp9_tape_write_reply (XDR *, ndmp9_tape_write_reply*);
extern  bool_t xdr_ndmp9_tape_read_request (XDR *, ndmp9_tape_read_request*);
extern  bool_t xdr_ndmp9_tape_read_reply (XDR *, ndmp9_tape_read_reply*);
extern  bool_t xdr_ndmp9_tape_execute_cdb_request (XDR *, ndmp9_tape_execute_cdb_request*);
extern  bool_t xdr_ndmp9_tape_execute_cdb_reply (XDR *, ndmp9_tape_execute_cdb_reply*);
extern  bool_t xdr_ndmp9_mover_state (XDR *, ndmp9_mover_state*);
extern  bool_t xdr_ndmp9_mover_mode (XDR *, ndmp9_mover_mode*);
extern  bool_t xdr_ndmp9_mover_pause_reason (XDR *, ndmp9_mover_pause_reason*);
extern  bool_t xdr_ndmp9_mover_halt_reason (XDR *, ndmp9_mover_halt_reason*);
extern  bool_t xdr_ndmp9_mover_get_state_request (XDR *, ndmp9_mover_get_state_request*);
extern  bool_t xdr_ndmp9_mover_get_state_reply (XDR *, ndmp9_mover_get_state_reply*);
extern  bool_t xdr_ndmp9_mover_listen_request (XDR *, ndmp9_mover_listen_request*);
extern  bool_t xdr_ndmp9_mover_listen_reply (XDR *, ndmp9_mover_listen_reply*);
extern  bool_t xdr_ndmp9_mover_connect_request (XDR *, ndmp9_mover_connect_request*);
extern  bool_t xdr_ndmp9_mover_connect_reply (XDR *, ndmp9_mover_connect_reply*);
extern  bool_t xdr_ndmp9_mover_set_record_size_request (XDR *, ndmp9_mover_set_record_size_request*);
extern  bool_t xdr_ndmp9_mover_set_record_size_reply (XDR *, ndmp9_mover_set_record_size_reply*);
extern  bool_t xdr_ndmp9_mover_set_window_request (XDR *, ndmp9_mover_set_window_request*);
extern  bool_t xdr_ndmp9_mover_set_window_reply (XDR *, ndmp9_mover_set_window_reply*);
extern  bool_t xdr_ndmp9_mover_continue_request (XDR *, ndmp9_mover_continue_request*);
extern  bool_t xdr_ndmp9_mover_continue_reply (XDR *, ndmp9_mover_continue_reply*);
extern  bool_t xdr_ndmp9_mover_abort_request (XDR *, ndmp9_mover_abort_request*);
extern  bool_t xdr_ndmp9_mover_abort_reply (XDR *, ndmp9_mover_abort_reply*);
extern  bool_t xdr_ndmp9_mover_stop_request (XDR *, ndmp9_mover_stop_request*);
extern  bool_t xdr_ndmp9_mover_stop_reply (XDR *, ndmp9_mover_stop_reply*);
extern  bool_t xdr_ndmp9_mover_read_request (XDR *, ndmp9_mover_read_request*);
extern  bool_t xdr_ndmp9_mover_read_reply (XDR *, ndmp9_mover_read_reply*);
extern  bool_t xdr_ndmp9_mover_close_request (XDR *, ndmp9_mover_close_request*);
extern  bool_t xdr_ndmp9_mover_close_reply (XDR *, ndmp9_mover_close_reply*);
extern  bool_t xdr_ndmp9_data_operation (XDR *, ndmp9_data_operation*);
extern  bool_t xdr_ndmp9_data_state (XDR *, ndmp9_data_state*);
extern  bool_t xdr_ndmp9_data_halt_reason (XDR *, ndmp9_data_halt_reason*);
extern  bool_t xdr_ndmp9_data_get_state_request (XDR *, ndmp9_data_get_state_request*);
extern  bool_t xdr_ndmp9_data_get_state_reply (XDR *, ndmp9_data_get_state_reply*);
extern  bool_t xdr_ndmp9_name (XDR *, ndmp9_name*);
extern  bool_t xdr_ndmp9_data_start_backup_request (XDR *, ndmp9_data_start_backup_request*);
extern  bool_t xdr_ndmp9_data_start_backup_reply (XDR *, ndmp9_data_start_backup_reply*);
extern  bool_t xdr_ndmp9_data_start_recover_request (XDR *, ndmp9_data_start_recover_request*);
extern  bool_t xdr_ndmp9_data_start_recover_reply (XDR *, ndmp9_data_start_recover_reply*);
extern  bool_t xdr_ndmp9_data_start_recover_filehist_request (XDR *, ndmp9_data_start_recover_filehist_request*);
extern  bool_t xdr_ndmp9_data_start_recover_filehist_reply (XDR *, ndmp9_data_start_recover_filehist_reply*);
extern  bool_t xdr_ndmp9_data_abort_request (XDR *, ndmp9_data_abort_request*);
extern  bool_t xdr_ndmp9_data_abort_reply (XDR *, ndmp9_data_abort_reply*);
extern  bool_t xdr_ndmp9_data_stop_request (XDR *, ndmp9_data_stop_request*);
extern  bool_t xdr_ndmp9_data_stop_reply (XDR *, ndmp9_data_stop_reply*);
extern  bool_t xdr_ndmp9_data_get_env_request (XDR *, ndmp9_data_get_env_request*);
extern  bool_t xdr_ndmp9_data_get_env_reply (XDR *, ndmp9_data_get_env_reply*);
extern  bool_t xdr_ndmp9_data_listen_request (XDR *, ndmp9_data_listen_request*);
extern  bool_t xdr_ndmp9_data_listen_reply (XDR *, ndmp9_data_listen_reply*);
extern  bool_t xdr_ndmp9_data_connect_request (XDR *, ndmp9_data_connect_request*);
extern  bool_t xdr_ndmp9_data_connect_reply (XDR *, ndmp9_data_connect_reply*);
extern  bool_t xdr_ndmp9_notify_data_halted_request (XDR *, ndmp9_notify_data_halted_request*);
extern  bool_t xdr_ndmp9_connect_reason (XDR *, ndmp9_connect_reason*);
extern  bool_t xdr_ndmp9_notify_connected_request (XDR *, ndmp9_notify_connected_request*);
extern  bool_t xdr_ndmp9_notify_mover_halted_request (XDR *, ndmp9_notify_mover_halted_request*);
extern  bool_t xdr_ndmp9_notify_mover_paused_request (XDR *, ndmp9_notify_mover_paused_request*);
extern  bool_t xdr_ndmp9_notify_data_read_request (XDR *, ndmp9_notify_data_read_request*);
extern  bool_t xdr_ndmp9_log_type (XDR *, ndmp9_log_type*);
extern  bool_t xdr_ndmp9_log_message_request (XDR *, ndmp9_log_message_request*);
extern  bool_t xdr_ndmp9_recovery_status (XDR *, ndmp9_recovery_status*);
extern  bool_t xdr_ndmp9_log_file_request (XDR *, ndmp9_log_file_request*);
extern  bool_t xdr_ndmp9_file_type (XDR *, ndmp9_file_type*);
extern  bool_t xdr_ndmp9_file_stat (XDR *, ndmp9_file_stat*);
extern  bool_t xdr_ndmp9_file (XDR *, ndmp9_file*);
extern  bool_t xdr_ndmp9_fh_add_file_request (XDR *, ndmp9_fh_add_file_request*);
extern  bool_t xdr_ndmp9_dir (XDR *, ndmp9_dir*);
extern  bool_t xdr_ndmp9_fh_add_dir_request (XDR *, ndmp9_fh_add_dir_request*);
extern  bool_t xdr_ndmp9_node (XDR *, ndmp9_node*);
extern  bool_t xdr_ndmp9_fh_add_node_request (XDR *, ndmp9_fh_add_node_request*);

#else /* K&R C */
extern bool_t xdr_ndmp9_error ();
extern bool_t xdr_ndmp9_message ();
extern bool_t xdr_ndmp9_just_error_reply ();
extern bool_t xdr_ndmp9_validity ();
extern bool_t xdr_ndmp9_valid_u_long ();
extern bool_t xdr_ndmp9_valid_u_quad ();
extern bool_t xdr_ndmp9_pval ();
extern bool_t xdr_ndmp9_auth_type ();
extern bool_t xdr_ndmp9_auth_attr ();
extern bool_t xdr_ndmp9_auth_text ();
extern bool_t xdr_ndmp9_auth_md5 ();
extern bool_t xdr_ndmp9_auth_data ();
extern bool_t xdr_ndmp9_addr_type ();
extern bool_t xdr_ndmp9_tcp_addr ();
extern bool_t xdr_ndmp9_addr ();
extern bool_t xdr_ndmp9_connect_open_request ();
extern bool_t xdr_ndmp9_connect_open_reply ();
extern bool_t xdr_ndmp9_connect_client_auth_request ();
extern bool_t xdr_ndmp9_connect_client_auth_reply ();
extern bool_t xdr_ndmp9_connect_close_request ();
extern bool_t xdr_ndmp9_connect_close_reply ();
extern bool_t xdr_ndmp9_connect_server_auth_request ();
extern bool_t xdr_ndmp9_connect_server_auth_reply ();
extern bool_t xdr_ndmp9_butype_info ();
extern bool_t xdr_ndmp9_fs_info ();
extern bool_t xdr_ndmp9_device_capability ();
extern bool_t xdr_ndmp9_device_info ();
extern bool_t xdr_ndmp9_config_info ();
extern bool_t xdr_ndmp9_config_get_info_request ();
extern bool_t xdr_ndmp9_config_get_info_reply ();
extern bool_t xdr_ndmp9_config_get_host_info_request ();
extern bool_t xdr_ndmp9_config_get_host_info_reply ();
extern bool_t xdr_ndmp9_config_get_connection_type_request ();
extern bool_t xdr_ndmp9_config_get_connection_type_reply ();
extern bool_t xdr_ndmp9_config_get_server_info_request ();
extern bool_t xdr_ndmp9_config_get_server_info_reply ();
extern bool_t xdr_ndmp9_config_get_butype_info_request ();
extern bool_t xdr_ndmp9_config_get_butype_info_reply ();
extern bool_t xdr_ndmp9_config_get_fs_info_request ();
extern bool_t xdr_ndmp9_config_get_fs_info_reply ();
extern bool_t xdr_ndmp9_config_get_tape_info_request ();
extern bool_t xdr_ndmp9_config_get_tape_info_reply ();
extern bool_t xdr_ndmp9_config_get_scsi_info_request ();
extern bool_t xdr_ndmp9_config_get_scsi_info_reply ();
extern bool_t xdr_ndmp9_config_get_auth_attr_request ();
extern bool_t xdr_ndmp9_config_get_auth_attr_reply ();
extern bool_t xdr_ndmp9_scsi_open_request ();
extern bool_t xdr_ndmp9_scsi_open_reply ();
extern bool_t xdr_ndmp9_scsi_close_request ();
extern bool_t xdr_ndmp9_scsi_close_reply ();
extern bool_t xdr_ndmp9_scsi_get_state_request ();
extern bool_t xdr_ndmp9_scsi_get_state_reply ();
extern bool_t xdr_ndmp9_scsi_set_target_request ();
extern bool_t xdr_ndmp9_scsi_set_target_reply ();
extern bool_t xdr_ndmp9_scsi_reset_device_request ();
extern bool_t xdr_ndmp9_scsi_reset_device_reply ();
extern bool_t xdr_ndmp9_scsi_reset_bus_request ();
extern bool_t xdr_ndmp9_scsi_reset_bus_reply ();
extern bool_t xdr_ndmp9_scsi_data_dir ();
extern bool_t xdr_ndmp9_execute_cdb_request ();
extern bool_t xdr_ndmp9_execute_cdb_reply ();
extern bool_t xdr_ndmp9_scsi_execute_cdb_request ();
extern bool_t xdr_ndmp9_scsi_execute_cdb_reply ();
extern bool_t xdr_ndmp9_tape_open_mode ();
extern bool_t xdr_ndmp9_tape_state ();
extern bool_t xdr_ndmp9_tape_open_request ();
extern bool_t xdr_ndmp9_tape_open_reply ();
extern bool_t xdr_ndmp9_tape_close_request ();
extern bool_t xdr_ndmp9_tape_close_reply ();
extern bool_t xdr_ndmp9_tape_get_state_request ();
extern bool_t xdr_ndmp9_tape_get_state_reply ();
extern bool_t xdr_ndmp9_tape_mtio_op ();
extern bool_t xdr_ndmp9_tape_mtio_request ();
extern bool_t xdr_ndmp9_tape_mtio_reply ();
extern bool_t xdr_ndmp9_tape_write_request ();
extern bool_t xdr_ndmp9_tape_write_reply ();
extern bool_t xdr_ndmp9_tape_read_request ();
extern bool_t xdr_ndmp9_tape_read_reply ();
extern bool_t xdr_ndmp9_tape_execute_cdb_request ();
extern bool_t xdr_ndmp9_tape_execute_cdb_reply ();
extern bool_t xdr_ndmp9_mover_state ();
extern bool_t xdr_ndmp9_mover_mode ();
extern bool_t xdr_ndmp9_mover_pause_reason ();
extern bool_t xdr_ndmp9_mover_halt_reason ();
extern bool_t xdr_ndmp9_mover_get_state_request ();
extern bool_t xdr_ndmp9_mover_get_state_reply ();
extern bool_t xdr_ndmp9_mover_listen_request ();
extern bool_t xdr_ndmp9_mover_listen_reply ();
extern bool_t xdr_ndmp9_mover_connect_request ();
extern bool_t xdr_ndmp9_mover_connect_reply ();
extern bool_t xdr_ndmp9_mover_set_record_size_request ();
extern bool_t xdr_ndmp9_mover_set_record_size_reply ();
extern bool_t xdr_ndmp9_mover_set_window_request ();
extern bool_t xdr_ndmp9_mover_set_window_reply ();
extern bool_t xdr_ndmp9_mover_continue_request ();
extern bool_t xdr_ndmp9_mover_continue_reply ();
extern bool_t xdr_ndmp9_mover_abort_request ();
extern bool_t xdr_ndmp9_mover_abort_reply ();
extern bool_t xdr_ndmp9_mover_stop_request ();
extern bool_t xdr_ndmp9_mover_stop_reply ();
extern bool_t xdr_ndmp9_mover_read_request ();
extern bool_t xdr_ndmp9_mover_read_reply ();
extern bool_t xdr_ndmp9_mover_close_request ();
extern bool_t xdr_ndmp9_mover_close_reply ();
extern bool_t xdr_ndmp9_data_operation ();
extern bool_t xdr_ndmp9_data_state ();
extern bool_t xdr_ndmp9_data_halt_reason ();
extern bool_t xdr_ndmp9_data_get_state_request ();
extern bool_t xdr_ndmp9_data_get_state_reply ();
extern bool_t xdr_ndmp9_name ();
extern bool_t xdr_ndmp9_data_start_backup_request ();
extern bool_t xdr_ndmp9_data_start_backup_reply ();
extern bool_t xdr_ndmp9_data_start_recover_request ();
extern bool_t xdr_ndmp9_data_start_recover_reply ();
extern bool_t xdr_ndmp9_data_start_recover_filehist_request ();
extern bool_t xdr_ndmp9_data_start_recover_filehist_reply ();
extern bool_t xdr_ndmp9_data_abort_request ();
extern bool_t xdr_ndmp9_data_abort_reply ();
extern bool_t xdr_ndmp9_data_stop_request ();
extern bool_t xdr_ndmp9_data_stop_reply ();
extern bool_t xdr_ndmp9_data_get_env_request ();
extern bool_t xdr_ndmp9_data_get_env_reply ();
extern bool_t xdr_ndmp9_data_listen_request ();
extern bool_t xdr_ndmp9_data_listen_reply ();
extern bool_t xdr_ndmp9_data_connect_request ();
extern bool_t xdr_ndmp9_data_connect_reply ();
extern bool_t xdr_ndmp9_notify_data_halted_request ();
extern bool_t xdr_ndmp9_connect_reason ();
extern bool_t xdr_ndmp9_notify_connected_request ();
extern bool_t xdr_ndmp9_notify_mover_halted_request ();
extern bool_t xdr_ndmp9_notify_mover_paused_request ();
extern bool_t xdr_ndmp9_notify_data_read_request ();
extern bool_t xdr_ndmp9_log_type ();
extern bool_t xdr_ndmp9_log_message_request ();
extern bool_t xdr_ndmp9_recovery_status ();
extern bool_t xdr_ndmp9_log_file_request ();
extern bool_t xdr_ndmp9_file_type ();
extern bool_t xdr_ndmp9_file_stat ();
extern bool_t xdr_ndmp9_file ();
extern bool_t xdr_ndmp9_fh_add_file_request ();
extern bool_t xdr_ndmp9_dir ();
extern bool_t xdr_ndmp9_fh_add_dir_request ();
extern bool_t xdr_ndmp9_node ();
extern bool_t xdr_ndmp9_fh_add_node_request ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_NDMP9_H_RPCGEN */
