//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef CONFIGURATION_GROUPICON_H
#define CONFIGURATION_GROUPICON_H

//--------------------
//forward declarations
class QPixmap;
class QString;
//--------------------

#include <qiconview.h>
#include <qobject.h>
#include <qstring.h>

//=====================================
/*! \brief Displays group icon and text, also contains pointer to widget for setting group settings
 */
//=====================================
class GroupIcon : public QIconViewItem
{
public:
  //creates icon, sets pointer to associated settings widget
  GroupIcon( QIconView* parent,
                  QPixmap icon,
                  QString text,
                  QWidget* settingsWidget );

  void paintItem( QPainter* p, const QColorGroup& cg);

  void paintFocus( QPainter *p, const QColorGroup &cg );

  void setMousedOver(bool val);

  QWidget* getSettingsWidget();

protected:
//  void calcRect ( const QString & text_ = QString::null );    
private:
  //initializes item rect size
  void initializeItemRect();    
    
  QIconView* parent;
  QWidget* settingsWidget;
  bool mousedOver;

};
//======================

#endif //CONFIGURATION_GROUPICON_H
