// ---------------------------------------------------------------------------
// - cmth.hpp                                                                -
// - standard system library - c math native function definition             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_CMTH_HPP
#define  AFNIX_CMTH_HPP

#ifndef  AFNIX_CCNF_HPP
#include "ccnf.hpp"
#endif

namespace afnix {

  /// @return true if the double is nan
  bool c_isnan (const double x);

  /// @return the ceiling of the argument
  double c_ceiling (const double x);

  /// @return the floor of the argument
  double c_floor (const double x);

  /// @return the absolute value of the argument
  double c_abs (const double x);

  /// @return the remainder of x divided by y
  double c_mod (const double x, const double y);

  /// @return the square root of the number
  double c_sqrt (const double x, bool& status);

  /// @return the natural logarithm of the number
  double c_log (const double x, bool& status);

  /// @return the exponential of the argument
  double c_exp (const double x);

  /// @return the x**y value of the arguments
  double c_pow (const double x, const double y);

  /// @return the sine of the argument in radian
  double c_sin (const double x);

  /// @return the cosine of the argument in radian
  double c_cos (const double x);

  /// @return the tangent of the argument in radian
  double c_tan (const double x);

  /// @return the arc sine of the argument
  double c_asin (const double x, bool& status);

  /// @return the arc cosine of the argument in radian
  double c_acos (const double x, bool& status);

  /// @return the tangent of the argument in radian
  double c_atan (const double x, bool& status);

  /// @return the hyperbolic sine of the argument
  double c_sinh (const double x, bool& status);

  /// @return the hyperbolic cosine of the argument
  double c_cosh (const double x, bool& status);

  /// @return the hyperbolic tangent of the argument
  double c_tanh (const double x, bool& status);

  /// @return the hyperbolic arc sine of the argument
  double c_asinh (const double x, bool& status);

  /// @return the hyperbolic arc cosine of the argument
  double c_acosh (const double x, bool& status);

  /// @return the hyperbolic arc tangent of the argument
  double c_atanh (const double x, bool& status);
}

#endif
