#!/bin/sh
JAR="/usr/share/java/acgvision-agent.jar"
AGENTCONFIGURATIONFILE="/etc/acgvision/agent.ini"
LOG4JFILE="/etc/acgvision/agent-log4j.properties"
TrustStore="/etc/acgvision/acgTrustStore.certs" 
TrustStorePassword="changeit" 
SSLOptions=" -Djavax.net.ssl.trustStore=$TrustStore -Djavax.net.ssl.trustStorePassword=$TrustStorePassword "
JAVA="/etc/alternatives/java"

if ! test -e "$JAVA";then
        echo "$JAVA does not exists"
        echo "Please Install SUN Java JRE"
        exit 100
fi


if ! test -e "$JAR";then
	echo "$JAR does not exists"
	exit 1
fi

if ! test -e "$TrustStore";then
        echo "$TrustStore does not exists"
        exit 2
fi

if ! test -e "$AGENTCONFIGURATIONFILE";then 
	echo "$AGENTCONFIGURATIONFILE does not exists"
	exit 3
fi

if ! test -e "$LOG4JFILE";then
	echo "$LOG4JFILE does not exists"
	exit 4
fi

echo $CLASSPATH
$JAVA -Xms8m -Xmx40m -Dlog4j.configuration=$LOG4JFILE $SSLOptions -jar $JAR  -configurationfile $AGENTCONFIGURATIONFILE  >> /var/log/acgvision/agent.log 2>&1 &

exit 0;

