!{\src2tex{textfont=tt}}
!!****f* ABINIT/setup2
!!
!! NAME
!! setup2
!!
!! FUNCTION
!! Call within main routine for setup of various arrays.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dedlnn=d(Etot)/d(log(npw)) (input variable, hartree)
!!  ecut=kinetic energy cutoff for planewave basis (hartree)
!!  iscf=parameter controlling scf or non-scf choice
!!  istwfk(nkpt)=input option parameter that describes the storage of wfs
!!  natom=number of atoms in unit cell
!!  nkpt=number of k points
!!  npwtot(nkpt)=number of planewaves in basis and boundary at each k point
!!  ucvol=unit cell volume (bohr^3)
!!  wtk(nkpt)=integration weight associated with each k point
!!  xred(3,natom)=starting reduced atomic coordinates
!!
!! OUTPUT
!!  epulay=Pulay basis set correction to total energy using method
!!   of Francis and Payne (reference below).
!!  start(3,natom)=copy of starting xred
!!
!! PARENTS
!!      gstate
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine setup2(dedlnn,ecut,epulay,iscf,istwfk,natom,nkpt,&
&  npwtot,start,ucvol,wtk,xred)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iscf,natom,nkpt
 real(dp),intent(in) :: dedlnn,ecut,ucvol
 real(dp),intent(out) :: epulay
!arrays
 integer,intent(in) :: istwfk(nkpt),npwtot(nkpt)
 real(dp),intent(in) :: wtk(nkpt),xred(3,natom)
 real(dp),intent(out) :: start(3,natom)

!Local variables-------------------------------
!scalars
 integer :: ikpt,npw
 real(dp) :: arith,geom,wtknrm
 character(len=500) :: message

! *************************************************************************

 epulay=0._dp
 if (iscf>0) then

! Copy coordinates into array start
  start(:,:)=xred(:,:)

! Get average number of planewaves per k point:
! both arithmetic and GEOMETRIC averages are desired--
! need geometric average to use method of Francis and Payne,
! J. Phys.: Condens. Matter 2, 4395-4404 (1990).
! Also note: force k point wts to sum to 1 for this averaging.
! (wtk is not forced to add to 1 in a case with occopt=2)
  wtknrm=sum(wtk(:))

  arith=0.0_dp
  geom=1.0_dp
  do ikpt=1,nkpt
   npw=npwtot(ikpt)
   arith=arith+npw*wtk(ikpt)
   geom=geom*npw**wtk(ikpt)
  end do

! Enforce normalization of weights to 1
  arith=arith/wtknrm
  geom=geom**(1.0_dp/wtknrm)

! Ensure portability of output thanks to tol8
  write(message, '(a,2f12.3)' ) &
&   ' setup2: Arith. and geom. avg. npw (full set) are',arith+tol8,geom
  call wrtout(ab_out,message,'COLL')
  call wrtout(06,  message,'COLL')

! Compute Francis and Payne correction to total energy
! (this number gets ADDED to the total energy to get the
! corrected total energy)
  epulay=-dedlnn*&
&    log(geom/(ucvol*((2._dp*ecut)**1.5_dp)/(6._dp*pi**2)))

 end if

end subroutine setup2
!!***
