!{\src2tex{textfont=tt}}
!!****f* ABINIT/opernld_ylm
!! NAME
!! opernld_ylm
!!
!! FUNCTION
!! * Operate with the non-local part of the hamiltonian,
!!   in order to get contributions to energy/forces/stress/dyn.matrix/elst tens.
!!   from projected scalars
!! * Operate with the non-local projectors and the overlap matrix Sij
!!   in order to get contributions to <c|S|c>
!!   from projected scalars
!! * Operate with the non-local projectors
!!   in order to get contributions to rhoij PAW quantities
!!   from projected scalars
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  atindx1(natom)=index table for atoms (gives the absolute index of
!!                 an atom from its rank in a block of atoms)
!!  choice=chooses possible output
!!  cplex=1 if <p_lmn|c> scalars are real (equivalent to istwfk>1)
!!        2 if <p_lmn|c> scalars are complex
!!  d2gxdt(cplex,nd2gxdt,nlmn,nincat)=2nd gradients of projected scalars
!!  dgxdt(cplex,ndgxdt,nlmn,nincat)=gradients of projected scalars
!!  dgxdtfac(cplex,ndgxdtfac,nlmn,nincat)=gradients of reduced projected scalars
!!  gx(cplex,nlmn,nincat)= projected scalars
!!  gxfac(cplex,nlmn,nincat)= reduced projected scalars related to Vnl (NL operator)
!!  gxfac_sij(cplex,nlmn,nincat)= reduced projected scalars related to Sij (overlap)
!!  ia3=gives the absolute number of the first atom in the subset presently treated
!!  ia5=gives the rank in the type of the first atom of the subset presently treated
!!  iatm=absolute rank of first atom of the current block of atoms
!!  indlmn(6,nlmn)= array giving l,m,n,lm,ln,s for i=lmn
!!  lmnmax=max. number of (l,m,n) numbers over all types of atom
!!  natom=number of atoms in cell
!!  nd2gxdt=second dimension of d2gxdt
!!  ndgxdt=second dimension of dgxdt
!!  ndgxdtfac=second dimension of dgxdtfac
!!  nincat=number of atoms in the subset here treated
!!  nlmn=number of (l,m,n) numbers for current type of atom
!!  nnlout=dimension of enlout
!!  paw_opt= define the nonlocal operator concerned with:
!!           paw_opt=0 : Norm-conserving Vnl (use of Kleinman-Bylander ener.)
!!           paw_opt=1 : PAW nonlocal part of H (use of Dij coeffs)
!!           paw_opt=2 : PAW: (Vnl-lambda.Sij) (Sij=overlap matrix)
!!           paw_opt=3 : PAW overlap matrix (Sij)
!!           paw_opt=4 : both PAW nonlocal part of H (Dij) and overlap matrix (Sij)
!!           paw_opt=-1: PAW augmentation occupancies (rhoij)
!!  rhoijshift= shift used to access into rhoij array (pawopt=2 only)
!!  ucvol=unit cell volume (bohr^3)
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!! --If (paw_opt==0, 1 or 2)
!!    enlout(nnlout)= contribution to the non-local part of the following properties:
!!      if choice=1 : enlout(1)               -> the energy
!!      if choice=2 : enlout(1:3*natom)       -> the forces
!!      if choice=3 : enlout(1:6)             -> the stresses
!!      if choice=23: enlout(1:6+3*natom)     -> the forces and the stresses
!!      if choice=4 : enlout(1:6*natom)       -> the frozen wf part of dyn. mat.
!!      if choice=24: enlout(1:9*natom)       -> the forces and the frozen wf part of dyn. mat.
!!      if choice=6 : enlout(1:6*(3*natom+6)) -> the frozen wf part of elastic tensor
!!    if (choice==3.or.choice==6.or.choice==23)
!!      enlk=contribution to the non-local part of the energy
!!    if (choice==6)
!!      fnlk(3*natom)=contribution to the non-local part of the forces
!!      strnlk(6)=contribution to the non-local part of the stresses
!! --If (paw_opt==3)
!!    if choice=1 : enlout(nnlout)= contribution to <c|S|c>  (nnlout=1)
!! --If (paw_opt==4)
!!    not available
!! --If (paw_opt==-1)
!!    enlout(nnlout)= contribution to rhoij PAW quantities (and derivatives):
!!                    related the following properties:
!!      if choice=1 : enlout(:)   -> rhoij
!!      if choice=2 : enlout(:)   -> first derivatives vs atm pos.
!!      if choice=3 : enlout(:)   -> first derivatives vs strains
!!      if choice=4 : enlout(:)   -> second derivatives vs atm pos.
!!      if choice=23: enlout(:)   -> first derivatives vs atm pos. and strains
!!      if choice=24: enlout(:)   -> first and second derivatives vs atm pos.
!!
!! NOTES
!! Operate for one type of atom, and within this given type of atom,
!! for a subset of at most nincat atoms.
!!
!! PARENTS
!!      nonlop_ylm
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine opernld_ylm(atindx1,choice,cplex,d2gxdt,dgxdt,dgxdtfac,enlk,enlout,fnlk,&
&                      gx,gxfac,gxfac_sij,ia3,ia5,indlmn,lmnmax,natom,nd2gxdt,&
&                      ndgxdt,ndgxdtfac,nincat,nlmn,nnlout,paw_opt,rhoijshift,&
&                       strnlk,ucvol)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: choice,cplex,ia3,ia5,lmnmax,natom,nd2gxdt,ndgxdt,ndgxdtfac
 integer,intent(in) :: nincat,nlmn,nnlout,paw_opt,rhoijshift
 real(dp),intent(in) :: ucvol
 real(dp),intent(out) :: enlk
!arrays
 integer,intent(in) :: atindx1(natom),indlmn(6,nlmn)
 real(dp),intent(in) :: d2gxdt(cplex,nd2gxdt,nlmn,nincat)
 real(dp),intent(in) :: dgxdt(cplex,ndgxdt,nlmn,nincat)
 real(dp),intent(in) :: dgxdtfac(cplex,ndgxdtfac,nlmn,nincat),gx(cplex,nlmn,nincat)
 real(dp),intent(in) :: gxfac(cplex,nlmn,nincat)
 real(dp),intent(in) :: gxfac_sij(cplex,nlmn,nincat*(paw_opt/3))
 real(dp),intent(inout) :: enlout(nnlout),fnlk(3*natom),strnlk(6)

!Local variables-------------------------------
!scalars
 integer :: dimd2rhoij,dimdrhoij,dimrhoij,ia,iashift,ilmn,iplex,ishift,j0lmn,jlmn,klmn
 integer :: mu,mua,mub,mushift,nu,nushift,rhoijsize
 real(dp) :: factvol
!arrays
 integer,parameter :: alpha(6)=(/1,2,3,3,3,2/),beta(6)=(/1,2,3,2,1,1/)
 real(dp) :: enlj(6),gxi(cplex),gxj(cplex),gxfacj(cplex)
 real(dp),allocatable :: dgxj(:,:)

! *************************************************************************

 if (paw_opt==0.or.paw_opt==1.or.paw_opt==2) then

! ============== Accumulate the non-local energy ===============
  if (choice==1) then
   do ia=1,nincat
    do ilmn=1,nlmn
     do iplex=1,cplex
      enlout(1)=enlout(1)+gxfac(iplex,ilmn,ia)*gx(iplex,ilmn,ia)
     end do
    end do
   end do
  end if

! ============ Accumulate the forces contributions =============
  if (choice==2.or.choice==23.or.choice==24) then
   ishift=0;if (choice==23) ishift=6
   factvol=two*ucvol
   do ia=1,nincat
    enlj(1:3)=zero
    iashift=3*(ia+ia3-2)+ishift
    do ilmn=1,nlmn
     do mu=1,3
      do iplex=1,cplex
       enlj(mu)=enlj(mu)+gxfac(iplex,ilmn,ia)*dgxdt(iplex,mu+ishift,ilmn,ia)
      end do
     end do
    end do
    enlout(iashift+1:iashift+3)=enlout(iashift+1:iashift+3)+factvol*enlj(1:3)
   end do
  end if

! ======== Accumulate the stress tensor contributions ==========
  if (choice==3.or.choice==23) then
   enlj(1:6)=zero
   do ia=1,nincat
    do ilmn=1,nlmn
     gxfacj(1:cplex)=gxfac(1:cplex,ilmn,ia)
     do iplex=1,cplex
      enlk=enlk+gxfacj(iplex)*gx(iplex,ilmn,ia)
     end do
     do mu=1,6
      do iplex=1,cplex
       enlj(mu)=enlj(mu)+gxfacj(iplex)*dgxdt(iplex,mu,ilmn,ia)
      end do
     end do
    end do
   end do
   enlout(1:6)=enlout(1:6)+two*enlj(1:6)
  end if

! ====== Accumulate the dynamical matrix contributions =========
  if (choice==4.or.choice==24) then
   ishift=0;if (choice==24) ishift=3*natom
   factvol=two*ucvol
   do ia=1,nincat
    enlj(1:6)=zero
    iashift=6*(ia+ia3-2)+ishift
    do ilmn=1,nlmn
     do mu=1,6
      mua=alpha(mu);mub=beta(mu)
      do iplex=1,cplex
       enlj(mu)=enlj(mu)+gxfac(iplex,ilmn,ia)*d2gxdt(iplex,mu,ilmn,ia)&
&                       +dgxdtfac(iplex,mub,ilmn,ia)*dgxdt(iplex,mua,ilmn,ia)
      end do
     end do
    end do
    enlout(iashift+1:iashift+6)=factvol*enlj(1:6)
   end do
  end if

! ======= Accumulate the elastic tensor contributions ==========
  if (choice==6) then
   do ia=1,nincat
    iashift=3*(ia+ia3-2)
    do ilmn=1,nlmn
     do iplex=1,cplex
      enlk=enlk+gxfac(iplex,ilmn,ia)*gx(iplex,ilmn,ia)
     end do
     enlj(1:3)=zero
     do mu=1,3
      do iplex=1,cplex
       enlj(mu)=enlj(mu)+gxfac(iplex,ilmn,ia)*dgxdt(iplex,6+mu,ilmn,ia)
      end do
     end do
     fnlk(iashift+1:iashift+3)=fnlk(iashift+1:iashift+3)+two*enlj(1:3)
     enlj(1:6)=zero
     do mu=1,6
      do iplex=1,cplex
       enlj(mu)=enlj(mu)+gxfac(iplex,ilmn,ia)*dgxdt(iplex,mu,ilmn,ia)
      end do
     end do
     strnlk(1:6)=strnlk(1:6)+two*enlj(1:6)
     do mub=1,6
      mushift=6*(mub-1);nushift=(3*natom+6)*(mub-1)
      do mua=1,6
       mu=mushift+mua;nu=nushift+mua
       do iplex=1,cplex
        enlout(nu)=enlout(nu)+two* &
&                 (gxfac(iplex,ilmn,ia)*d2gxdt(iplex,mu,ilmn,ia)&
&                 +dgxdtfac(iplex,mua,ilmn,ia)*dgxdt(iplex,mub,ilmn,ia))
       end do
      end do
      mushift=36+3*(mub-1);nushift=6+iashift+(3*natom+6)*(mub-1)
      do mua=1,3
       mu=mushift+mua;nu=nushift+mua
       do iplex=1,cplex
        enlout(nu)=enlout(nu)+two* &
&                (gxfac(iplex,ilmn,ia)*d2gxdt(iplex,mu,ilmn,ia)&
&                +dgxdtfac(iplex,mub,ilmn,ia)*dgxdt(iplex,6+mua,ilmn,ia))
       end do
      end do
     end do
    end do
   end do
  end if
 end if

! ========= Store contributions to rhoij PAW quantities and derivatives ============
 if (paw_opt==5) then
  dimrhoij=0;dimdrhoij=0;dimd2rhoij=0
  if (choice==1) dimrhoij=dimrhoij+1
  if (choice==2.or.choice==23.or.choice==4.or.choice==24) dimdrhoij=dimdrhoij+3
  if (choice==3.or.choice==23) dimdrhoij=dimdrhoij+6
  if (choice==4.or.choice==24) dimd2rhoij=dimd2rhoij+6
  rhoijsize=(1+dimdrhoij+dimd2rhoij)*nlmn*(nlmn+1)/2
  if (dimd2rhoij>0) allocate(dgxj(cplex,dimdrhoij))
  do ia=1,nincat
   iashift=rhoijshift+rhoijsize*(ia5+ia-2)
   do jlmn=1,nlmn
    j0lmn=jlmn*(jlmn-1)/2
    gxj(1:cplex)=gx(1:cplex,jlmn,ia)
    do ilmn=1,jlmn
     klmn=j0lmn+ilmn
     if (dimdrhoij>0.or.dimd2rhoij>0) gxi(1:cplex)=gx(1:cplex,ilmn,ia)
     if (dimd2rhoij>0) dgxj(1:cplex,1:dimdrhoij)=dgxdt(1:cplex,1:dimdrhoij,jlmn,ia)
!    --- Contribution to rhoij
     if (dimrhoij>0) then
      do iplex=1,cplex
       enlout(iashift+1)=enlout(iashift+1)+gx(iplex,ilmn,ia)*gxj(iplex)
      end do
      iashift=iashift+1
     end if
!    --- Contribution to derivative of rhoij wrt atm pos./strains/...
     if (dimdrhoij>0) then
      do mu=1,dimdrhoij
       do iplex=1,cplex
        enlout(iashift+mu)=enlout(iashift+mu)+dgxdt(iplex,mu,ilmn,ia)*gxj(iplex)&
&                                            +dgxdt(iplex,mu,jlmn,ia)*gxi(iplex)
       end do
      end do
      iashift=iashift+dimdrhoij
     end if
!    --- Contribution to 2nd derivative of rhoij wrt atm pos./strains/...
     if (dimd2rhoij>0) then
      do mu=1,6
       mua=alpha(mu);mub=beta(mu)
       do iplex=1,cplex
        enlout(iashift+mu)=enlout(iashift+mu)+&
&                     d2gxdt(iplex,mu,ilmn,ia)*gxj(iplex) &
&                    +d2gxdt(iplex,mu,jlmn,ia)*gxi(iplex) &
&                    +dgxdt(iplex,mua,ilmn,ia)*dgxj(iplex,mub) &
&                    +dgxdt(iplex,mub,ilmn,ia)*dgxj(iplex,mua)
       end do
      end do
      iashift=iashift+6
     end if
    end do
   end do
  end do
  if (dimd2rhoij>0) deallocate(dgxj)
 end if


! ============== Accumulate contribution to <c|S|c> ===============
 if (paw_opt==3) then
  do ia=1,nincat
   do ilmn=1,nlmn
    do iplex=1,cplex
     enlout(1)=enlout(1)+gxfac_sij(iplex,ilmn,ia)*gx(iplex,ilmn,ia)
    end do
   end do
  end do
 end if

end subroutine opernld_ylm
!!***
