/*
 * intl_text.c - Translation texts to be included in intl.c
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

intl_translate_t intl_string_table[] = {

/* en */ { IDMS_FILE,    "File" },
/* da */ { IDMS_FILE_DA, "Fil" },
/* de */ { IDMS_FILE_DE, "Datei" },
/* fr */ { IDMS_FILE_FR, "Fichier" },
/* hu */ { IDMS_FILE_HU, "Fjl" },
/* it */ { IDMS_FILE_IT, "File" },
/* nl */ { IDMS_FILE_NL, "Bestand" },
/* pl */ { IDMS_FILE_PL, "Plik" },
/* sv */ { IDMS_FILE_SV, "Arkiv" },
/* tr */ { IDMS_FILE_TR, "Dosya" },

/* en */ { IDMS_AUTOSTART_IMAGE,    "Autostart disk/tape image..." },
/* da */ { IDMS_AUTOSTART_IMAGE_DA, "Autostart disk-/bndimage..." },
/* de */ { IDMS_AUTOSTART_IMAGE_DE, "Autostart Disk/Band Image..." },
/* fr */ { IDMS_AUTOSTART_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_AUTOSTART_IMAGE_HU, "Lemez/szalag kpms automatikus indtsa..." },
/* it */ { IDMS_AUTOSTART_IMAGE_IT, "Avvia automaticamente immagine disco/cassetta..." },
/* nl */ { IDMS_AUTOSTART_IMAGE_NL, "Autostart schijf-/tapebestand..." },
/* pl */ { IDMS_AUTOSTART_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_AUTOSTART_IMAGE_SV, "Autostarta disk-/bandavbildningsfil..." },
/* tr */ { IDMS_AUTOSTART_IMAGE_TR, "Disk/Teyp imajn otomatik balat..." },

/* en */ { IDMS_ATTACH_DISK_IMAGE,    "Attach disk image" },
/* da */ { IDMS_ATTACH_DISK_IMAGE_DA, "Tilslut disk-image" },
/* de */ { IDMS_ATTACH_DISK_IMAGE_DE, "Disk Image einlegen" },
/* fr */ { IDMS_ATTACH_DISK_IMAGE_FR, "Insrer une image de disque" },
/* hu */ { IDMS_ATTACH_DISK_IMAGE_HU, "Lemez kpms csatolsa" },
/* it */ { IDMS_ATTACH_DISK_IMAGE_IT, "Seleziona immagine disco" },
/* nl */ { IDMS_ATTACH_DISK_IMAGE_NL, "Koppel schijfbestand aan" },
/* pl */ { IDMS_ATTACH_DISK_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ATTACH_DISK_IMAGE_SV, "Anslut diskettavbildningsfil" },
/* tr */ { IDMS_ATTACH_DISK_IMAGE_TR, "Disk imajn yerletir" },

/* en */ {IDMS_DRIVE_8,    "Drive 8" },
/* da */ {IDMS_DRIVE_8_DA, "Drev 8" },
/* de */ {IDMS_DRIVE_8_DE, "Laufwerk 8" },
/* fr */ {IDMS_DRIVE_8_FR, "Lecteur #8" },
/* hu */ {IDMS_DRIVE_8_HU, "#8-as lemezegysg" },
/* it */ {IDMS_DRIVE_8_IT, "Drive 8" },
/* nl */ {IDMS_DRIVE_8_NL, "Drive 8" },
/* pl */ {IDMS_DRIVE_8_PL, "" },  /* fuzzy */
/* sv */ {IDMS_DRIVE_8_SV, "Enhet 8" },
/* tr */ {IDMS_DRIVE_8_TR, "Src 8" },

/* en */ { IDMS_DRIVE_9,    "Drive 9" },
/* da */ { IDMS_DRIVE_9_DA, "Drev 9" },
/* de */ { IDMS_DRIVE_9_DE, "Laufwerk 9" },
/* fr */ { IDMS_DRIVE_9_FR, "Lecteur #9" },
/* hu */ { IDMS_DRIVE_9_HU, "#9-es lemezegysg" },
/* it */ { IDMS_DRIVE_9_IT, "Drive 9" },
/* nl */ { IDMS_DRIVE_9_NL, "Drive 9" },
/* pl */ { IDMS_DRIVE_9_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DRIVE_9_SV, "Enhet 9" },
/* tr */ { IDMS_DRIVE_9_TR, "Src 9" },

/* en */ { IDMS_DRIVE_10,    "Drive 10" },
/* da */ { IDMS_DRIVE_10_DA, "Drev 10" },
/* de */ { IDMS_DRIVE_10_DE, "Laufwerk 10" },
/* fr */ { IDMS_DRIVE_10_FR, "Lecteur #10" },
/* hu */ { IDMS_DRIVE_10_HU, "#10-es lemezegysg" },
/* it */ { IDMS_DRIVE_10_IT, "Drive 10" },
/* nl */ { IDMS_DRIVE_10_NL, "Drive 10" },
/* pl */ { IDMS_DRIVE_10_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DRIVE_10_SV, "Enhet 10" },
/* tr */ { IDMS_DRIVE_10_TR, "Src 10" },

/* en */ { IDMS_DRIVE_11,    "Drive 11" },
/* da */ { IDMS_DRIVE_11_DA, "Drev 11" },
/* de */ { IDMS_DRIVE_11_DE, "Laufwerk 11" },
/* fr */ { IDMS_DRIVE_11_FR, "Lecteur #11" },
/* hu */ { IDMS_DRIVE_11_HU, "#11-es lemezegysg" },
/* it */ { IDMS_DRIVE_11_IT, "Drive 11" },
/* nl */ { IDMS_DRIVE_11_NL, "Drive 11" },
/* pl */ { IDMS_DRIVE_11_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DRIVE_11_SV, "Enhet 11" },
/* tr */ { IDMS_DRIVE_11_TR, "Src 11" },

/* en */ { IDMS_DETACH_DISK_IMAGE,    "Detach disk image" },
/* da */ { IDMS_DETACH_DISK_IMAGE_DA, "Frakobl disk-image" },
/* de */ { IDMS_DETACH_DISK_IMAGE_DE, "Disk Image entfernen" },
/* fr */ { IDMS_DETACH_DISK_IMAGE_FR, "Retirer une image de disque" },
/* hu */ { IDMS_DETACH_DISK_IMAGE_HU, "Lemezkpms levlasztsa" },
/* it */ { IDMS_DETACH_DISK_IMAGE_IT, "Rimuovi immagine disco" },
/* nl */ { IDMS_DETACH_DISK_IMAGE_NL, "Ontkoppel schijfbestand" },
/* pl */ { IDMS_DETACH_DISK_IMAGE_PL, "Wyjmij obraz dyskietki" },
/* sv */ { IDMS_DETACH_DISK_IMAGE_SV, "Koppla frn diskettavbildningsfil" },
/* tr */ { IDMS_DETACH_DISK_IMAGE_TR, "Disk imajn kart" },

/* en */ { IDMS_ALL,    "All" },
/* da */ { IDMS_ALL_DA, "Alle" },
/* de */ { IDMS_ALL_DE, "Alle" },
/* fr */ { IDMS_ALL_FR, "Tous" },
/* hu */ { IDMS_ALL_HU, "sszes" },
/* it */ { IDMS_ALL_IT, "Tutti" },
/* nl */ { IDMS_ALL_NL, "Alles" },
/* pl */ { IDMS_ALL_PL, "Wszystko" },
/* sv */ { IDMS_ALL_SV, "Alla" },
/* tr */ { IDMS_ALL_TR, "Tm" },

/* en */ { IDMS_FLIP_LIST,    "Flip list" },
/* da */ { IDMS_FLIP_LIST_DA, "Bladreliste" },
/* de */ { IDMS_FLIP_LIST_DE, "Flipliste" },
/* fr */ { IDMS_FLIP_LIST_FR, "" },  /* fuzzy */
/* hu */ { IDMS_FLIP_LIST_HU, "Lemezlista" },
/* it */ { IDMS_FLIP_LIST_IT, "Flip list" },
/* nl */ { IDMS_FLIP_LIST_NL, "Flip lijst" },
/* pl */ { IDMS_FLIP_LIST_PL, "" },  /* fuzzy */
/* sv */ { IDMS_FLIP_LIST_SV, "Vallista" },
/* tr */ { IDMS_FLIP_LIST_TR, "Sralama listesi" },

/* en */ { IDMS_ADD_CURRENT_IMAGE,    "Add current image" },
/* da */ { IDMS_ADD_CURRENT_IMAGE_DA, "Tilfj aktuelt image" },
/* de */ { IDMS_ADD_CURRENT_IMAGE_DE, "Aktuelles Image hinzufgen" },
/* fr */ { IDMS_ADD_CURRENT_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ADD_CURRENT_IMAGE_HU, "Az aktulis kpms hozzadsa" },
/* it */ { IDMS_ADD_CURRENT_IMAGE_IT, "Aggiungi immagine attuale" },
/* nl */ { IDMS_ADD_CURRENT_IMAGE_NL, "Voeg huidig bestand toe" },
/* pl */ { IDMS_ADD_CURRENT_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ADD_CURRENT_IMAGE_SV, "Lgg till aktuell avbildning" },
/* tr */ { IDMS_ADD_CURRENT_IMAGE_TR, "Geerli imaj ekle" },

/* en */ { IDMS_REMOVE_CURRENT_IMAGE,    "Remove current image" },
/* da */ { IDMS_REMOVE_CURRENT_IMAGE_DA, "Fjern aktuelt image" },
/* de */ { IDMS_REMOVE_CURRENT_IMAGE_DE, "Aktuelles Image entfernen" },
/* fr */ { IDMS_REMOVE_CURRENT_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_REMOVE_CURRENT_IMAGE_HU, "Az aktulis kpms eltvoltsa" },
/* it */ { IDMS_REMOVE_CURRENT_IMAGE_IT, "Rimuovi immagine attuale" },
/* nl */ { IDMS_REMOVE_CURRENT_IMAGE_NL, "Verwijder huidig bestand" },
/* pl */ { IDMS_REMOVE_CURRENT_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_REMOVE_CURRENT_IMAGE_SV, "Ta bort aktuell avbildning" },
/* tr */ { IDMS_REMOVE_CURRENT_IMAGE_TR, "Geerli imaj kart" },

/* en */ { IDMS_ATTACH_NEXT_IMAGE,    "Attach next image" },
/* da */ { IDMS_ATTACH_NEXT_IMAGE_DA, "Tilslut nste image" },
/* de */ { IDMS_ATTACH_NEXT_IMAGE_DE, "Nchstes Image" },
/* fr */ { IDMS_ATTACH_NEXT_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ATTACH_NEXT_IMAGE_HU, "Kvetkez kpms csatolsa" },
/* it */ { IDMS_ATTACH_NEXT_IMAGE_IT, "Seleziona immagine successiva" },
/* nl */ { IDMS_ATTACH_NEXT_IMAGE_NL, "Koppel volgend bestand" },
/* pl */ { IDMS_ATTACH_NEXT_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ATTACH_NEXT_IMAGE_SV, "Anslut nsta avbildning" },
/* tr */ { IDMS_ATTACH_NEXT_IMAGE_TR, "Sonraki imaj yerletir" },

/* en */ { IDMS_ATTACH_PREVIOUS_IMAGE,    "Attach previous image" },
/* da */ { IDMS_ATTACH_PREVIOUS_IMAGE_DA, "Tilslut forrige image" },
/* de */ { IDMS_ATTACH_PREVIOUS_IMAGE_DE, "Voriges Image" },
/* fr */ { IDMS_ATTACH_PREVIOUS_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ATTACH_PREVIOUS_IMAGE_HU, "Elz kpms csatolsa" },
/* it */ { IDMS_ATTACH_PREVIOUS_IMAGE_IT, "Seleziona immagine precedente" },
/* nl */ { IDMS_ATTACH_PREVIOUS_IMAGE_NL, "Koppel vorig bestand" },
/* pl */ { IDMS_ATTACH_PREVIOUS_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ATTACH_PREVIOUS_IMAGE_SV, "Anslut fregende avbildning" },
/* tr */ { IDMS_ATTACH_PREVIOUS_IMAGE_TR, "nceki imaj yerletir" },

/* en */ { IDMS_LOAD_FLIP_LIST,    "Load flip list" },
/* da */ { IDMS_LOAD_FLIP_LIST_DA, "Indls bladreliste" },
/* de */ { IDMS_LOAD_FLIP_LIST_DE, "Fliplist Datei Laden" },
/* fr */ { IDMS_LOAD_FLIP_LIST_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LOAD_FLIP_LIST_HU, "Lemezlista betltse" },
/* it */ { IDMS_LOAD_FLIP_LIST_IT, "Carica flip list" },
/* nl */ { IDMS_LOAD_FLIP_LIST_NL, "Laad fliplijst" },
/* pl */ { IDMS_LOAD_FLIP_LIST_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LOAD_FLIP_LIST_SV, "Ls in vallistefil" },
/* tr */ { IDMS_LOAD_FLIP_LIST_TR, "Sralama listesi ykle" },

/* en */ { IDMS_SAVE_FLIP_LIST,    "Save flip list" },
/* da */ { IDMS_SAVE_FLIP_LIST_DA, "Gem bladreliste" },
/* de */ { IDMS_SAVE_FLIP_LIST_DE, "Fliplist Datei Speichern" },
/* fr */ { IDMS_SAVE_FLIP_LIST_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SAVE_FLIP_LIST_HU, "Lemezlista mentse" },
/* it */ { IDMS_SAVE_FLIP_LIST_IT, "Salva fliplist" },
/* nl */ { IDMS_SAVE_FLIP_LIST_NL, "Opslaan fliplijst" },
/* pl */ { IDMS_SAVE_FLIP_LIST_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SAVE_FLIP_LIST_SV, "Spara vallistefil" },
/* tr */ { IDMS_SAVE_FLIP_LIST_TR, "Sralama listesi kaydet" },

/* en */ { IDMS_ATTACH_TAPE_IMAGE,    "Attach tape image..." },
/* da */ { IDMS_ATTACH_TAPE_IMAGE_DA, "Tilslut bnd-image..." },
/* de */ { IDMS_ATTACH_TAPE_IMAGE_DE, "Band Image einlegen..." },
/* fr */ { IDMS_ATTACH_TAPE_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ATTACH_TAPE_IMAGE_HU, "Szalag kpms csatolsa..." },
/* it */ { IDMS_ATTACH_TAPE_IMAGE_IT, "Seleziona immagine cassetta..." },
/* nl */ { IDMS_ATTACH_TAPE_IMAGE_NL, "Koppel tapebestand..." },
/* pl */ { IDMS_ATTACH_TAPE_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ATTACH_TAPE_IMAGE_SV, "Anslut en bandavbildningsfil..." },
/* tr */ { IDMS_ATTACH_TAPE_IMAGE_TR, "Teyp imaj yerletir..." },

/* en */ { IDMS_DETACH_TAPE_IMAGE,    "Detach tape image" },
/* da */ { IDMS_DETACH_TAPE_IMAGE_DA, "Frakobl bnd-image" },
/* de */ { IDMS_DETACH_TAPE_IMAGE_DE, "Band Image entfernen" },
/* fr */ { IDMS_DETACH_TAPE_IMAGE_FR, "Retirer une image datassette..." },
/* hu */ { IDMS_DETACH_TAPE_IMAGE_HU, "Szalag kpms levlasztsa" },
/* it */ { IDMS_DETACH_TAPE_IMAGE_IT, "Rimuovi immagine cassetta" },
/* nl */ { IDMS_DETACH_TAPE_IMAGE_NL, "Ontkoppel tapebestand" },
/* pl */ { IDMS_DETACH_TAPE_IMAGE_PL, "Wyjmij obraz kasety" },
/* sv */ { IDMS_DETACH_TAPE_IMAGE_SV, "Koppla frn bandavbildningsfil" },
/* tr */ { IDMS_DETACH_TAPE_IMAGE_TR, "Teyp imajn kart" },

/* en */ { IDMS_DATASSETTE_CONTROL,    "Datassette control" },
/* da */ { IDMS_DATASSETTE_CONTROL_DA, "Datasettestyring" },
/* de */ { IDMS_DATASSETTE_CONTROL_DE, "Bandlaufwerk Kontrolle" },
/* fr */ { IDMS_DATASSETTE_CONTROL_FR, "Contrle datassette" },
/* hu */ { IDMS_DATASSETTE_CONTROL_HU, "Magn vezrls" },
/* it */ { IDMS_DATASSETTE_CONTROL_IT, "Comandi registratore" },
/* nl */ { IDMS_DATASSETTE_CONTROL_NL, "Datasette regeling" },
/* pl */ { IDMS_DATASSETTE_CONTROL_PL, "Zarzdzanie magnetofonem" },
/* sv */ { IDMS_DATASSETTE_CONTROL_SV, "Datasettestyrning" },
/* tr */ { IDMS_DATASSETTE_CONTROL_TR, "Teyp kontrol" },

/* en */ { IDMS_STOP,    "Stop" },
/* da */ { IDMS_STOP_DA, "Stop" },
/* de */ { IDMS_STOP_DE, "Stop" },
/* fr */ { IDMS_STOP_FR, "Arrt" },
/* hu */ { IDMS_STOP_HU, "Lellts" },
/* it */ { IDMS_STOP_IT, "Stop" },
/* nl */ { IDMS_STOP_NL, "Stop" },
/* pl */ { IDMS_STOP_PL, "Zatrzymaj" },
/* sv */ { IDMS_STOP_SV, "Stoppa" },
/* tr */ { IDMS_STOP_TR, "Dur" },

/* en */ { IDMS_START,    "Start" },
/* da */ { IDMS_START_DA, "Start" },
/* de */ { IDMS_START_DE, "Start" },
/* fr */ { IDMS_START_FR, "" },  /* fuzzy */
/* hu */ { IDMS_START_HU, "Indts" },
/* it */ { IDMS_START_IT, "Avvia" },
/* nl */ { IDMS_START_NL, "Start" },
/* pl */ { IDMS_START_PL, "" },  /* fuzzy */
/* sv */ { IDMS_START_SV, "Starta" },
/* tr */ { IDMS_START_TR, "Balat" },

/* en */ { IDMS_FORWARD,    "Forward" },
/* da */ { IDMS_FORWARD_DA, "Spol frem" },
/* de */ { IDMS_FORWARD_DE, "Forward" },
/* fr */ { IDMS_FORWARD_FR, "En avant" },
/* hu */ { IDMS_FORWARD_HU, "Elrecsvls" },
/* it */ { IDMS_FORWARD_IT, "Avanti" },
/* nl */ { IDMS_FORWARD_NL, "Vooruit" },
/* pl */ { IDMS_FORWARD_PL, "Przewi do przodu" },
/* sv */ { IDMS_FORWARD_SV, "Spola framt" },
/* tr */ { IDMS_FORWARD_TR, "leri" },

/* en */ { IDMS_REWIND,    "Rewind" },
/* da */ { IDMS_REWIND_DA, "Spol tilbage" },
/* de */ { IDMS_REWIND_DE, "Rewind" },
/* fr */ { IDMS_REWIND_FR, "En arrire" },
/* hu */ { IDMS_REWIND_HU, "Visszacsvls" },
/* it */ { IDMS_REWIND_IT, "Indietro" },
/* nl */ { IDMS_REWIND_NL, "Terug" },
/* pl */ { IDMS_REWIND_PL, "Przewi do tyu" },
/* sv */ { IDMS_REWIND_SV, "Spola bakt" },
/* tr */ { IDMS_REWIND_TR, "Geri" },

/* en */ { IDMS_RECORD,    "Record" },
/* da */ { IDMS_RECORD_DA, "Optag" },
/* de */ { IDMS_RECORD_DE, "Record" },
/* fr */ { IDMS_RECORD_FR, "Enregistrer" },
/* hu */ { IDMS_RECORD_HU, "Felvtel" },
/* it */ { IDMS_RECORD_IT, "Registra" },
/* nl */ { IDMS_RECORD_NL, "Opname" },
/* pl */ { IDMS_RECORD_PL, "Rejestruj" },
/* sv */ { IDMS_RECORD_SV, "Spela in" },
/* tr */ { IDMS_RECORD_TR, "Kayt" },

/* en */ { IDMS_RESET,    "Reset" },
/* da */ { IDMS_RESET_DA, "Reset" },
/* de */ { IDMS_RESET_DE, "Reset" },
/* fr */ { IDMS_RESET_FR, "Rinitialiser" },
/* hu */ { IDMS_RESET_HU, "Reset" },
/* it */ { IDMS_RESET_IT, "Reset" },
/* nl */ { IDMS_RESET_NL, "Reset" },
/* pl */ { IDMS_RESET_PL, "Reset" },
/* sv */ { IDMS_RESET_SV, "terstll" },
/* tr */ { IDMS_RESET_TR, "Reset" },

/* en */ { IDMS_RESET_COUNTER,    "Reset Counter" },
/* da */ { IDMS_RESET_COUNTER_DA, "Nulstil tller" },
/* de */ { IDMS_RESET_COUNTER_DE, "Zhler zurcksetzen" },
/* fr */ { IDMS_RESET_COUNTER_FR, "" },  /* fuzzy */
/* hu */ { IDMS_RESET_COUNTER_HU, "Szmll nullzsa" },
/* it */ { IDMS_RESET_COUNTER_IT, "Reset contantore" },
/* nl */ { IDMS_RESET_COUNTER_NL, "Reset Teller" },
/* pl */ { IDMS_RESET_COUNTER_PL, "" },  /* fuzzy */
/* sv */ { IDMS_RESET_COUNTER_SV, "Nollstll rknare" },
/* tr */ { IDMS_RESET_COUNTER_TR, "Sayac Resetle" },

/* en */ { IDMS_ATTACH_CART_IMAGE,    "Attach cartridge image..." },
/* da */ { IDMS_ATTACH_CART_IMAGE_DA, "Tilslut cartridge-image..." },
/* de */ { IDMS_ATTACH_CART_IMAGE_DE, "Erweiterungsmodul einlegen..." },
/* fr */ { IDMS_ATTACH_CART_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ATTACH_CART_IMAGE_HU, "Cartridge kpms csatolsa..." },
/* it */ { IDMS_ATTACH_CART_IMAGE_IT, "Seleziona immagine cartuccia..." },
/* nl */ { IDMS_ATTACH_CART_IMAGE_NL, "Koppel cartridge bestand..." },
/* pl */ { IDMS_ATTACH_CART_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ATTACH_CART_IMAGE_SV, "Anslut insticksmodulfil..." },
/* tr */ { IDMS_ATTACH_CART_IMAGE_TR, "Kartu imaj yerletir..." },

/* en */ { IDMS_GENERIC_IMAGE,    "Generic image..." },
/* da */ { IDMS_GENERIC_IMAGE_DA, "Standard-image..." },
/* de */ { IDMS_GENERIC_IMAGE_DE, "Generisches Image..." },
/* fr */ { IDMS_GENERIC_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_GENERIC_IMAGE_HU, "ltalnos kpms..." },
/* it */ { IDMS_GENERIC_IMAGE_IT, "Immagine generica..." },
/* nl */ { IDMS_GENERIC_IMAGE_NL, "Algemeen bestand..." },
/* pl */ { IDMS_GENERIC_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_GENERIC_IMAGE_SV, "Generisk avbild..." },
/* tr */ { IDMS_GENERIC_IMAGE_TR, "Jenerik imaj..." },

/* en */ { IDMS_MEGA_CART_IMAGE,    "Mega-Cart image..." },
/* da */ { IDMS_MEGA_CART_IMAGE_DA, "Mega-Cart image..." },
/* de */ { IDMS_MEGA_CART_IMAGE_DE, "Mega-Cart Image..." },
/* fr */ { IDMS_MEGA_CART_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_MEGA_CART_IMAGE_HU, "Mega-Cart kpms..." },
/* it */ { IDMS_MEGA_CART_IMAGE_IT, "Immagine Mega-Cart..." },
/* nl */ { IDMS_MEGA_CART_IMAGE_NL, "Mega-Cart bestand..." },
/* pl */ { IDMS_MEGA_CART_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_MEGA_CART_IMAGE_SV, "Mega-Cart-avbildning..." },
/* tr */ { IDMS_MEGA_CART_IMAGE_TR, "Mega-Cart imaj..." },

/* en */ { IDMS_FINAL_EXPANSION_IMAGE,    "Final Expansion image..." },
/* da */ { IDMS_FINAL_EXPANSION_IMAGE_DA, "Final Expansion-image..." },
/* de */ { IDMS_FINAL_EXPANSION_IMAGE_DE, "Final Expansion Image..." },
/* fr */ { IDMS_FINAL_EXPANSION_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_FINAL_EXPANSION_IMAGE_HU, "Final Expansion kpms..." },
/* it */ { IDMS_FINAL_EXPANSION_IMAGE_IT, "Immagine Final Expansion..." },
/* nl */ { IDMS_FINAL_EXPANSION_IMAGE_NL, "Final Expansion bestand..." },
/* pl */ { IDMS_FINAL_EXPANSION_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_FINAL_EXPANSION_IMAGE_SV, "Final Expansion-fil..." },
/* tr */ { IDMS_FINAL_EXPANSION_IMAGE_TR, "Final Expansion imaj..." },

/* en */ { IDMS_FP_IMAGE,    "Vic Flash Plugin image..." },
/* da */ { IDMS_FP_IMAGE_DA, "Vic Flash Plugin-image..." },
/* de */ { IDMS_FP_IMAGE_DE, "Vic Flash Plugin Image..." },
/* fr */ { IDMS_FP_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_FP_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_FP_IMAGE_IT, "Immagine Vic Flash Plugin..." },
/* nl */ { IDMS_FP_IMAGE_NL, "Vic Flash Plugin bestand..." },
/* pl */ { IDMS_FP_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_FP_IMAGE_SV, "Vic Flash insticksmodul-fil..." },
/* tr */ { IDMS_FP_IMAGE_TR, "Vic Flash Plugin imaj..." },

/* en */ { IDMS_ADD_TO_GENERIC,    "Add to generic..." },
/* da */ { IDMS_ADD_TO_GENERIC_DA, "Tilfj til standard..." },
/* de */ { IDMS_ADD_TO_GENERIC_DE, "Zu Universal Image hinzufgen..." },
/* fr */ { IDMS_ADD_TO_GENERIC_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ADD_TO_GENERIC_HU, "ltalnoshoz hozzads..." },
/* it */ { IDMS_ADD_TO_GENERIC_IT, "Aggiungi a generica..." },
/* nl */ { IDMS_ADD_TO_GENERIC_NL, "Voeg toe aan algemeen..." },
/* pl */ { IDMS_ADD_TO_GENERIC_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ADD_TO_GENERIC_SV, "Lgg till generisk.." },
/* tr */ { IDMS_ADD_TO_GENERIC_TR, "Jenerie ekle..." },

/* en */ { IDMS_SMART_ATTACH_IMAGE,    "Smart-attach image..." },
/* da */ { IDMS_SMART_ATTACH_IMAGE_DA, "Smart-tilslut image..." },
/* de */ { IDMS_SMART_ATTACH_IMAGE_DE, "Smart-Einlegen Image Date..." },
/* fr */ { IDMS_SMART_ATTACH_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SMART_ATTACH_IMAGE_HU, "Kpms okos csatolsa..." },
/* it */ { IDMS_SMART_ATTACH_IMAGE_IT, "Immagine Smart-attach..." },
/* nl */ { IDMS_SMART_ATTACH_IMAGE_NL, "Slimme bestandskoppeling..." },
/* pl */ { IDMS_SMART_ATTACH_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SMART_ATTACH_IMAGE_SV, "Smartanslut avbildning..." },
/* tr */ { IDMS_SMART_ATTACH_IMAGE_TR, "Smart-attach imaj..." },

/* en */ { IDMS_4_8_16KB_AT_2000,    "4/8/16KB image at $2000..." },
/* da */ { IDMS_4_8_16KB_AT_2000_DA, "4/8/16KB-image p $2000..." },
/* de */ { IDMS_4_8_16KB_AT_2000_DE, "4/8/16KB Image bei $2000..." },
/* fr */ { IDMS_4_8_16KB_AT_2000_FR, "" },  /* fuzzy */
/* hu */ { IDMS_4_8_16KB_AT_2000_HU, "4/8/16KB kpms $2000 cmen..." },
/* it */ { IDMS_4_8_16KB_AT_2000_IT, "Immagine di 4/8/16KB a $2000..." },
/* nl */ { IDMS_4_8_16KB_AT_2000_NL, "4/8/16KB bestand in $2000..." },
/* pl */ { IDMS_4_8_16KB_AT_2000_PL, "" },  /* fuzzy */
/* sv */ { IDMS_4_8_16KB_AT_2000_SV, "4/8/16KB-fil vid $2000..." },
/* tr */ { IDMS_4_8_16KB_AT_2000_TR, "4/8/16KB imaj $2000 adresinde..." },

/* en */ { IDMS_4_8_16KB_AT_4000,    "4/8/16KB image at $4000..." },
/* da */ { IDMS_4_8_16KB_AT_4000_DA, "4/8/16KB-image p $4000..." },
/* de */ { IDMS_4_8_16KB_AT_4000_DE, "4/8/16KB Image bei $4000..." },
/* fr */ { IDMS_4_8_16KB_AT_4000_FR, "" },  /* fuzzy */
/* hu */ { IDMS_4_8_16KB_AT_4000_HU, "4/8/16KB kpms $4000 cmen..." },
/* it */ { IDMS_4_8_16KB_AT_4000_IT, "Immagine di 4/8/16KB a $4000..." },
/* nl */ { IDMS_4_8_16KB_AT_4000_NL, "4/8/16KB bestand in $4000..." },
/* pl */ { IDMS_4_8_16KB_AT_4000_PL, "" },  /* fuzzy */
/* sv */ { IDMS_4_8_16KB_AT_4000_SV, "4/8/16KB-fil vid $4000..." },
/* tr */ { IDMS_4_8_16KB_AT_4000_TR, "4/8/16KB imaj $4000 adresinde..." },

/* en */ { IDMS_4_8_16KB_AT_6000,    "4/8/16KB image at $6000..." },
/* da */ { IDMS_4_8_16KB_AT_6000_DA, "4/8/16KB-image p $6000..." },
/* de */ { IDMS_4_8_16KB_AT_6000_DE, "4/8/16KB Image bei $6000..." },
/* fr */ { IDMS_4_8_16KB_AT_6000_FR, "" },  /* fuzzy */
/* hu */ { IDMS_4_8_16KB_AT_6000_HU, "4/8/16KB kpms $6000 cmen..." },
/* it */ { IDMS_4_8_16KB_AT_6000_IT, "Immagine di 4/8/16KB a $6000..." },
/* nl */ { IDMS_4_8_16KB_AT_6000_NL, "4/8/16KB bestand in $6000..." },
/* pl */ { IDMS_4_8_16KB_AT_6000_PL, "" },  /* fuzzy */
/* sv */ { IDMS_4_8_16KB_AT_6000_SV, "4/8/16KB-fil vid $6000..." },
/* tr */ { IDMS_4_8_16KB_AT_6000_TR, "4/8/16KB imaj $6000 adresinde..." },

/* en */ { IDMS_4_8KB_AT_A000,    "4/8KB image at $A000..." },
/* da */ { IDMS_4_8KB_AT_A000_DA, "4/8KB-image p $A000..." },
/* de */ { IDMS_4_8KB_AT_A000_DE, "4/8KB Image bei $A000..." },
/* fr */ { IDMS_4_8KB_AT_A000_FR, "" },  /* fuzzy */
/* hu */ { IDMS_4_8KB_AT_A000_HU, "4/8KB kpms $A000 cmen..." },
/* it */ { IDMS_4_8KB_AT_A000_IT, "Immagine di 4/8KB a $A000..." },
/* nl */ { IDMS_4_8KB_AT_A000_NL, "4/8KB bestand in $A000..." },
/* pl */ { IDMS_4_8KB_AT_A000_PL, "" },  /* fuzzy */
/* sv */ { IDMS_4_8KB_AT_A000_SV, "4/8KB-fil vid $A000..." },
/* tr */ { IDMS_4_8KB_AT_A000_TR, "4/8KB imaj $A000 adresinde..." },

/* en */ { IDMS_4KB_AT_B000,    "4KB image at $B000..." },
/* da */ { IDMS_4KB_AT_B000_DA, "4KB-image p $B000..." },
/* de */ { IDMS_4KB_AT_B000_DE, "4KB Image bei $B000..." },
/* fr */ { IDMS_4KB_AT_B000_FR, "" },  /* fuzzy */
/* hu */ { IDMS_4KB_AT_B000_HU, "4KB kpms $B000 cmen..." },
/* it */ { IDMS_4KB_AT_B000_IT, "Immagine di 4KB a $B000..." },
/* nl */ { IDMS_4KB_AT_B000_NL, "4KB bestand in $&B000..." },
/* pl */ { IDMS_4KB_AT_B000_PL, "" },  /* fuzzy */
/* sv */ { IDMS_4KB_AT_B000_SV, "4KB-fil vid $B000..." },
/* tr */ { IDMS_4KB_AT_B000_TR, "4KB imaj $B000 adresinde..." },

/* en */ { IDMS_DETACH_CART_IMAGE,    "Detach cartridge image" },
/* da */ { IDMS_DETACH_CART_IMAGE_DA, "Frakobl cartridge-image" },
/* de */ { IDMS_DETACH_CART_IMAGE_DE, "Erweiterungsmodul Image entfernen" },
/* fr */ { IDMS_DETACH_CART_IMAGE_FR, "Retirer une cartouche" },
/* hu */ { IDMS_DETACH_CART_IMAGE_HU, "Cartridge kpms levlasztsa" },
/* it */ { IDMS_DETACH_CART_IMAGE_IT, "Rimuovi immagine cartuccia" },
/* nl */ { IDMS_DETACH_CART_IMAGE_NL, "Ontkoppel cartridge bestand" },
/* pl */ { IDMS_DETACH_CART_IMAGE_PL, "Wjmij obraz kartrida" },
/* sv */ { IDMS_DETACH_CART_IMAGE_SV, "Koppla frn insticksmodulfil" },
/* tr */ { IDMS_DETACH_CART_IMAGE_TR, "Kartu imajn kart" },

/* en */ { IDMS_C1_LOW_IMAGE,    "C1 low  image..." },
/* da */ { IDMS_C1_LOW_IMAGE_DA, "C1 lav-image..." },
/* de */ { IDMS_C1_LOW_IMAGE_DE, "C1 low Image Datei..." },
/* fr */ { IDMS_C1_LOW_IMAGE_FR, "Image C1 basse..." },
/* hu */ { IDMS_C1_LOW_IMAGE_HU, "C1 als kpms..." },
/* it */ { IDMS_C1_LOW_IMAGE_IT, "Immagine C1 bassa..." },
/* nl */ { IDMS_C1_LOW_IMAGE_NL, "C1 low bestand..." },
/* pl */ { IDMS_C1_LOW_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C1_LOW_IMAGE_SV, "C1 lg-avbildning..." },
/* tr */ { IDMS_C1_LOW_IMAGE_TR, "C1 low imaj..." },

/* en */ { IDMS_C1_HIGH_IMAGE,    "C1 high image..." },
/* da */ { IDMS_C1_HIGH_IMAGE_DA, "C1 hj-image..." },
/* de */ { IDMS_C1_HIGH_IMAGE_DE, "C1 high Image Datei..." },
/* fr */ { IDMS_C1_HIGH_IMAGE_FR, "Image C1 haute..." },
/* hu */ { IDMS_C1_HIGH_IMAGE_HU, "C1 fels kpms..." },
/* it */ { IDMS_C1_HIGH_IMAGE_IT, "Immagine C1 alta..." },
/* nl */ { IDMS_C1_HIGH_IMAGE_NL, "C1 high bestand..." },
/* pl */ { IDMS_C1_HIGH_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C1_HIGH_IMAGE_SV, "C1 hg-avbildning..." },
/* tr */ { IDMS_C1_HIGH_IMAGE_TR, "C1 high imaj..." },

/* en */ { IDMS_C2_LOW_IMAGE,    "C2 low  image..." },
/* da */ { IDMS_C2_LOW_IMAGE_DA, "C2 lav-image..." },
/* de */ { IDMS_C2_LOW_IMAGE_DE, "C2 low  Image Datei..." },
/* fr */ { IDMS_C2_LOW_IMAGE_FR, "Image C2 basse..." },
/* hu */ { IDMS_C2_LOW_IMAGE_HU, "C2 als kpms..." },
/* it */ { IDMS_C2_LOW_IMAGE_IT, "Immagine C2 bassa..." },
/* nl */ { IDMS_C2_LOW_IMAGE_NL, "C2 low bestand..." },
/* pl */ { IDMS_C2_LOW_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C2_LOW_IMAGE_SV, "C2 lg-avbildning..." },
/* tr */ { IDMS_C2_LOW_IMAGE_TR, "C2 low imaj..." },

/* en */ { IDMS_C2_HIGH_IMAGE,    "C2 high image..." },
/* da */ { IDMS_C2_HIGH_IMAGE_DA, "C2 hj-image..." },
/* de */ { IDMS_C2_HIGH_IMAGE_DE, "C2 high Image Datei..." },
/* fr */ { IDMS_C2_HIGH_IMAGE_FR, "Image C1 haute..." },
/* hu */ { IDMS_C2_HIGH_IMAGE_HU, "C2 fels kpms..." },
/* it */ { IDMS_C2_HIGH_IMAGE_IT, "Immagine C2 alta..." },
/* nl */ { IDMS_C2_HIGH_IMAGE_NL, "C2 high bestand..." },
/* pl */ { IDMS_C2_HIGH_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C2_HIGH_IMAGE_SV, "C2 hg-avbildning..." },
/* tr */ { IDMS_C2_HIGH_IMAGE_TR, "C2 high imaj..." },

/* en */ { IDMS_FUNCTION_LOW_3PLUS1,    "Function low  image (3plus1)..." },
/* da */ { IDMS_FUNCTION_LOW_3PLUS1_DA, "Funktion lav-image (3plus1)..." },
/* de */ { IDMS_FUNCTION_LOW_3PLUS1_DE, "Funktions ROM Image Datei low (3plus1)" },
/* fr */ { IDMS_FUNCTION_LOW_3PLUS1_FR, "Image Fonction basse (3+1)..." },
/* hu */ { IDMS_FUNCTION_LOW_3PLUS1_HU, "Function als kpms (3plus1)..." },
/* it */ { IDMS_FUNCTION_LOW_3PLUS1_IT, "Immagine Function low (3plus1)..." },
/* nl */ { IDMS_FUNCTION_LOW_3PLUS1_NL, "Function low bestand (3plus1)..." },
/* pl */ { IDMS_FUNCTION_LOW_3PLUS1_PL, "" },  /* fuzzy */
/* sv */ { IDMS_FUNCTION_LOW_3PLUS1_SV, "Funktion lg-avbildning (3plus1)..." },
/* tr */ { IDMS_FUNCTION_LOW_3PLUS1_TR, "Function low  imaj (3plus1)..." },

/* en */ { IDMS_FUNCTION_HIGH_3PLUS1,    "Function high image (3plus1)..." },
/* da */ { IDMS_FUNCTION_HIGH_3PLUS1_DA, "Funktion hj-image (3plus1)..." },
/* de */ { IDMS_FUNCTION_HIGH_3PLUS1_DE, "Funktions ROM Image Datei high (3plus1)" },
/* fr */ { IDMS_FUNCTION_HIGH_3PLUS1_FR, "Image Fonction haute (3+1)..." },
/* hu */ { IDMS_FUNCTION_HIGH_3PLUS1_HU, "Function fels kpms (3plus1)..." },
/* it */ { IDMS_FUNCTION_HIGH_3PLUS1_IT, "Immagine Function high (3plus1)..." },
/* nl */ { IDMS_FUNCTION_HIGH_3PLUS1_NL, "Function high bestand (3plus1)..." },
/* pl */ { IDMS_FUNCTION_HIGH_3PLUS1_PL, "" },  /* fuzzy */
/* sv */ { IDMS_FUNCTION_HIGH_3PLUS1_SV, "Funktion hg-avbildning (3plus1)..." },
/* tr */ { IDMS_FUNCTION_HIGH_3PLUS1_TR, "Function high imaj (3plus1)..." },

/* en */ { IDMS_CRT_IMAGE,    "CRT image..." },
/* da */ { IDMS_CRT_IMAGE_DA, "CRT-fil..." },
/* de */ { IDMS_CRT_IMAGE_DE, "CRT Image..." },
/* fr */ { IDMS_CRT_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_CRT_IMAGE_HU, "CRT kpms..." },
/* it */ { IDMS_CRT_IMAGE_IT, "Immagine CRT..." },
/* nl */ { IDMS_CRT_IMAGE_NL, "CRT bestand..." },
/* pl */ { IDMS_CRT_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_CRT_IMAGE_SV, "CRT-fil..." },
/* tr */ { IDMS_CRT_IMAGE_TR, "CRT imaj..." },

/* en */ { IDMS_GENERIC_8KB_IMAGE,    "Generic 8KB image..." },
/* da */ { IDMS_GENERIC_8KB_IMAGE_DA, "Standard 8KB-image..." },
/* de */ { IDMS_GENERIC_8KB_IMAGE_DE, "Generisches 8kB Image..." },
/* fr */ { IDMS_GENERIC_8KB_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_GENERIC_8KB_IMAGE_HU, "ltalnos 8KB kpms..." },
/* it */ { IDMS_GENERIC_8KB_IMAGE_IT, "Immagine generica di 8KB..." },
/* nl */ { IDMS_GENERIC_8KB_IMAGE_NL, "Algemeen 8KB bestand..." },
/* pl */ { IDMS_GENERIC_8KB_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_GENERIC_8KB_IMAGE_SV, "Vanlig 8KB-fil..." },
/* tr */ { IDMS_GENERIC_8KB_IMAGE_TR, "8KB Jenerik imaj..." },

/* en */ { IDMS_GENERIC_16KB_IMAGE,    "Generic 16KB image..." },
/* da */ { IDMS_GENERIC_16KB_IMAGE_DA, "Standard 16KB-image..." },
/* de */ { IDMS_GENERIC_16KB_IMAGE_DE, "Generisches 16kB Image..." },
/* fr */ { IDMS_GENERIC_16KB_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_GENERIC_16KB_IMAGE_HU, "ltalnos 16KB kpms..." },
/* it */ { IDMS_GENERIC_16KB_IMAGE_IT, "Immagine generica di 16KB..." },
/* nl */ { IDMS_GENERIC_16KB_IMAGE_NL, "Algemeen 16KB bestand..." },
/* pl */ { IDMS_GENERIC_16KB_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_GENERIC_16KB_IMAGE_SV, "Vanlig 16KB-fil..." },
/* tr */ { IDMS_GENERIC_16KB_IMAGE_TR, "16KB Jenerik imaj..." },

/* en */ { IDMS_ACTION_REPLAY_IMAGE,    "Action Replay image..." },
/* da */ { IDMS_ACTION_REPLAY_IMAGE_DA, "Action Replay-image..." },
/* de */ { IDMS_ACTION_REPLAY_IMAGE_DE, "Action Replay Image..." },
/* fr */ { IDMS_ACTION_REPLAY_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ACTION_REPLAY_IMAGE_HU, "Action Replay kpms..." },
/* it */ { IDMS_ACTION_REPLAY_IMAGE_IT, "Immagine Action Replay..." },
/* nl */ { IDMS_ACTION_REPLAY_IMAGE_NL, "Action Replay bestand..." },
/* pl */ { IDMS_ACTION_REPLAY_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ACTION_REPLAY_IMAGE_SV, "Action Replay-fil..." },
/* tr */ { IDMS_ACTION_REPLAY_IMAGE_TR, "Action Replay imaj..." },

/* en */ { IDMS_ACTION_REPLAY3_IMAGE,    "Action Replay MK3 image..." },
/* da */ { IDMS_ACTION_REPLAY3_IMAGE_DA, "Action Replay MK3 image..." },
/* de */ { IDMS_ACTION_REPLAY3_IMAGE_DE, "Action Replay MK3 Image..." },
/* fr */ { IDMS_ACTION_REPLAY3_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ACTION_REPLAY3_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_ACTION_REPLAY3_IMAGE_IT, "Immagine Action Replay MK3..." },
/* nl */ { IDMS_ACTION_REPLAY3_IMAGE_NL, "Action Replay MK3 bestand..." },
/* pl */ { IDMS_ACTION_REPLAY3_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ACTION_REPLAY3_IMAGE_SV, "Action Replay MK3-fil..." },
/* tr */ { IDMS_ACTION_REPLAY3_IMAGE_TR, "Action Replay MK3 imaj..." },

/* en */ { IDMS_ACTION_REPLAY4_IMAGE,    "Action Replay MK4 image..." },
/* da */ { IDMS_ACTION_REPLAY4_IMAGE_DA, "Action Replay MK4 image..." },
/* de */ { IDMS_ACTION_REPLAY4_IMAGE_DE, "Action Replay MK4 Image..." },
/* fr */ { IDMS_ACTION_REPLAY4_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ACTION_REPLAY4_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_ACTION_REPLAY4_IMAGE_IT, "Immagine Action Replay MK4..." },
/* nl */ { IDMS_ACTION_REPLAY4_IMAGE_NL, "Action Replay MK4 bestand..." },
/* pl */ { IDMS_ACTION_REPLAY4_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ACTION_REPLAY4_IMAGE_SV, "Action Replay MK4-fil..." },
/* tr */ { IDMS_ACTION_REPLAY4_IMAGE_TR, "Action Replay MK4 imaj..." },

/* en */ { IDMS_STARDOS_IMAGE,    "Stardos image..." },
/* da */ { IDMS_STARDOS_IMAGE_DA, "Stardos image..." },
/* de */ { IDMS_STARDOS_IMAGE_DE, "Stardos Image..." },
/* fr */ { IDMS_STARDOS_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_STARDOS_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_STARDOS_IMAGE_IT, "Immagine Stardos..." },
/* nl */ { IDMS_STARDOS_IMAGE_NL, "Stardos bestand..." },
/* pl */ { IDMS_STARDOS_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_STARDOS_IMAGE_SV, "Stardos-fil..." },
/* tr */ { IDMS_STARDOS_IMAGE_TR, "Stardos imaj..." },

/* en */ { IDMS_ATOMIC_POWER_IMAGE,    "Atomic Power image..." },
/* da */ { IDMS_ATOMIC_POWER_IMAGE_DA, "Atomic Power-image..." },
/* de */ { IDMS_ATOMIC_POWER_IMAGE_DE, "Atomic Power Image..." },
/* fr */ { IDMS_ATOMIC_POWER_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ATOMIC_POWER_IMAGE_HU, "Atomic Power kpms..." },
/* it */ { IDMS_ATOMIC_POWER_IMAGE_IT, "Immagine Atomic Power..." },
/* nl */ { IDMS_ATOMIC_POWER_IMAGE_NL, "Atomic Power bestand..." },
/* pl */ { IDMS_ATOMIC_POWER_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ATOMIC_POWER_IMAGE_SV, "Atomic Power-fil..." },
/* tr */ { IDMS_ATOMIC_POWER_IMAGE_TR, "Atomic Power imaj..." },

/* en */ { IDMS_EPYX_FASTLOAD_IMAGE,    "Epyx FastLoad image..." },
/* da */ { IDMS_EPYX_FASTLOAD_IMAGE_DA, "Epyx FastLoad image..." },
/* de */ { IDMS_EPYX_FASTLOAD_IMAGE_DE, "Epyx Fastload Image..." },
/* fr */ { IDMS_EPYX_FASTLOAD_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_EPYX_FASTLOAD_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_EPYX_FASTLOAD_IMAGE_IT, "Immagine Epyx FastLoad..." },
/* nl */ { IDMS_EPYX_FASTLOAD_IMAGE_NL, "Epyx FastLoad bestand..." },
/* pl */ { IDMS_EPYX_FASTLOAD_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_EPYX_FASTLOAD_IMAGE_SV, "Epyx FastLoad-fil..." },
/* tr */ { IDMS_EPYX_FASTLOAD_IMAGE_TR, "Epyx FastLoad imaj..." },

/* en */ { IDMS_IEEE488_INTERFACE_IMAGE,    "IEEE488 Interface image..." },
/* da */ { IDMS_IEEE488_INTERFACE_IMAGE_DA, "IEEE488 Interface image..." },
/* de */ { IDMS_IEEE488_INTERFACE_IMAGE_DE, "IEEE 488 Schnittstellenmodul..." },
/* fr */ { IDMS_IEEE488_INTERFACE_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_IEEE488_INTERFACE_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_IEEE488_INTERFACE_IMAGE_IT, "Immagine interfaccia IEEE488..." },
/* nl */ { IDMS_IEEE488_INTERFACE_IMAGE_NL, "EEE-488 Interface bestand..." },
/* pl */ { IDMS_IEEE488_INTERFACE_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_IEEE488_INTERFACE_IMAGE_SV, "IEEE-488-grnssnittsfil..." },
/* tr */ { IDMS_IEEE488_INTERFACE_IMAGE_TR, "IEEE488 Arabirim imaj..." },

/* en */ { IDMS_RETRO_REPLAY_IMAGE,    "Retro Replay image..." },
/* da */ { IDMS_RETRO_REPLAY_IMAGE_DA, "Retro Replay-image..." },
/* de */ { IDMS_RETRO_REPLAY_IMAGE_DE, "Retro Replay Image..." },
/* fr */ { IDMS_RETRO_REPLAY_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_RETRO_REPLAY_IMAGE_HU, "Retro Replay kpms..." },
/* it */ { IDMS_RETRO_REPLAY_IMAGE_IT, "Immagine Retro Replay..." },
/* nl */ { IDMS_RETRO_REPLAY_IMAGE_NL, "Retro Replay bestand..." },
/* pl */ { IDMS_RETRO_REPLAY_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_RETRO_REPLAY_IMAGE_SV, "Retro Replay-fil..." },
/* tr */ { IDMS_RETRO_REPLAY_IMAGE_TR, "Retro Replay imaj..." },

/* en */ { IDMS_IDE64_INTERFACE_IMAGE,    "IDE64 interface image..." },
/* da */ { IDMS_IDE64_INTERFACE_IMAGE_DA, "IDE64-interface image..." },
/* de */ { IDMS_IDE64_INTERFACE_IMAGE_DE, "IDE64 Schnittstellenmodul..." },
/* fr */ { IDMS_IDE64_INTERFACE_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_IDE64_INTERFACE_IMAGE_HU, "IDE64 interfsz kpms..." },
/* it */ { IDMS_IDE64_INTERFACE_IMAGE_IT, "Immagine interfaccia IDE64..." },
/* nl */ { IDMS_IDE64_INTERFACE_IMAGE_NL, "IDE64 interfacebestand..." },
/* pl */ { IDMS_IDE64_INTERFACE_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_IDE64_INTERFACE_IMAGE_SV, "IDE64-grnssnittsfil..." },
/* tr */ { IDMS_IDE64_INTERFACE_IMAGE_TR, "IDE64 arabirim imaj..." },

/* en */ { IDMS_SUPER_SNAPSHOT_4_IMAGE,    "Super Snapshot V4 image..." },
/* da */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_DA, "Super Snapshot V4 image..." },
/* de */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_DE, "Super Snapshot V4 Image..." },
/* fr */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_IT, "Immagine Super Snapshot V4..." },
/* nl */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_NL, "Super Snapshot V4 bestand..." },
/* pl */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_SV, "Super Snapshot V4-fil..." },
/* tr */ { IDMS_SUPER_SNAPSHOT_4_IMAGE_TR, "Super Snapshot V4 imaj..." },

/* en */ { IDMS_SUPER_SNAPSHOT_5_IMAGE,    "Super Snapshot V5 image..." },
/* da */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_DA, "Super Snapshot V5 image..." },
/* de */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_DE, "Super Snapshot V5 Image..." },
/* fr */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_IT, "Immagine Super Snapshot V5..." },
/* nl */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_NL, "Super Snapshot V5 bestand..." },
/* pl */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_SV, "Super Snapshot V5-fil..." },
/* tr */ { IDMS_SUPER_SNAPSHOT_5_IMAGE_TR, "Super Snapshot V5 imaj..." },

/* en */ { IDMS_STRUCTURED_BASIC_IMAGE,    "Structured BASIC image..." },
/* da */ { IDMS_STRUCTURED_BASIC_IMAGE_DA, "Structured BASIC-image..." },
/* de */ { IDMS_STRUCTURED_BASIC_IMAGE_DE, "Structured Basic Image..." },
/* fr */ { IDMS_STRUCTURED_BASIC_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_STRUCTURED_BASIC_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDMS_STRUCTURED_BASIC_IMAGE_IT, "Immagine Structured BASIC..." },
/* nl */ { IDMS_STRUCTURED_BASIC_IMAGE_NL, "Structured BASIC bestand..." },
/* pl */ { IDMS_STRUCTURED_BASIC_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_STRUCTURED_BASIC_IMAGE_SV, "Structured BASIC-fil..." },
/* tr */ { IDMS_STRUCTURED_BASIC_IMAGE_TR, "Structured BASIC imaj..." },

/* en */ { IDMS_ENABLE,    "Enable" },
/* da */ { IDMS_ENABLE_DA, "Aktivr" },
/* de */ { IDMS_ENABLE_DE, "Aktivieren" },
/* fr */ { IDMS_ENABLE_FR, "Activer" },
/* hu */ { IDMS_ENABLE_HU, "Engedlyezs" },
/* it */ { IDMS_ENABLE_IT, "Attivo" },
/* nl */ { IDMS_ENABLE_NL, "Activeer" },
/* pl */ { IDMS_ENABLE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ENABLE_SV, "Aktivera" },
/* tr */ { IDMS_ENABLE_TR, "Aktif Et" },

/* en */ { IDMS_SET_CART_AS_DEFAULT,    "Set cartridge as default" },
/* da */ { IDMS_SET_CART_AS_DEFAULT_DA, "Vlg cartridge som standard" },
/* de */ { IDMS_SET_CART_AS_DEFAULT_DE, "Aktuelles Erweiterungsmodul als standard aktivieren" },
/* fr */ { IDMS_SET_CART_AS_DEFAULT_FR, "Dfinir cette cartouche par dfaut" },
/* hu */ { IDMS_SET_CART_AS_DEFAULT_HU, "Cartridge alaprtelmezett ttele" },
/* it */ { IDMS_SET_CART_AS_DEFAULT_IT, "Imposta la cartuccia come predefinita" },
/* nl */ { IDMS_SET_CART_AS_DEFAULT_NL, "Zet cartridge als standaard" },
/* pl */ { IDMS_SET_CART_AS_DEFAULT_PL, "Ustaw kartrid jako domylny" },
/* sv */ { IDMS_SET_CART_AS_DEFAULT_SV, "Vlj insticksmodul som frval" },
/* tr */ { IDMS_SET_CART_AS_DEFAULT_TR, "Kartuu varsaylan yap" },

/* en */ { IDMS_RESET_ON_CART_CHANGE,    "Reset on cart change" },
/* da */ { IDMS_RESET_ON_CART_CHANGE_DA, "Reset ved cartridge-skift" },
/* de */ { IDMS_RESET_ON_CART_CHANGE_DE, "Reset bei Wechsel von Erweiterungsmodulen" },
/* fr */ { IDMS_RESET_ON_CART_CHANGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_RESET_ON_CART_CHANGE_HU, "jraindts cartridge csernl" },
/* it */ { IDMS_RESET_ON_CART_CHANGE_IT, "Reset al cambio di cartuccia" },
/* nl */ { IDMS_RESET_ON_CART_CHANGE_NL, "Reset bij cartwisseling" },
/* pl */ { IDMS_RESET_ON_CART_CHANGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_RESET_ON_CART_CHANGE_SV, "Nollstll vid modulbyte" },
/* tr */ { IDMS_RESET_ON_CART_CHANGE_TR, "Kartu deiiminde resetle" },

/* en */ { IDMS_CART_FREEZE,    "Cartridge freeze" },
/* da */ { IDMS_CART_FREEZE_DA, "Cartridgets frys-funktion" },
/* de */ { IDMS_CART_FREEZE_DE, "Erweiterungsmodul Freeze" },
/* fr */ { IDMS_CART_FREEZE_FR, "Geler la cartouche" },
/* hu */ { IDMS_CART_FREEZE_HU, "Fagyaszts Cartridge-dzsel" },
/* it */ { IDMS_CART_FREEZE_IT, "Freeze cartuccia" },
/* nl */ { IDMS_CART_FREEZE_NL, "Cartridge freeze" },
/* pl */ { IDMS_CART_FREEZE_PL, "Cartridge freeze" },
/* sv */ { IDMS_CART_FREEZE_SV, "Insticksmodulens frysfunktion" },
/* tr */ { IDMS_CART_FREEZE_TR, "Kartu freeze" },

/* en */ { IDMS_PAUSE,    "Pause" },
/* da */ { IDMS_PAUSE_DA, "Pause" },
/* de */ { IDMS_PAUSE_DE, "Pause" },
/* fr */ { IDMS_PAUSE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PAUSE_HU, "Sznet" },
/* it */ { IDMS_PAUSE_IT, "Pausa" },
/* nl */ { IDMS_PAUSE_NL, "Pauze" },
/* pl */ { IDMS_PAUSE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PAUSE_SV, "Paus" },
/* tr */ { IDMS_PAUSE_TR, "Duraklat" },

/* en */ { IDMS_MONITOR,    "Monitor" },
/* da */ { IDMS_MONITOR_DA, "Monitor" },
/* de */ { IDMS_MONITOR_DE, "Monitor" },
/* fr */ { IDMS_MONITOR_FR, "Moniteur" },
/* hu */ { IDMS_MONITOR_HU, "Monitor" },
/* it */ { IDMS_MONITOR_IT, "Monitor" },
/* nl */ { IDMS_MONITOR_NL, "Monitor" },
/* pl */ { IDMS_MONITOR_PL, "Monitor" },
/* sv */ { IDMS_MONITOR_SV, "Monitor" },
/* tr */ { IDMS_MONITOR_TR, "Monitr" },

/* en */ { IDMS_HARD,    "Hard" },
/* da */ { IDMS_HARD_DA, "Hrd" },
/* de */ { IDMS_HARD_DE, "Hart" },
/* fr */ { IDMS_HARD_FR, " froid" },
/* hu */ { IDMS_HARD_HU, "Hideg" },
/* it */ { IDMS_HARD_IT, "Hard" },
/* nl */ { IDMS_HARD_NL, "Hard" },
/* pl */ { IDMS_HARD_PL, "Twardy" },
/* sv */ { IDMS_HARD_SV, "Hrd" },
/* tr */ { IDMS_HARD_TR, "Hard" },

/* en */ { IDMS_SOFT,    "Soft" },
/* da */ { IDMS_SOFT_DA, "Bld" },
/* de */ { IDMS_SOFT_DE, "Weich" },
/* fr */ { IDMS_SOFT_FR, " chaud" },
/* hu */ { IDMS_SOFT_HU, "Meleg" },
/* it */ { IDMS_SOFT_IT, "Soft" },
/* nl */ { IDMS_SOFT_NL, "Zacht" },
/* pl */ { IDMS_SOFT_PL, "Mikki" },
/* sv */ { IDMS_SOFT_SV, "Mjuk" },
/* tr */ { IDMS_SOFT_TR, "Soft" },

/* en */ { IDMS_EXIT,    "Exit" },
/* da */ { IDMS_EXIT_DA, "Afslut" },
/* de */ { IDMS_EXIT_DE, "Exit" },
/* fr */ { IDMS_EXIT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_EXIT_HU, "Kilps" },
/* it */ { IDMS_EXIT_IT, "Esci" },
/* nl */ { IDMS_EXIT_NL, "Afsluiten" },
/* pl */ { IDMS_EXIT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_EXIT_SV, "Avsluta" },
/* tr */ { IDMS_EXIT_TR, "k" },

/* en */ { IDMS_EDIT,    "Edit" },
/* da */ { IDMS_EDIT_DA, "Redigr" },
/* de */ { IDMS_EDIT_DE, "Bearbeiten" },
/* fr */ { IDMS_EDIT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_EDIT_HU, "Szerkeszt" },
/* it */ { IDMS_EDIT_IT, "Modifica" },
/* nl */ { IDMS_EDIT_NL, "Bewerken" },
/* pl */ { IDMS_EDIT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_EDIT_SV, "Redigera" },
/* tr */ { IDMS_EDIT_TR, "Dzenle" },

/* en */ { IDMS_COPY,    "Copy" },
/* da */ { IDMS_COPY_DA, "Kopir" },
/* de */ { IDMS_COPY_DE, "Kopie" },
/* fr */ { IDMS_COPY_FR, "" },  /* fuzzy */
/* hu */ { IDMS_COPY_HU, "Msol" },
/* it */ { IDMS_COPY_IT, "Copia" },
/* nl */ { IDMS_COPY_NL, "Kopie" },
/* pl */ { IDMS_COPY_PL, "" },  /* fuzzy */
/* sv */ { IDMS_COPY_SV, "Kopiera" },
/* tr */ { IDMS_COPY_TR, "Kopyala" },

/* en */ { IDMS_PASTE,    "Paste" },
/* da */ { IDMS_PASTE_DA, "Indst" },
/* de */ { IDMS_PASTE_DE, "Einfgen" },
/* fr */ { IDMS_PASTE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PASTE_HU, "Beilleszt" },
/* it */ { IDMS_PASTE_IT, "Incolla" },
/* nl */ { IDMS_PASTE_NL, "Plakken" },
/* pl */ { IDMS_PASTE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PASTE_SV, "Klistra in" },
/* tr */ { IDMS_PASTE_TR, "Yaptr" },

/* en */ { IDMS_SNAPSHOT,    "Snapshot" },
/* da */ { IDMS_SNAPSHOT_DA, "Snapshot" },
/* de */ { IDMS_SNAPSHOT_DE, "Snapshot" },
/* fr */ { IDMS_SNAPSHOT_FR, "Instantans" },
/* hu */ { IDMS_SNAPSHOT_HU, "Pillanatkp" },
/* it */ { IDMS_SNAPSHOT_IT, "Snapshot" },
/* nl */ { IDMS_SNAPSHOT_NL, "Momentopname" },
/* pl */ { IDMS_SNAPSHOT_PL, "Migawka" },
/* sv */ { IDMS_SNAPSHOT_SV, "gonblicksbild" },
/* tr */ { IDMS_SNAPSHOT_TR, "Anlk Grnt" },

/* en */ { IDMS_LOAD_SNAPSHOT_IMAGE,    "Load snapshot image..." },
/* da */ { IDMS_LOAD_SNAPSHOT_IMAGE_DA, "Indls snapshot..." },
/* de */ { IDMS_LOAD_SNAPSHOT_IMAGE_DE, "Snapshot Image laden..." },
/* fr */ { IDMS_LOAD_SNAPSHOT_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LOAD_SNAPSHOT_IMAGE_HU, "Pillanatkp betltse..." },
/* it */ { IDMS_LOAD_SNAPSHOT_IMAGE_IT, "Carica immagine snapshot..." },
/* nl */ { IDMS_LOAD_SNAPSHOT_IMAGE_NL, "Laad momentopnamebestand..." },
/* pl */ { IDMS_LOAD_SNAPSHOT_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LOAD_SNAPSHOT_IMAGE_SV, "Ls in gonblicksbild..." },
/* tr */ { IDMS_LOAD_SNAPSHOT_IMAGE_TR, "Anlk grnt imaj ykle..." },

/* en */ { IDMS_SAVE_SNAPSHOT_IMAGE,    "Save snapshot image..." },
/* da */ { IDMS_SAVE_SNAPSHOT_IMAGE_DA, "Gem snapshot..." },
/* de */ { IDMS_SAVE_SNAPSHOT_IMAGE_DE, "Snapshot Datei speichern..." },
/* fr */ { IDMS_SAVE_SNAPSHOT_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SAVE_SNAPSHOT_IMAGE_HU, "Pillanatkp mentse..." },
/* it */ { IDMS_SAVE_SNAPSHOT_IMAGE_IT, "Salva immagine snapshot..." },
/* nl */ { IDMS_SAVE_SNAPSHOT_IMAGE_NL, "Opslaan momentopnamebestand..." },
/* pl */ { IDMS_SAVE_SNAPSHOT_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SAVE_SNAPSHOT_IMAGE_SV, "Spara gonblicksbildfil..." },
/* tr */ { IDMS_SAVE_SNAPSHOT_IMAGE_TR, "Anlk grnt imaj kaydet..." },

/* en */ { IDMS_START_STOP_RECORDING,    "Start/Stop Recording History" },
/* da */ { IDMS_START_STOP_RECORDING_DA, "Start/stop optagelse af historik" },
/* de */ { IDMS_START_STOP_RECORDING_DE, "Start/Stop Aufnahme History" },
/* fr */ { IDMS_START_STOP_RECORDING_FR, "" },  /* fuzzy */
/* hu */ { IDMS_START_STOP_RECORDING_HU, "Esemny felvtel indtsa/meglltsa" },
/* it */ { IDMS_START_STOP_RECORDING_IT, "Avvia/termina registrazione cronologia" },
/* nl */ { IDMS_START_STOP_RECORDING_NL, "Start/Stop Opnamegeschiedenis" },
/* pl */ { IDMS_START_STOP_RECORDING_PL, "" },  /* fuzzy */
/* sv */ { IDMS_START_STOP_RECORDING_SV, "Brja/sluta spela in hndelser" },
/* tr */ { IDMS_START_STOP_RECORDING_TR, "Kayt Tarihesini Balat/Durdur" },

/* en */ { IDMS_START_STOP_PLAYBACK,    "Start/Stop Playback History" },
/* da */ { IDMS_START_STOP_PLAYBACK_DA, "Start/stop afspilning af historik" },
/* de */ { IDMS_START_STOP_PLAYBACK_DE, "Start/Stop Wiedergabe History" },
/* fr */ { IDMS_START_STOP_PLAYBACK_FR, "" },  /* fuzzy */
/* hu */ { IDMS_START_STOP_PLAYBACK_HU, "Esemny visszajtszs indtsa/meglltsa" },
/* it */ { IDMS_START_STOP_PLAYBACK_IT, "Avvia/termina riproduzione cronologia" },
/* nl */ { IDMS_START_STOP_PLAYBACK_NL, "Start/Stop Afspeelgeschiedenis" },
/* pl */ { IDMS_START_STOP_PLAYBACK_PL, "" },  /* fuzzy */
/* sv */ { IDMS_START_STOP_PLAYBACK_SV, "Brja/sluta spela upp hndelser" },
/* tr */ { IDMS_START_STOP_PLAYBACK_TR, "Kayttan Yrtme Tarihesini Balat/Durdur" },

/* en */ { IDMS_SET_MILESTONE,    "Set recording milestone" },
/* da */ { IDMS_SET_MILESTONE_DA, "Angiv optagelses-bogmrke" },
/* de */ { IDMS_SET_MILESTONE_DE, "Setze Aufnahme Meilenstein" },
/* fr */ { IDMS_SET_MILESTONE_FR, "Lever le signet d'enregistrement" },
/* hu */ { IDMS_SET_MILESTONE_HU, "Kilmterk elhelyezse a felvtelben" },
/* it */ { IDMS_SET_MILESTONE_IT, "Imposta segnalibro" },
/* nl */ { IDMS_SET_MILESTONE_NL, "Zet opname mijlpaal" },
/* pl */ { IDMS_SET_MILESTONE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SET_MILESTONE_SV, "Ange inspelningsbokmrke" },
/* tr */ { IDMS_SET_MILESTONE_TR, "Kayt kilometre ta koy" },

/* en */ { IDMS_RETURN_TO_MILESTONE,    "Return to milestone" },
/* da */ { IDMS_RETURN_TO_MILESTONE_DA, "G til bogmrke" },
/* de */ { IDMS_RETURN_TO_MILESTONE_DE, "Rckkehr zum Meilenstein" },
/* fr */ { IDMS_RETURN_TO_MILESTONE_FR, "Retourner au signet d'enregistrement" },
/* hu */ { IDMS_RETURN_TO_MILESTONE_HU, "Visszaugrs az elz kilmterkhz" },
/* it */ { IDMS_RETURN_TO_MILESTONE_IT, "Vai al segnalibro" },
/* nl */ { IDMS_RETURN_TO_MILESTONE_NL, "Ga terug naar mijlpaal" },
/* pl */ { IDMS_RETURN_TO_MILESTONE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_RETURN_TO_MILESTONE_SV, "terg till bokmrke" },
/* tr */ { IDMS_RETURN_TO_MILESTONE_TR, "Kilometre tana geri dn" },

/* en */ { IDMS_RECORDING_START_MODE,    "Recording start mode" },
/* da */ { IDMS_RECORDING_START_MODE_DA, "Start-tilstand for optagelse" },
/* de */ { IDMS_RECORDING_START_MODE_DE, "Aufnahme Start Modus" },
/* fr */ { IDMS_RECORDING_START_MODE_FR, "Mode de dpart d'enregistrement" },
/* hu */ { IDMS_RECORDING_START_MODE_HU, "Rgzts indtsnak mdja" },
/* it */ { IDMS_RECORDING_START_MODE_IT, "Modalit di avvio registrazione" },
/* nl */ { IDMS_RECORDING_START_MODE_NL, "Opname start modus" },
/* pl */ { IDMS_RECORDING_START_MODE_PL, "Rozpocznij tryb zapisu" },
/* sv */ { IDMS_RECORDING_START_MODE_SV, "Spelar in startlge" },
/* tr */ { IDMS_RECORDING_START_MODE_TR, "Kayt balang modu" },

/* en */ { IDMS_SAVE_NEW_SNAPSHOT,    "Save new snapshot" },
/* da */ { IDMS_SAVE_NEW_SNAPSHOT_DA, "Gem nyt snapshot" },
/* de */ { IDMS_SAVE_NEW_SNAPSHOT_DE, "Speichere neuen Snapshot" },
/* fr */ { IDMS_SAVE_NEW_SNAPSHOT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SAVE_NEW_SNAPSHOT_HU, "j pillanatkp mentse" },
/* it */ { IDMS_SAVE_NEW_SNAPSHOT_IT, "Salva nuovo snapshot" },
/* nl */ { IDMS_SAVE_NEW_SNAPSHOT_NL, "Opslaan nieuwe momentopname" },
/* pl */ { IDMS_SAVE_NEW_SNAPSHOT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SAVE_NEW_SNAPSHOT_SV, "Spara ny gonblicksbild" },
/* tr */ { IDMS_SAVE_NEW_SNAPSHOT_TR, "Yeni anlk grnt kaydet" },

/* en */ { IDMS_LOAD_EXISTING_SNAPSHOT,    "Load existing snapshot" },
/* da */ { IDMS_LOAD_EXISTING_SNAPSHOT_DA, "Indls eksisterende snapshot" },
/* de */ { IDMS_LOAD_EXISTING_SNAPSHOT_DE, "Lade existierenden Snapshot" },
/* fr */ { IDMS_LOAD_EXISTING_SNAPSHOT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LOAD_EXISTING_SNAPSHOT_HU, "Ltez pillanatkp betltse" },
/* it */ { IDMS_LOAD_EXISTING_SNAPSHOT_IT, "Carica snapshot esistente" },
/* nl */ { IDMS_LOAD_EXISTING_SNAPSHOT_NL, "Laad bestaande momentopname" },
/* pl */ { IDMS_LOAD_EXISTING_SNAPSHOT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LOAD_EXISTING_SNAPSHOT_SV, "Ls in existerande gonblicksbild" },
/* tr */ { IDMS_LOAD_EXISTING_SNAPSHOT_TR, "Varolan anlk grnty ykle" },

/* en */ { IDMS_START_WITH_RESET,    "Start with reset" },
/* da */ { IDMS_START_WITH_RESET_DA, "Start med reset" },
/* de */ { IDMS_START_WITH_RESET_DE, "Mit Reset starten" },
/* fr */ { IDMS_START_WITH_RESET_FR, "" },  /* fuzzy */
/* hu */ { IDMS_START_WITH_RESET_HU, "Induls RESET-tel" },
/* it */ { IDMS_START_WITH_RESET_IT, "Avvia con reset" },
/* nl */ { IDMS_START_WITH_RESET_NL, "Start met reset" },
/* pl */ { IDMS_START_WITH_RESET_PL, "" },  /* fuzzy */
/* sv */ { IDMS_START_WITH_RESET_SV, "Starta med nollstllning" },
/* tr */ { IDMS_START_WITH_RESET_TR, "Reset ile balat" },

/* en */ { IDMS_OVERWRITE_PLAYBACK,    "Overwrite Playback" },
/* da */ { IDMS_OVERWRITE_PLAYBACK_DA, "Overskriv afspilning" },
/* de */ { IDMS_OVERWRITE_PLAYBACK_DE, "Laufende Aufnahme berschreiben" },
/* fr */ { IDMS_OVERWRITE_PLAYBACK_FR, "" },  /* fuzzy */
/* hu */ { IDMS_OVERWRITE_PLAYBACK_HU, "Visszajtszs fellrsa" },
/* it */ { IDMS_OVERWRITE_PLAYBACK_IT, "Sovrascrivi riproduzione" },
/* nl */ { IDMS_OVERWRITE_PLAYBACK_NL, "Overschrijf weergave" },
/* pl */ { IDMS_OVERWRITE_PLAYBACK_PL, "" },  /* fuzzy */
/* sv */ { IDMS_OVERWRITE_PLAYBACK_SV, "Skriv ver aktiv uppspelning" },
/* tr */ { IDMS_OVERWRITE_PLAYBACK_TR, "Kayttan Yrtmenin zerine Yaz" },

/* en */ { IDMS_SELECT_HISTORY_DIR,    "Select History files/directory" },
/* da */ { IDMS_SELECT_HISTORY_DIR_DA, "Vlg historikfiler/-katalog" },
/* de */ { IDMS_SELECT_HISTORY_DIR_DE, "Verzeichnis fr Event Aufnahme" },
/* fr */ { IDMS_SELECT_HISTORY_DIR_FR, "Slectionnez le rpertoire des captures" },
/* hu */ { IDMS_SELECT_HISTORY_DIR_HU, "Vlassza ki a felvteleket/knyvtrat" },
/* it */ { IDMS_SELECT_HISTORY_DIR_IT, "Seleziona file/directory della cronologia" },
/* nl */ { IDMS_SELECT_HISTORY_DIR_NL, "Selecteer geschiedenisdirectory" },
/* pl */ { IDMS_SELECT_HISTORY_DIR_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SELECT_HISTORY_DIR_SV, "Vlj historikfiler/-katalog" },
/* tr */ { IDMS_SELECT_HISTORY_DIR_TR, "Tarihe dosyalar/dizin se" },

/* en */ { IDMS_SAVE_STOP_MEDIA_FILE,    "Save/stop media file..." },
/* da */ { IDMS_SAVE_STOP_MEDIA_FILE_DA, "Gem/stop mediefil..." },
/* de */ { IDMS_SAVE_STOP_MEDIA_FILE_DE, "Speichern/stop media Datei..." },
/* fr */ { IDMS_SAVE_STOP_MEDIA_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SAVE_STOP_MEDIA_FILE_HU, "Mdia fjl mentse/meglltsa..." },
/* it */ { IDMS_SAVE_STOP_MEDIA_FILE_IT, "Salva/arresta file multimediale..." },
/* nl */ { IDMS_SAVE_STOP_MEDIA_FILE_NL, "Opslaan/stop mediabestand..." },
/* pl */ { IDMS_SAVE_STOP_MEDIA_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SAVE_STOP_MEDIA_FILE_SV, "Starta/stoppa mediafil..." },
/* tr */ { IDMS_SAVE_STOP_MEDIA_FILE_TR, "Ortam dosyas kaydet/durdur..." },

/* en */ { IDMS_NETPLAY,    "Netplay (experimental)..." },
/* da */ { IDMS_NETPLAY_DA, "Netvrksspil (eksperimentelt)..." },
/* de */ { IDMS_NETPLAY_DE, "Netplay (experimentell)..." },
/* fr */ { IDMS_NETPLAY_FR, "Jeu en rseau (exprimental)..." },
/* hu */ { IDMS_NETPLAY_HU, "Hlzati jtk (ksrleti)..." },
/* it */ { IDMS_NETPLAY_IT, "Netplay (sperimentale)..." },
/* nl */ { IDMS_NETPLAY_NL, "Netplay (experimenteel)..." },
/* pl */ { IDMS_NETPLAY_PL, "" },  /* fuzzy */
/* sv */ { IDMS_NETPLAY_SV, "Ntverksspel (experimentellt)..." },
/* tr */ { IDMS_NETPLAY_TR, "Netplay (deneysel)..." },

/* en */ { IDMS_OPTIONS,    "Options" },
/* da */ { IDMS_OPTIONS_DA, "Valg" },
/* de */ { IDMS_OPTIONS_DE, "Optionen" },
/* fr */ { IDMS_OPTIONS_FR, "Options" },
/* hu */ { IDMS_OPTIONS_HU, "Opcik" },
/* it */ { IDMS_OPTIONS_IT, "Opzioni" },
/* nl */ { IDMS_OPTIONS_NL, "Opties" },
/* pl */ { IDMS_OPTIONS_PL, "Opcje" },
/* sv */ { IDMS_OPTIONS_SV, "Alternativ" },
/* tr */ { IDMS_OPTIONS_TR, "Seenekler" },

/* en */ { IDMS_REFRESH_RATE,    "Refresh rate" },
/* da */ { IDMS_REFRESH_RATE_DA, "Opdateringsfrekvens" },
/* de */ { IDMS_REFRESH_RATE_DE, "Wiederholrate" },
/* fr */ { IDMS_REFRESH_RATE_FR, "Taux de rafrachissement" },
/* hu */ { IDMS_REFRESH_RATE_HU, "Frisstsi rta" },
/* it */ { IDMS_REFRESH_RATE_IT, "Frequenza di aggiornamento" },
/* nl */ { IDMS_REFRESH_RATE_NL, "Vernieuwing snelheid" },
/* pl */ { IDMS_REFRESH_RATE_PL, "Czstotliwo odwieania" },
/* sv */ { IDMS_REFRESH_RATE_SV, "Uppdateringshastighet" },
/* tr */ { IDMS_REFRESH_RATE_TR, "Yenileme hz" },

/* en */ { IDMS_AUTO,    "Auto" },
/* da */ { IDMS_AUTO_DA, "Auto" },
/* de */ { IDMS_AUTO_DE, "Automatisch" },
/* fr */ { IDMS_AUTO_FR, "" },  /* fuzzy */
/* hu */ { IDMS_AUTO_HU, "Automatikus" },
/* it */ { IDMS_AUTO_IT, "Auto" },
/* nl */ { IDMS_AUTO_NL, "Auto" },
/* pl */ { IDMS_AUTO_PL, "" },  /* fuzzy */
/* sv */ { IDMS_AUTO_SV, "Auto" },
/* tr */ { IDMS_AUTO_TR, "Otomatik" },

/* en */ { IDMS_1_1,    "1/1" },
/* da */ { IDMS_1_1_DA, "1/1" },
/* de */ { IDMS_1_1_DE, "1/1" },
/* fr */ { IDMS_1_1_FR, "1/1" },
/* hu */ { IDMS_1_1_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_1_IT, "1/1" },
/* nl */ { IDMS_1_1_NL, "1/1" },
/* pl */ { IDMS_1_1_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_1_SV, "1/1" },
/* tr */ { IDMS_1_1_TR, "1/1" },

/* en */ { IDMS_1_2,    "1/2" },
/* da */ { IDMS_1_2_DA, "1/2" },
/* de */ { IDMS_1_2_DE, "1/2" },
/* fr */ { IDMS_1_2_FR, "1/2" },
/* hu */ { IDMS_1_2_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_2_IT, "1/2" },
/* nl */ { IDMS_1_2_NL, "1/2" },
/* pl */ { IDMS_1_2_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_2_SV, "1/2" },
/* tr */ { IDMS_1_2_TR, "1/2" },

/* en */ { IDMS_1_3,    "1/3" },
/* da */ { IDMS_1_3_DA, "1/3" },
/* de */ { IDMS_1_3_DE, "1/3" },
/* fr */ { IDMS_1_3_FR, "1/3" },
/* hu */ { IDMS_1_3_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_3_IT, "1/3" },
/* nl */ { IDMS_1_3_NL, "1/3" },
/* pl */ { IDMS_1_3_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_3_SV, "1/3" },
/* tr */ { IDMS_1_3_TR, "1/3" },

/* en */ { IDMS_1_4,    "1/4" },
/* da */ { IDMS_1_4_DA, "1/4" },
/* de */ { IDMS_1_4_DE, "1/4" },
/* fr */ { IDMS_1_4_FR, "1/4" },
/* hu */ { IDMS_1_4_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_4_IT, "1/4" },
/* nl */ { IDMS_1_4_NL, "1/4" },
/* pl */ { IDMS_1_4_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_4_SV, "1/4" },
/* tr */ { IDMS_1_4_TR, "1/4" },

/* en */ { IDMS_1_5,    "1/5" },
/* da */ { IDMS_1_5_DA, "1/5" },
/* de */ { IDMS_1_5_DE, "1/5" },
/* fr */ { IDMS_1_5_FR, "1/5" },
/* hu */ { IDMS_1_5_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_5_IT, "1/5" },
/* nl */ { IDMS_1_5_NL, "1/5" },
/* pl */ { IDMS_1_5_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_5_SV, "1/5" },
/* tr */ { IDMS_1_5_TR, "1/5" },

/* en */ { IDMS_1_6,    "1/6" },
/* da */ { IDMS_1_6_DA, "1/6" },
/* de */ { IDMS_1_6_DE, "1/6" },
/* fr */ { IDMS_1_6_FR, "1/6" },
/* hu */ { IDMS_1_6_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_6_IT, "1/6" },
/* nl */ { IDMS_1_6_NL, "1/6" },
/* pl */ { IDMS_1_6_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_6_SV, "1/6" },
/* tr */ { IDMS_1_6_TR, "1/6" },

/* en */ { IDMS_1_7,    "1/7" },
/* da */ { IDMS_1_7_DA, "1/7" },
/* de */ { IDMS_1_7_DE, "1/7" },
/* fr */ { IDMS_1_7_FR, "1/7" },
/* hu */ { IDMS_1_7_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_7_IT, "1/7" },
/* nl */ { IDMS_1_7_NL, "1/7" },
/* pl */ { IDMS_1_7_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_7_SV, "1/7" },
/* tr */ { IDMS_1_7_TR, "1/7" },

/* en */ { IDMS_1_8,    "1/8" },
/* da */ { IDMS_1_8_DA, "1/8" },
/* de */ { IDMS_1_8_DE, "1/8" },
/* fr */ { IDMS_1_8_FR, "1/8" },
/* hu */ { IDMS_1_8_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_8_IT, "1/8" },
/* nl */ { IDMS_1_8_NL, "1/8" },
/* pl */ { IDMS_1_8_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_8_SV, "1/8" },
/* tr */ { IDMS_1_8_TR, "1/8" },

/* en */ { IDMS_1_9,    "1/9" },
/* da */ { IDMS_1_9_DA, "1/9" },
/* de */ { IDMS_1_9_DE, "1/9" },
/* fr */ { IDMS_1_9_FR, "1/9" },
/* hu */ { IDMS_1_9_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_9_IT, "1/9" },
/* nl */ { IDMS_1_9_NL, "1/9" },
/* pl */ { IDMS_1_9_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_9_SV, "1/9" },
/* tr */ { IDMS_1_9_TR, "1/9" },

/* en */ { IDMS_1_10,    "1/10" },
/* da */ { IDMS_1_10_DA, "1/10" },
/* de */ { IDMS_1_10_DE, "1/10" },
/* fr */ { IDMS_1_10_FR, "1/10" },
/* hu */ { IDMS_1_10_HU, "" },  /* fuzzy */
/* it */ { IDMS_1_10_IT, "1/10" },
/* nl */ { IDMS_1_10_NL, "1/10" },
/* pl */ { IDMS_1_10_PL, "" },  /* fuzzy */
/* sv */ { IDMS_1_10_SV, "1/10" },
/* tr */ { IDMS_1_10_TR, "1/10" },

/* en */ { IDMS_MAXIMUM_SPEED,    "Maximum speed" },
/* da */ { IDMS_MAXIMUM_SPEED_DA, "Maksimal hastighed" },
/* de */ { IDMS_MAXIMUM_SPEED_DE, "Maximale Geschwindigkeit" },
/* fr */ { IDMS_MAXIMUM_SPEED_FR, "Vitesse maximale" },
/* hu */ { IDMS_MAXIMUM_SPEED_HU, "Maximlis sebessg" },
/* it */ { IDMS_MAXIMUM_SPEED_IT, "Velocit massima" },
/* nl */ { IDMS_MAXIMUM_SPEED_NL, "Maximale snelheid" },
/* pl */ { IDMS_MAXIMUM_SPEED_PL, "Maksymalna prdko" },
/* sv */ { IDMS_MAXIMUM_SPEED_SV, "Maximal hastighet" },
/* tr */ { IDMS_MAXIMUM_SPEED_TR, "Maksimum hz" },

/* en */ { IDMS_200_PERCENT,    "200%" },
/* da */ { IDMS_200_PERCENT_DA, "200%" },
/* de */ { IDMS_200_PERCENT_DE, "200%" },
/* fr */ { IDMS_200_PERCENT_FR, "200%" },
/* hu */ { IDMS_200_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_200_PERCENT_IT, "200%" },
/* nl */ { IDMS_200_PERCENT_NL, "200%" },
/* pl */ { IDMS_200_PERCENT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_200_PERCENT_SV, "200%" },
/* tr */ { IDMS_200_PERCENT_TR, "200%" },

/* en */ { IDMS_100_PERCENT,    "100%" },
/* da */ { IDMS_100_PERCENT_DA, "100%" },
/* de */ { IDMS_100_PERCENT_DE, "100%" },
/* fr */ { IDMS_100_PERCENT_FR, "100%" },
/* hu */ { IDMS_100_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_100_PERCENT_IT, "100%" },
/* nl */ { IDMS_100_PERCENT_NL, "100%" },
/* pl */ { IDMS_100_PERCENT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_100_PERCENT_SV, "100%" },
/* tr */ { IDMS_100_PERCENT_TR, "100%" },

/* en */ { IDMS_50_PERCENT,    "50%" },
/* da */ { IDMS_50_PERCENT_DA, "50%" },
/* de */ { IDMS_50_PERCENT_DE, "50%" },
/* fr */ { IDMS_50_PERCENT_FR, "50%" },
/* hu */ { IDMS_50_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_50_PERCENT_IT, "50%" },
/* nl */ { IDMS_50_PERCENT_NL, "50%" },
/* pl */ { IDMS_50_PERCENT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_50_PERCENT_SV, "50%" },
/* tr */ { IDMS_50_PERCENT_TR, "50%" },

/* en */ { IDMS_20_PERCENT,    "20%" },
/* da */ { IDMS_20_PERCENT_DA, "20%" },
/* de */ { IDMS_20_PERCENT_DE, "20%" },
/* fr */ { IDMS_20_PERCENT_FR, "20%" },
/* hu */ { IDMS_20_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_20_PERCENT_IT, "20%" },
/* nl */ { IDMS_20_PERCENT_NL, "20%" },
/* pl */ { IDMS_20_PERCENT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_20_PERCENT_SV, "20%" },
/* tr */ { IDMS_20_PERCENT_TR, "20%" },

/* en */ { IDMS_10_PERCENT,    "10%" },
/* da */ { IDMS_10_PERCENT_DA, "10%" },
/* de */ { IDMS_10_PERCENT_DE, "10%" },
/* fr */ { IDMS_10_PERCENT_FR, "10%" },
/* hu */ { IDMS_10_PERCENT_HU, "" },  /* fuzzy */
/* it */ { IDMS_10_PERCENT_IT, "10%" },
/* nl */ { IDMS_10_PERCENT_NL, "10%" },
/* pl */ { IDMS_10_PERCENT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_10_PERCENT_SV, "10%" },
/* tr */ { IDMS_10_PERCENT_TR, "10%" },

/* en */ { IDMS_NO_LIMIT,    "No limit" },
/* da */ { IDMS_NO_LIMIT_DA, "Ubegrnset" },
/* de */ { IDMS_NO_LIMIT_DE, "Kein Limit" },
/* fr */ { IDMS_NO_LIMIT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_NO_LIMIT_HU, "Nincs hatr" },
/* it */ { IDMS_NO_LIMIT_IT, "Nessun limite" },
/* nl */ { IDMS_NO_LIMIT_NL, "Geen limiet" },
/* pl */ { IDMS_NO_LIMIT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_NO_LIMIT_SV, "Ingen grns" },
/* tr */ { IDMS_NO_LIMIT_TR, "Limitsiz" },

/* en */ { IDMS_CUSTOM,    "Custom" },
/* da */ { IDMS_CUSTOM_DA, "Egen" },
/* de */ { IDMS_CUSTOM_DE, "Benutzerdefiniert" },
/* fr */ { IDMS_CUSTOM_FR, "" },  /* fuzzy */
/* hu */ { IDMS_CUSTOM_HU, "Egyni" },
/* it */ { IDMS_CUSTOM_IT, "Personalizzato" },
/* nl */ { IDMS_CUSTOM_NL, "Aangepast" },
/* pl */ { IDMS_CUSTOM_PL, "" },  /* fuzzy */
/* sv */ { IDMS_CUSTOM_SV, "Egen" },
/* tr */ { IDMS_CUSTOM_TR, "zel" },

/* en */ { IDMS_WARP_MODE,    "Warp mode" },
/* da */ { IDMS_WARP_MODE_DA, "Warp-tilstand" },
/* de */ { IDMS_WARP_MODE_DE, "Warp modus" },
/* fr */ { IDMS_WARP_MODE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_WARP_MODE_HU, "Hipergyors md" },
/* it */ { IDMS_WARP_MODE_IT, "Modalit turbo" },
/* nl */ { IDMS_WARP_MODE_NL, "Warpmodus" },
/* pl */ { IDMS_WARP_MODE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_WARP_MODE_SV, "Warplge" },
/* tr */ { IDMS_WARP_MODE_TR, "Warp modu" },

/* en */ { IDMS_FULLSCREEN,    "Fullscreen" },
/* da */ { IDMS_FULLSCREEN_DA, "Fuldskrm" },
/* de */ { IDMS_FULLSCREEN_DE, "Vollbild" },
/* fr */ { IDMS_FULLSCREEN_FR, "Plein cran" },
/* hu */ { IDMS_FULLSCREEN_HU, "Teljes kperny" },
/* it */ { IDMS_FULLSCREEN_IT, "Schermo intero" },
/* nl */ { IDMS_FULLSCREEN_NL, "Volscherm" },
/* pl */ { IDMS_FULLSCREEN_PL, "" },  /* fuzzy */
/* sv */ { IDMS_FULLSCREEN_SV, "Fullskrm" },
/* tr */ { IDMS_FULLSCREEN_TR, "Tam ekran" },

/* en */ { IDMS_VIDEO_CACHE,    "Video cache" },
/* da */ { IDMS_VIDEO_CACHE_DA, "Grafikcache" },
/* de */ { IDMS_VIDEO_CACHE_DE, "Video Cache" },
/* fr */ { IDMS_VIDEO_CACHE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIDEO_CACHE_HU, "Kp gyorsttr" },
/* it */ { IDMS_VIDEO_CACHE_IT, "Cache video" },
/* nl */ { IDMS_VIDEO_CACHE_NL, "Videocache" },
/* pl */ { IDMS_VIDEO_CACHE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VIDEO_CACHE_SV, "Grafikcache" },
/* tr */ { IDMS_VIDEO_CACHE_TR, "Grnt nbellei" },

/* en */ { IDMS_DOUBLE_SIZE,    "Double size" },
/* da */ { IDMS_DOUBLE_SIZE_DA, "Dobbelt strrelse" },
/* de */ { IDMS_DOUBLE_SIZE_DE, "Doppelte Gre" },
/* fr */ { IDMS_DOUBLE_SIZE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DOUBLE_SIZE_HU, "Dupla mret" },
/* it */ { IDMS_DOUBLE_SIZE_IT, "Dimensione doppia" },
/* nl */ { IDMS_DOUBLE_SIZE_NL, "Dubbele grootte" },
/* pl */ { IDMS_DOUBLE_SIZE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DOUBLE_SIZE_SV, "Dubbel storlek" },
/* tr */ { IDMS_DOUBLE_SIZE_TR, "ift boyut" },

/* en */ { IDMS_DOUBLE_SCAN,    "Double scan" },
/* da */ { IDMS_DOUBLE_SCAN_DA, "Dobbelt-skan" },
/* de */ { IDMS_DOUBLE_SCAN_DE, "Doppelt Scan" },
/* fr */ { IDMS_DOUBLE_SCAN_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DOUBLE_SCAN_HU, "Dupla psztzs" },
/* it */ { IDMS_DOUBLE_SCAN_IT, "Scansione doppia" },
/* nl */ { IDMS_DOUBLE_SCAN_NL, "Dubbele scan" },
/* pl */ { IDMS_DOUBLE_SCAN_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DOUBLE_SCAN_SV, "Dubbelskanning" },
/* tr */ { IDMS_DOUBLE_SCAN_TR, "ift tarama" },

/* en */ { IDMS_VDC_SETTINGS,    "VDC settings" },
/* da */ { IDMS_VDC_SETTINGS_DA, "VDC-indstillinger" },
/* de */ { IDMS_VDC_SETTINGS_DE, "VDC Einstellungen" },
/* fr */ { IDMS_VDC_SETTINGS_FR, "Paramtres VDC" },
/* hu */ { IDMS_VDC_SETTINGS_HU, "VDC belltsai" },
/* it */ { IDMS_VDC_SETTINGS_IT, "Impostazioni VDC" },
/* nl */ { IDMS_VDC_SETTINGS_NL, "VDC instellingen" },
/* pl */ { IDMS_VDC_SETTINGS_PL, "Ustawienia VDC" },
/* sv */ { IDMS_VDC_SETTINGS_SV, "VDC-instllningar" },
/* tr */ { IDMS_VDC_SETTINGS_TR, "VDC ayarlar" },

/* en */ { IDMS_64KB_VIDEO_MEMORY,    "64KB video memory" },
/* da */ { IDMS_64KB_VIDEO_MEMORY_DA, "64KB grafikhukommelse" },
/* de */ { IDMS_64KB_VIDEO_MEMORY_DE, "64KB Bildschirm Speicher" },
/* fr */ { IDMS_64KB_VIDEO_MEMORY_FR, "" },  /* fuzzy */
/* hu */ { IDMS_64KB_VIDEO_MEMORY_HU, "64KB kperny memria" },
/* it */ { IDMS_64KB_VIDEO_MEMORY_IT, "Memoria video di 64KB" },
/* nl */ { IDMS_64KB_VIDEO_MEMORY_NL, "64KB videogeheugen" },
/* pl */ { IDMS_64KB_VIDEO_MEMORY_PL, "" },  /* fuzzy */
/* sv */ { IDMS_64KB_VIDEO_MEMORY_SV, "64KB grafikminne" },
/* tr */ { IDMS_64KB_VIDEO_MEMORY_TR, "64KB grnt bellei" },

/* en */ { IDMS_VDC_REVISION,    "VDC revision" },
/* da */ { IDMS_VDC_REVISION_DA, "VDC-revision" },
/* de */ { IDMS_VDC_REVISION_DE, "VDC Revision" },
/* fr */ { IDMS_VDC_REVISION_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VDC_REVISION_HU, "VDC vltozat" },
/* it */ { IDMS_VDC_REVISION_IT, "Revisione VDC" },
/* nl */ { IDMS_VDC_REVISION_NL, "VDC revisie" },
/* pl */ { IDMS_VDC_REVISION_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VDC_REVISION_SV, "VDC-revision" },
/* tr */ { IDMS_VDC_REVISION_TR, "VDC revizyonu" },

/* en */ { IDMS_VDC_REV_0,    "Rev 0" },
/* da */ { IDMS_VDC_REV_0_DA, "Udgave 0" },
/* de */ { IDMS_VDC_REV_0_DE, "Rev 0" },
/* fr */ { IDMS_VDC_REV_0_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VDC_REV_0_HU, "0-s vltozat" },
/* it */ { IDMS_VDC_REV_0_IT, "Rev 0" },
/* nl */ { IDMS_VDC_REV_0_NL, "Revisie 0" },
/* pl */ { IDMS_VDC_REV_0_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VDC_REV_0_SV, "Utgva 0" },
/* tr */ { IDMS_VDC_REV_0_TR, "Rev 0" },

/* en */ { IDMS_VDC_REV_1,    "Rev 1" },
/* da */ { IDMS_VDC_REV_1_DA, "Udgave 1" },
/* de */ { IDMS_VDC_REV_1_DE, "Rev 1" },
/* fr */ { IDMS_VDC_REV_1_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VDC_REV_1_HU, "1-es vltozat" },
/* it */ { IDMS_VDC_REV_1_IT, "Rev 1" },
/* nl */ { IDMS_VDC_REV_1_NL, "Revisie 1" },
/* pl */ { IDMS_VDC_REV_1_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VDC_REV_1_SV, "Utgva 1" },
/* tr */ { IDMS_VDC_REV_1_TR, "Rev 1" },

/* en */ { IDMS_VDC_REV_2,    "Rev 2" },
/* da */ { IDMS_VDC_REV_2_DA, "Udgave 2" },
/* de */ { IDMS_VDC_REV_2_DE, "Rev 2" },
/* fr */ { IDMS_VDC_REV_2_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VDC_REV_2_HU, "2-es vltozat" },
/* it */ { IDMS_VDC_REV_2_IT, "Rev 2" },
/* nl */ { IDMS_VDC_REV_2_NL, "Revisie 2" },
/* pl */ { IDMS_VDC_REV_2_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VDC_REV_2_SV, "Utgva 2" },
/* tr */ { IDMS_VDC_REV_2_TR, "Rev 2" },

/* en */ { IDMS_SWAP_JOYSTICKS,    "Swap joysticks" },
/* da */ { IDMS_SWAP_JOYSTICKS_DA, "Byt om p joystickportene" },
/* de */ { IDMS_SWAP_JOYSTICKS_DE, "Joystick ports austauschen" },
/* fr */ { IDMS_SWAP_JOYSTICKS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SWAP_JOYSTICKS_HU, "" },  /* fuzzy */
/* it */ { IDMS_SWAP_JOYSTICKS_IT, "Scambia joystick" },
/* nl */ { IDMS_SWAP_JOYSTICKS_NL, "Verwissel joysticks" },
/* pl */ { IDMS_SWAP_JOYSTICKS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SWAP_JOYSTICKS_SV, "Vxla spelportarna" },
/* tr */ { IDMS_SWAP_JOYSTICKS_TR, "Joystickleri deitir" },

/* en */ { IDMS_SWAP_USERPORT_JOYSTICKS,    "Swap userport joysticks" },
/* da */ { IDMS_SWAP_USERPORT_JOYSTICKS_DA, "Byt om p brugerportjoysticks" },
/* de */ { IDMS_SWAP_USERPORT_JOYSTICKS_DE, "Userport Joystick ports austauschen" },
/* fr */ { IDMS_SWAP_USERPORT_JOYSTICKS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SWAP_USERPORT_JOYSTICKS_HU, "" },  /* fuzzy */
/* it */ { IDMS_SWAP_USERPORT_JOYSTICKS_IT, "Scambia joystick su userport" },
/* nl */ { IDMS_SWAP_USERPORT_JOYSTICKS_NL, "Verwissel userport joysticks" },
/* pl */ { IDMS_SWAP_USERPORT_JOYSTICKS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SWAP_USERPORT_JOYSTICKS_SV, "Vxla anvndarportstyrspakar" },
/* tr */ { IDMS_SWAP_USERPORT_JOYSTICKS_TR, "Userport joysticklerini yer deitir" },

/* en */ { IDMS_ENABLE_JOY_KEYS,    "Enable Joy Keys" },
/* da */ { IDMS_ENABLE_JOY_KEYS_DA, "Aktivr joystick via keyboard" },
/* de */ { IDMS_ENABLE_JOY_KEYS_DE, "Joystick Tasten aktivieren" },
/* fr */ { IDMS_ENABLE_JOY_KEYS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ENABLE_JOY_KEYS_HU, "Botkormny gombok engedlyezse" },
/* it */ { IDMS_ENABLE_JOY_KEYS_IT, "Attiva tasti joystick" },
/* nl */ { IDMS_ENABLE_JOY_KEYS_NL, "Activeer Joy Keys" },
/* pl */ { IDMS_ENABLE_JOY_KEYS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ENABLE_JOY_KEYS_SV, "Aktivera styrspak via tangenter" },
/* tr */ { IDMS_ENABLE_JOY_KEYS_TR, "Joy Tularn Aktif Et" },

/* en */ { IDMS_ENABLE_JOY_KEYS,    "Allow opposite directions" },
/* da */ { IDMS_ENABLE_JOY_KEYS_DA, "Tillad modsatte retninger" },
/* de */ { IDMS_ENABLE_JOY_KEYS_DE, "Gegenberliegende Richtungen zulassen" },
/* fr */ { IDMS_ENABLE_JOY_KEYS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ENABLE_JOY_KEYS_HU, "" },  /* fuzzy */
/* it */ { IDMS_ENABLE_JOY_KEYS_IT, "Consenti direzioni opposte" },
/* nl */ { IDMS_ENABLE_JOY_KEYS_NL, "Tegenovergestelde richtingen toestaan" },
/* pl */ { IDMS_ENABLE_JOY_KEYS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ENABLE_JOY_KEYS_SV, "Tillt motsatta riktningar" },
/* tr */ { IDMS_ENABLE_JOY_KEYS_TR, "Zt ynlere izin ver" },

/* en */ { IDMS_SOUND_PLAYBACK,    "Sound playback" },
/* da */ { IDMS_SOUND_PLAYBACK_DA, "Sl lydemulering til" },
/* de */ { IDMS_SOUND_PLAYBACK_DE, "Sound Wiedergabe" },
/* fr */ { IDMS_SOUND_PLAYBACK_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SOUND_PLAYBACK_HU, "Hangok engedlyezse" },
/* it */ { IDMS_SOUND_PLAYBACK_IT, "Riproduzione audio" },
/* nl */ { IDMS_SOUND_PLAYBACK_NL, "Geluidsuitvoer" },
/* pl */ { IDMS_SOUND_PLAYBACK_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SOUND_PLAYBACK_SV, "Aktivera ljudtergivning" },
/* tr */ { IDMS_SOUND_PLAYBACK_TR, "Ses" },

/* en */ { IDMS_TRUE_DRIVE_EMU,    "True drive emulation" },
/* da */ { IDMS_TRUE_DRIVE_EMU_DA, "gte drev-emulering" },
/* de */ { IDMS_TRUE_DRIVE_EMU_DE, "Przise Floppy Emulation" },
/* fr */ { IDMS_TRUE_DRIVE_EMU_FR, "" },  /* fuzzy */
/* hu */ { IDMS_TRUE_DRIVE_EMU_HU, "Vals lemezegysg emulci" },
/* it */ { IDMS_TRUE_DRIVE_EMU_IT, "Attiva emulazione hardware dei drive" },
/* nl */ { IDMS_TRUE_DRIVE_EMU_NL, "Hardwarematige driveemulatie" },
/* pl */ { IDMS_TRUE_DRIVE_EMU_PL, "" },  /* fuzzy */
/* sv */ { IDMS_TRUE_DRIVE_EMU_SV, "kta diskettenhetsemulering" },
/* tr */ { IDMS_TRUE_DRIVE_EMU_TR, "Gerek src emlasyonu" },

/* en */ { IDMS_AUTOSTART_HANDLE_TDE,    "Handle TDE on autostart" },
/* da */ { IDMS_AUTOSTART_HANDLE_TDE_DA, "Brug TDE ved autostart" },
/* de */ { IDMS_AUTOSTART_HANDLE_TDE_DE, "TDE bei Autostart beachten" },
/* fr */ { IDMS_AUTOSTART_HANDLE_TDE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_AUTOSTART_HANDLE_TDE_HU, "" },  /* fuzzy */
/* it */ { IDMS_AUTOSTART_HANDLE_TDE_IT, "Emulazione hardware dei drive all'avvio automatico" },
/* nl */ { IDMS_AUTOSTART_HANDLE_TDE_NL, "Manipuleer hardwarematige drive emulatie bij autostarten" },
/* pl */ { IDMS_AUTOSTART_HANDLE_TDE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_AUTOSTART_HANDLE_TDE_SV, "Hantera TDE fr autostart" },
/* tr */ { IDMS_AUTOSTART_HANDLE_TDE_TR, "Balangta Gerek Src Emlasyonu'nu denetle" },

/* en */ { IDMS_VIRTUAL_DEVICE_TRAPS,    "Virtual device traps" },
/* da */ { IDMS_VIRTUAL_DEVICE_TRAPS_DA, "Virtuelle enheds-traps" },
/* de */ { IDMS_VIRTUAL_DEVICE_TRAPS_DE, "Virtuelle Gerte Traps" },
/* fr */ { IDMS_VIRTUAL_DEVICE_TRAPS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIRTUAL_DEVICE_TRAPS_HU, "Virtulis eszkzk ciklus kihagysa" },
/* it */ { IDMS_VIRTUAL_DEVICE_TRAPS_IT, "Attiva periferiche virtuali" },
/* nl */ { IDMS_VIRTUAL_DEVICE_TRAPS_NL, "Virtuele apparaattraps" },
/* pl */ { IDMS_VIRTUAL_DEVICE_TRAPS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VIRTUAL_DEVICE_TRAPS_SV, "Virtuella enhetstrap:ar" },
/* tr */ { IDMS_VIRTUAL_DEVICE_TRAPS_TR, "Sanal a&ygt trapleri" },

/* en */ { IDMS_DRIVE_SYNC_FACTOR,    "Drive sync factor" },
/* da */ { IDMS_DRIVE_SYNC_FACTOR_DA, "Synkfaktor for diskettedrev" },
/* de */ { IDMS_DRIVE_SYNC_FACTOR_DE, "Laufwerkt Sync Faktor" },
/* fr */ { IDMS_DRIVE_SYNC_FACTOR_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DRIVE_SYNC_FACTOR_HU, "Lemezegysg szinkron faktor" },
/* it */ { IDMS_DRIVE_SYNC_FACTOR_IT, "Fattore di sincronizzazione del drive" },
/* nl */ { IDMS_DRIVE_SYNC_FACTOR_NL, "Drive synchronisatiefactor" },
/* pl */ { IDMS_DRIVE_SYNC_FACTOR_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DRIVE_SYNC_FACTOR_SV, "Synkfaktor fr diskettstation" },
/* tr */ { IDMS_DRIVE_SYNC_FACTOR_TR, "Src senkron faktr" },

/* en */ { IDMS_PAL,    "PAL" },
/* da */ { IDMS_PAL_DA, "PAL-G" },
/* de */ { IDMS_PAL_DE, "PAL" },
/* fr */ { IDMS_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_PAL_IT, "PAL" },
/* nl */ { IDMS_PAL_NL, "PAL" },
/* pl */ { IDMS_PAL_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PAL_SV, "PAL-G" },
/* tr */ { IDMS_PAL_TR, "PAL" },

/* en */ { IDMS_NTSC,    "NTSC" },
/* da */ { IDMS_NTSC_DA, "NTSC-M" },
/* de */ { IDMS_NTSC_DE, "NTSC" },
/* fr */ { IDMS_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDMS_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_NTSC_IT, "NTSC" },
/* nl */ { IDMS_NTSC_NL, "NTSC" },
/* pl */ { IDMS_NTSC_PL, "" },  /* fuzzy */
/* sv */ { IDMS_NTSC_SV, "NTSC-M" },
/* tr */ { IDMS_NTSC_TR, "NTSC" },

/* en */ { IDMS_VIDEO_STANDARD,    "Video standard" },
/* da */ { IDMS_VIDEO_STANDARD_DA, "TV-standard" },
/* de */ { IDMS_VIDEO_STANDARD_DE, "Video Standard" },
/* fr */ { IDMS_VIDEO_STANDARD_FR, "Standard vido" },
/* hu */ { IDMS_VIDEO_STANDARD_HU, "Vide szabvny" },
/* it */ { IDMS_VIDEO_STANDARD_IT, "Standard video" },
/* nl */ { IDMS_VIDEO_STANDARD_NL, "Videostandaard" },
/* pl */ { IDMS_VIDEO_STANDARD_PL, "Standard video" },
/* sv */ { IDMS_VIDEO_STANDARD_SV, "TV-standard" },
/* tr */ { IDMS_VIDEO_STANDARD_TR, "Grnt standard" },

/* en */ { IDMS_PAL_G,    "PAL-G" },
/* da */ { IDMS_PAL_G_DA, "PAL-G" },
/* de */ { IDMS_PAL_G_DE, "PAL-G" },
/* fr */ { IDMS_PAL_G_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PAL_G_HU, "" },  /* fuzzy */
/* it */ { IDMS_PAL_G_IT, "PAL-G" },
/* nl */ { IDMS_PAL_G_NL, "PAL-G" },
/* pl */ { IDMS_PAL_G_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PAL_G_SV, "PAL-G" },
/* tr */ { IDMS_PAL_G_TR, "PAL-G" },

/* en */ { IDMS_NTSC_M,    "NTSC-M" },
/* da */ { IDMS_NTSC_M_DA, "NTSC-M" },
/* de */ { IDMS_NTSC_M_DE, "NTSC-M" },
/* fr */ { IDMS_NTSC_M_FR, "" },  /* fuzzy */
/* hu */ { IDMS_NTSC_M_HU, "" },  /* fuzzy */
/* it */ { IDMS_NTSC_M_IT, "NTSC-M" },
/* nl */ { IDMS_NTSC_M_NL, "NTSC-M" },
/* pl */ { IDMS_NTSC_M_PL, "" },  /* fuzzy */
/* sv */ { IDMS_NTSC_M_SV, "NTSC-M" },
/* tr */ { IDMS_NTSC_M_TR, "NTSC-M" },

/* en */ { IDMS_OLD_NTSC_M,    "Old NTSC-M" },
/* da */ { IDMS_OLD_NTSC_M_DA, "Gammel NTSC-M" },
/* de */ { IDMS_OLD_NTSC_M_DE, "NTSC-M alt" },
/* fr */ { IDMS_OLD_NTSC_M_FR, "" },  /* fuzzy */
/* hu */ { IDMS_OLD_NTSC_M_HU, "Rgi NTSC-M" },
/* it */ { IDMS_OLD_NTSC_M_IT, "NTSC-M vecchio" },
/* nl */ { IDMS_OLD_NTSC_M_NL, "Oud NTSC-M" },
/* pl */ { IDMS_OLD_NTSC_M_PL, "" },  /* fuzzy */
/* sv */ { IDMS_OLD_NTSC_M_SV, "Gammal NTSC-M" },
/* tr */ { IDMS_OLD_NTSC_M_TR, "Eski NTSC-M" },

/* en */ { IDMS_VIC_1112_IEEE_488,    "VIC-1112 IEEE-488 module" },
/* da */ { IDMS_VIC_1112_IEEE_488_DA, "VIC-1112 IEEE-488-modul" },
/* de */ { IDMS_VIC_1112_IEEE_488_DE, "VIC-1112 IEEE-488 Modul" },
/* fr */ { IDMS_VIC_1112_IEEE_488_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIC_1112_IEEE_488_HU, "" },  /* fuzzy */
/* it */ { IDMS_VIC_1112_IEEE_488_IT, "Modulo VIC-1112 IEEE-488" },
/* nl */ { IDMS_VIC_1112_IEEE_488_NL, "VIC-1112 IEEE-488 module" },
/* pl */ { IDMS_VIC_1112_IEEE_488_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VIC_1112_IEEE_488_SV, "VIC-1112 IEEE-488-modul" },
/* tr */ { IDMS_VIC_1112_IEEE_488_TR, "VIC-1112 IEEE-488 modl" },

/* en */ { IDMS_ENABLE_PADDLES,    "Enable paddles" },
/* da */ { IDMS_ENABLE_PADDLES_DA, "Aktivr paddles" },
/* de */ { IDMS_ENABLE_PADDLES_DE, "Paddles aktivieren" },
/* fr */ { IDMS_ENABLE_PADDLES_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ENABLE_PADDLES_HU, "" },  /* fuzzy */
/* it */ { IDMS_ENABLE_PADDLES_IT, "Attiva paddle" },
/* nl */ { IDMS_ENABLE_PADDLES_NL, "Activeer paddles" },
/* pl */ { IDMS_ENABLE_PADDLES_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ENABLE_PADDLES_SV, "Aktivera paddlar" },
/* tr */ { IDMS_ENABLE_PADDLES_TR, "Paddlelar aktif et" },

/* en */ { IDMS_IEEE_488_INTERFACE,    "IEEE-488 Interface emulation" },
/* da */ { IDMS_IEEE_488_INTERFACE_DA, "Emulering af IEEE-488-interface" },
/* de */ { IDMS_IEEE_488_INTERFACE_DE, "IEEE-488 Schnittstellen-Emulation" },
/* fr */ { IDMS_IEEE_488_INTERFACE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_IEEE_488_INTERFACE_HU, "" },  /* fuzzy */
/* it */ { IDMS_IEEE_488_INTERFACE_IT, "Emulazione interfaccia IEEE-488" },
/* nl */ { IDMS_IEEE_488_INTERFACE_NL, "IEEE-488 Interface emulatie" },
/* pl */ { IDMS_IEEE_488_INTERFACE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_IEEE_488_INTERFACE_SV, "Emulering av IEEE-488-grnssnitt" },
/* tr */ { IDMS_IEEE_488_INTERFACE_TR, "IEEE-488 Arabirimi emlasyonu" },

/* en */ { IDMS_GRAB_MOUSE,    "Grab mouse events" },
/* da */ { IDMS_GRAB_MOUSE_DA, "Fang mussehndelser" },
/* de */ { IDMS_GRAB_MOUSE_DE, "Maus Ereignisse abfangen" },
/* fr */ { IDMS_GRAB_MOUSE_FR, "Attraper les vnements souris" },
/* hu */ { IDMS_GRAB_MOUSE_HU, "Egr esemnyek elkapsa" },
/* it */ { IDMS_GRAB_MOUSE_IT, "Cattura eventi mouse" },
/* nl */ { IDMS_GRAB_MOUSE_NL, "Gebruik de muis" },
/* pl */ { IDMS_GRAB_MOUSE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_GRAB_MOUSE_SV, "Fnga mushndelser" },
/* tr */ { IDMS_GRAB_MOUSE_TR, "Mouse olaylarn yakala" },

/* en */ { IDMS_PS2_MOUSE,    "PS/2 mouse emulation" },
/* da */ { IDMS_PS2_MOUSE_DA, "Emulering af PS/2-mus" },
/* de */ { IDMS_PS2_MOUSE_DE, "PS/2 Mausemulation" },
/* fr */ { IDMS_PS2_MOUSE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PS2_MOUSE_HU, "PS/2 egr emulci" },
/* it */ { IDMS_PS2_MOUSE_IT, "Emulazione mouse PS/2" },
/* nl */ { IDMS_PS2_MOUSE_NL, "PS/2 muis emulatie" },
/* pl */ { IDMS_PS2_MOUSE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PS2_MOUSE_SV, "PS/2-musemulering" },
/* tr */ { IDMS_PS2_MOUSE_TR, "PS/2 mouse emlasyonu" },

/* en */ { IDMS_SETTINGS,    "Settings" },
/* da */ { IDMS_SETTINGS_DA, "Indstillinger" },
/* de */ { IDMS_SETTINGS_DE, "Einstellungen" },
/* fr */ { IDMS_SETTINGS_FR, "Paramtres" },
/* hu */ { IDMS_SETTINGS_HU, "Belltsok" },
/* it */ { IDMS_SETTINGS_IT, "Impostazioni" },
/* nl */ { IDMS_SETTINGS_NL, "Instellingen" },
/* pl */ { IDMS_SETTINGS_PL, "Ustawienia" },
/* sv */ { IDMS_SETTINGS_SV, "Instllningar" },
/* tr */ { IDMS_SETTINGS_TR, "Ayarlar" },

/* en */ { IDMS_C64_MODEL_SETTINGS,    "C64 Model settings..." },
/* da */ { IDMS_C64_MODEL_SETTINGS_DA, "C64 model-indstillinger..." },
/* de */ { IDMS_C64_MODEL_SETTINGS_DE, "C64 Modell Einstellungen..." },
/* fr */ { IDMS_C64_MODEL_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_MODEL_SETTINGS_IT, "Impostazioni modello C64..." },
/* nl */ { IDMS_C64_MODEL_SETTINGS_NL, "C64 Model instellingen..." },
/* pl */ { IDMS_C64_MODEL_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C64_MODEL_SETTINGS_SV, "C64-modell-instllningar..." },
/* tr */ { IDMS_C64_MODEL_SETTINGS_TR, "C64 Model ayarlar..." },

/* en */ { IDMS_C64_PAL,    "C64 PAL" },
/* da */ { IDMS_C64_PAL_DA, "C64 PAL" },
/* de */ { IDMS_C64_PAL_DE, "C64 PAL" },
/* fr */ { IDMS_C64_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_PAL_IT, "C64 PAL" },
/* nl */ { IDMS_C64_PAL_NL, "C64 PAL" },
/* pl */ { IDMS_C64_PAL_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C64_PAL_SV, "C64 PAL" },
/* tr */ { IDMS_C64_PAL_TR, "C64 PAL" },

/* en */ { IDMS_C64C_PAL,    "C64C PAL" },
/* da */ { IDMS_C64C_PAL_DA, "C64C PAL" },
/* de */ { IDMS_C64C_PAL_DE, "C64C PAL" },
/* fr */ { IDMS_C64C_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64C_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64C_PAL_IT, "C64C PAL" },
/* nl */ { IDMS_C64C_PAL_NL, "C64C PAL" },
/* pl */ { IDMS_C64C_PAL_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C64C_PAL_SV, "C64C PAL" },
/* tr */ { IDMS_C64C_PAL_TR, "C64C PAL" },

/* en */ { IDMS_C64_OLD_PAL,    "C64 old PAL" },
/* da */ { IDMS_C64_OLD_PAL_DA, "C64 gammel PAL" },
/* de */ { IDMS_C64_OLD_PAL_DE, "C64 alt PAL" },
/* fr */ { IDMS_C64_OLD_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64_OLD_PAL_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_OLD_PAL_IT, "C64 PAL vecchio" },
/* nl */ { IDMS_C64_OLD_PAL_NL, "C64 oud PAL" },
/* pl */ { IDMS_C64_OLD_PAL_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C64_OLD_PAL_SV, "C64 gammal PAL" },
/* tr */ { IDMS_C64_OLD_PAL_TR, "C64 eski PAL" },

/* en */ { IDMS_C64_NTSC,    "C64 NTSC" },
/* da */ { IDMS_C64_NTSC_DA, "C64 NTSC" },
/* de */ { IDMS_C64_NTSC_DE, "C64 NTSC" },
/* fr */ { IDMS_C64_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_NTSC_IT, "C64 NTSC" },
/* nl */ { IDMS_C64_NTSC_NL, "C64 NTSC" },
/* pl */ { IDMS_C64_NTSC_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C64_NTSC_SV, "C64 NTSC" },
/* tr */ { IDMS_C64_NTSC_TR, "C64 NTSC" },

/* en */ { IDMS_C64C_NTSC,    "C64C NTSC" },
/* da */ { IDMS_C64C_NTSC_DA, "C64C NTSC" },
/* de */ { IDMS_C64C_NTSC_DE, "C64C NTSC" },
/* fr */ { IDMS_C64C_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64C_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64C_NTSC_IT, "C64C NTSC" },
/* nl */ { IDMS_C64C_NTSC_NL, "C64C NTSC" },
/* pl */ { IDMS_C64C_NTSC_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C64C_NTSC_SV, "C64C NTSC" },
/* tr */ { IDMS_C64C_NTSC_TR, "C64C NTSC" },

/* en */ { IDMS_C64_OLD_NTSC,    "C64 old NTSC" },
/* da */ { IDMS_C64_OLD_NTSC_DA, "C64 gammel NTSC" },
/* de */ { IDMS_C64_OLD_NTSC_DE, "C64 alt NTSC" },
/* fr */ { IDMS_C64_OLD_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64_OLD_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDMS_C64_OLD_NTSC_IT, "C64 NTSC vecchio" },
/* nl */ { IDMS_C64_OLD_NTSC_NL, "C64 oud NTSC" },
/* pl */ { IDMS_C64_OLD_NTSC_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C64_OLD_NTSC_SV, "C64 gammal NTSC" },
/* tr */ { IDMS_C64_OLD_NTSC_TR, "C64 eski NTSC" },

/* en */ { IDMS_DREAN,    "Drean" },
/* da */ { IDMS_DREAN_DA, "Drean" },
/* de */ { IDMS_DREAN_DE, "Drean" },
/* fr */ { IDMS_DREAN_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DREAN_HU, "" },  /* fuzzy */
/* it */ { IDMS_DREAN_IT, "Drean" },
/* nl */ { IDMS_DREAN_NL, "Drean" },
/* pl */ { IDMS_DREAN_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DREAN_SV, "Drean" },
/* tr */ { IDMS_DREAN_TR, "Drean" },

/* en */ { IDMS_CUSTOM_C64_MODEL,    "Custom C64 model" },
/* da */ { IDMS_CUSTOM_C64_MODEL_DA, "Speciel C64 model" },
/* de */ { IDMS_CUSTOM_C64_MODEL_DE, "Modifiziertes C64 Modell" },
/* fr */ { IDMS_CUSTOM_C64_MODEL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_CUSTOM_C64_MODEL_HU, "" },  /* fuzzy */
/* it */ { IDMS_CUSTOM_C64_MODEL_IT, "Modello C64 personalizzato" },
/* nl */ { IDMS_CUSTOM_C64_MODEL_NL, "Aangepast C64 model" },
/* pl */ { IDMS_CUSTOM_C64_MODEL_PL, "" },  /* fuzzy */
/* sv */ { IDMS_CUSTOM_C64_MODEL_SV, "Speciell C64-modell" },
/* tr */ { IDMS_CUSTOM_C64_MODEL_TR, "zel C64 modeli" },

/* en */ { IDMS_AUTOSTART_SETTINGS,    "Autostart settings..." },
/* da */ { IDMS_AUTOSTART_SETTINGS_DA, "Autostart-indstillinger..." },
/* de */ { IDMS_AUTOSTART_SETTINGS_DE, "Autostart Einstellungen..." },
/* fr */ { IDMS_AUTOSTART_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_AUTOSTART_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_AUTOSTART_SETTINGS_IT, "Impostazioni avvio automatico..." },
/* nl */ { IDMS_AUTOSTART_SETTINGS_NL, "Autostart instellingen..." },
/* pl */ { IDMS_AUTOSTART_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_AUTOSTART_SETTINGS_SV, "Autostartinstllningar..." },
/* tr */ { IDMS_AUTOSTART_SETTINGS_TR, "Otomatik balatma ayarlar..." },

/* en */ { IDMS_VIDEO_SETTINGS,    "Video settings..." },
/* da */ { IDMS_VIDEO_SETTINGS_DA, "Grafikindstillinger..." },
/* de */ { IDMS_VIDEO_SETTINGS_DE, "Video Einstellungen..." },
/* fr */ { IDMS_VIDEO_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIDEO_SETTINGS_HU, "Vide belltsai..." },
/* it */ { IDMS_VIDEO_SETTINGS_IT, "Impostazioni video..." },
/* nl */ { IDMS_VIDEO_SETTINGS_NL, "Video instellingen..." },
/* pl */ { IDMS_VIDEO_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VIDEO_SETTINGS_SV, "Grafikinstllningar..." },
/* tr */ { IDMS_VIDEO_SETTINGS_TR, "Grnt ayalar..." },

/* en */ { IDMS_VIC_SETTINGS,    "VIC settings..." },
/* da */ { IDMS_VIC_SETTINGS_DA, "VIC-indstillinger..." },
/* de */ { IDMS_VIC_SETTINGS_DE, "VIC Einstellungen" },
/* fr */ { IDMS_VIC_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIC_SETTINGS_HU, "VIC belltsai..." },
/* it */ { IDMS_VIC_SETTINGS_IT, "Impostazioni VIC..." },
/* nl */ { IDMS_VIC_SETTINGS_NL, "VIC instellingen..." },
/* pl */ { IDMS_VIC_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VIC_SETTINGS_SV, "VIC-instllningar..." },
/* tr */ { IDMS_VIC_SETTINGS_TR, "VIC ayarlar..." },

/* en */ { IDMS_CBM2_SETTINGS,    "CBM2 settings..." },
/* da */ { IDMS_CBM2_SETTINGS_DA, "CBM2-indstillinger..." },
/* de */ { IDMS_CBM2_SETTINGS_DE, "CBM2 Einstellungen..." },
/* fr */ { IDMS_CBM2_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_CBM2_SETTINGS_HU, "CBM belltsai..." },
/* it */ { IDMS_CBM2_SETTINGS_IT, "Impostazioni CBM2..." },
/* nl */ { IDMS_CBM2_SETTINGS_NL, "CBM2 instellingen..." },
/* pl */ { IDMS_CBM2_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_CBM2_SETTINGS_SV, "CBM2-instllningar..." },
/* tr */ { IDMS_CBM2_SETTINGS_TR, "CBM2 ayarlar..." },

/* en */ { IDMS_SET_PET_MODEL,    "Change PET model" },
/* da */ { IDMS_SET_PET_MODEL_DA, "Skift PET-model" },
/* de */ { IDMS_SET_PET_MODEL_DE, "PET Modell verndern" },
/* fr */ { IDMS_SET_PET_MODEL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SET_PET_MODEL_HU, "PET modell kivlasztsa" },
/* it */ { IDMS_SET_PET_MODEL_IT, "Cambia modello di PET" },
/* nl */ { IDMS_SET_PET_MODEL_NL, "Verander PET model" },
/* pl */ { IDMS_SET_PET_MODEL_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SET_PET_MODEL_SV, "Byt PET-modell" },
/* tr */ { IDMS_SET_PET_MODEL_TR, "PET modelini deitir" },

/* en */ { IDMS_PET_SETTINGS,    "PET settings..." },
/* da */ { IDMS_PET_SETTINGS_DA, "PET-indstillinger..." },
/* de */ { IDMS_PET_SETTINGS_DE, "PET Einstellungen..." },
/* fr */ { IDMS_PET_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PET_SETTINGS_HU, "PET belltsai..." },
/* it */ { IDMS_PET_SETTINGS_IT, "Impostazioni PET..." },
/* nl */ { IDMS_PET_SETTINGS_NL, "PET instellingen..." },
/* pl */ { IDMS_PET_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PET_SETTINGS_SV, "PET-instllningar..." },
/* tr */ { IDMS_PET_SETTINGS_TR, "PET ayarlar..." },

/* en */ { IDMS_PERIPHERAL_SETTINGS,    "Peripheral settings..." },
/* da */ { IDMS_PERIPHERAL_SETTINGS_DA, "Ekstern-enhedsindstillinger..." },
/* de */ { IDMS_PERIPHERAL_SETTINGS_DE, "Peripherie Einstellungen..." },
/* fr */ { IDMS_PERIPHERAL_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PERIPHERAL_SETTINGS_HU, "Perifrik belltsai..." },
/* it */ { IDMS_PERIPHERAL_SETTINGS_IT, "Impostazioni periferiche..." },
/* nl */ { IDMS_PERIPHERAL_SETTINGS_NL, "Randapparaten instellingen..." },
/* pl */ { IDMS_PERIPHERAL_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PERIPHERAL_SETTINGS_SV, "Instllningar fr kringutrustning..." },
/* tr */ { IDMS_PERIPHERAL_SETTINGS_TR, "evresel ayarlar..." },

/* en */ { IDMS_DRIVE_SETTINGS,    "Drive settings..." },
/* da */ { IDMS_DRIVE_SETTINGS_DA, "Diskettedrevsindstillinger..." },
/* de */ { IDMS_DRIVE_SETTINGS_DE, "Floppy Einstellungen..." },
/* fr */ { IDMS_DRIVE_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DRIVE_SETTINGS_HU, "Lemezegysg belltsai..." },
/* it */ { IDMS_DRIVE_SETTINGS_IT, "Impostazioni drive..." },
/* nl */ { IDMS_DRIVE_SETTINGS_NL, "Drive instellingen..." },
/* pl */ { IDMS_DRIVE_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DRIVE_SETTINGS_SV, "Diskettenhetsinstllningar..." },
/* tr */ { IDMS_DRIVE_SETTINGS_TR, "Src ayarlar..." },

/* en */ { IDMS_PRINTER_SETTINGS,    "Printer settings..." },
/* da */ { IDMS_PRINTER_SETTINGS_DA, "Printerindstillinger..." },
/* de */ { IDMS_PRINTER_SETTINGS_DE, "Drucker Einstellungen..." },
/* fr */ { IDMS_PRINTER_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PRINTER_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_PRINTER_SETTINGS_IT, "Impostazioni stampanti..." },
/* nl */ { IDMS_PRINTER_SETTINGS_NL, "Printer instellingen..." },
/* pl */ { IDMS_PRINTER_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PRINTER_SETTINGS_SV, "Skrivarinstllningar..." },
/* tr */ { IDMS_PRINTER_SETTINGS_TR, "Yazc ayarlar..." },

/* en */ { IDMS_DATASETTE_SETTINGS,    "Datasette settings..." },
/* da */ { IDMS_DATASETTE_SETTINGS_DA, "Datasetteindstillinger..." },
/* de */ { IDMS_DATASETTE_SETTINGS_DE, "Bandlaufwerk Einstellungen..." },
/* fr */ { IDMS_DATASETTE_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DATASETTE_SETTINGS_HU, "Magn belltsai..." },
/* it */ { IDMS_DATASETTE_SETTINGS_IT, "Impostazioni registratore..." },
/* nl */ { IDMS_DATASETTE_SETTINGS_NL, "Datasette instellingen..." },
/* pl */ { IDMS_DATASETTE_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DATASETTE_SETTINGS_SV, "Datasetteinstllningar..." },
/* tr */ { IDMS_DATASETTE_SETTINGS_TR, "Teyp ayarlar..." },

/* en */ { IDMS_PLUS4_SETTINGS,    "Plus4 settings..." },
/* da */ { IDMS_PLUS4_SETTINGS_DA, "Plus4-indstillinger..." },
/* de */ { IDMS_PLUS4_SETTINGS_DE, "Plus4 Einstellungen..." },
/* fr */ { IDMS_PLUS4_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PLUS4_SETTINGS_HU, "Plus4 belltsai..." },
/* it */ { IDMS_PLUS4_SETTINGS_IT, "Impostazioni Plus4..." },
/* nl */ { IDMS_PLUS4_SETTINGS_NL, "Plus4 instellingen..." },
/* pl */ { IDMS_PLUS4_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PLUS4_SETTINGS_SV, "Plus4-instllningar..." },
/* tr */ { IDMS_PLUS4_SETTINGS_TR, "Plus4 ayarlar..." },

/* en */ { IDMS_VICII_SETTINGS,    "VIC-II settings..." },
/* da */ { IDMS_VICII_SETTINGS_DA, "VIC-II-indstillinger..." },
/* de */ { IDMS_VICII_SETTINGS_DE, "VIC-II Einstellungen..." },
/* fr */ { IDMS_VICII_SETTINGS_FR, "Paramtres VIC-II..." },
/* hu */ { IDMS_VICII_SETTINGS_HU, "VIC-II belltsai..." },
/* it */ { IDMS_VICII_SETTINGS_IT, "Impostazioni VIC-II..." },
/* nl */ { IDMS_VICII_SETTINGS_NL, "VIC-II instellingen..." },
/* pl */ { IDMS_VICII_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VICII_SETTINGS_SV, "VIC-II-instllningar..." },
/* tr */ { IDMS_VICII_SETTINGS_TR, "VIC-II ayarlar..." },

/* en */ { IDMS_JOYSTICK_SETTINGS,    "Joystick settings..." },
/* da */ { IDMS_JOYSTICK_SETTINGS_DA, "Joystickindstillinger..." },
/* de */ { IDMS_JOYSTICK_SETTINGS_DE, "Joystick Einstellungen..." },
/* fr */ { IDMS_JOYSTICK_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_JOYSTICK_SETTINGS_HU, "Botkormny belltsai..." },
/* it */ { IDMS_JOYSTICK_SETTINGS_IT, "Impostazioni joystick..." },
/* nl */ { IDMS_JOYSTICK_SETTINGS_NL, "Joystick instellingen..." },
/* pl */ { IDMS_JOYSTICK_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_JOYSTICK_SETTINGS_SV, "Instllningar fr styrspak..." },
/* tr */ { IDMS_JOYSTICK_SETTINGS_TR, "Joystick ayarlar..." },

/* en */ { IDMS_JOYSTICK_DEVICE_SELECT,    "Joystick device selection" },
/* da */ { IDMS_JOYSTICK_DEVICE_SELECT_DA, "Joystick enheds-valg" },
/* de */ { IDMS_JOYSTICK_DEVICE_SELECT_DE, "Joystick Gerte Auswahl" },
/* fr */ { IDMS_JOYSTICK_DEVICE_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_JOYSTICK_DEVICE_SELECT_HU, "Botkormny eszkz kivlasztsa" },
/* it */ { IDMS_JOYSTICK_DEVICE_SELECT_IT, "Selezione dispositivo joystick" },
/* nl */ { IDMS_JOYSTICK_DEVICE_SELECT_NL, "Joystickapparaatselectie" },
/* pl */ { IDMS_JOYSTICK_DEVICE_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_JOYSTICK_DEVICE_SELECT_SV, "Vlj styrspakenhet" },
/* tr */ { IDMS_JOYSTICK_DEVICE_SELECT_TR, "Joystick aygt seimi" },

/* en */ { IDMS_JOYSTICK_FIRE_SELECT,    "Joystick fire button selection" },
/* da */ { IDMS_JOYSTICK_FIRE_SELECT_DA, "Vlg fireknap for joystick" },
/* de */ { IDMS_JOYSTICK_FIRE_SELECT_DE, "Joystick Feuerknopf Wahl" },
/* fr */ { IDMS_JOYSTICK_FIRE_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_JOYSTICK_FIRE_SELECT_HU, "Botkormny tzgomb kivlaszts" },
/* it */ { IDMS_JOYSTICK_FIRE_SELECT_IT, "Selezione pulsante di fuoco del joystick" },
/* nl */ { IDMS_JOYSTICK_FIRE_SELECT_NL, "Joystickvuurknopselectie" },
/* pl */ { IDMS_JOYSTICK_FIRE_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_JOYSTICK_FIRE_SELECT_SV, "Vlj fireknapp fr styrspak" },
/* tr */ { IDMS_JOYSTICK_FIRE_SELECT_TR, "Joystick ate dmesi seimi" },

/* en */ { IDMS_KEYBOARD_SETTINGS,    "Keyboard settings..." },
/* da */ { IDMS_KEYBOARD_SETTINGS_DA, "Tastaturindstillinger..." },
/* de */ { IDMS_KEYBOARD_SETTINGS_DE, "Tastatur Einstellungen..." },
/* fr */ { IDMS_KEYBOARD_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_KEYBOARD_SETTINGS_HU, "Billentyzet belltsai..." },
/* it */ { IDMS_KEYBOARD_SETTINGS_IT, "Impostazioni tastiera..." },
/* nl */ { IDMS_KEYBOARD_SETTINGS_NL, "Toetsenbord instellingen..." },
/* pl */ { IDMS_KEYBOARD_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_KEYBOARD_SETTINGS_SV, "Tangentbordsinstllningar..." },
/* tr */ { IDMS_KEYBOARD_SETTINGS_TR, "Klavye ayarlar..." },

/* en */ { IDMS_MOUSE_SETTINGS,    "Mouse settings..." },
/* da */ { IDMS_MOUSE_SETTINGS_DA, "Musseindstillinger..." },
/* de */ { IDMS_MOUSE_SETTINGS_DE, "Maus Einstellungen..." },
/* fr */ { IDMS_MOUSE_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_MOUSE_SETTINGS_HU, "Egr belltsai..." },
/* it */ { IDMS_MOUSE_SETTINGS_IT, "Impostazioni mouse..." },
/* nl */ { IDMS_MOUSE_SETTINGS_NL, "Muis instellingen..." },
/* pl */ { IDMS_MOUSE_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_MOUSE_SETTINGS_SV, "Musinstllningar..." },
/* tr */ { IDMS_MOUSE_SETTINGS_TR, "Mouse ayarlar..." },

/* en */ { IDMS_SOUND_SETTINGS,    "Sound settings..." },
/* da */ { IDMS_SOUND_SETTINGS_DA, "Lydindstillinger..." },
/* de */ { IDMS_SOUND_SETTINGS_DE, "Sound Einstellungen..." },
/* fr */ { IDMS_SOUND_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SOUND_SETTINGS_HU, "Hang belltsai..." },
/* it */ { IDMS_SOUND_SETTINGS_IT, "Impostazioni audio..." },
/* nl */ { IDMS_SOUND_SETTINGS_NL, "Geluidsinstellingen..." },
/* pl */ { IDMS_SOUND_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SOUND_SETTINGS_SV, "Ljudinstllningar..." },
/* tr */ { IDMS_SOUND_SETTINGS_TR, "Ses ayarlar..." },

/* en */ { IDMS_SID_SETTINGS,    "SID settings..." },
/* da */ { IDMS_SID_SETTINGS_DA, "SID-indstillinger..." },
/* de */ { IDMS_SID_SETTINGS_DE, "SID Einstellungen..." },
/* fr */ { IDMS_SID_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SID_SETTINGS_HU, "SID belltsai..." },
/* it */ { IDMS_SID_SETTINGS_IT, "Impostazioni SID..." },
/* nl */ { IDMS_SID_SETTINGS_NL, "SID instellingen..." },
/* pl */ { IDMS_SID_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SID_SETTINGS_SV, "SID-instllningar..." },
/* tr */ { IDMS_SID_SETTINGS_TR, "SID ayarlar..." },

/* en */ { IDMS_COMPUTER_ROM_SETTINGS,    "Computer ROM settings..." },
/* da */ { IDMS_COMPUTER_ROM_SETTINGS_DA, "Compute ROM-indstillinger..." },
/* de */ { IDMS_COMPUTER_ROM_SETTINGS_DE, "Computer ROM Einstellungen..." },
/* fr */ { IDMS_COMPUTER_ROM_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_COMPUTER_ROM_SETTINGS_HU, "ROM-ok belltsai..." },
/* it */ { IDMS_COMPUTER_ROM_SETTINGS_IT, "Impostazioni ROM del computer..." },
/* nl */ { IDMS_COMPUTER_ROM_SETTINGS_NL, "Computer ROM instellingen..." },
/* pl */ { IDMS_COMPUTER_ROM_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_COMPUTER_ROM_SETTINGS_SV, "ROM-instllningar fr dator..." },
/* tr */ { IDMS_COMPUTER_ROM_SETTINGS_TR, "Bilgisayar ROM ayarlar..." },

/* en */ { IDMS_DRIVE_ROM_SETTINGS,    "Drive ROM settings..." },
/* da */ { IDMS_DRIVE_ROM_SETTINGS_DA, "Drev ROM-indstillinger..." },
/* de */ { IDMS_DRIVE_ROM_SETTINGS_DE, "Floppy ROM Einstellungen..." },
/* fr */ { IDMS_DRIVE_ROM_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DRIVE_ROM_SETTINGS_HU, "Lemezegysg ROM belltsai..." },
/* it */ { IDMS_DRIVE_ROM_SETTINGS_IT, "Impostazioni ROM del drive..." },
/* nl */ { IDMS_DRIVE_ROM_SETTINGS_NL, "Drive ROM instellingen..." },
/* pl */ { IDMS_DRIVE_ROM_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DRIVE_ROM_SETTINGS_SV, "ROM-instllningar fr diskettenhet..." },
/* tr */ { IDMS_DRIVE_ROM_SETTINGS_TR, "Src ROM ayarlar..." },

/* en */ { IDMS_RAM_SETTINGS,    "RAM settings..." },
/* da */ { IDMS_RAM_SETTINGS_DA, "RAM-indstillinger..." },
/* de */ { IDMS_RAM_SETTINGS_DE, "RAM Einstellungen..." },
/* fr */ { IDMS_RAM_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_RAM_SETTINGS_HU, "RAM belltsai..." },
/* it */ { IDMS_RAM_SETTINGS_IT, "Impostazioni RAM..." },
/* nl */ { IDMS_RAM_SETTINGS_NL, "RAM instellingen..." },
/* pl */ { IDMS_RAM_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_RAM_SETTINGS_SV, "RAM-instllningar..." },
/* tr */ { IDMS_RAM_SETTINGS_TR, "RAM ayarlar..." },

/* en */ { IDMS_RS232_SETTINGS,    "RS232 settings..." },
/* da */ { IDMS_RS232_SETTINGS_DA, "RS232-indstillinger..." },
/* de */ { IDMS_RS232_SETTINGS_DE, "RS232 Einstellungen..." },
/* fr */ { IDMS_RS232_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_RS232_SETTINGS_HU, "RS232 belltsai..." },
/* it */ { IDMS_RS232_SETTINGS_IT, "Impostazioni RS232..." },
/* nl */ { IDMS_RS232_SETTINGS_NL, "RS232 instellingen..." },
/* pl */ { IDMS_RS232_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_RS232_SETTINGS_SV, "RS232-instllningar..." },
/* tr */ { IDMS_RS232_SETTINGS_TR, "RS232 ayarlar..." },

/* en */ { IDMS_C128_SETTINGS,    "C128 settings..." },
/* da */ { IDMS_C128_SETTINGS_DA, "C128-indstillinger..." },
/* de */ { IDMS_C128_SETTINGS_DE, "C128 Einstellungen..." },
/* fr */ { IDMS_C128_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C128_SETTINGS_HU, "C128 belltsai..." },
/* it */ { IDMS_C128_SETTINGS_IT, "Impostazioni C128..." },
/* nl */ { IDMS_C128_SETTINGS_NL, "C128 instellingen..." },
/* pl */ { IDMS_C128_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C128_SETTINGS_SV, "C128-instllningar..." },
/* tr */ { IDMS_C128_SETTINGS_TR, "C128 ayarlar..." },

/* en */ { IDMS_CART_IO_SETTINGS,    "Cartridge/IO settings" },
/* da */ { IDMS_CART_IO_SETTINGS_DA, "Modul/IO-indstillinger" },
/* de */ { IDMS_CART_IO_SETTINGS_DE, "Erweiterungsmodul I/O Einstellungen" },
/* fr */ { IDMS_CART_IO_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_CART_IO_SETTINGS_HU, "Cartridge/IO belltsai" },
/* it */ { IDMS_CART_IO_SETTINGS_IT, "Impostazioni cartuccia/IO" },
/* nl */ { IDMS_CART_IO_SETTINGS_NL, "Cartridge/IO instellingen" },
/* pl */ { IDMS_CART_IO_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_CART_IO_SETTINGS_SV, "Modul/IO-instllningar" },
/* tr */ { IDMS_CART_IO_SETTINGS_TR, "Kartu/G ayarlar" },

/* en */ { IDMS_REU_SETTINGS,    "REU settings..." },
/* da */ { IDMS_REU_SETTINGS_DA, "REU-indstillinger..." },
/* de */ { IDMS_REU_SETTINGS_DE, "REU Einstellungen..." },
/* fr */ { IDMS_REU_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_REU_SETTINGS_HU, "RED belltsai..." },
/* it */ { IDMS_REU_SETTINGS_IT, "Impostazioni REU..." },
/* nl */ { IDMS_REU_SETTINGS_NL, "REU instellingen..." },
/* pl */ { IDMS_REU_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_REU_SETTINGS_SV, "REU-instllningar..." },
/* tr */ { IDMS_REU_SETTINGS_TR, "REU ayarlar..." },

/* en */ { IDMS_MAGIC_VOICE_SETTINGS,    "Magic Voice settings..." },
/* da */ { IDMS_MAGIC_VOICE_SETTINGS_DA, "Magic Voice-indstillinger..." },
/* de */ { IDMS_MAGIC_VOICE_SETTINGS_DE, "Magic Voice Einstellungen..." },
/* fr */ { IDMS_MAGIC_VOICE_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_MAGIC_VOICE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_MAGIC_VOICE_SETTINGS_IT, "Impostazioni Magic Voice..." },
/* nl */ { IDMS_MAGIC_VOICE_SETTINGS_NL, "Magic Voice instellingen..." },
/* pl */ { IDMS_MAGIC_VOICE_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_MAGIC_VOICE_SETTINGS_SV, "Magic Voice-instllningar..." },
/* tr */ { IDMS_MAGIC_VOICE_SETTINGS_TR, "Magic Voice ayalar..." },

/* en */ { IDMS_GEORAM_SETTINGS,    "GEO-RAM settings..." },
/* da */ { IDMS_GEORAM_SETTINGS_DA, "GEO-RAM-indstillinger..." },
/* de */ { IDMS_GEORAM_SETTINGS_DE, "GEO-RAM Einstellungen..." },
/* fr */ { IDMS_GEORAM_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_GEORAM_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_GEORAM_SETTINGS_IT, "Impostazioni GEO-RAM..." },
/* nl */ { IDMS_GEORAM_SETTINGS_NL, "GEO-RAM instellingen..." },
/* pl */ { IDMS_GEORAM_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_GEORAM_SETTINGS_SV, "GEO-RAM-instllningar..." },
/* tr */ { IDMS_GEORAM_SETTINGS_TR, "GEO-RAM ayarlar..." },

/* en */ { IDMS_RAMCART_SETTINGS,    "RamCart settings..." },
/* da */ { IDMS_RAMCART_SETTINGS_DA, "RamCart indstillinger..." },
/* de */ { IDMS_RAMCART_SETTINGS_DE, "RamCart Einstellungen..." },
/* fr */ { IDMS_RAMCART_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_RAMCART_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_RAMCART_SETTINGS_IT, "Impostazioni RamCart..." },
/* nl */ { IDMS_RAMCART_SETTINGS_NL, "RamCart instellingen..." },
/* pl */ { IDMS_RAMCART_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_RAMCART_SETTINGS_SV, "RamCart-instllningar..." },
/* tr */ { IDMS_RAMCART_SETTINGS_TR, "RamCart ayarlar..." },

/* en */ { IDMS_DQBB_SETTINGS,    "Double Quick Brown Box settings..." },
/* da */ { IDMS_DQBB_SETTINGS_DA, "Double Quick Brown Box indstillinger..." },
/* de */ { IDMS_DQBB_SETTINGS_DE, "Double Quick Brown Box Einstellungen..." },
/* fr */ { IDMS_DQBB_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DQBB_SETTINGS_HU, "Double Quick Brown Box belltsok..." },
/* it */ { IDMS_DQBB_SETTINGS_IT, "Impostazioni Double Quick Brown Box..." },
/* nl */ { IDMS_DQBB_SETTINGS_NL, "Double Quick Brown Box instellingen..." },
/* pl */ { IDMS_DQBB_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DQBB_SETTINGS_SV, "Instllninga fr dubbel Quick Brown Box..." },
/* tr */ { IDMS_DQBB_SETTINGS_TR, "Double Quick Brown Box ayarlar..." },

/* en */ { IDMS_ISEPIC_SETTINGS,    "ISEPIC settings..." },
/* da */ { IDMS_ISEPIC_SETTINGS_DA, "ISEPIC-indstillinger..." },
/* de */ { IDMS_ISEPIC_SETTINGS_DE, "ISEPIC Einstellungen..." },
/* fr */ { IDMS_ISEPIC_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ISEPIC_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_ISEPIC_SETTINGS_IT, "Impostazioni ISEPIC..." },
/* nl */ { IDMS_ISEPIC_SETTINGS_NL, "ISEPIC instellingen..." },
/* pl */ { IDMS_ISEPIC_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ISEPIC_SETTINGS_SV, "ISEPIC-instllningar..." },
/* tr */ { IDMS_ISEPIC_SETTINGS_TR, "ISEPIC ayarlar..." },

/* en */ { IDMS_EXPERT_SETTINGS,    "Expert Cartridge settings..." },
/* da */ { IDMS_EXPERT_SETTINGS_DA, "Expert Cartridge indstillinger..." },
/* de */ { IDMS_EXPERT_SETTINGS_DE, "Expert Cartridge Einstellungen" },
/* fr */ { IDMS_EXPERT_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_EXPERT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_EXPERT_SETTINGS_IT, "Impostazioni Expert Cartridge..." },
/* nl */ { IDMS_EXPERT_SETTINGS_NL, "Expert Cartridge instellingen..." },
/* pl */ { IDMS_EXPERT_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_EXPERT_SETTINGS_SV, "Expert Cartridge-instllningar..." },
/* tr */ { IDMS_EXPERT_SETTINGS_TR, "Expert Kartuu ayarlar..." },

/* en */ { IDMS_PLUS60K_SETTINGS,    "PLUS60K settings..." },
/* da */ { IDMS_PLUS60K_SETTINGS_DA, "PLUS60K-indstillinger..." },
/* de */ { IDMS_PLUS60K_SETTINGS_DE, "PLUS60K Einstellungen..." },
/* fr */ { IDMS_PLUS60K_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PLUS60K_SETTINGS_HU, "PLUS60K belltsai..." },
/* it */ { IDMS_PLUS60K_SETTINGS_IT, "Impostazioni PLUS60K..." },
/* nl */ { IDMS_PLUS60K_SETTINGS_NL, "PLUS60K instellingen..." },
/* pl */ { IDMS_PLUS60K_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PLUS60K_SETTINGS_SV, "PLUS60K-instllningar..." },
/* tr */ { IDMS_PLUS60K_SETTINGS_TR, "PLUS60K ayarlar..." },

/* en */ { IDS_PLUS256K_FILENAME,    "PLUS256K file" },
/* da */ { IDS_PLUS256K_FILENAME_DA, "PLUS256K-fil" },
/* de */ { IDS_PLUS256K_FILENAME_DE, "PLUS256K Image Name" },
/* fr */ { IDS_PLUS256K_FILENAME_FR, "Fichier PLUS256K" },
/* hu */ { IDS_PLUS256K_FILENAME_HU, "PLUS256K fjl" },
/* it */ { IDS_PLUS256K_FILENAME_IT, "File PLUS256K" },
/* nl */ { IDS_PLUS256K_FILENAME_NL, "PLUS256K bestand" },
/* pl */ { IDS_PLUS256K_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_PLUS256K_FILENAME_SV, "PLUS256K-fil" },
/* tr */ { IDS_PLUS256K_FILENAME_TR, "PLUS256K dosyas" },

/* en */ { IDS_PLUS256K_FILENAME_SELECT,    "Select file for PLUS256K" },
/* da */ { IDS_PLUS256K_FILENAME_SELECT_DA, "Vlg fil for PLUS256K" },
/* de */ { IDS_PLUS256K_FILENAME_SELECT_DE, "Datei fr PLUS256K auswhlen" },
/* fr */ { IDS_PLUS256K_FILENAME_SELECT_FR, "Slectionner fichier pour PLUS256K" },
/* hu */ { IDS_PLUS256K_FILENAME_SELECT_HU, "Vlasszon fjlt a PLUS256K-hoz" },
/* it */ { IDS_PLUS256K_FILENAME_SELECT_IT, "Seleziona file per PLUS256K" },
/* nl */ { IDS_PLUS256K_FILENAME_SELECT_NL, "Selecteer bestand voor PLUS256K" },
/* pl */ { IDS_PLUS256K_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_PLUS256K_FILENAME_SELECT_SV, "Ange fil fr PLUS256K" },
/* tr */ { IDS_PLUS256K_FILENAME_SELECT_TR, "PLUS256K iin dosya sein" },

/* en */ { IDMS_PLUS256K_SETTINGS,    "PLUS256K settings..." },
/* da */ { IDMS_PLUS256K_SETTINGS_DA, "PLUS256K-indstillinger..." },
/* de */ { IDMS_PLUS256K_SETTINGS_DE, "PLUS256K Einstellungen..." },
/* fr */ { IDMS_PLUS256K_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PLUS256K_SETTINGS_HU, "PLUS256K belltsai..." },
/* it */ { IDMS_PLUS256K_SETTINGS_IT, "Impostazioni PLUS256K..." },
/* nl */ { IDMS_PLUS256K_SETTINGS_NL, "PLUS256K instellingen..." },
/* pl */ { IDMS_PLUS256K_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PLUS256K_SETTINGS_SV, "PLUS256K-instllningar..." },
/* tr */ { IDMS_PLUS256K_SETTINGS_TR, "PLUS256K ayarlar..." },

/* en */ { IDMS_256K_SETTINGS,    "256K settings..." },
/* da */ { IDMS_256K_SETTINGS_DA, "256K-indstillinger..." },
/* de */ { IDMS_256K_SETTINGS_DE, "256K Einstellungen..." },
/* fr */ { IDMS_256K_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_256K_SETTINGS_HU, "256K belltsai..." },
/* it */ { IDMS_256K_SETTINGS_IT, "Impostazioni 256K..." },
/* nl */ { IDMS_256K_SETTINGS_NL, "256K instellingen..." },
/* pl */ { IDMS_256K_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_256K_SETTINGS_SV, "256K-instllningar..." },
/* tr */ { IDMS_256K_SETTINGS_TR, "256K ayarlar..." },

/* en */ { IDMS_IDE64_SETTINGS,    "IDE64 settings..." },
/* da */ { IDMS_IDE64_SETTINGS_DA, "IDE64-indstillinger..." },
/* de */ { IDMS_IDE64_SETTINGS_DE, "IDE64 Einstellungen..." },
/* fr */ { IDMS_IDE64_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_IDE64_SETTINGS_HU, "IDE64 belltsai..." },
/* it */ { IDMS_IDE64_SETTINGS_IT, "Impostazioni IDE64..." },
/* nl */ { IDMS_IDE64_SETTINGS_NL, "IDE64 instellingen..." },
/* pl */ { IDMS_IDE64_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_IDE64_SETTINGS_SV, "IDE64-instllningar..." },
/* tr */ { IDMS_IDE64_SETTINGS_TR, "IDE64 ayarlar..." },

/* en */ { IDMS_MMC64_SETTINGS,    "MMC64 settings..." },
/* da */ { IDMS_MMC64_SETTINGS_DA, "MMC64-indstillinger..." },
/* de */ { IDMS_MMC64_SETTINGS_DE, "MMC64 Einstellungen..." },
/* fr */ { IDMS_MMC64_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_MMC64_SETTINGS_HU, "MMC64 belltsai..." },
/* it */ { IDMS_MMC64_SETTINGS_IT, "Impostazioni MMC64..." },
/* nl */ { IDMS_MMC64_SETTINGS_NL, "MMC64 instellingen..." },
/* pl */ { IDMS_MMC64_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_MMC64_SETTINGS_SV, "MMC64-instllningar..." },
/* tr */ { IDMS_MMC64_SETTINGS_TR, "MMC64 ayarlar..." },

/* en */ { IDMS_MMCREPLAY_SETTINGS,    "MMC Replay settings..." },
/* da */ { IDMS_MMCREPLAY_SETTINGS_DA, "MMC Replay-indstillinger..." },
/* de */ { IDMS_MMCREPLAY_SETTINGS_DE, "MMC Replay Einstellungen..." },
/* fr */ { IDMS_MMCREPLAY_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_MMCREPLAY_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_MMCREPLAY_SETTINGS_IT, "Impostazioni MMC Replay..." },
/* nl */ { IDMS_MMCREPLAY_SETTINGS_NL, "MMC Replay instellingen..." },
/* pl */ { IDMS_MMCREPLAY_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_MMCREPLAY_SETTINGS_SV, "MMC Replay-instllningar..." },
/* tr */ { IDMS_MMCREPLAY_SETTINGS_TR, "MMC Replay ayarlar..." },

/* en */ { IDMS_DIGIMAX_SETTINGS,    "DigiMAX settings..." },
/* da */ { IDMS_DIGIMAX_SETTINGS_DA, "DigiMAX-indstillinger..." },
/* de */ { IDMS_DIGIMAX_SETTINGS_DE, "DigiMAX Einstellungen..." },
/* fr */ { IDMS_DIGIMAX_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DIGIMAX_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_DIGIMAX_SETTINGS_IT, "Impostazioni DigiMAX..." },
/* nl */ { IDMS_DIGIMAX_SETTINGS_NL, "DigiMAX instellingen..." },
/* pl */ { IDMS_DIGIMAX_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DIGIMAX_SETTINGS_SV, "DigiMAX-instllningar..." },
/* tr */ { IDMS_DIGIMAX_SETTINGS_TR, "DigiMAX ayarlar..." },

/* en */ { IDMS_SFX_SE_SETTINGS,    "SFX Sound Expander settings..." },
/* da */ { IDMS_SFX_SE_SETTINGS_DA, "SFX Sound Expander-indstillinger..." },
/* de */ { IDMS_SFX_SE_SETTINGS_DE, "SFX Sound Expander Einstellungen..." },
/* fr */ { IDMS_SFX_SE_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SFX_SE_SETTINGS_HU, "SFX Sound Expander belltsai..." },
/* it */ { IDMS_SFX_SE_SETTINGS_IT, "Impostazioni SFX Sound Expander..." },
/* nl */ { IDMS_SFX_SE_SETTINGS_NL, "SFX Sound Expander instellingen..." },
/* pl */ { IDMS_SFX_SE_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SFX_SE_SETTINGS_SV, "Instllningar fr SFX Sound Expander..." },
/* tr */ { IDMS_SFX_SE_SETTINGS_TR, "SFX Sound Expander ayarlar..." },

/* en */ { IDMS_EASYFLASH_SETTINGS,    "EasyFlash settings..." },
/* da */ { IDMS_EASYFLASH_SETTINGS_DA, "EasyFlash-indstillinger..." },
/* de */ { IDMS_EASYFLASH_SETTINGS_DE, "EasyFlash Einstellungen..." },
/* fr */ { IDMS_EASYFLASH_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_EASYFLASH_SETTINGS_HU, "EasyFlash belltsai..." },
/* it */ { IDMS_EASYFLASH_SETTINGS_IT, "Impostazioni EasyFlash..." },
/* nl */ { IDMS_EASYFLASH_SETTINGS_NL, "EasyFlash instellingen..." },
/* pl */ { IDMS_EASYFLASH_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_EASYFLASH_SETTINGS_SV, "EasyFlash-instllningar..." },
/* tr */ { IDMS_EASYFLASH_SETTINGS_TR, "EasyFlash ayarlar..." },

/* en */ { IDMS_ENABLE_SFX_SS,    "Enable SFX Sound Sampler" },
/* da */ { IDMS_ENABLE_SFX_SS_DA, "Aktivr SFX Sound Sampler" },
/* de */ { IDMS_ENABLE_SFX_SS_DE, "SFX Sound Sampler aktivieren" },
/* fr */ { IDMS_ENABLE_SFX_SS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ENABLE_SFX_SS_HU, "SFX Sound Sampler engedlyezse" },
/* it */ { IDMS_ENABLE_SFX_SS_IT, "Attiva SFX Sound Sampler" },
/* nl */ { IDMS_ENABLE_SFX_SS_NL, "Activeer SFX Sound Sampler" },
/* pl */ { IDMS_ENABLE_SFX_SS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ENABLE_SFX_SS_SV, "Aktivera SFX Sound Sampler" },
/* tr */ { IDMS_ENABLE_SFX_SS_TR, "SFX Sound Sampler' Aktif Et" },

/* en */ { IDMS_ENABLE_USERPORT_DAC,    "Enable userport DAC" },
/* da */ { IDMS_ENABLE_USERPORT_DAC_DA, "Aktivr brugerport DAC" },
/* de */ { IDMS_ENABLE_USERPORT_DAC_DE, "Userport DAC aktivieren" },
/* fr */ { IDMS_ENABLE_USERPORT_DAC_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ENABLE_USERPORT_DAC_HU, "" },  /* fuzzy */
/* it */ { IDMS_ENABLE_USERPORT_DAC_IT, "Attiva DAC su userport" },
/* nl */ { IDMS_ENABLE_USERPORT_DAC_NL, "Activeer userport DAC" },
/* pl */ { IDMS_ENABLE_USERPORT_DAC_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ENABLE_USERPORT_DAC_SV, "Aktivera D/A-omvandlare p anvndarporten" },
/* tr */ { IDMS_ENABLE_USERPORT_DAC_TR, "Userport DAC' aktif et" },

/* en */ { IDMS_ETHERNET_SETTINGS,    "Ethernet settings..." },
/* da */ { IDMS_ETHERNET_SETTINGS_DA, "Ethernetindstillinger..." },
/* de */ { IDMS_ETHERNET_SETTINGS_DE, "Ethernet Einstellungen..." },
/* fr */ { IDMS_ETHERNET_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ETHERNET_SETTINGS_HU, "Ethernet belltsai..." },
/* it */ { IDMS_ETHERNET_SETTINGS_IT, "Impostazioni Ethernet..." },
/* nl */ { IDMS_ETHERNET_SETTINGS_NL, "Ethernet instellingen..." },
/* pl */ { IDMS_ETHERNET_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ETHERNET_SETTINGS_SV, "Ethernetinstllningar..." },
/* tr */ { IDMS_ETHERNET_SETTINGS_TR, "Ethernet ayarlar..." },

/* en */ { IDMS_ACIA_SETTINGS,    "ACIA settings..." },
/* da */ { IDMS_ACIA_SETTINGS_DA, "ACIA-indstillinger..." },
/* de */ { IDMS_ACIA_SETTINGS_DE, "ACIA Einstellungen..." },
/* fr */ { IDMS_ACIA_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ACIA_SETTINGS_HU, "ACIA belltsai..." },
/* it */ { IDMS_ACIA_SETTINGS_IT, "Impostazioni ACIA..." },
/* nl */ { IDMS_ACIA_SETTINGS_NL, "ACIA instellingen..." },
/* pl */ { IDMS_ACIA_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ACIA_SETTINGS_SV, "ACIA-instllningar..." },
/* tr */ { IDMS_ACIA_SETTINGS_TR, "ACIA ayarlar..." },

/* en */ { IDMS_PETREU_SETTINGS,    "PET REU settings..." },
/* da */ { IDMS_PETREU_SETTINGS_DA, "PET REU-indstillinger..." },
/* de */ { IDMS_PETREU_SETTINGS_DE, "PET Einstellungen..." },
/* fr */ { IDMS_PETREU_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PETREU_SETTINGS_HU, "PET REU belltsai..." },
/* it */ { IDMS_PETREU_SETTINGS_IT, "Impostazioni PET..." },
/* nl */ { IDMS_PETREU_SETTINGS_NL, "PET REU instellingen..." },
/* pl */ { IDMS_PETREU_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PETREU_SETTINGS_SV, "PET REU-instllningar..." },
/* tr */ { IDMS_PETREU_SETTINGS_TR, "PET REU ayarlar..." },

/* en */ { IDMS_V364_SPEECH_SETTINGS,    "V364 Speech settings..." },
/* da */ { IDMS_V364_SPEECH_SETTINGS_DA, "V364 Speech-indstillinger..." },
/* de */ { IDMS_V364_SPEECH_SETTINGS_DE, "V364 Stimme Einstellungen" },
/* fr */ { IDMS_V364_SPEECH_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_V364_SPEECH_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_V364_SPEECH_SETTINGS_IT, "Impostazioni V364 Speech..." },
/* nl */ { IDMS_V364_SPEECH_SETTINGS_NL, "V364 Spraak instellingen..." },
/* pl */ { IDMS_V364_SPEECH_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_V364_SPEECH_SETTINGS_SV, "V364-rstinstllningar..." },
/* tr */ { IDMS_V364_SPEECH_SETTINGS_TR, "V364 Speech ayarlar..." },

/* en */ { IDMS_SIDCART_SETTINGS,    "SID cart settings..." },
/* da */ { IDMS_SIDCART_SETTINGS_DA, "SID-indstillinger..." },
/* de */ { IDMS_SIDCART_SETTINGS_DE, "SID Modul Einstellungen..." },
/* fr */ { IDMS_SIDCART_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SIDCART_SETTINGS_HU, "SID krtya belltsai..." },
/* it */ { IDMS_SIDCART_SETTINGS_IT, "Impostazioni cartuccia SID..." },
/* nl */ { IDMS_SIDCART_SETTINGS_NL, "SID cart instellingen..." },
/* pl */ { IDMS_SIDCART_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SIDCART_SETTINGS_SV, "SID-modulinstllningar..." },
/* tr */ { IDMS_SIDCART_SETTINGS_TR, "SID kartu ayarlar..." },

/* en */ { IDMS_PETDWW_SETTINGS,    "PET DWW settings..." },
/* da */ { IDMS_PETDWW_SETTINGS_DA, "PET DWW-indstillinger..." },
/* de */ { IDMS_PETDWW_SETTINGS_DE, "PET DWW Einstellungen..." },
/* fr */ { IDMS_PETDWW_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_PETDWW_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDMS_PETDWW_SETTINGS_IT, "Impostazioni PET DWW..." },
/* nl */ { IDMS_PETDWW_SETTINGS_NL, "PET DWW instellingen..." },
/* pl */ { IDMS_PETDWW_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_PETDWW_SETTINGS_SV, "PET DWW-instllningar..." },
/* tr */ { IDMS_PETDWW_SETTINGS_TR, "PET DWW ayarlar..." },

/* en */ { IDMS_FINAL_EXPANSION_WRITEBACK,    "Enable Final Expansion write-back" },
/* da */ { IDMS_FINAL_EXPANSION_WRITEBACK_DA, "Aktivr Final Expansion tilbageskrivning" },
/* de */ { IDMS_FINAL_EXPANSION_WRITEBACK_DE, "Final Expansion rckschreiben aktivieren" },
/* fr */ { IDMS_FINAL_EXPANSION_WRITEBACK_FR, "" },  /* fuzzy */
/* hu */ { IDMS_FINAL_EXPANSION_WRITEBACK_HU, "Final Expansion visszars engedlyezse" },
/* it */ { IDMS_FINAL_EXPANSION_WRITEBACK_IT, "Attiva write back su Final Expansion" },
/* nl */ { IDMS_FINAL_EXPANSION_WRITEBACK_NL, "Activeer terug schrijven van Final Expansion" },
/* pl */ { IDMS_FINAL_EXPANSION_WRITEBACK_PL, "" },  /* fuzzy */
/* sv */ { IDMS_FINAL_EXPANSION_WRITEBACK_SV, "Aktivera Final Expansion-terskrivning" },
/* tr */ { IDMS_FINAL_EXPANSION_WRITEBACK_TR, "Final Expansion geri yazmay aktif et" },

/* en */ { IDMS_FP_WRITEBACK,    "Enable Vic Flash Plugin write-back" },
/* da */ { IDMS_FP_WRITEBACK_DA, "Aktivr Vic Flash Plugin tilbageskrivning" },
/* de */ { IDMS_FP_WRITEBACK_DE, "Vic Flash Plugin Rckschreiben aktivieren" },
/* fr */ { IDMS_FP_WRITEBACK_FR, "" },  /* fuzzy */
/* hu */ { IDMS_FP_WRITEBACK_HU, "" },  /* fuzzy */
/* it */ { IDMS_FP_WRITEBACK_IT, "Write back Vic Flash Plugin" },
/* nl */ { IDMS_FP_WRITEBACK_NL, "Activeer Vic Flash Plugin terug schrijven" },
/* pl */ { IDMS_FP_WRITEBACK_PL, "" },  /* fuzzy */
/* sv */ { IDMS_FP_WRITEBACK_SV, "Aktivera Vic Flash-insticksmodul-terskrivning" },
/* tr */ { IDMS_FP_WRITEBACK_TR, "Vic Flash Plugin geri yazmay aktif et" },

/* en */ { IDMS_MEGACART_WRITEBACK,    "Enable Mega-Cart NvRAM writeback" },
/* da */ { IDMS_MEGACART_WRITEBACK_DA, "Aktivr Mega-Cart NvRAM tilbageskrivning" },
/* de */ { IDMS_MEGACART_WRITEBACK_DE, "Mega-Cart NvRAM Rckschreiben aktivieren" },
/* fr */ { IDMS_MEGACART_WRITEBACK_FR, "" },  /* fuzzy */
/* hu */ { IDMS_MEGACART_WRITEBACK_HU, "" },  /* fuzzy */
/* it */ { IDMS_MEGACART_WRITEBACK_IT, "Write back NvRAM Mega-Cart" },
/* nl */ { IDMS_MEGACART_WRITEBACK_NL, "Activeer Mega-Cart NvRAM terug schrijven" },
/* pl */ { IDMS_MEGACART_WRITEBACK_PL, "" },  /* fuzzy */
/* sv */ { IDMS_MEGACART_WRITEBACK_SV, "Aktivera Mega-Cart NvRAM-terskrivning" },
/* tr */ { IDMS_MEGACART_WRITEBACK_TR, "Mega-Cart NvRAM geri yazmay aktif et" },

/* en */ { IDMS_MEGACART_WRITEBACK_FILE,    "Select Mega-Cart non-volatile RAM file" },
/* da */ { IDMS_MEGACART_WRITEBACK_FILE_DA, "Vlg Mega-Cart NVRAM-fil" },
/* de */ { IDMS_MEGACART_WRITEBACK_FILE_DE, "Mega-Cart nicht-flchtiges RAM Datei whlen" },
/* fr */ { IDMS_MEGACART_WRITEBACK_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_MEGACART_WRITEBACK_FILE_HU, "Vlassza ki az NvRAM kpfjlt" },
/* it */ { IDMS_MEGACART_WRITEBACK_FILE_IT, "Seleziona file non-volatile RAM Mega-Cart" },
/* nl */ { IDMS_MEGACART_WRITEBACK_FILE_NL, "Selecteer Mega-Cart non-volatile RAM bestand" },
/* pl */ { IDMS_MEGACART_WRITEBACK_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_MEGACART_WRITEBACK_FILE_SV, "Vlj NvRAM-fil fr Mega-Cart" },
/* tr */ { IDMS_MEGACART_WRITEBACK_FILE_TR, "Mega-Cart non-volatile RAM dosyasn se" },

/* en */ { IDMS_C64DTV_SETTINGS,    "C64DTV settings..." },
/* da */ { IDMS_C64DTV_SETTINGS_DA, "C64DTV-indstillinger..." },
/* de */ { IDMS_C64DTV_SETTINGS_DE, "C64DTV Einstellungen..." },
/* fr */ { IDMS_C64DTV_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_C64DTV_SETTINGS_HU, "C64DTV belltsai..." },
/* it */ { IDMS_C64DTV_SETTINGS_IT, "Impostazioni C64DTV..." },
/* nl */ { IDMS_C64DTV_SETTINGS_NL, "C64DTV instellingen..." },
/* pl */ { IDMS_C64DTV_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_C64DTV_SETTINGS_SV, "C64DTV-instllningar..." },
/* tr */ { IDMS_C64DTV_SETTINGS_TR, "C64DTV ayarlar..." },

/* en */ { IDMS_RS232_USERPORT_SETTINGS,    "RS232 userport settings..." },
/* da */ { IDMS_RS232_USERPORT_SETTINGS_DA, "RS232-brugerportindstillinger..." },
/* de */ { IDMS_RS232_USERPORT_SETTINGS_DE, "RS232 Userport Einstellungen..." },
/* fr */ { IDMS_RS232_USERPORT_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_RS232_USERPORT_SETTINGS_HU, "RS232 userport belltsai..." },
/* it */ { IDMS_RS232_USERPORT_SETTINGS_IT, "Impostazioni RS232 su userport..." },
/* nl */ { IDMS_RS232_USERPORT_SETTINGS_NL, "RS232 userport instellingen..." },
/* pl */ { IDMS_RS232_USERPORT_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_RS232_USERPORT_SETTINGS_SV, "RS232-anvndarportinstllningar..." },
/* tr */ { IDMS_RS232_USERPORT_SETTINGS_TR, "RS232 userport ayarlar..." },

/* en */ { IDMS_SAVE_CURRENT_SETTINGS_FILE,    "Save current settings to specified file" },
/* da */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_DA, "Gem indstillinger som" },
/* de */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_DE, "Speichere Einstellungen in angegebene Datei" },
/* fr */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_HU, "Jelenlegi belltsok mentse adott fjlba" },
/* it */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_IT, "Salva impostazioni attuali sul file specificato" },
/* nl */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_NL, "Huidige instellingen opslaan naar opgegeven bestand" },
/* pl */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_SV, "Spara nuvarande instllningar till den angivna filen" },
/* tr */ { IDMS_SAVE_CURRENT_SETTINGS_FILE_TR, "Belirtilen dosyaya geerli ayarlar kaydet" },

/* en */ { IDMS_LOAD_SAVED_SETTINGS_FILE,    "Load settings from specified file" },
/* da */ { IDMS_LOAD_SAVED_SETTINGS_FILE_DA, "Indls indstillinger fra" },
/* de */ { IDMS_LOAD_SAVED_SETTINGS_FILE_DE, "Lade Einstellungen aus Datei" },
/* fr */ { IDMS_LOAD_SAVED_SETTINGS_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LOAD_SAVED_SETTINGS_FILE_HU, "Belltsok betltse a megadott fjlbl" },
/* it */ { IDMS_LOAD_SAVED_SETTINGS_FILE_IT, "Carica impostazioni dal file specificato" },
/* nl */ { IDMS_LOAD_SAVED_SETTINGS_FILE_NL, "Instellingen laden van opgegeven bestand" },
/* pl */ { IDMS_LOAD_SAVED_SETTINGS_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LOAD_SAVED_SETTINGS_FILE_SV, "Ls instllningar frn den angivna filen" },
/* tr */ { IDMS_LOAD_SAVED_SETTINGS_FILE_TR, "Belirtilen dosyadan ayarlar ykle" },

/* en */ { IDMS_SAVE_CURRENT_SETTINGS,    "Save current settings" },
/* da */ { IDMS_SAVE_CURRENT_SETTINGS_DA, "Gen aktuelle indstillinger" },
/* de */ { IDMS_SAVE_CURRENT_SETTINGS_DE, "Einstellungen speichern" },
/* fr */ { IDMS_SAVE_CURRENT_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SAVE_CURRENT_SETTINGS_HU, "Jelenlegi belltsok mentse" },
/* it */ { IDMS_SAVE_CURRENT_SETTINGS_IT, "Salva impostazioni attuali" },
/* nl */ { IDMS_SAVE_CURRENT_SETTINGS_NL, "Huidige instellingen opslaan" },
/* pl */ { IDMS_SAVE_CURRENT_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SAVE_CURRENT_SETTINGS_SV, "Spara nuvarande instllningar" },
/* tr */ { IDMS_SAVE_CURRENT_SETTINGS_TR, "Geerli ayarlar kaydet" },

/* en */ { IDMS_LOAD_SAVED_SETTINGS,    "Load saved settings" },
/* da */ { IDMS_LOAD_SAVED_SETTINGS_DA, "Indls gemte indstillinger" },
/* de */ { IDMS_LOAD_SAVED_SETTINGS_DE, "Gespeicherte Einstellungen Laden" },
/* fr */ { IDMS_LOAD_SAVED_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LOAD_SAVED_SETTINGS_HU, "Belltsok betltse" },
/* it */ { IDMS_LOAD_SAVED_SETTINGS_IT, "Carica impostazioni salvate" },
/* nl */ { IDMS_LOAD_SAVED_SETTINGS_NL, "Opgeslagen instellingen laden" },
/* pl */ { IDMS_LOAD_SAVED_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LOAD_SAVED_SETTINGS_SV, "Ls sparade instllningar" },
/* tr */ { IDMS_LOAD_SAVED_SETTINGS_TR, "Kaydedilmi ayarlar ykle" },

/* en */ { IDMS_SET_DEFAULT_SETTINGS,    "Set default settings" },
/* da */ { IDMS_SET_DEFAULT_SETTINGS_DA, "Gendan standard indstillinger" },
/* de */ { IDMS_SET_DEFAULT_SETTINGS_DE, "Standard Einstellungen wiederherstellen" },
/* fr */ { IDMS_SET_DEFAULT_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SET_DEFAULT_SETTINGS_HU, "Alaprtelmezs belltsa" },
/* it */ { IDMS_SET_DEFAULT_SETTINGS_IT, "Ripristina impostazioni originarie" },
/* nl */ { IDMS_SET_DEFAULT_SETTINGS_NL, "Herstel standaard instellingen" },
/* pl */ { IDMS_SET_DEFAULT_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SET_DEFAULT_SETTINGS_SV, "terstll frvalda instllningar" },
/* tr */ { IDMS_SET_DEFAULT_SETTINGS_TR, "Mevcut ayarlar varsaylan olarak kaydet" },

/* en */ { IDMS_SAVE_SETTING_ON_EXIT,    "Save settings on exit" },
/* da */ { IDMS_SAVE_SETTING_ON_EXIT_DA, "Gem indstillinger nr programmet afsluttes" },
/* de */ { IDMS_SAVE_SETTING_ON_EXIT_DE, "Einstellungen beim Beenden speichern" },
/* fr */ { IDMS_SAVE_SETTING_ON_EXIT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_SAVE_SETTING_ON_EXIT_HU, "Belltsok mentse kilpskor" },
/* it */ { IDMS_SAVE_SETTING_ON_EXIT_IT, "Salva impostazioni in uscita" },
/* nl */ { IDMS_SAVE_SETTING_ON_EXIT_NL, "Sla instellingen op bij afsluiten" },
/* pl */ { IDMS_SAVE_SETTING_ON_EXIT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_SAVE_SETTING_ON_EXIT_SV, "Spara instllningar vid avslut" },
/* tr */ { IDMS_SAVE_SETTING_ON_EXIT_TR, "kta ayarlar kaydet" },

/* en */ { IDMS_CONFIRM_ON_EXIT,    "Confirm on exit" },
/* da */ { IDMS_CONFIRM_ON_EXIT_DA, "Bekrft programafslutning" },
/* de */ { IDMS_CONFIRM_ON_EXIT_DE, "Besttigung beim Beenden" },
/* fr */ { IDMS_CONFIRM_ON_EXIT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_CONFIRM_ON_EXIT_HU, "Megersts kilpskor" },
/* it */ { IDMS_CONFIRM_ON_EXIT_IT, "Conferma all'uscita" },
/* nl */ { IDMS_CONFIRM_ON_EXIT_NL, "Bevestigen bij afsluiten" },
/* pl */ { IDMS_CONFIRM_ON_EXIT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_CONFIRM_ON_EXIT_SV, "Bekrfta avslutning" },
/* tr */ { IDMS_CONFIRM_ON_EXIT_TR, "kta teyit et" },

/* en */ { IDMS_HELP,    "Help" },
/* da */ { IDMS_HELP_DA, "Hjlp" },
/* de */ { IDMS_HELP_DE, "Hilfe" },
/* fr */ { IDMS_HELP_FR, "Aide" },
/* hu */ { IDMS_HELP_HU, "Segtsg" },
/* it */ { IDMS_HELP_IT, "Aiuto" },
/* nl */ { IDMS_HELP_NL, "Help" },
/* pl */ { IDMS_HELP_PL, "Pomoc" },
/* sv */ { IDMS_HELP_SV, "Hjlp" },
/* tr */ { IDMS_HELP_TR, "Yardm" },

/* en */ { IDMS_ABOUT,    "About..." },
/* da */ { IDMS_ABOUT_DA, "Om..." },
/* de */ { IDMS_ABOUT_DE, "ber VICE..." },
/* fr */ { IDMS_ABOUT_FR, "" },  /* fuzzy */
/* hu */ { IDMS_ABOUT_HU, "Nvjegy..." },
/* it */ { IDMS_ABOUT_IT, "Informazioni..." },
/* nl */ { IDMS_ABOUT_NL, "Over VICE..." },
/* pl */ { IDMS_ABOUT_PL, "" },  /* fuzzy */
/* sv */ { IDMS_ABOUT_SV, "Om..." },
/* tr */ { IDMS_ABOUT_TR, "Hakknda..." },

/* en */ { IDMS_COMMAND_LINE_OPTIONS,    "Command line options" },
/* da */ { IDMS_COMMAND_LINE_OPTIONS_DA, "Kommandolinjeparametre" },
/* de */ { IDMS_COMMAND_LINE_OPTIONS_DE, "Kommandozeilen Paramteter" },
/* fr */ { IDMS_COMMAND_LINE_OPTIONS_FR, "Options de ligne de commande" },
/* hu */ { IDMS_COMMAND_LINE_OPTIONS_HU, "Parancssori opcik" },
/* it */ { IDMS_COMMAND_LINE_OPTIONS_IT, "Parametri della riga di comando" },
/* nl */ { IDMS_COMMAND_LINE_OPTIONS_NL, "Commando opties" },
/* pl */ { IDMS_COMMAND_LINE_OPTIONS_PL, "" },  /* fuzzy */
/* sv */ { IDMS_COMMAND_LINE_OPTIONS_SV, "Kommandoradsflaggor" },
/* tr */ { IDMS_COMMAND_LINE_OPTIONS_TR, "Komut satr seenekleri" },

/* en */ { IDMS_CONTRIBUTORS,    "Contributors" },
/* da */ { IDMS_CONTRIBUTORS_DA, "Bidragsydere" },
/* de */ { IDMS_CONTRIBUTORS_DE, "VICE Hackers" },
/* fr */ { IDMS_CONTRIBUTORS_FR, "Contributeurs" },
/* hu */ { IDMS_CONTRIBUTORS_HU, "Kzremkdk" },
/* it */ { IDMS_CONTRIBUTORS_IT, "Collaboratori" },
/* nl */ { IDMS_CONTRIBUTORS_NL, "Medewerkers" },
/* pl */ { IDMS_CONTRIBUTORS_PL, "Wsppracownicy" },
/* sv */ { IDMS_CONTRIBUTORS_SV, "Bidragslmnare" },
/* tr */ { IDMS_CONTRIBUTORS_TR, "Katlmclar" },

/* en */ { IDMS_LICENSE,    "License" },
/* da */ { IDMS_LICENSE_DA, "Licens" },
/* de */ { IDMS_LICENSE_DE, "Lizenz" },
/* fr */ { IDMS_LICENSE_FR, "License" },
/* hu */ { IDMS_LICENSE_HU, "Licensz" },
/* it */ { IDMS_LICENSE_IT, "Licenza" },
/* nl */ { IDMS_LICENSE_NL, "Licentie" },
/* pl */ { IDMS_LICENSE_PL, "Licencja" },
/* sv */ { IDMS_LICENSE_SV, "Licens" },
/* tr */ { IDMS_LICENSE_TR, "Lisans" },

/* en */ { IDMS_NO_WARRANTY,    "No warranty" },
/* da */ { IDMS_NO_WARRANTY_DA, "Ingen garanti" },
/* de */ { IDMS_NO_WARRANTY_DE, "Keine Garantie" },
/* fr */ { IDMS_NO_WARRANTY_FR, "" },  /* fuzzy */
/* hu */ { IDMS_NO_WARRANTY_HU, "Nincs garancia!" },
/* it */ { IDMS_NO_WARRANTY_IT, "Nessuna garanzia" },
/* nl */ { IDMS_NO_WARRANTY_NL, "Geen garantie!" },
/* pl */ { IDMS_NO_WARRANTY_PL, "" },  /* fuzzy */
/* sv */ { IDMS_NO_WARRANTY_SV, "Ingen garanti" },
/* tr */ { IDMS_NO_WARRANTY_TR, "Garanti verilmez" },

/* en */ { IDMS_LANGUAGE_INTERNATIONAL,    "International" },
/* da */ { IDMS_LANGUAGE_INTERNATIONAL_DA, "International" },
/* de */ { IDMS_LANGUAGE_INTERNATIONAL_DE, "International" },
/* fr */ { IDMS_LANGUAGE_INTERNATIONAL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_INTERNATIONAL_HU, "Nemzetkzi" },
/* it */ { IDMS_LANGUAGE_INTERNATIONAL_IT, "Internazionale" },
/* nl */ { IDMS_LANGUAGE_INTERNATIONAL_NL, "Internationaal" },
/* pl */ { IDMS_LANGUAGE_INTERNATIONAL_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_INTERNATIONAL_SV, "Internationell" },
/* tr */ { IDMS_LANGUAGE_INTERNATIONAL_TR, "Uluslararas" },

/* en */ { IDMS_LANGUAGE_ENGLISH,    "English" },
/* da */ { IDMS_LANGUAGE_ENGLISH_DA, "Engelsk" },
/* de */ { IDMS_LANGUAGE_ENGLISH_DE, "Englisch" },
/* fr */ { IDMS_LANGUAGE_ENGLISH_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_ENGLISH_HU, "Angol" },
/* it */ { IDMS_LANGUAGE_ENGLISH_IT, "Inglese" },
/* nl */ { IDMS_LANGUAGE_ENGLISH_NL, "Engels" },
/* pl */ { IDMS_LANGUAGE_ENGLISH_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_ENGLISH_SV, "Engelska" },
/* tr */ { IDMS_LANGUAGE_ENGLISH_TR, "ngilizce" },

/* en */ { IDMS_LANGUAGE_DANISH,    "Danish" },
/* da */ { IDMS_LANGUAGE_DANISH_DA, "Dansk" },
/* de */ { IDMS_LANGUAGE_DANISH_DE, "Dnisch" },
/* fr */ { IDMS_LANGUAGE_DANISH_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_DANISH_HU, "Dn" },
/* it */ { IDMS_LANGUAGE_DANISH_IT, "Danese" },
/* nl */ { IDMS_LANGUAGE_DANISH_NL, "Deens" },
/* pl */ { IDMS_LANGUAGE_DANISH_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_DANISH_SV, "Danska" },
/* tr */ { IDMS_LANGUAGE_DANISH_TR, "Danimarkaca" },

/* en */ { IDMS_LANGUAGE_GERMAN,    "German" },
/* da */ { IDMS_LANGUAGE_GERMAN_DA, "Tysk" },
/* de */ { IDMS_LANGUAGE_GERMAN_DE, "Deutsch" },
/* fr */ { IDMS_LANGUAGE_GERMAN_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_GERMAN_HU, "Nmet" },
/* it */ { IDMS_LANGUAGE_GERMAN_IT, "Tedesco" },
/* nl */ { IDMS_LANGUAGE_GERMAN_NL, "Duits" },
/* pl */ { IDMS_LANGUAGE_GERMAN_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_GERMAN_SV, "Tyska" },
/* tr */ { IDMS_LANGUAGE_GERMAN_TR, "Almanca" },

/* en */ { IDMS_LANGUAGE_FINNISH,    "Finnish" },
/* da */ { IDMS_LANGUAGE_FINNISH_DA, "Finsk" },
/* de */ { IDMS_LANGUAGE_FINNISH_DE, "Finnisch" },
/* fr */ { IDMS_LANGUAGE_FINNISH_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_FINNISH_HU, "Finn" },
/* it */ { IDMS_LANGUAGE_FINNISH_IT, "Finlandese" },
/* nl */ { IDMS_LANGUAGE_FINNISH_NL, "Fins" },
/* pl */ { IDMS_LANGUAGE_FINNISH_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_FINNISH_SV, "Finska" },
/* tr */ { IDMS_LANGUAGE_FINNISH_TR, "Fince" },

/* en */ { IDMS_LANGUAGE_FRENCH,    "French" },
/* da */ { IDMS_LANGUAGE_FRENCH_DA, "Fransk" },
/* de */ { IDMS_LANGUAGE_FRENCH_DE, "Franzsisch" },
/* fr */ { IDMS_LANGUAGE_FRENCH_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_FRENCH_HU, "Francia" },
/* it */ { IDMS_LANGUAGE_FRENCH_IT, "Francese" },
/* nl */ { IDMS_LANGUAGE_FRENCH_NL, "Frans" },
/* pl */ { IDMS_LANGUAGE_FRENCH_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_FRENCH_SV, "Franska" },
/* tr */ { IDMS_LANGUAGE_FRENCH_TR, "Franszca" },

/* en */ { IDMS_LANGUAGE_HUNGARIAN,    "Hungarian" },
/* da */ { IDMS_LANGUAGE_HUNGARIAN_DA, "Ungersk" },
/* de */ { IDMS_LANGUAGE_HUNGARIAN_DE, "Ungarisch" },
/* fr */ { IDMS_LANGUAGE_HUNGARIAN_FR, "Hungarian" },
/* hu */ { IDMS_LANGUAGE_HUNGARIAN_HU, "Magyar" },
/* it */ { IDMS_LANGUAGE_HUNGARIAN_IT, "Ungherese" },
/* nl */ { IDMS_LANGUAGE_HUNGARIAN_NL, "Hongaars" },
/* pl */ { IDMS_LANGUAGE_HUNGARIAN_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_HUNGARIAN_SV, "Ungerska" },
/* tr */ { IDMS_LANGUAGE_HUNGARIAN_TR, "Macarca" },

/* en */ { IDMS_LANGUAGE_ITALIAN,    "Italian" },
/* da */ { IDMS_LANGUAGE_ITALIAN_DA, "Italiensk" },
/* de */ { IDMS_LANGUAGE_ITALIAN_DE, "Italienisch" },
/* fr */ { IDMS_LANGUAGE_ITALIAN_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_ITALIAN_HU, "Olasz" },
/* it */ { IDMS_LANGUAGE_ITALIAN_IT, "Italiano" },
/* nl */ { IDMS_LANGUAGE_ITALIAN_NL, "Italiaans" },
/* pl */ { IDMS_LANGUAGE_ITALIAN_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_ITALIAN_SV, "Italienska" },
/* tr */ { IDMS_LANGUAGE_ITALIAN_TR, "talyanca" },

/* en */ { IDMS_LANGUAGE_DUTCH,    "Dutch" },
/* da */ { IDMS_LANGUAGE_DUTCH_DA, "Hollandsk" },
/* de */ { IDMS_LANGUAGE_DUTCH_DE, "Hollndisch" },
/* fr */ { IDMS_LANGUAGE_DUTCH_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_DUTCH_HU, "Holland" },
/* it */ { IDMS_LANGUAGE_DUTCH_IT, "Olandese" },
/* nl */ { IDMS_LANGUAGE_DUTCH_NL, "Nederlands" },
/* pl */ { IDMS_LANGUAGE_DUTCH_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_DUTCH_SV, "Nederlndska" },
/* tr */ { IDMS_LANGUAGE_DUTCH_TR, "Hollandaca" },

/* en */ { IDMS_LANGUAGE_NORWEGIAN,    "Norwegian" },
/* da */ { IDMS_LANGUAGE_NORWEGIAN_DA, "Norsk" },
/* de */ { IDMS_LANGUAGE_NORWEGIAN_DE, "Norwegisch" },
/* fr */ { IDMS_LANGUAGE_NORWEGIAN_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_NORWEGIAN_HU, "Norvg" },
/* it */ { IDMS_LANGUAGE_NORWEGIAN_IT, "Norvegese" },
/* nl */ { IDMS_LANGUAGE_NORWEGIAN_NL, "Noors" },
/* pl */ { IDMS_LANGUAGE_NORWEGIAN_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_NORWEGIAN_SV, "Norska" },
/* tr */ { IDMS_LANGUAGE_NORWEGIAN_TR, "Norvee" },

/* en */ { IDMS_LANGUAGE_POLISH,    "Polish" },
/* da */ { IDMS_LANGUAGE_POLISH_DA, "Polsk" },
/* de */ { IDMS_LANGUAGE_POLISH_DE, "Polnisch" },
/* fr */ { IDMS_LANGUAGE_POLISH_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_POLISH_HU, "Lengyel" },
/* it */ { IDMS_LANGUAGE_POLISH_IT, "Polacco" },
/* nl */ { IDMS_LANGUAGE_POLISH_NL, "Pools" },
/* pl */ { IDMS_LANGUAGE_POLISH_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_POLISH_SV, "Polska" },
/* tr */ { IDMS_LANGUAGE_POLISH_TR, "Polonyaca" },

/* en */ { IDMS_LANGUAGE_SWEDISH,    "Swedish" },
/* da */ { IDMS_LANGUAGE_SWEDISH_DA, "Svensk" },
/* de */ { IDMS_LANGUAGE_SWEDISH_DE, "Schwedisch" },
/* fr */ { IDMS_LANGUAGE_SWEDISH_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_SWEDISH_HU, "Svd" },
/* it */ { IDMS_LANGUAGE_SWEDISH_IT, "Svedese" },
/* nl */ { IDMS_LANGUAGE_SWEDISH_NL, "Zweeds" },
/* pl */ { IDMS_LANGUAGE_SWEDISH_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_SWEDISH_SV, "Svenska" },
/* tr */ { IDMS_LANGUAGE_SWEDISH_TR, "svee" },

/* en */ { IDMS_LANGUAGE_TURKISH,    "Turkish" },
/* da */ { IDMS_LANGUAGE_TURKISH_DA, "Tyrkisk" },
/* de */ { IDMS_LANGUAGE_TURKISH_DE, "Trkisch" },
/* fr */ { IDMS_LANGUAGE_TURKISH_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_TURKISH_HU, "Trk" },
/* it */ { IDMS_LANGUAGE_TURKISH_IT, "Turco" },
/* nl */ { IDMS_LANGUAGE_TURKISH_NL, "Turks" },
/* pl */ { IDMS_LANGUAGE_TURKISH_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_TURKISH_SV, "Turkiska" },
/* tr */ { IDMS_LANGUAGE_TURKISH_TR, "Trke" },

/* en */ { IDMS_LANGUAGE,    "Language" },
/* da */ { IDMS_LANGUAGE_DA, "Sprog" },
/* de */ { IDMS_LANGUAGE_DE, "Sprache" },
/* fr */ { IDMS_LANGUAGE_FR, "" },  /* fuzzy */
/* hu */ { IDMS_LANGUAGE_HU, "Nyelv" },
/* it */ { IDMS_LANGUAGE_IT, "Lingua" },
/* nl */ { IDMS_LANGUAGE_NL, "Taal" },
/* pl */ { IDMS_LANGUAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMS_LANGUAGE_SV, "Sprk" },
/* tr */ { IDMS_LANGUAGE_TR, "Dil" },

/* en */ { IDMS_FULLSCREEN_STATUSBAR,    "Fullscreen Statusbar" },
/* da */ { IDMS_FULLSCREEN_STATUSBAR_DA, "Statusbar i fullscreen" },
/* de */ { IDMS_FULLSCREEN_STATUSBAR_DE, "Vollbild Statusleiste" },
/* fr */ { IDMS_FULLSCREEN_STATUSBAR_FR, "" },  /* fuzzy */
/* hu */ { IDMS_FULLSCREEN_STATUSBAR_HU, "llapotsor teljes kpernynl" },
/* it */ { IDMS_FULLSCREEN_STATUSBAR_IT, "Barra di stato nella modalit a schermo intero" },
/* nl */ { IDMS_FULLSCREEN_STATUSBAR_NL, "Volscherm Statusbalk" },
/* pl */ { IDMS_FULLSCREEN_STATUSBAR_PL, "" },  /* fuzzy */
/* sv */ { IDMS_FULLSCREEN_STATUSBAR_SV, "Statusrad i fullskrm" },
/* tr */ { IDMS_FULLSCREEN_STATUSBAR_TR, "Tam ekran durum ubuu" },

/* en */ { IDMS_VIDEO_OVERLAY,    "Video overlay" },
/* da */ { IDMS_VIDEO_OVERLAY_DA, "Video-overlay" },
/* de */ { IDMS_VIDEO_OVERLAY_DE, "Video Overlay" },
/* fr */ { IDMS_VIDEO_OVERLAY_FR, "" },  /* fuzzy */
/* hu */ { IDMS_VIDEO_OVERLAY_HU, "Vide overlay" },
/* it */ { IDMS_VIDEO_OVERLAY_IT, "Overlay video" },
/* nl */ { IDMS_VIDEO_OVERLAY_NL, "Video overlay" },
/* pl */ { IDMS_VIDEO_OVERLAY_PL, "" },  /* fuzzy */
/* sv */ { IDMS_VIDEO_OVERLAY_SV, "Video-overlay" },
/* tr */ { IDMS_VIDEO_OVERLAY_TR, "Grnt bindirme" },

/* en */ { IDMS_START_SOUND_RECORD,    "Start Sound Record..." },
/* da */ { IDMS_START_SOUND_RECORD_DA, "Start lydoptagelse..." },
/* de */ { IDMS_START_SOUND_RECORD_DE, "Tonaufnahme starten..." },
/* fr */ { IDMS_START_SOUND_RECORD_FR, "" },  /* fuzzy */
/* hu */ { IDMS_START_SOUND_RECORD_HU, "Hangfelvtel indtsa..." },
/* it */ { IDMS_START_SOUND_RECORD_IT, "Avvia la registrazione audio..." },
/* nl */ { IDMS_START_SOUND_RECORD_NL, "Start Geluidsopname..." },
/* pl */ { IDMS_START_SOUND_RECORD_PL, "" },  /* fuzzy */
/* sv */ { IDMS_START_SOUND_RECORD_SV, "Starta ljudinspelning..." },
/* tr */ { IDMS_START_SOUND_RECORD_TR, "Ses Kaydn Balat..." },

/* en */ { IDMS_STOP_SOUND_RECORD,    "Stop Sound record" },
/* da */ { IDMS_STOP_SOUND_RECORD_DA, "Stop lydoptagelse" },
/* de */ { IDMS_STOP_SOUND_RECORD_DE, "Tonaufnahme stoppen" },
/* fr */ { IDMS_STOP_SOUND_RECORD_FR, "" },  /* fuzzy */
/* hu */ { IDMS_STOP_SOUND_RECORD_HU, "Hangfelvtel lelltsa" },
/* it */ { IDMS_STOP_SOUND_RECORD_IT, "Interrompi registrazione audio" },
/* nl */ { IDMS_STOP_SOUND_RECORD_NL, "Stop geluidsopname" },
/* pl */ { IDMS_STOP_SOUND_RECORD_PL, "" },  /* fuzzy */
/* sv */ { IDMS_STOP_SOUND_RECORD_SV, "Stoppa ljudinspelning" },
/* tr */ { IDMS_STOP_SOUND_RECORD_TR, "Ses kaydn durdur" },

/* en */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD,    "Value %d out of range, range is from %d to %d, using %d instead" },
/* da */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_DA, "Vrdi %d ugyldig. Tilladt vrdi fra %d til %d. Bruger %d istedet" },
/* de */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_DE, "Wert %d ist unzulssig, Bereich mu zwischen %d und %d liegen, benutze %d" },
/* fr */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_FR, "" },  /* fuzzy */
/* hu */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_HU, "" },  /* fuzzy */
/* it */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_IT, "Valore %d fuori dai limiti, l' intervallo  da %d a %d, uso %d al suo posto" },
/* nl */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_NL, "Waarde %d is buiten het bereik, het bereik is van %d tot %d, %d zal gebruikt worden" },
/* pl */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_PL, "" },  /* fuzzy */
/* sv */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_SV, "Vrdet %d r utanfr grnserna, giltiga vrden mellan %d och %d, anvnder %d istllet" },
/* tr */ { IDMES_VALUE_D_OUT_OF_RANGE_USING_D_INSTEAD_TR, "%d deeri alan dna kt, alan %d - %d aralnda, yerine %d kullanlyor" },

/* en */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD,    "Value %.3f out of range, range is from %.3f to %.3f, using %.3f instead" },
/* da */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_DA, "Vrdi %.3f ugyldig. Tilladt vrdi fra %.3f til %.3f. Bruger %.3f istedet" },
/* de */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_DE, "Wert %.3f ist unzulssig, Bereich mu zwischen %.3f und %.3f liegen, benutze %.3f" },
/* fr */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_FR, "" },  /* fuzzy */
/* hu */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_HU, "" },  /* fuzzy */
/* it */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_IT, "Valore %.3f fuori dai limiti, l' intervallo  da %.3f a %.3f, uso %.3f al suo posto" },
/* nl */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_NL, "Waarde %.3f is buiten het bereik, het bereik is van %.3f tot %.3f, %.3f zal gebruikt worden" },
/* pl */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_PL, "" },  /* fuzzy */
/* sv */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_SV, "Vrdet %.3f r utanfr grnserna, giltiga vrden mellan %.3f och %.3f, anvnder %.3f istllet" },
/* tr */ { IDMES_VALUE_F_OUT_OF_RANGE_USING_F_INSTEAD_TR, "%.3f deeri alan dna kt, alan %.3f - %.3f aralnda, yerine %.3f kullanlyor" },

/* en */ { IDMES_SETTINGS_SAVED_SUCCESS,    "Settings saved successfully." },
/* da */ { IDMES_SETTINGS_SAVED_SUCCESS_DA, "Indstillingerne er gemt." },
/* de */ { IDMES_SETTINGS_SAVED_SUCCESS_DE, "Einstellungen erfolgreich gespeichert" },
/* fr */ { IDMES_SETTINGS_SAVED_SUCCESS_FR, "Sauvegarde des paramtres effectue correctement." },
/* hu */ { IDMES_SETTINGS_SAVED_SUCCESS_HU, "Belltsok sikeresen elmentve." },
/* it */ { IDMES_SETTINGS_SAVED_SUCCESS_IT, "Impostazioni salvate con successo." },
/* nl */ { IDMES_SETTINGS_SAVED_SUCCESS_NL, "Instellingen met succes opgeslagen." },
/* pl */ { IDMES_SETTINGS_SAVED_SUCCESS_PL, "Zapisywanie ustawie powiodo si." },
/* sv */ { IDMES_SETTINGS_SAVED_SUCCESS_SV, "Instllningarna har sparats." },
/* tr */ { IDMES_SETTINGS_SAVED_SUCCESS_TR, "Ayarlar baaryla kaydedildi." },

/* en */ { IDMES_SETTINGS_LOAD_SUCCESS,    "Settings loaded successfully." },
/* da */ { IDMES_SETTINGS_LOAD_SUCCESS_DA, "Indstillinger indlst med success." },
/* de */ { IDMES_SETTINGS_LOAD_SUCCESS_DE, "Einstellungen erfolgreich geladen." },
/* fr */ { IDMES_SETTINGS_LOAD_SUCCESS_FR, "Chargement des paramtres russi." },
/* hu */ { IDMES_SETTINGS_LOAD_SUCCESS_HU, "Belltsok sikeresen elmentve." },
/* it */ { IDMES_SETTINGS_LOAD_SUCCESS_IT, "Impostazioni caricate con successo." },
/* nl */ { IDMES_SETTINGS_LOAD_SUCCESS_NL, "Instellingen met succes geladen." },
/* pl */ { IDMES_SETTINGS_LOAD_SUCCESS_PL, "" },  /* fuzzy */
/* sv */ { IDMES_SETTINGS_LOAD_SUCCESS_SV, "Instllningarna har lsts in." },
/* tr */ { IDMES_SETTINGS_LOAD_SUCCESS_TR, "Ayarlar baaryla yklendi." },

/* en */ { IDMES_DFLT_SETTINGS_RESTORED,    "Default settings restored." },
/* da */ { IDMES_DFLT_SETTINGS_RESTORED_DA, "Standardindstillinger gendannet." },
/* de */ { IDMES_DFLT_SETTINGS_RESTORED_DE, "Standard wiederhergestellt" },
/* fr */ { IDMES_DFLT_SETTINGS_RESTORED_FR, "Paramtres par dfaut restaurs." },
/* hu */ { IDMES_DFLT_SETTINGS_RESTORED_HU, "Alaprtelmezett belltsok visszalltva." },
/* it */ { IDMES_DFLT_SETTINGS_RESTORED_IT, "Impostazioni originarie ripristinate." },
/* nl */ { IDMES_DFLT_SETTINGS_RESTORED_NL, "Standaard instellingen hersteld." },
/* pl */ { IDMES_DFLT_SETTINGS_RESTORED_PL, "" },  /* fuzzy */
/* sv */ { IDMES_DFLT_SETTINGS_RESTORED_SV, "Frvalda instllningar terstllda." },
/* tr */ { IDMES_DFLT_SETTINGS_RESTORED_TR, "Varsaylan ayarlara geri dnld." },

/* en */ { IDMES_VICE_MESSAGE,    "VICE Message" },
/* da */ { IDMES_VICE_MESSAGE_DA, "VICE-besked" },
/* de */ { IDMES_VICE_MESSAGE_DE, "VICE Nachricht" },
/* fr */ { IDMES_VICE_MESSAGE_FR, "Message VICE" },
/* hu */ { IDMES_VICE_MESSAGE_HU, "VICE zenet" },
/* it */ { IDMES_VICE_MESSAGE_IT, "Messaggio di VICE" },
/* nl */ { IDMES_VICE_MESSAGE_NL, "VICE bericht" },
/* pl */ { IDMES_VICE_MESSAGE_PL, "Wiadomo VICE" },
/* sv */ { IDMES_VICE_MESSAGE_SV, "VICE-meddelande" },
/* tr */ { IDMES_VICE_MESSAGE_TR, "VICE Mesaj" },

/* en */ { IDMES_OK,    "OK" },
/* da */ { IDMES_OK_DA, "OK" },
/* de */ { IDMES_OK_DE, "OK" },
/* fr */ { IDMES_OK_FR, "OK" },
/* hu */ { IDMES_OK_HU, "OK" },
/* it */ { IDMES_OK_IT, "OK" },
/* nl */ { IDMES_OK_NL, "OK" },
/* pl */ { IDMES_OK_PL, "" },  /* fuzzy */
/* sv */ { IDMES_OK_SV, "OK" },
/* tr */ { IDMES_OK_TR, "Tamam" },

/* en */ { IDMES_VICE_CONTRIBUTORS,    "VICE contributors" },
/* da */ { IDMES_VICE_CONTRIBUTORS_DA, "VICE bidragsydere" },
/* de */ { IDMES_VICE_CONTRIBUTORS_DE, "VICE Hackers" },
/* fr */ { IDMES_VICE_CONTRIBUTORS_FR, "Contributeurs  VICE" },
/* hu */ { IDMES_VICE_CONTRIBUTORS_HU, "VICE - kzremkdk" },
/* it */ { IDMES_VICE_CONTRIBUTORS_IT, "Collaboratori" },
/* nl */ { IDMES_VICE_CONTRIBUTORS_NL, "VICE medewerkers" },
/* pl */ { IDMES_VICE_CONTRIBUTORS_PL, "" },  /* fuzzy */
/* sv */ { IDMES_VICE_CONTRIBUTORS_SV, "Bidragslmnare till VICE" },
/* tr */ { IDMES_VICE_CONTRIBUTORS_TR, "VICE katlmclar" },

/* en */ { IDMES_WHO_MADE_WHAT,    "Who made what?" },
/* da */ { IDMES_WHO_MADE_WHAT_DA, "Hvem har lavet hvad?" },
/* de */ { IDMES_WHO_MADE_WHAT_DE, "Wer hat was gemacht?" },
/* fr */ { IDMES_WHO_MADE_WHAT_FR, "Qui fait quoi?" },
/* hu */ { IDMES_WHO_MADE_WHAT_HU, "Ki mit csinlt?" },
/* it */ { IDMES_WHO_MADE_WHAT_IT, "Chi ha fatto cosa?" },
/* nl */ { IDMES_WHO_MADE_WHAT_NL, "Wie heeft wat gemaakt?" },
/* pl */ { IDMES_WHO_MADE_WHAT_PL, "" },  /* fuzzy */
/* sv */ { IDMES_WHO_MADE_WHAT_SV, "Vem gjorde vad?" },
/* tr */ { IDMES_WHO_MADE_WHAT_TR, "Kim ne yapt?" },

/* en */ { IDMES_VICE_DIST_NO_WARRANTY,    "VICE is distributed WITHOUT ANY WARRANTY!" },
/* da */ { IDMES_VICE_DIST_NO_WARRANTY_DA, "VICE distribueres UDEN NOGEN SOM HELST GARANTI!" },
/* de */ { IDMES_VICE_DIST_NO_WARRANTY_DE, "VICE ist ohne Garantie" },
/* fr */ { IDMES_VICE_DIST_NO_WARRANTY_FR, "VICE est distribu SANS AUCUN GARANTIE!" },
/* hu */ { IDMES_VICE_DIST_NO_WARRANTY_HU, "A VICE-t garancia nlkl terjesztjk!" },
/* it */ { IDMES_VICE_DIST_NO_WARRANTY_IT, "VICE  distribuito SENZA NESSUNA GARANZIA!" },
/* nl */ { IDMES_VICE_DIST_NO_WARRANTY_NL, "VICE heeft ABSOLUUT GEEN GARANTIE!" },
/* pl */ { IDMES_VICE_DIST_NO_WARRANTY_PL, "" },  /* fuzzy */
/* sv */ { IDMES_VICE_DIST_NO_WARRANTY_SV, "VICE distribueras UTAN NGON SOM HELST GARANTI!" },
/* tr */ { IDMES_VICE_DIST_NO_WARRANTY_TR, "VICE HBR GARANT VERLMEDEN datlmtr!" },

/* en */ { IDMES_WHICH_COMMANDS_AVAILABLE,    "Which command line options are available?" },
/* da */ { IDMES_WHICH_COMMANDS_AVAILABLE_DA, "Hvilke kommandolinjeparametre er tilgngelige?" },
/* de */ { IDMES_WHICH_COMMANDS_AVAILABLE_DE, "Welche Kommandozeilen Parameter sind verfgbar?" },
/* fr */ { IDMES_WHICH_COMMANDS_AVAILABLE_FR, "Quelles sont les lignes de commandes disponibles?" },
/* hu */ { IDMES_WHICH_COMMANDS_AVAILABLE_HU, "Milyen parancssori opcik lehetsgesek?" },
/* it */ { IDMES_WHICH_COMMANDS_AVAILABLE_IT, "Quali parametri della riga di comando sono disponibili?" },
/* nl */ { IDMES_WHICH_COMMANDS_AVAILABLE_NL, "Welke commando opties zijn beschikbaar?" },
/* pl */ { IDMES_WHICH_COMMANDS_AVAILABLE_PL, "" },  /* fuzzy */
/* sv */ { IDMES_WHICH_COMMANDS_AVAILABLE_SV, "Vilka kommandoradsflaggor r tillgngliga?" },
/* tr */ { IDMES_WHICH_COMMANDS_AVAILABLE_TR, "Hangi komut satr seenekleri mevcut?" },

/* en */ { IDMES_CANNOT_SAVE_SETTINGS,    "Cannot save settings." },
/* da */ { IDMES_CANNOT_SAVE_SETTINGS_DA, "Kunne ikke gemme indstillinger." },
/* de */ { IDMES_CANNOT_SAVE_SETTINGS_DE, "Fehler beim Speichern der Einstellungen." },
/* fr */ { IDMES_CANNOT_SAVE_SETTINGS_FR, "Impossible d'enregistrer les paramtres." },
/* hu */ { IDMES_CANNOT_SAVE_SETTINGS_HU, "A belltsok mentse nem sikerlt." },
/* it */ { IDMES_CANNOT_SAVE_SETTINGS_IT, "Non  possibile salvare le impostazioni." },
/* nl */ { IDMES_CANNOT_SAVE_SETTINGS_NL, "Kan de instellingen niet opslaan." },
/* pl */ { IDMES_CANNOT_SAVE_SETTINGS_PL, "Nie mona zapisa ustawie." },
/* sv */ { IDMES_CANNOT_SAVE_SETTINGS_SV, "Kan inte spara instllningar." },
/* tr */ { IDMES_CANNOT_SAVE_SETTINGS_TR, "Ayarlar kaydedilemedi." },

/* en */ { IDMES_CANNOT_LOAD_SETTINGS,    "Cannot load settings." },
/* da */ { IDMES_CANNOT_LOAD_SETTINGS_DA, "Kunne ikke indlse indstillinger." },
/* de */ { IDMES_CANNOT_LOAD_SETTINGS_DE, "Fehler beim Laden der Einstellungen." },
/* fr */ { IDMES_CANNOT_LOAD_SETTINGS_FR, "Impossible de charger les paramtres." },
/* hu */ { IDMES_CANNOT_LOAD_SETTINGS_HU, "A belltsok betltse nem sikerlt." },
/* it */ { IDMES_CANNOT_LOAD_SETTINGS_IT, "Non  possibile caricare le impostazioni." },
/* nl */ { IDMES_CANNOT_LOAD_SETTINGS_NL, "Kan de instellingen niet laden." },
/* pl */ { IDMES_CANNOT_LOAD_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDMES_CANNOT_LOAD_SETTINGS_SV, "Kan inte lsa instllningar." },
/* tr */ { IDMES_CANNOT_LOAD_SETTINGS_TR, "Ayarlar yklenemedi." },

/* en */ { IDMES_VICE_ERROR,    "VICE Error" },
/* da */ { IDMES_VICE_ERROR_DA, "VICE-fejl" },
/* de */ { IDMES_VICE_ERROR_DE, "VICE Fehler" },
/* fr */ { IDMES_VICE_ERROR_FR, "Erreur VICE" },
/* hu */ { IDMES_VICE_ERROR_HU, "VICE hiba" },
/* it */ { IDMES_VICE_ERROR_IT, "Errore di VICE" },
/* nl */ { IDMES_VICE_ERROR_NL, "Vice fout" },
/* pl */ { IDMES_VICE_ERROR_PL, "Bd VICE" },
/* sv */ { IDMES_VICE_ERROR_SV, "VICE-fel" },
/* tr */ { IDMES_VICE_ERROR_TR, "VICE Hatas" },

/* en */ { IDMES_DEVICE_NOT_GAMEPAD,    "The device on this port is not a gamepad" },
/* da */ { IDMES_DEVICE_NOT_GAMEPAD_DA, "Enheden p denne port er ikke en joypad" },
/* de */ { IDMES_DEVICE_NOT_GAMEPAD_DE, "Das Gert in diesem Port ist kein Gamepad" },
/* fr */ { IDMES_DEVICE_NOT_GAMEPAD_FR, "Le priphrique sur ce port nest pas une manette" },
/* hu */ { IDMES_DEVICE_NOT_GAMEPAD_HU, "Az eszkz ezen a porton nem gamepad" },
/* it */ { IDMES_DEVICE_NOT_GAMEPAD_IT, "Il dispositivo su questa porta non  un gamepad" },
/* nl */ { IDMES_DEVICE_NOT_GAMEPAD_NL, "Het apparaat op deze poort is geen gamepad" },
/* pl */ { IDMES_DEVICE_NOT_GAMEPAD_PL, "" },  /* fuzzy */
/* sv */ { IDMES_DEVICE_NOT_GAMEPAD_SV, "Enheten p denna port r inte en styrplatta" },
/* tr */ { IDMES_DEVICE_NOT_GAMEPAD_TR, "Bu port zerindeki aygt gamepad deil" },

/* en */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT,    "The port is not mapped to an Amiga port" },
/* da */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_DA, "Denne port er ikke koblet til en Amigaport" },
/* de */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_DE, "Dieses Port ist keinem Amiga Port zugeordnet" },
/* fr */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_FR, "Le port nest pas mapp sur un port Amiga" },
/* hu */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_HU, "A port nincs lekpezve egy Amiga portra" },
/* it */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_IT, "Questa porta non  mappata su una porta dell'Amiga" },
/* nl */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_NL, "De poort is niet verbonden met een Amigapoort" },
/* pl */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_PL, "" },  /* fuzzy */
/* sv */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_SV, "Porten r inte kopplad till en Amigaport" },
/* tr */ { IDMES_NOT_MAPPED_TO_AMIGA_PORT_TR, "Port bir Amiga portuyla eletirilemedi" },

/* en */ { IDMES_CANNOT_AUTOSTART_FILE,    "Cannot autostart specified file." },
/* da */ { IDMES_CANNOT_AUTOSTART_FILE_DA, "Kan ikke autostarte valgt fil" },
/* de */ { IDMES_CANNOT_AUTOSTART_FILE_DE, "Autostart von angeforderter Datei fehlgeschlagen." },
/* fr */ { IDMES_CANNOT_AUTOSTART_FILE_FR, "Impossible de dmarrer automatiquement le fichier spcifi" },
/* hu */ { IDMES_CANNOT_AUTOSTART_FILE_HU, "Nem lehet automatikusan elindtani a megadott fjlt." },
/* it */ { IDMES_CANNOT_AUTOSTART_FILE_IT, "Non  possibile avviare automaticamente il file specificato." },
/* nl */ { IDMES_CANNOT_AUTOSTART_FILE_NL, "Kan opgegeven bestand niet autostarten." },
/* pl */ { IDMES_CANNOT_AUTOSTART_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDMES_CANNOT_AUTOSTART_FILE_SV, "Kan inte autostarta angiven fil." },
/* tr */ { IDMES_CANNOT_AUTOSTART_FILE_TR, "Belirtilen dosya otomatik balatlamad." },

/* en */ { IDMES_CANNOT_ATTACH_FILE,    "Cannot attach specified file" },
/* da */ { IDMES_CANNOT_ATTACH_FILE_DA, "Kan ikke tilslutte den valgte fil" },
/* de */ { IDMES_CANNOT_ATTACH_FILE_DE, "Kann Image Datei nicht einlegen" },
/* fr */ { IDMES_CANNOT_ATTACH_FILE_FR, "Impossible d'attacher le fichier spcifi" },
/* hu */ { IDMES_CANNOT_ATTACH_FILE_HU, "Nem lehet csatolni a megadott fjlt" },
/* it */ { IDMES_CANNOT_ATTACH_FILE_IT, "Non  possibile selezionare il file specificato" },
/* nl */ { IDMES_CANNOT_ATTACH_FILE_NL, "Kan het opgegeven bestand niet koppelen" },
/* pl */ { IDMES_CANNOT_ATTACH_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDMES_CANNOT_ATTACH_FILE_SV, "Kan inte ansluta filen" },
/* tr */ { IDMES_CANNOT_ATTACH_FILE_TR, "Belirtilen dosya yerletirilemedi" },

/* en */ { IDMES_INVALID_CART,    "Invalid cartridge" },
/* da */ { IDMES_INVALID_CART_DA, "Ugyldigt cartridge" },
/* de */ { IDMES_INVALID_CART_DE, "Ungltiges Erweiterungsmodul" },
/* fr */ { IDMES_INVALID_CART_FR, "Cartouche invalide" },
/* hu */ { IDMES_INVALID_CART_HU, "rvnytelen cartridge" },
/* it */ { IDMES_INVALID_CART_IT, "Cartuccia non valida" },
/* nl */ { IDMES_INVALID_CART_NL, "Ongeldige cartridge" },
/* pl */ { IDMES_INVALID_CART_PL, "Nieprawidowy kartrid" },
/* sv */ { IDMES_INVALID_CART_SV, "Ogiltig insticksmodul" },
/* tr */ { IDMES_INVALID_CART_TR, "Geersiz kartu" },

/* en */ { IDMES_BAD_CART_CONFIG_IN_UI,    "Bad cartridge config in UI!" },
/* da */ { IDMES_BAD_CART_CONFIG_IN_UI_DA, "Ugyldig cartridgekonfiguration i brugergrnseflade!" },
/* de */ { IDMES_BAD_CART_CONFIG_IN_UI_DE, "Fehlerhafte Modul Konfiguration im UI!" },
/* fr */ { IDMES_BAD_CART_CONFIG_IN_UI_FR, "Mauvaise configuration de la cartouche dans l'interface utilisateur!" },
/* hu */ { IDMES_BAD_CART_CONFIG_IN_UI_HU, "Rossz cartridge konfigurci!" },
/* it */ { IDMES_BAD_CART_CONFIG_IN_UI_IT, "Configurazione della cartuccia errata nell'IU!" },
/* nl */ { IDMES_BAD_CART_CONFIG_IN_UI_NL, "Slechte cartridge configuratie in UI!" },
/* pl */ { IDMES_BAD_CART_CONFIG_IN_UI_PL, "" },  /* fuzzy */
/* sv */ { IDMES_BAD_CART_CONFIG_IN_UI_SV, "Felaktiga insticksmodulsinstllningar i UI!" },
/* tr */ { IDMES_BAD_CART_CONFIG_IN_UI_TR, "UI'de kt kartu konfigrasyonu!" },

/* en */ { IDMES_INVALID_CART_IMAGE,    "Invalid cartridge image" },
/* da */ { IDMES_INVALID_CART_IMAGE_DA, "Ugyldigt cartridge-image" },
/* de */ { IDMES_INVALID_CART_IMAGE_DE, "Ungltiges Erweiterungsmodul Image" },
/* fr */ { IDMES_INVALID_CART_IMAGE_FR, "Image de cartouche invalide" },
/* hu */ { IDMES_INVALID_CART_IMAGE_HU, "rvnytelen cartridge kpms" },
/* it */ { IDMES_INVALID_CART_IMAGE_IT, "Immagine cartuccia non valida" },
/* nl */ { IDMES_INVALID_CART_IMAGE_NL, "Ongeldig cartridge bestand" },
/* pl */ { IDMES_INVALID_CART_IMAGE_PL, "Nieprawidowy obraz kartrida" },
/* sv */ { IDMES_INVALID_CART_IMAGE_SV, "Ogiltig insticksmodulfil" },
/* tr */ { IDMES_INVALID_CART_IMAGE_TR, "Geersiz kartu imaj" },

/* en */ { IDMES_CANNOT_CREATE_IMAGE,    "Cannot create image" },
/* da */ { IDMES_CANNOT_CREATE_IMAGE_DA, "Kunne ikke oprette image" },
/* de */ { IDMES_CANNOT_CREATE_IMAGE_DE, "Kann Image Datei nicht erzeugen" },
/* fr */ { IDMES_CANNOT_CREATE_IMAGE_FR, "Impossible de crer l'image" },
/* hu */ { IDMES_CANNOT_CREATE_IMAGE_HU, "Nem sikerlt a kpmst ltrehozni" },
/* it */ { IDMES_CANNOT_CREATE_IMAGE_IT, "Non  possibile creare l'immagine" },
/* nl */ { IDMES_CANNOT_CREATE_IMAGE_NL, "Kan bestand niet maken" },
/* pl */ { IDMES_CANNOT_CREATE_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDMES_CANNOT_CREATE_IMAGE_SV, "Kan inte skapa avbildningsfil" },
/* tr */ { IDMES_CANNOT_CREATE_IMAGE_TR, "Imaj yaratlamad" },

/* en */ { IDMES_ERROR_STARTING_SERVER,    "An error occured starting the server." },
/* da */ { IDMES_ERROR_STARTING_SERVER_DA, "Fejl under start af serveren." },
/* de */ { IDMES_ERROR_STARTING_SERVER_DE, "Fehler beim Starten des Netplay Servers." },
/* fr */ { IDMES_ERROR_STARTING_SERVER_FR, "Il y a eu une erreur au dmarrage du serveur." },
/* hu */ { IDMES_ERROR_STARTING_SERVER_HU, "Hiba trtnt a jtk kiszolgl indtsakor." },
/* it */ { IDMES_ERROR_STARTING_SERVER_IT, "Si  verificato un errore all'avvio del server." },
/* nl */ { IDMES_ERROR_STARTING_SERVER_NL, "Een fout is opgetreden bij het starten van de server." },
/* pl */ { IDMES_ERROR_STARTING_SERVER_PL, "" },  /* fuzzy */
/* sv */ { IDMES_ERROR_STARTING_SERVER_SV, "Fel vid start av servern." },
/* tr */ { IDMES_ERROR_STARTING_SERVER_TR, "Sunucu balatlrken bir hata olutu." },

/* en */ { IDMES_ERROR_CONNECTING_CLIENT,    "An error occured connecting the client." },
/* da */ { IDMES_ERROR_CONNECTING_CLIENT_DA, "Fejl under tilslutning af klienten." },
/* de */ { IDMES_ERROR_CONNECTING_CLIENT_DE, "Fehler beim Verbindungsaufbau zum Client" },
/* fr */ { IDMES_ERROR_CONNECTING_CLIENT_FR, "" },  /* fuzzy */
/* hu */ { IDMES_ERROR_CONNECTING_CLIENT_HU, "Hiba trtnt a kapcsoldskor." },
/* it */ { IDMES_ERROR_CONNECTING_CLIENT_IT, "Si  verificato un errore durante il collegamento col client." },
/* nl */ { IDMES_ERROR_CONNECTING_CLIENT_NL, "Een fout is opgetreden bij het verbinden." },
/* pl */ { IDMES_ERROR_CONNECTING_CLIENT_PL, "" },  /* fuzzy */
/* sv */ { IDMES_ERROR_CONNECTING_CLIENT_SV, "Fel vid anslutning til klienten." },
/* tr */ { IDMES_ERROR_CONNECTING_CLIENT_TR, "stemciye balanrken bir hata olutu." },

/* en */ { IDMES_INVALID_PORT_NUMBER,    "Invalid port number" },
/* da */ { IDMES_INVALID_PORT_NUMBER_DA, "Ugyldigt portnummer" },
/* de */ { IDMES_INVALID_PORT_NUMBER_DE, "Ungltige Port Nummer" },
/* fr */ { IDMES_INVALID_PORT_NUMBER_FR, "" },  /* fuzzy */
/* hu */ { IDMES_INVALID_PORT_NUMBER_HU, "rvnytelen port szm" },
/* it */ { IDMES_INVALID_PORT_NUMBER_IT, "Numero di porta non valido" },
/* nl */ { IDMES_INVALID_PORT_NUMBER_NL, "Ongeldig poort nummer" },
/* pl */ { IDMES_INVALID_PORT_NUMBER_PL, "" },  /* fuzzy */
/* sv */ { IDMES_INVALID_PORT_NUMBER_SV, "Ogiltigt portnummer" },
/* tr */ { IDMES_INVALID_PORT_NUMBER_TR, "Geersiz port numaras" },

/* en */ { IDMES_THIS_MACHINE_NO_SID,    "This machine may not have a SID" },
/* da */ { IDMES_THIS_MACHINE_NO_SID_DA, "Denne maskine kan ikke have en SID" },
/* de */ { IDMES_THIS_MACHINE_NO_SID_DE, "Diese Maschine hat mglicherweise keinen SID" },
/* fr */ { IDMES_THIS_MACHINE_NO_SID_FR, "Cette machine n'a peut-tre pas de SID" },
/* hu */ { IDMES_THIS_MACHINE_NO_SID_HU, "Ennek a gpnek nem lehet SIDje" },
/* it */ { IDMES_THIS_MACHINE_NO_SID_IT, "Questa macchina potrebbe non avere un SID" },
/* nl */ { IDMES_THIS_MACHINE_NO_SID_NL, "Deze machine heeft mogelijk geen SID" },
/* pl */ { IDMES_THIS_MACHINE_NO_SID_PL, "" },  /* fuzzy */
/* sv */ { IDMES_THIS_MACHINE_NO_SID_SV, "Denna maskin kan inte ha en SID" },
/* tr */ { IDMES_THIS_MACHINE_NO_SID_TR, "Bu makinede SID olmayabilir" },

/* en */ { IDMES_SCREENSHOT_SAVE_S_FAILED,    "Screenshot save of %s failed" },
/* da */ { IDMES_SCREENSHOT_SAVE_S_FAILED_DA, "Kunne ikke gemme screenshot %s" },
/* de */ { IDMES_SCREENSHOT_SAVE_S_FAILED_DE, "Screenshot speicherung von %s ist fehlgeschlagen" },
/* fr */ { IDMES_SCREENSHOT_SAVE_S_FAILED_FR, "" },  /* fuzzy */
/* hu */ { IDMES_SCREENSHOT_SAVE_S_FAILED_HU, "Fnykp fjl mentse %s fjlba nem sikerlt" },
/* it */ { IDMES_SCREENSHOT_SAVE_S_FAILED_IT, "Il salvataggio della schermata %s  fallito" },
/* nl */ { IDMES_SCREENSHOT_SAVE_S_FAILED_NL, "Opslaan schermafdrukbestand %s is mislukt" },
/* pl */ { IDMES_SCREENSHOT_SAVE_S_FAILED_PL, "" },  /* fuzzy */
/* sv */ { IDMES_SCREENSHOT_SAVE_S_FAILED_SV, "Kunde inte spara skrmdump %s" },
/* tr */ { IDMES_SCREENSHOT_SAVE_S_FAILED_TR, "%s ekran grnts kaydedilemedi" },

/* en */ { IDMES_SCREENSHOT_S_SAVED,    "Screenshot %s saved." },
/* da */ { IDMES_SCREENSHOT_S_SAVED_DA, "Screenshot %s gemt." },
/* de */ { IDMES_SCREENSHOT_S_SAVED_DE, "Screenshots %s gespeicher." },
/* fr */ { IDMES_SCREENSHOT_S_SAVED_FR, "" },  /* fuzzy */
/* hu */ { IDMES_SCREENSHOT_S_SAVED_HU, "Fnykp %s fjlba elmentve." },
/* it */ { IDMES_SCREENSHOT_S_SAVED_IT, "Schermata %s salvata." },
/* nl */ { IDMES_SCREENSHOT_S_SAVED_NL, "Scherm afdruk %s opgeslagen." },
/* pl */ { IDMES_SCREENSHOT_S_SAVED_PL, "" },  /* fuzzy */
/* sv */ { IDMES_SCREENSHOT_S_SAVED_SV, "Skrmdump %s sparad." },
/* tr */ { IDMES_SCREENSHOT_S_SAVED_TR, "%s ekran grnts kaydedildi." },

/* en */ { IDS_PRESS_KEY_BUTTON,    "Press desired key/button, move stick or press ESC for no key." },
/* da */ { IDS_PRESS_KEY_BUTTON_DA, "Tryk nsket tast, bevg joystick eller tryk ESC for ingen binding." },
/* de */ { IDS_PRESS_KEY_BUTTON_DE, "Gewnschte Taste/Knopf drcken, Knppel bewegen oder ESC fr keine Taste drcken." },
/* fr */ { IDS_PRESS_KEY_BUTTON_FR, "Appuyez sur la touche/bouton desire(e), dplacez le stick ou appuyez sur ESC pour effacer cette touche." },
/* hu */ { IDS_PRESS_KEY_BUTTON_HU, "Nyomja meg a vlasztott gombot, mozdtsa a botkormnyt, vagy nyomjon ESC-et reshez" },
/* it */ { IDS_PRESS_KEY_BUTTON_IT, "Premi il tasto/bottone desiderato, muovi la leva o premi ESC per non selezionare alcun tasto." },
/* nl */ { IDS_PRESS_KEY_BUTTON_NL, "Druk de toets/knop, beweeg de joystick of druk op ESC voor geen toets." },
/* pl */ { IDS_PRESS_KEY_BUTTON_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRESS_KEY_BUTTON_SV, "Tryck nskad tangent/knapp, flytta styrspaken eller tryck ESC fr att inte koppla ngon tangent." },
/* tr */ { IDS_PRESS_KEY_BUTTON_TR, "stenilen tu/dmeye basn, ubuu hareket ettirin veya tu sememek iin ESC'e basn." },

/* en */ { IDS_SAVE,    "Save" },
/* da */ { IDS_SAVE_DA, "Gem" },
/* de */ { IDS_SAVE_DE, "Speichern" },
/* fr */ { IDS_SAVE_FR, "Enregistrer" },
/* hu */ { IDS_SAVE_HU, "Ments" },
/* it */ { IDS_SAVE_IT, "Salva" },
/* nl */ { IDS_SAVE_NL, "Opslaan" },
/* pl */ { IDS_SAVE_PL, "Zapisz" },
/* sv */ { IDS_SAVE_SV, "Spara" },
/* tr */ { IDS_SAVE_TR, "Kaydet" },

/* en */ { IDS_BROWSE,    "Browse" },
/* da */ { IDS_BROWSE_DA, "Gennemse" },
/* de */ { IDS_BROWSE_DE, "Stbern" },
/* fr */ { IDS_BROWSE_FR, "Parcourir" },
/* hu */ { IDS_BROWSE_HU, "Tallz" },
/* it */ { IDS_BROWSE_IT, "Sfoglia" },
/* nl */ { IDS_BROWSE_NL, "Bladeren" },
/* pl */ { IDS_BROWSE_PL, "" },  /* fuzzy */
/* sv */ { IDS_BROWSE_SV, "Blddra" },
/* tr */ { IDS_BROWSE_TR, "Gz at" },

/* en */ { IDS_CURRENT_MODE,    "Current mode" },
/* da */ { IDS_CURRENT_MODE_DA, "Nuvrende tilstand" },
/* de */ { IDS_CURRENT_MODE_DE, "Aktueller Modus" },
/* fr */ { IDS_CURRENT_MODE_FR, "" },  /* fuzzy */
/* hu */ { IDS_CURRENT_MODE_HU, "Jelenlegi md" },
/* it */ { IDS_CURRENT_MODE_IT, "Modalit attuale" },
/* nl */ { IDS_CURRENT_MODE_NL, "Huidige modus" },
/* pl */ { IDS_CURRENT_MODE_PL, "" },  /* fuzzy */
/* sv */ { IDS_CURRENT_MODE_SV, "Nuvarande lge" },
/* tr */ { IDS_CURRENT_MODE_TR, "Geerli mod" },

/* en */ { IDS_TCP_PORT,    "TCP port" },
/* da */ { IDS_TCP_PORT_DA, "TCP-port" },
/* de */ { IDS_TCP_PORT_DE, "TCP Port: " },
/* fr */ { IDS_TCP_PORT_FR, "Port TCP" },
/* hu */ { IDS_TCP_PORT_HU, "TCP port" },
/* it */ { IDS_TCP_PORT_IT, "Porta TCP" },
/* nl */ { IDS_TCP_PORT_NL, "TCP poort" },
/* pl */ { IDS_TCP_PORT_PL, "" },  /* fuzzy */
/* sv */ { IDS_TCP_PORT_SV, "TCP-port" },
/* tr */ { IDS_TCP_PORT_TR, "TCP portu" },

/* en */ { IDS_START_SERVER,    "Start Server" },
/* da */ { IDS_START_SERVER_DA, "Start server" },
/* de */ { IDS_START_SERVER_DE, "Server Starten" },
/* fr */ { IDS_START_SERVER_FR, "Dmarrer le serveur" },
/* hu */ { IDS_START_SERVER_HU, "Kiszolgl indtsa" },
/* it */ { IDS_START_SERVER_IT, "Avvia server" },
/* nl */ { IDS_START_SERVER_NL, "Start server" },
/* pl */ { IDS_START_SERVER_PL, "" },  /* fuzzy */
/* sv */ { IDS_START_SERVER_SV, "Starta server" },
/* tr */ { IDS_START_SERVER_TR, "Sunucuyu Balat" },

/* en */ { IDS_SERVER_BIND,    "Server Bind" },
/* da */ { IDS_SERVER_BIND_DA, "Server" },
/* de */ { IDS_SERVER_BIND_DE, "Server Bind" },
/* fr */ { IDS_SERVER_BIND_FR, "" },  /* fuzzy */
/* hu */ { IDS_SERVER_BIND_HU, "Szerver cm+port" },
/* it */ { IDS_SERVER_BIND_IT, "Server Bind" },
/* nl */ { IDS_SERVER_BIND_NL, "Server binding" },
/* pl */ { IDS_SERVER_BIND_PL, "" },  /* fuzzy */
/* sv */ { IDS_SERVER_BIND_SV, "Serverbindning" },
/* tr */ { IDS_SERVER_BIND_TR, "Sunucu Balants" },

/* en */ { IDS_CONNECT_TO,    "Connect to" },
/* da */ { IDS_CONNECT_TO_DA, "Tilslut til" },
/* de */ { IDS_CONNECT_TO_DE, "Verbinden mit" },
/* fr */ { IDS_CONNECT_TO_FR, "Se connecter " },
/* hu */ { IDS_CONNECT_TO_HU, "Kapcsolds ehhez:" },
/* it */ { IDS_CONNECT_TO_IT, "Connetti a" },
/* nl */ { IDS_CONNECT_TO_NL, "Maak verbinding naar" },
/* pl */ { IDS_CONNECT_TO_PL, "" },  /* fuzzy */
/* sv */ { IDS_CONNECT_TO_SV, "Anslut till" },
/* tr */ { IDS_CONNECT_TO_TR, "Balanlan" },

/* en */ { IDS_DISCONNECT,    "Disconnect" },
/* da */ { IDS_DISCONNECT_DA, "Afbryd forbindelse" },
/* de */ { IDS_DISCONNECT_DE, "Verbindung Trennen" },
/* fr */ { IDS_DISCONNECT_FR, "Se dconnecter du serveur" },
/* hu */ { IDS_DISCONNECT_HU, "Sztkapcsolds" },
/* it */ { IDS_DISCONNECT_IT, "Disconnetti" },
/* nl */ { IDS_DISCONNECT_NL, "Verbreek verbinding" },
/* pl */ { IDS_DISCONNECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_DISCONNECT_SV, "Koppla frn" },
/* tr */ { IDS_DISCONNECT_TR, "Balanty kes" },

/* en */ { IDS_IDLE,    "Idle" },
/* da */ { IDS_IDLE_DA, "Venter" },
/* de */ { IDS_IDLE_DE, "Idle" },
/* fr */ { IDS_IDLE_FR, "Inactif" },
/* hu */ { IDS_IDLE_HU, "Ttlen" },
/* it */ { IDS_IDLE_IT, "Inattivo" },
/* nl */ { IDS_IDLE_NL, "Idle" },
/* pl */ { IDS_IDLE_PL, "" },  /* fuzzy */
/* sv */ { IDS_IDLE_SV, "Vntar" },
/* tr */ { IDS_IDLE_TR, "Boa vakit geirme" },

/* en */ { IDS_SERVER_LISTENING,    "Server listening" },
/* da */ { IDS_SERVER_LISTENING_DA, "Server lytter" },
/* de */ { IDS_SERVER_LISTENING_DE, "Server wartet auf Verbindung" },
/* fr */ { IDS_SERVER_LISTENING_FR, "" },  /* fuzzy */
/* hu */ { IDS_SERVER_LISTENING_HU, "Vrakozs kliensre" },
/* it */ { IDS_SERVER_LISTENING_IT, "Server in ascolto" },
/* nl */ { IDS_SERVER_LISTENING_NL, "Server wacht op verbinding" },
/* pl */ { IDS_SERVER_LISTENING_PL, "" },  /* fuzzy */
/* sv */ { IDS_SERVER_LISTENING_SV, "Servern lyssnar" },
/* tr */ { IDS_SERVER_LISTENING_TR, "Sunucu dinleniyor" },

/* en */ { IDS_CONNECTED_SERVER,    "Connected server" },
/* da */ { IDS_CONNECTED_SERVER_DA, "Tilsluttet server" },
/* de */ { IDS_CONNECTED_SERVER_DE, "Server verbunden" },
/* fr */ { IDS_CONNECTED_SERVER_FR, "Connect au serveur" },
/* hu */ { IDS_CONNECTED_SERVER_HU, "Kapcsoldva kiszolglhoz" },
/* it */ { IDS_CONNECTED_SERVER_IT, "Server connesso" },
/* nl */ { IDS_CONNECTED_SERVER_NL, "Verbonden server" },
/* pl */ { IDS_CONNECTED_SERVER_PL, "" },  /* fuzzy */
/* sv */ { IDS_CONNECTED_SERVER_SV, "Ansluten server" },
/* tr */ { IDS_CONNECTED_SERVER_TR, "Sunucuya balanld" },

/* en */ { IDS_CONNECTED_CLIENT,    "Connected client" },
/* da */ { IDS_CONNECTED_CLIENT_DA, "Tilsluttet klient" },
/* de */ { IDS_CONNECTED_CLIENT_DE, "Verbunden, Client" },
/* fr */ { IDS_CONNECTED_CLIENT_FR, "Client connect" },
/* hu */ { IDS_CONNECTED_CLIENT_HU, "Kapcsold kliens" },
/* it */ { IDS_CONNECTED_CLIENT_IT, "Client connesso" },
/* nl */ { IDS_CONNECTED_CLIENT_NL, "Verbonden client" },
/* pl */ { IDS_CONNECTED_CLIENT_PL, "" },  /* fuzzy */
/* sv */ { IDS_CONNECTED_CLIENT_SV, "Ansluten klient" },
/* tr */ { IDS_CONNECTED_CLIENT_TR, "Bal istemci" },

/* en */ { IDS_NETPLAY_SETTINGS,    "Netplay Settings" },
/* da */ { IDS_NETPLAY_SETTINGS_DA, "Ntvrksspilindstillinger" },
/* de */ { IDS_NETPLAY_SETTINGS_DE, "Netplay Einstellungen" },
/* fr */ { IDS_NETPLAY_SETTINGS_FR, "Paramtres de jeu en rseau" },
/* hu */ { IDS_NETPLAY_SETTINGS_HU, "Hlzati jtk belltsai" },
/* it */ { IDS_NETPLAY_SETTINGS_IT, "Impostazioni Netplay" },
/* nl */ { IDS_NETPLAY_SETTINGS_NL, "Netplay instellingen" },
/* pl */ { IDS_NETPLAY_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_NETPLAY_SETTINGS_SV, "Instllningar fr ntverksspel" },
/* tr */ { IDS_NETPLAY_SETTINGS_TR, "Netplay Ayarlar" },

/* en */ { IDS_SAVE_SCREENSHOT,    "Save Screenshot" },
/* da */ { IDS_SAVE_SCREENSHOT_DA, "Gem screenshot" },
/* de */ { IDS_SAVE_SCREENSHOT_DE, "Screenshot speichern" },
/* fr */ { IDS_SAVE_SCREENSHOT_FR, "Enregistrer une capture d'cran" },
/* hu */ { IDS_SAVE_SCREENSHOT_HU, "Fnykp mentse" },
/* it */ { IDS_SAVE_SCREENSHOT_IT, "Salva schermata" },
/* nl */ { IDS_SAVE_SCREENSHOT_NL, "Schermafdruk opslaan" },
/* pl */ { IDS_SAVE_SCREENSHOT_PL, "Zapisz zrzut ekranu" },
/* sv */ { IDS_SAVE_SCREENSHOT_SV, "Spara skrmdump" },
/* tr */ { IDS_SAVE_SCREENSHOT_TR, "Ekran Grnts Kaydet" },

/* en */ { IDS_CANCEL,    "Cancel" },
/* da */ { IDS_CANCEL_DA, "Annullr" },
/* de */ { IDS_CANCEL_DE, "Abbruch" },
/* fr */ { IDS_CANCEL_FR, "Annuler" },
/* hu */ { IDS_CANCEL_HU, "Mgsem" },
/* it */ { IDS_CANCEL_IT, "Annulla" },
/* nl */ { IDS_CANCEL_NL, "Annuleren" },
/* pl */ { IDS_CANCEL_PL, "Anuluj" },
/* sv */ { IDS_CANCEL_SV, "Avbryt" },
/* tr */ { IDS_CANCEL_TR, "ptal" },

/* en */ { IDS_CHOOSE_SCREENSHOT_FORMAT,    "Choose screenshot format" },
/* da */ { IDS_CHOOSE_SCREENSHOT_FORMAT_DA, "Vlg screenshot format" },
/* de */ { IDS_CHOOSE_SCREENSHOT_FORMAT_DE, "Whle Screenshot Format" },
/* fr */ { IDS_CHOOSE_SCREENSHOT_FORMAT_FR, "Chosir le format de capture d'cran" },
/* hu */ { IDS_CHOOSE_SCREENSHOT_FORMAT_HU, "Vlasszon fnykp formtumot" },
/* it */ { IDS_CHOOSE_SCREENSHOT_FORMAT_IT, "Seleziona il formato per il salvataggio della schermata" },
/* nl */ { IDS_CHOOSE_SCREENSHOT_FORMAT_NL, "Kies schermafdrukformaat" },
/* pl */ { IDS_CHOOSE_SCREENSHOT_FORMAT_PL, "" },  /* fuzzy */
/* sv */ { IDS_CHOOSE_SCREENSHOT_FORMAT_SV, "Vlj format p skrmdump" },
/* tr */ { IDS_CHOOSE_SCREENSHOT_FORMAT_TR, "Ekran grnts biimi sein" },

/* en */ { IDS_SAVE_S_SCREENSHOT,    "Save %s screenshot" },
/* da */ { IDS_SAVE_S_SCREENSHOT_DA, "Gem %s-screenshot" },
/* de */ { IDS_SAVE_S_SCREENSHOT_DE, "Screenshot %s speichern" },
/* fr */ { IDS_SAVE_S_SCREENSHOT_FR, "Enregistrer une capture d'cran %s" },
/* hu */ { IDS_SAVE_S_SCREENSHOT_HU, "%s fnykp mentse" },
/* it */ { IDS_SAVE_S_SCREENSHOT_IT, "Salva schermata %s" },
/* nl */ { IDS_SAVE_S_SCREENSHOT_NL, "Scherm afdruk %s opslaan" },
/* pl */ { IDS_SAVE_S_SCREENSHOT_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_S_SCREENSHOT_SV, "Spara %s-skrmdump" },
/* tr */ { IDS_SAVE_S_SCREENSHOT_TR, "%s ekran grntsn kaydet" },

/* en */ { IDS_DETACHED_DEVICE_D,    "Detached device %d" },
/* da */ { IDS_DETACHED_DEVICE_D_DA, "Frakoblet enhed %d" },
/* de */ { IDS_DETACHED_DEVICE_D_DE, "Gert %d entfernt" },
/* fr */ { IDS_DETACHED_DEVICE_D_FR, "Priphrique dtach %d" },
/* hu */ { IDS_DETACHED_DEVICE_D_HU, "%d eszkz levlasztva" },
/* it */ { IDS_DETACHED_DEVICE_D_IT, "Rimosso dispositivo %d" },
/* nl */ { IDS_DETACHED_DEVICE_D_NL, "Apparaat %d ontkoppelt" },
/* pl */ { IDS_DETACHED_DEVICE_D_PL, "" },  /* fuzzy */
/* sv */ { IDS_DETACHED_DEVICE_D_SV, "Kopplade frn enhet %d" },
/* tr */ { IDS_DETACHED_DEVICE_D_TR, "kartlm aygt %d" },

/* en */ { IDS_ATTACHED_S_TO_DEVICE_D,    "Attached %s to device#%d" },
/* da */ { IDS_ATTACHED_S_TO_DEVICE_D_DA, "Tilsluttet %s til enhed #%d" },
/* de */ { IDS_ATTACHED_S_TO_DEVICE_D_DE, "%s mit Gert#%d verbunden" },
/* fr */ { IDS_ATTACHED_S_TO_DEVICE_D_FR, "%s attach au priphrique #%d" },
/* hu */ { IDS_ATTACHED_S_TO_DEVICE_D_HU, "%s csatolva #%d eszkzhz" },
/* it */ { IDS_ATTACHED_S_TO_DEVICE_D_IT, "Selezionato %s per la periferica #%d" },
/* nl */ { IDS_ATTACHED_S_TO_DEVICE_D_NL, "%s aan apparaat#%d gekoppelt" },
/* pl */ { IDS_ATTACHED_S_TO_DEVICE_D_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACHED_S_TO_DEVICE_D_SV, "Anslt %s till enhet %d" },
/* tr */ { IDS_ATTACHED_S_TO_DEVICE_D_TR, "%s aygt#%d'e balanm" },

/* en */ { IDS_VICE_QUESTION,    "VICE Question" },
/* da */ { IDS_VICE_QUESTION_DA, "VICE-sprgsml" },
/* de */ { IDS_VICE_QUESTION_DE, "VICE Frage" },
/* fr */ { IDS_VICE_QUESTION_FR, "Question VICE" },
/* hu */ { IDS_VICE_QUESTION_HU, "VICE krds" },
/* it */ { IDS_VICE_QUESTION_IT, "Domanda di VICE" },
/* nl */ { IDS_VICE_QUESTION_NL, "VICE vraag" },
/* pl */ { IDS_VICE_QUESTION_PL, "" },  /* fuzzy */
/* sv */ { IDS_VICE_QUESTION_SV, "VICE-frga" },
/* tr */ { IDS_VICE_QUESTION_TR, "VICE Sorusu" },

/* en */ { IDS_EXTEND_TO_40_TRACK,    "Extend image to 40-track format?" },
/* da */ { IDS_EXTEND_TO_40_TRACK_DA, "Udvid disk-image til 40 spor?" },
/* de */ { IDS_EXTEND_TO_40_TRACK_DE, "Image Dateu auf 40-Spur Format erweitern?" },
/* fr */ { IDS_EXTEND_TO_40_TRACK_FR, "tendre l'image au format 40 pistes?" },
/* hu */ { IDS_EXTEND_TO_40_TRACK_HU, "Kiterjesszem a kpmst 40 svos formtumra?" },
/* it */ { IDS_EXTEND_TO_40_TRACK_IT, "Estendere l'immagine al formato di 40 tracce?" },
/* nl */ { IDS_EXTEND_TO_40_TRACK_NL, "Bestand uitbreiden naar 40-sporen formaat?" },
/* pl */ { IDS_EXTEND_TO_40_TRACK_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXTEND_TO_40_TRACK_SV, "Utka avbildning till 40-sprsformat?" },
/* tr */ { IDS_EXTEND_TO_40_TRACK_TR, "Imaj 40-track biimine geniletilsin mi?" },

/* en */ { IDS_YES_NO,    "Yes|No" },
/* da */ { IDS_YES_NO_DA, "Ja|Nej" },
/* de */ { IDS_YES_NO_DE, "Ja|Nein" },
/* fr */ { IDS_YES_NO_FR, "Oui|Non" },
/* hu */ { IDS_YES_NO_HU, "Igen|Nem" },
/* it */ { IDS_YES_NO_IT, "S|No" },
/* nl */ { IDS_YES_NO_NL, "Ja|Nee" },
/* pl */ { IDS_YES_NO_PL, "" },  /* fuzzy */
/* sv */ { IDS_YES_NO_SV, "Ja|Nej" },
/* tr */ { IDS_YES_NO_TR, "Evet|Hayr" },

/* en */ { IDS_DETACHED_TAPE,    "Detached tape" },
/* da */ { IDS_DETACHED_TAPE_DA, "Frakoblet bnd" },
/* de */ { IDS_DETACHED_TAPE_DE, "Band Image entfernt" },
/* fr */ { IDS_DETACHED_TAPE_FR, "Datassette dtach" },
/* hu */ { IDS_DETACHED_TAPE_HU, "Szalag levlasztva" },
/* it */ { IDS_DETACHED_TAPE_IT, "Cassetta rimossa" },
/* nl */ { IDS_DETACHED_TAPE_NL, "Tape ontkoppelt" },
/* pl */ { IDS_DETACHED_TAPE_PL, "" },  /* fuzzy */
/* sv */ { IDS_DETACHED_TAPE_SV, "Kopplade frn band" },
/* tr */ { IDS_DETACHED_TAPE_TR, "Teyp kartld" },

/* en */ { IDS_ATTACHED_TAPE_S,    "Attached tape %s" },
/* da */ { IDS_ATTACHED_TAPE_S_DA, "Tilsluttet bnd %s" },
/* de */ { IDS_ATTACHED_TAPE_S_DE, "Band Image %s eingelegt" },
/* fr */ { IDS_ATTACHED_TAPE_S_FR, "Datassette %s attach" },
/* hu */ { IDS_ATTACHED_TAPE_S_HU, "%s szalag csatolva" },
/* it */ { IDS_ATTACHED_TAPE_S_IT, "Cassetta %s selezionata" },
/* nl */ { IDS_ATTACHED_TAPE_S_NL, "Tape %s gekoppelt" },
/* pl */ { IDS_ATTACHED_TAPE_S_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACHED_TAPE_S_SV, "Anslt band %s" },
/* tr */ { IDS_ATTACHED_TAPE_S_TR, "Yerletirilmi teyp %s" },

/* en */ { IDS_SELECT_START_SNAPSHOT,    "Select start snapshot for event history" },
/* da */ { IDS_SELECT_START_SNAPSHOT_DA, "Vlg start-snapshot for hndelseshistorik" },
/* de */ { IDS_SELECT_START_SNAPSHOT_DE, "Startsnapshot fr Ereignishistory festlegen" },
/* fr */ { IDS_SELECT_START_SNAPSHOT_FR, "Slectionner l'instantan de dpart pour l'historique des vnements" },
/* hu */ { IDS_SELECT_START_SNAPSHOT_HU, "Vlasszon kezdeti pillanatkpet az esemny rgztshez" },
/* it */ { IDS_SELECT_START_SNAPSHOT_IT, "Seleziona snapshot iniziale per la cronologia degli eventi" },
/* nl */ { IDS_SELECT_START_SNAPSHOT_NL, "Selecteer start momentopname voor gebeurtenis geschiedenis" },
/* pl */ { IDS_SELECT_START_SNAPSHOT_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_START_SNAPSHOT_SV, "Vlj startgonblicksmodul fr hndelsehistorik" },
/* tr */ { IDS_SELECT_START_SNAPSHOT_TR, "Olay tarihesi iin balang anlk grntsn se" },

/* en */ { IDS_SELECT_END_SNAPSHOT,    "Select end snapshot for event history" },
/* da */ { IDS_SELECT_END_SNAPSHOT_DA, "Vlg slut-snapshot for hndelseshistorik" },
/* de */ { IDS_SELECT_END_SNAPSHOT_DE, "Startsnapshot fr Ereignishistory festlegen" },
/* fr */ { IDS_SELECT_END_SNAPSHOT_FR, "Slectionner l'instantan de dpart pour l'historique des vnements" },
/* hu */ { IDS_SELECT_END_SNAPSHOT_HU, "Vlasszon vgs pillanatkpet az esemny rgztshez" },
/* it */ { IDS_SELECT_END_SNAPSHOT_IT, "Seleziona snapshot finale per la cronologia degli eventi" },
/* nl */ { IDS_SELECT_END_SNAPSHOT_NL, "Selecteer eind momentopname voor gebeurtenis geschiedenis" },
/* pl */ { IDS_SELECT_END_SNAPSHOT_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_END_SNAPSHOT_SV, "Vlj slutgonblicksbild fr hndelsehistorik" },
/* tr */ { IDS_SELECT_END_SNAPSHOT_TR, "Olay tarihesi iin biti anlk grntsn se" },

/* en */ { IDS_REALLY_EXIT,    "Do you really want to exit?\n\nAll the data present in the emulated RAM will be lost." },
/* da */ { IDS_REALLY_EXIT_DA, "Vil du virkelig afslutte?\n\nAlle data i emuleret RAM gr tabt." },
/* de */ { IDS_REALLY_EXIT_DE, "Willst Du wirklich beenden?\nDaten im emulierten Speicher RAM gehen verloren." },
/* fr */ { IDS_REALLY_EXIT_FR, "Dsirez-vous vraiment quitter?\n\nToutes les donnes prsentes dans la mmoire de l'mulateur seront perdues." },
/* hu */ { IDS_REALLY_EXIT_HU, "Biztosan kilp?\n\nAz emullt memria teljes tartalma el fog veszni." },
/* it */ { IDS_REALLY_EXIT_IT, "Uscire davvero?\n\nTutti i dati presenti nella RAM emulata saranno persi." },
/* nl */ { IDS_REALLY_EXIT_NL, "Wilt U echt afsluiten?\n\nAlle data in geëmuleerd geheugen zal verloren gaan." },
/* pl */ { IDS_REALLY_EXIT_PL, "" },  /* fuzzy */
/* sv */ { IDS_REALLY_EXIT_SV, "Vill du verkligen avsluta?\n\nAlla data i emulerat RAM kommer frloras." },
/* tr */ { IDS_REALLY_EXIT_TR, "kmak istediinizden emin misiniz?\n\nEmle edilmi RAM'de bulunan mevcut tm veri kaybedilecektir." },

/* en */ { IDS_ATTACH_CRT_IMAGE,    "Attach CRT cartridge image" },
/* da */ { IDS_ATTACH_CRT_IMAGE_DA, "Tilslut CRT-cartridge image" },
/* de */ { IDS_ATTACH_CRT_IMAGE_DE, "CRT Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_CRT_IMAGE_FR, "Insrer une cartouche CRT" },
/* hu */ { IDS_ATTACH_CRT_IMAGE_HU, "CRT cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_CRT_IMAGE_IT, "Seleziona immagine cartuccia CRT" },
/* nl */ { IDS_ATTACH_CRT_IMAGE_NL, "Koppel CRT cartridge bestand aan" },
/* pl */ { IDS_ATTACH_CRT_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_CRT_IMAGE_SV, "Anslut CRT-insticksmodulfil" },
/* tr */ { IDS_ATTACH_CRT_IMAGE_TR, "CRT kartu imaj yerletir" },

/* en */ { IDS_ATTACH_RAW_8KB_IMAGE,    "Attach raw 8KB cartridge image" },
/* da */ { IDS_ATTACH_RAW_8KB_IMAGE_DA, "Tilslut rt 8KB-cartridge image" },
/* de */ { IDS_ATTACH_RAW_8KB_IMAGE_DE, "8KB Erweiterungsmodul (raw) Image einlegen" },
/* fr */ { IDS_ATTACH_RAW_8KB_IMAGE_FR, "Insrer une cartouche 8KO" },
/* hu */ { IDS_ATTACH_RAW_8KB_IMAGE_HU, "Nyers 8KB-os cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_RAW_8KB_IMAGE_IT, "Seleziona immagine cartuccia di 8KB" },
/* nl */ { IDS_ATTACH_RAW_8KB_IMAGE_NL, "Koppel binair 8KB cartridge bestand" },
/* pl */ { IDS_ATTACH_RAW_8KB_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_RAW_8KB_IMAGE_SV, "Anslut r 8KB-insticksmodulavbilding" },
/* tr */ { IDS_ATTACH_RAW_8KB_IMAGE_TR, "Dz 8KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_RAW_16KB_IMAGE,    "Attach raw 16KB cartridge image" },
/* da */ { IDS_ATTACH_RAW_16KB_IMAGE_DA, "Tilslut rt 16KB-cartridge image" },
/* de */ { IDS_ATTACH_RAW_16KB_IMAGE_DE, "16KB Erweiterungsmodul (raw) Image einlegen" },
/* fr */ { IDS_ATTACH_RAW_16KB_IMAGE_FR, "Insrer une cartouche 16KO" },
/* hu */ { IDS_ATTACH_RAW_16KB_IMAGE_HU, "Nyers 16KB-os cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_RAW_16KB_IMAGE_IT, "Seleziona immagine cartuccia di 16KB" },
/* nl */ { IDS_ATTACH_RAW_16KB_IMAGE_NL, "Koppel binair 16KB cartridge bestand" },
/* pl */ { IDS_ATTACH_RAW_16KB_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_RAW_16KB_IMAGE_SV, "Anslut r 16KB-insticksmodulavbilding" },
/* tr */ { IDS_ATTACH_RAW_16KB_IMAGE_TR, "Dz 16KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_ACTION_REPLAY_IMAGE,    "Attach Action Replay cartridge image" },
/* da */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_DA, "Tilslut Action Replay-cartridge image" },
/* de */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_DE, "Action Replay Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_FR, "Insrer une cartouche Action Replay" },
/* hu */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_HU, "Action Replay cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_IT, "Seleziona immagine cartuccia Action Replay" },
/* nl */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_NL, "Koppel Action Replay cartridge bestand" },
/* pl */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_SV, "Anslut Action Replay-insticksmodulfil" },
/* tr */ { IDS_ATTACH_ACTION_REPLAY_IMAGE_TR, "Action Replay kartu imaj yerletir" },

/* en */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE,    "Attach Action Replay MK3 cartridge image" },
/* da */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_DA, "Tilslut Action Replay 3-cartridge image" },
/* de */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_DE, "Action Replay MK3 Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_IT, "Seleziona immagine cartuccia Action Replay MK3" },
/* nl */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_NL, "Koppel Action Replay MK3 cartridge bestand" },
/* pl */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_SV, "Anslut Action Replay MK3-insticksmodulfil" },
/* tr */ { IDS_ATTACH_ACTION_REPLAY3_IMAGE_TR, "Action Replay MK3 kartu imajn yerletir" },

/* en */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE,    "Attach Action Replay MK4 cartridge image" },
/* da */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_DA, "Tilslut Action Replay 4-cartridge image" },
/* de */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_DE, "Action Replay MK4 Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_IT, "Seleziona immagine cartuccia Action Replay MK4" },
/* nl */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_NL, "Koppel Action Replay MK4 cartridge bestand" },
/* pl */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_SV, "Anslut Action Replay MK4-insticksmodulfil" },
/* tr */ { IDS_ATTACH_ACTION_REPLAY4_IMAGE_TR, "Action Replay MK4 kartu imaj yerletir" },

/* en */ { IDS_ATTACH_STARDOS_IMAGE,    "Attach Stardos cartridge image" },
/* da */ { IDS_ATTACH_STARDOS_IMAGE_DA, "Tilslut StarDOS-cartridge image" },
/* de */ { IDS_ATTACH_STARDOS_IMAGE_DE, "Erweiterungsmodul StarDOS Image einlegen" },
/* fr */ { IDS_ATTACH_STARDOS_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_ATTACH_STARDOS_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_STARDOS_IMAGE_IT, "Seleziona immagine cartuccia Stardos" },
/* nl */ { IDS_ATTACH_STARDOS_IMAGE_NL, "Koppel Stardos cartridge gebestand" },
/* pl */ { IDS_ATTACH_STARDOS_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_STARDOS_IMAGE_SV, "Anslut Stardos-insticksmodulfil" },
/* tr */ { IDS_ATTACH_STARDOS_IMAGE_TR, "Stardos kartu imaj yerletir" },

/* en */ { IDS_ATTACH_ATOMIC_POWER_IMAGE,    "Attach Atomic Power cartridge image" },
/* da */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_DA, "Tilslut Atomic Power-cartridge image" },
/* de */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_DE, "Atomic Power Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_FR, "Insrer une cartouche Atomic Power" },
/* hu */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_HU, "Atomic Power cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_IT, "Seleziona immagine cartuccia Atomic Power" },
/* nl */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_NL, "Koppel Atomic Power cartridge bestand" },
/* pl */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_SV, "Anslut Atomic Power-avbildningsfil" },
/* tr */ { IDS_ATTACH_ATOMIC_POWER_IMAGE_TR, "Atomic Power kartu imaj yerletir" },

/* en */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE,    "Attach Epyx FastLoad cartridge image" },
/* da */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_DA, "Tilslut Epyx FastLoad-cartridge image" },
/* de */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_DE, "Epyx Fastload Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_IT, "Seleziona immagine cartuccia Epyx FastLoad" },
/* nl */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_NL, "Koppel Epyx FastLoad cartridge bestand" },
/* pl */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_SV, "Anslut Epyx FastLoad-avbildningsfil" },
/* tr */ { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_TR, "Epyx FastLoad kartu imaj yerletir" },

/* en */ { IDS_ATTACH_IEEE488_IMAGE,    "Attach IEEE-488 Interface cartridge image" },
/* da */ { IDS_ATTACH_IEEE488_IMAGE_DA, "Tilslut IEEE-488 interface cartridge image" },
/* de */ { IDS_ATTACH_IEEE488_IMAGE_DE, "IEEE Schnittstellen Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_IEEE488_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_ATTACH_IEEE488_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_IEEE488_IMAGE_IT, "Seleziona immagine cartuccia interfaccia IEEE" },
/* nl */ { IDS_ATTACH_IEEE488_IMAGE_NL, "Koppel IEEE-488 Interface cartridge bestand" },
/* pl */ { IDS_ATTACH_IEEE488_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_IEEE488_IMAGE_SV, "Anslut IEEE-488-grnssnittsavbildningsfil" },
/* tr */ { IDS_ATTACH_IEEE488_IMAGE_TR, "IEEE-488 Arabirimi kartu imaj yerletir" },

/* en */ { IDS_ATTACH_RETRO_REPLAY_IMAGE,    "Attach Retro Replay cartridge image" },
/* da */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_DA, "Tilslut Retro Replay-cartridge image" },
/* de */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_DE, "Retro Replay Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_FR, "Insrer une cartouche Retro Replay" },
/* hu */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_HU, "Retro Replay cartridge kpms csatolsa" },
/* it */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_IT, "Seleziona immagine cartuccia Retro Replay" },
/* nl */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_NL, "Koppel Retro Replay cartridge bestand" },
/* pl */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_SV, "Anslut Retro Replay-avbildningsfil" },
/* tr */ { IDS_ATTACH_RETRO_REPLAY_IMAGE_TR, "Retro Replay kartu imaj yerletir" },

/* en */ { IDS_ATTACH_IDE64_IMAGE,    "Attach IDE64 interface cartridge image" },
/* da */ { IDS_ATTACH_IDE64_IMAGE_DA, "Tilslut IDE64-interface cartridge image" },
/* de */ { IDS_ATTACH_IDE64_IMAGE_DE, "IDE64 Schnittstellen Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_IDE64_IMAGE_FR, "Insrer une cartouche interface IDE64" },
/* hu */ { IDS_ATTACH_IDE64_IMAGE_HU, "IDE64 interfsz kpms csatolsa" },
/* it */ { IDS_ATTACH_IDE64_IMAGE_IT, "Seleziona immagine cartuccia di interfaccia IDE64" },
/* nl */ { IDS_ATTACH_IDE64_IMAGE_NL, "Koppel IDE64 interfacebestand" },
/* pl */ { IDS_ATTACH_IDE64_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_IDE64_IMAGE_SV, "Anslut IDE64-grnssnittsavbildningsfil" },
/* tr */ { IDS_ATTACH_IDE64_IMAGE_TR, "IDE64 arabirimi kartu imaj yerletir" },

/* en */ { IDS_ATTACH_SS4_IMAGE,    "Attach Super Snapshot V4 cartridge image" },
/* da */ { IDS_ATTACH_SS4_IMAGE_DA, "Tilslut Super Snapshot 4-cartridge image" },
/* de */ { IDS_ATTACH_SS4_IMAGE_DE, "Super Snapshot V4 Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_SS4_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_ATTACH_SS4_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_SS4_IMAGE_IT, "Seleziona immagine cartuccia Super Snapshot V4" },
/* nl */ { IDS_ATTACH_SS4_IMAGE_NL, "Koppel Super Snapshot V4 cartridge bestand" },
/* pl */ { IDS_ATTACH_SS4_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_SS4_IMAGE_SV, "Anslut Super Snapshot V4-avbildningsfil" },
/* tr */ { IDS_ATTACH_SS4_IMAGE_TR, "Super Snapshot V4 kartu imaj yerletir" },

/* en */ { IDS_ATTACH_SS5_IMAGE,    "Attach Super Snapshot V5 cartridge image" },
/* da */ { IDS_ATTACH_SS5_IMAGE_DA, "Tilslut Super Snapshot 5-cartridge image" },
/* de */ { IDS_ATTACH_SS5_IMAGE_DE, "Super Snapshot V5 Erweiterungsmodul Image einlegen" },
/* fr */ { IDS_ATTACH_SS5_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_ATTACH_SS5_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_SS5_IMAGE_IT, "Seleziona immagine cartuccia Super Snapshot V5" },
/* nl */ { IDS_ATTACH_SS5_IMAGE_NL, "Koppel Super Snapshot V5 cartridge bestand" },
/* pl */ { IDS_ATTACH_SS5_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_SS5_IMAGE_SV, "Anslut Super Snapshot V5-avbildningsfil" },
/* tr */ { IDS_ATTACH_SS5_IMAGE_TR, "Super Snapshot V5 kartu imaj yerletir" },

/* en */ { IDS_ATTACH_SB_IMAGE,    "Attach Structured BASIC cartridge image" },
/* da */ { IDS_ATTACH_SB_IMAGE_DA, "Tilslut Strucured BASIC-cartridge image" },
/* de */ { IDS_ATTACH_SB_IMAGE_DE, "Erweiterungsmodul Structured Basic einlegen" },
/* fr */ { IDS_ATTACH_SB_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_ATTACH_SB_IMAGE_HU, "" },  /* fuzzy */
/* it */ { IDS_ATTACH_SB_IMAGE_IT, "Seleziona immagine cartuccia Structured BASIC" },
/* nl */ { IDS_ATTACH_SB_IMAGE_NL, "Koppel Structured BASIC cartridge bestand" },
/* pl */ { IDS_ATTACH_SB_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_SB_IMAGE_SV, "Anslut Structured BASIC-insticksmodulfil" },
/* tr */ { IDS_ATTACH_SB_IMAGE_TR, "Structured BASIC kartu imaj yerletir" },

/* en */ { IDS_AVAILABLE_CMDLINE_OPTIONS,    "\nAvailable command-line options:\n\n" },
/* da */ { IDS_AVAILABLE_CMDLINE_OPTIONS_DA, "\nMulige kommandolinjeparametre:\n\n" },
/* de */ { IDS_AVAILABLE_CMDLINE_OPTIONS_DE, "\nZulssige Kommandozeilen Optionen:\n\n" },
/* fr */ { IDS_AVAILABLE_CMDLINE_OPTIONS_FR, "\nOptions de ligne de commande disponibles:\n\n" },
/* hu */ { IDS_AVAILABLE_CMDLINE_OPTIONS_HU, "\nLehetsges parancssori opcik:\n\n" },
/* it */ { IDS_AVAILABLE_CMDLINE_OPTIONS_IT, "\nOpzioni disponibili da riga di comando:\n\n" },
/* nl */ { IDS_AVAILABLE_CMDLINE_OPTIONS_NL, "\nBeschikbare command-line opties:\n\n" },
/* pl */ { IDS_AVAILABLE_CMDLINE_OPTIONS_PL, "\nDostpne opcje z linii polece:\n\n" },
/* sv */ { IDS_AVAILABLE_CMDLINE_OPTIONS_SV, "\nTillgngliga kommandoradsflaggor:\n\n" },
/* tr */ { IDS_AVAILABLE_CMDLINE_OPTIONS_TR, "\nMevcut komut satr seenekleri:\n\n" },

/* en */ { IDS_ATTACH_4_8_16KB_AT_2000,    "Attach 4/8/16KB cartridge image at $2000" },
/* da */ { IDS_ATTACH_4_8_16KB_AT_2000_DA, "Tilslut 4/8/16KB-cartridge image p $2000" },
/* de */ { IDS_ATTACH_4_8_16KB_AT_2000_DE, "4/8/16KB Modul Image bei $2000 einlegen" },
/* fr */ { IDS_ATTACH_4_8_16KB_AT_2000_FR, "Insertion d'une image 4/8/16Ko  $2000" },
/* hu */ { IDS_ATTACH_4_8_16KB_AT_2000_HU, "4/8/16KB kpms csatolsa $2000 cmre" },
/* it */ { IDS_ATTACH_4_8_16KB_AT_2000_IT, "Seleziona immagine cartuccia di 4/8/16KB a $2000" },
/* nl */ { IDS_ATTACH_4_8_16KB_AT_2000_NL, "Koppel 4/8/16KB bestand op $2000" },
/* pl */ { IDS_ATTACH_4_8_16KB_AT_2000_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_4_8_16KB_AT_2000_SV, "Anslut 4/8/16KB-modulfil vid $2000" },
/* tr */ { IDS_ATTACH_4_8_16KB_AT_2000_TR, "$2000 adresine 4/8/16KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_4_8_16KB_AT_4000,    "Attach 4/8/16KB cartridge image at $4000" },
/* da */ { IDS_ATTACH_4_8_16KB_AT_4000_DA, "Tilslut 4/8/16KB-cartridge image p $4000" },
/* de */ { IDS_ATTACH_4_8_16KB_AT_4000_DE, "4/8/16KB Modul Image bei $4000 einlegen" },
/* fr */ { IDS_ATTACH_4_8_16KB_AT_4000_FR, "Insertion d'une image 4/8/16Ko  $4000" },
/* hu */ { IDS_ATTACH_4_8_16KB_AT_4000_HU, "4/8/16KB kpms csatolsa $4000 cmre" },
/* it */ { IDS_ATTACH_4_8_16KB_AT_4000_IT, "Seleziona immagine cartuccia di 4/8/16KB a $4000" },
/* nl */ { IDS_ATTACH_4_8_16KB_AT_4000_NL, "Koppel 4/8/16KB bestand op $4000" },
/* pl */ { IDS_ATTACH_4_8_16KB_AT_4000_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_4_8_16KB_AT_4000_SV, "Anslut 4/8/16KB-modulfil vid $4000" },
/* tr */ { IDS_ATTACH_4_8_16KB_AT_4000_TR, "$4000 adresine 4/8/16KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_4_8_16KB_AT_6000,    "Attach 4/8/16KB cartridge image at $6000" },
/* da */ { IDS_ATTACH_4_8_16KB_AT_6000_DA, "Tilslut 4/8/16KB-cartridge image p $6000" },
/* de */ { IDS_ATTACH_4_8_16KB_AT_6000_DE, "4/8/16KB Modul Image bei $6000 einlegen" },
/* fr */ { IDS_ATTACH_4_8_16KB_AT_6000_FR, "Insertion d'une image 4/8/16Ko  $6000" },
/* hu */ { IDS_ATTACH_4_8_16KB_AT_6000_HU, "4/8/16KB kpms csatolsa $6000 cmre" },
/* it */ { IDS_ATTACH_4_8_16KB_AT_6000_IT, "Seleziona immagine cartuccia di 4/8/16KB a $6000" },
/* nl */ { IDS_ATTACH_4_8_16KB_AT_6000_NL, "Koppel 4/8/16KB bestand op $6000" },
/* pl */ { IDS_ATTACH_4_8_16KB_AT_6000_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_4_8_16KB_AT_6000_SV, "Anslut 4/8/16KB-modulfil vid $6000" },
/* tr */ { IDS_ATTACH_4_8_16KB_AT_6000_TR, "$6000 adresine 4/8/16KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_4_8KB_AT_A000,    "Attach 4/8KB cartridge image at $A000" },
/* da */ { IDS_ATTACH_4_8KB_AT_A000_DA, "Tilslut 4/8KB-cartridge image p $A000" },
/* de */ { IDS_ATTACH_4_8KB_AT_A000_DE, "4/8KB Modul Image bei $A000 einlegen" },
/* fr */ { IDS_ATTACH_4_8KB_AT_A000_FR, "Insertion d'une image 4/8Ko  $A000" },
/* hu */ { IDS_ATTACH_4_8KB_AT_A000_HU, "4/8KB kpms csatolsa $A000 cmre" },
/* it */ { IDS_ATTACH_4_8KB_AT_A000_IT, "Seleziona immagine cartuccia di 4/8KB a $A000" },
/* nl */ { IDS_ATTACH_4_8KB_AT_A000_NL, "Koppel 4/8KB bestand op $A000" },
/* pl */ { IDS_ATTACH_4_8KB_AT_A000_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_4_8KB_AT_A000_SV, "Anslut 4/8KB-modulfil vid $A000" },
/* tr */ { IDS_ATTACH_4_8KB_AT_A000_TR, "$A000 adresine 4/8KB kartu imaj yerletir" },

/* en */ { IDS_ATTACH_4KB_AT_B000,    "Attach 4KB cartridge image at $B000" },
/* da */ { IDS_ATTACH_4KB_AT_B000_DA, "Tilslut 4KB-cartridge image p $B000" },
/* de */ { IDS_ATTACH_4KB_AT_B000_DE, "4KB Modul Image bei $B000 einlegen" },
/* fr */ { IDS_ATTACH_4KB_AT_B000_FR, "Insertion d'une image 4Ko  $B000" },
/* hu */ { IDS_ATTACH_4KB_AT_B000_HU, "4KB kpms csatolsa $B000 cmre" },
/* it */ { IDS_ATTACH_4KB_AT_B000_IT, "Seleziona immagine cartuccia di 4KB a $B000" },
/* nl */ { IDS_ATTACH_4KB_AT_B000_NL, "Koppel 4KB bestand op $B000" },
/* pl */ { IDS_ATTACH_4KB_AT_B000_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_4KB_AT_B000_SV, "Anslut 4KB-modulfil vid $B000" },
/* tr */ { IDS_ATTACH_4KB_AT_B000_TR, "$B000 adresine 4KB kartu imaj yerletir" },

/* en */ { IDS_S_AT_D_SPEED,    "%s at %d%% speed, %d fps%s" },
/* da */ { IDS_S_AT_D_SPEED_DA, "%s med %d%% hastighed, %d b/s%s" },
/* de */ { IDS_S_AT_D_SPEED_DE, "%s bei %d%% Geschwindigkeit, %d fps%s" },
/* fr */ { IDS_S_AT_D_SPEED_FR, "%s  une vitesse de %d%%,  %d img/s%s" },
/* hu */ { IDS_S_AT_D_SPEED_HU, "%s %d%% sebessgen, %d fps%s" },
/* it */ { IDS_S_AT_D_SPEED_IT, "velocit %s al %d%%, %d fps%s" },
/* nl */ { IDS_S_AT_D_SPEED_NL, "%s met %d%% snelheid, %d fps%s" },
/* pl */ { IDS_S_AT_D_SPEED_PL, "" },  /* fuzzy */
/* sv */ { IDS_S_AT_D_SPEED_SV, "%s med %d%% hastighet, %d b/s%s" },
/* tr */ { IDS_S_AT_D_SPEED_TR, "%s %d%% hznda, %d fps%s" },

/* en */ { IDS_ATTACH,    "Attach" },
/* da */ { IDS_ATTACH_DA, "Tilslut" },
/* de */ { IDS_ATTACH_DE, "Einlegen" },
/* fr */ { IDS_ATTACH_FR, "" },  /* fuzzy */
/* hu */ { IDS_ATTACH_HU, "Csatols" },
/* it */ { IDS_ATTACH_IT, "Seleziona" },
/* nl */ { IDS_ATTACH_NL, "Koppel" },
/* pl */ { IDS_ATTACH_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_SV, "Anslut" },
/* tr */ { IDS_ATTACH_TR, "Yerletir" },

/* en */ { IDS_PARENT,    "Parent" },
/* da */ { IDS_PARENT_DA, "Forlder" },
/* de */ { IDS_PARENT_DE, "Vorgnger" },
/* fr */ { IDS_PARENT_FR, "" },  /* fuzzy */
/* hu */ { IDS_PARENT_HU, "Szl" },
/* it */ { IDS_PARENT_IT, "Su" },
/* nl */ { IDS_PARENT_NL, "Bevenliggende directory" },
/* pl */ { IDS_PARENT_PL, "" },  /* fuzzy */
/* sv */ { IDS_PARENT_SV, "Frlder" },
/* tr */ { IDS_PARENT_TR, "st e" },

/* en */ { IDS_ATTACH_READ_ONLY,    "Attach read only" },
/* da */ { IDS_ATTACH_READ_ONLY_DA, "Tilslut skrivebeskyttet" },
/* de */ { IDS_ATTACH_READ_ONLY_DE, "Schreibgeschtzt einlegen" },
/* fr */ { IDS_ATTACH_READ_ONLY_FR, "Insrer en lecture seule" },
/* hu */ { IDS_ATTACH_READ_ONLY_HU, "Csatols csak olvashat mdon" },
/* it */ { IDS_ATTACH_READ_ONLY_IT, "Seleziona in sola lettura" },
/* nl */ { IDS_ATTACH_READ_ONLY_NL, "Alleen lezen" },
/* pl */ { IDS_ATTACH_READ_ONLY_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_READ_ONLY_SV, "Anslut skrivskyddat" },
/* tr */ { IDS_ATTACH_READ_ONLY_TR, "Salt okunur yerletir" },

/* en */ { IDS_NAME,    "Name" },
/* da */ { IDS_NAME_DA, "Navn" },
/* de */ { IDS_NAME_DE, "Name" },
/* fr */ { IDS_NAME_FR, "Nom" },
/* hu */ { IDS_NAME_HU, "Nv" },
/* it */ { IDS_NAME_IT, "Nome" },
/* nl */ { IDS_NAME_NL, "Naam" },
/* pl */ { IDS_NAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_NAME_SV, "Namn" },
/* tr */ { IDS_NAME_TR, "sim" },

/* en */ { IDS_CREATE_IMAGE,    "Create Image" },
/* da */ { IDS_CREATE_IMAGE_DA, "Opret image" },
/* de */ { IDS_CREATE_IMAGE_DE, "Image Datei erzeugen" },
/* fr */ { IDS_CREATE_IMAGE_FR, "Cration d'image" },
/* hu */ { IDS_CREATE_IMAGE_HU, "Kpms ltrehozsa" },
/* it */ { IDS_CREATE_IMAGE_IT, "Crea immagine" },
/* nl */ { IDS_CREATE_IMAGE_NL, "Maak Bestand" },
/* pl */ { IDS_CREATE_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_CREATE_IMAGE_SV, "Skapa avbildning" },
/* tr */ { IDS_CREATE_IMAGE_TR, "Imaj Yarat" },

/* en */ { IDS_NEW_IMAGE,    "New Image" },
/* da */ { IDS_NEW_IMAGE_DA, "Nyt image" },
/* de */ { IDS_NEW_IMAGE_DE, "Neue Image Datei" },
/* fr */ { IDS_NEW_IMAGE_FR, "Nouvelle image" },
/* hu */ { IDS_NEW_IMAGE_HU, "j kpms" },
/* it */ { IDS_NEW_IMAGE_IT, "Nuova immagine" },
/* nl */ { IDS_NEW_IMAGE_NL, "Nieuw Bestand" },
/* pl */ { IDS_NEW_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_NEW_IMAGE_SV, "Ny avbildning" },
/* tr */ { IDS_NEW_IMAGE_TR, "Yeni maj" },

/* en */ { IDS_NEW_TAP_IMAGE,    "New TAP Image" },
/* da */ { IDS_NEW_TAP_IMAGE_DA, "Nyt TAP-image" },
/* de */ { IDS_NEW_TAP_IMAGE_DE, "Neue TAP Image Datei" },
/* fr */ { IDS_NEW_TAP_IMAGE_FR, "Nouvelle image TAP" },
/* hu */ { IDS_NEW_TAP_IMAGE_HU, "j TAP kpms" },
/* it */ { IDS_NEW_TAP_IMAGE_IT, "Nuova immagine TAP" },
/* nl */ { IDS_NEW_TAP_IMAGE_NL, "Nieuw TAP bestand" },
/* pl */ { IDS_NEW_TAP_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_NEW_TAP_IMAGE_SV, "Ny TAP-avbildning" },
/* tr */ { IDS_NEW_TAP_IMAGE_TR, "Yeni TAP Imaj" },

/* en */ { IDS_OVERWRITE_EXISTING_IMAGE,    "Overwrite existing image?" },
/* da */ { IDS_OVERWRITE_EXISTING_IMAGE_DA, "Overskriv eksisterende image?" },
/* de */ { IDS_OVERWRITE_EXISTING_IMAGE_DE, "Existierende Datei berschreiben?" },
/* fr */ { IDS_OVERWRITE_EXISTING_IMAGE_FR, "craser les images existantes?" },
/* hu */ { IDS_OVERWRITE_EXISTING_IMAGE_HU, "Fellrjam a meglv kpmst?" },
/* it */ { IDS_OVERWRITE_EXISTING_IMAGE_IT, "Sovrascrivo l'immagine esistente?" },
/* nl */ { IDS_OVERWRITE_EXISTING_IMAGE_NL, "Bestaand bestand overschrijven?" },
/* pl */ { IDS_OVERWRITE_EXISTING_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_OVERWRITE_EXISTING_IMAGE_SV, "Skriva ver existerande avbildning?" },
/* tr */ { IDS_OVERWRITE_EXISTING_IMAGE_TR, "Varolan imajn zerine yazlsn m?" },

/* en */ { IDS_ABOUT,    "About" },
/* da */ { IDS_ABOUT_DA, "Om" },
/* de */ { IDS_ABOUT_DE, "ber" },
/* fr */ { IDS_ABOUT_FR, "" },  /* fuzzy */
/* hu */ { IDS_ABOUT_HU, "Nvjegy" },
/* it */ { IDS_ABOUT_IT, "Informazioni" },
/* nl */ { IDS_ABOUT_NL, "Over VICE" },
/* pl */ { IDS_ABOUT_PL, "" },  /* fuzzy */
/* sv */ { IDS_ABOUT_SV, "Om" },
/* tr */ { IDS_ABOUT_TR, "Hakknda" },

/* en */ { IDS_IMAGE_CONTENTS,    "Image Contents" },
/* da */ { IDS_IMAGE_CONTENTS_DA, "Indhold i image" },
/* de */ { IDS_IMAGE_CONTENTS_DE, "Image Datei Inhalt" },
/* fr */ { IDS_IMAGE_CONTENTS_FR, "" },  /* fuzzy */
/* hu */ { IDS_IMAGE_CONTENTS_HU, "Tartalom" },
/* it */ { IDS_IMAGE_CONTENTS_IT, "Contenuti immagine" },
/* nl */ { IDS_IMAGE_CONTENTS_NL, "bestandsinhoud" },
/* pl */ { IDS_IMAGE_CONTENTS_PL, "" },  /* fuzzy */
/* sv */ { IDS_IMAGE_CONTENTS_SV, "Innehll i avbildning" },
/* tr */ { IDS_IMAGE_CONTENTS_TR, "Imaj erii" },

/* en */ { IDMS_DISABLED,    "Disabled" },
/* da */ { IDMS_DISABLED_DA, "Deaktiveret" },
/* de */ { IDMS_DISABLED_DE, "Deaktiviert" },
/* fr */ { IDMS_DISABLED_FR, "" },  /* fuzzy */
/* hu */ { IDMS_DISABLED_HU, "Tiltva" },
/* it */ { IDMS_DISABLED_IT, "Disattivo" },
/* nl */ { IDMS_DISABLED_NL, "Uit" },
/* pl */ { IDMS_DISABLED_PL, "" },  /* fuzzy */
/* sv */ { IDMS_DISABLED_SV, "Inaktiverad" },
/* tr */ { IDMS_DISABLED_TR, "Pasif" },

/* en */ { IDS_ENABLED,    "Enabled" },
/* da */ { IDS_ENABLED_DA, "Aktiveret" },
/* de */ { IDS_ENABLED_DE, "Aktiviert" },
/* fr */ { IDS_ENABLED_FR, "" },  /* fuzzy */
/* hu */ { IDS_ENABLED_HU, "Engedlyezve" },
/* it */ { IDS_ENABLED_IT, "Attivo" },
/* nl */ { IDS_ENABLED_NL, "Aan" },
/* pl */ { IDS_ENABLED_PL, "" },  /* fuzzy */
/* sv */ { IDS_ENABLED_SV, "Aktiverad" },
/* tr */ { IDS_ENABLED_TR, "Aktif" },

/* en */ { IDS_RS232_DEVICE_1,    "RS232 device 1" },
/* da */ { IDS_RS232_DEVICE_1_DA, "RS232-enhed 1" },
/* de */ { IDS_RS232_DEVICE_1_DE, "RS232 Gert 1" },
/* fr */ { IDS_RS232_DEVICE_1_FR, "1er Priphrique RS232" },
/* hu */ { IDS_RS232_DEVICE_1_HU, "RS232 1-es eszkz" },
/* it */ { IDS_RS232_DEVICE_1_IT, "Dispositivo RS232 #1" },
/* nl */ { IDS_RS232_DEVICE_1_NL, "RS232 apparaat 1" },
/* pl */ { IDS_RS232_DEVICE_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_RS232_DEVICE_1_SV, "RS232-enhet 1" },
/* tr */ { IDS_RS232_DEVICE_1_TR, "RS232 aygt 1" },

/* en */ { IDS_RS232_DEVICE_2,    "RS232 device 2" },
/* da */ { IDS_RS232_DEVICE_2_DA, "RS232-enhed 2" },
/* de */ { IDS_RS232_DEVICE_2_DE, "RS232 Gert 2" },
/* fr */ { IDS_RS232_DEVICE_2_FR, "2e Priphrique RS232" },
/* hu */ { IDS_RS232_DEVICE_2_HU, "RS232 2-es eszkz" },
/* it */ { IDS_RS232_DEVICE_2_IT, "Dispositivo RS232 #2" },
/* nl */ { IDS_RS232_DEVICE_2_NL, "RS232 apparaat 2" },
/* pl */ { IDS_RS232_DEVICE_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_RS232_DEVICE_2_SV, "RS232-enhet 2" },
/* tr */ { IDS_RS232_DEVICE_2_TR, "RS232 aygt 2" },

/* en */ { IDS_RS232_DEVICE_3,    "RS232 device 3" },
/* da */ { IDS_RS232_DEVICE_3_DA, "RS232-enhed 3" },
/* de */ { IDS_RS232_DEVICE_3_DE, "RS232 Gert 3" },
/* fr */ { IDS_RS232_DEVICE_3_FR, "3e Priphrique RS232" },
/* hu */ { IDS_RS232_DEVICE_3_HU, "RS232 3-as eszkz" },
/* it */ { IDS_RS232_DEVICE_3_IT, "Dispositivo RS232 #3" },
/* nl */ { IDS_RS232_DEVICE_3_NL, "RS232 apparaat 3" },
/* pl */ { IDS_RS232_DEVICE_3_PL, "" },  /* fuzzy */
/* sv */ { IDS_RS232_DEVICE_3_SV, "RS232-enhet 3" },
/* tr */ { IDS_RS232_DEVICE_3_TR, "RS232 aygt 3" },

/* en */ { IDS_RS232_DEVICE_4,    "RS232 device 4" },
/* da */ { IDS_RS232_DEVICE_4_DA, "RS232-enhed 4" },
/* de */ { IDS_RS232_DEVICE_4_DE, "RS232 Gert 4" },
/* fr */ { IDS_RS232_DEVICE_4_FR, "4e Priphrique RS232" },
/* hu */ { IDS_RS232_DEVICE_4_HU, "RS232 4-es eszkz" },
/* it */ { IDS_RS232_DEVICE_4_IT, "Dispositivo RS232 #4" },
/* nl */ { IDS_RS232_DEVICE_4_NL, "RS232 apparaat 4" },
/* pl */ { IDS_RS232_DEVICE_4_PL, "" },  /* fuzzy */
/* sv */ { IDS_RS232_DEVICE_4_SV, "RS232-enhet 4" },
/* tr */ { IDS_RS232_DEVICE_4_TR, "RS232 aygt 4" },

/* en */ { IDS_NONE,    "None" },
/* da */ { IDS_NONE_DA, "Ingen" },
/* de */ { IDS_NONE_DE, "Kein" },
/* fr */ { IDS_NONE_FR, "Aucun" },
/* hu */ { IDS_NONE_HU, "Nincs" },
/* it */ { IDS_NONE_IT, "Nessuno" },
/* nl */ { IDS_NONE_NL, "Geen" },
/* pl */ { IDS_NONE_PL, "" },  /* fuzzy */
/* sv */ { IDS_NONE_SV, "Ingen" },
/* tr */ { IDS_NONE_TR, "Yok" },

/* en */ { IDS_FILESYSTEM,    "Filesystem" },
/* da */ { IDS_FILESYSTEM_DA, "Filsystem" },
/* de */ { IDS_FILESYSTEM_DE, "Dateisystem" },
/* fr */ { IDS_FILESYSTEM_FR, "" },  /* fuzzy */
/* hu */ { IDS_FILESYSTEM_HU, "" },  /* fuzzy */
/* it */ { IDS_FILESYSTEM_IT, "Filesystem" },
/* nl */ { IDS_FILESYSTEM_NL, "Bestandssysteem" },
/* pl */ { IDS_FILESYSTEM_PL, "" },  /* fuzzy */
/* sv */ { IDS_FILESYSTEM_SV, "Filsystem" },
/* tr */ { IDS_FILESYSTEM_TR, "Dosya sistemi" },

/* en */ { IDS_RAW,    "Raw" },
/* da */ { IDS_RAW_DA, "R" },
/* de */ { IDS_RAW_DE, "Raw" },
/* fr */ { IDS_RAW_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAW_HU, "" },  /* fuzzy */
/* it */ { IDS_RAW_IT, "Raw" },
/* nl */ { IDS_RAW_NL, "Raw" },
/* pl */ { IDS_RAW_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAW_SV, "Rtt" },
/* tr */ { IDS_RAW_TR, "Dz" },

/* en */ { IDS_JOYSTICK,    "Joystick" },
/* da */ { IDS_JOYSTICK_DA, "Joystick" },
/* de */ { IDS_JOYSTICK_DE, "Joystick" },
/* fr */ { IDS_JOYSTICK_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYSTICK_HU, "Botkormny" },
/* it */ { IDS_JOYSTICK_IT, "Joystick" },
/* nl */ { IDS_JOYSTICK_NL, "Joystick" },
/* pl */ { IDS_JOYSTICK_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOYSTICK_SV, "Styrspak" },
/* tr */ { IDS_JOYSTICK_TR, "Joystick" },

/* en */ { IDS_IRQ,    "IRQ" },
/* da */ { IDS_IRQ_DA, "IRQ" },
/* de */ { IDS_IRQ_DE, "IRQ" },
/* fr */ { IDS_IRQ_FR, "IRQ" },
/* hu */ { IDS_IRQ_HU, "IRQ" },
/* it */ { IDS_IRQ_IT, "IRQ" },
/* nl */ { IDS_IRQ_NL, "IRQ" },
/* pl */ { IDS_IRQ_PL, "" },  /* fuzzy */
/* sv */ { IDS_IRQ_SV, "IRQ" },
/* tr */ { IDS_IRQ_TR, "IRQ" },

/* en */ { IDS_NMI,    "NMI" },
/* da */ { IDS_NMI_DA, "NMI" },
/* de */ { IDS_NMI_DE, "NMI" },
/* fr */ { IDS_NMI_FR, "NMI" },
/* hu */ { IDS_NMI_HU, "NMI" },
/* it */ { IDS_NMI_IT, "NMI" },
/* nl */ { IDS_NMI_NL, "NMI" },
/* pl */ { IDS_NMI_PL, "" },  /* fuzzy */
/* sv */ { IDS_NMI_SV, "NMI" },
/* tr */ { IDS_NMI_TR, "NMI" },

/* en */ { IDS_ACIA_DEVICE,    "ACIA device" },
/* da */ { IDS_ACIA_DEVICE_DA, "ACIA-enhed" },
/* de */ { IDS_ACIA_DEVICE_DE, "ACIA Gert" },
/* fr */ { IDS_ACIA_DEVICE_FR, "Priphrique ACIA" },
/* hu */ { IDS_ACIA_DEVICE_HU, "ACIA eszkz" },
/* it */ { IDS_ACIA_DEVICE_IT, "Dispositivo ACIA" },
/* nl */ { IDS_ACIA_DEVICE_NL, "ACIA apparaat" },
/* pl */ { IDS_ACIA_DEVICE_PL, "Urzdzenia ACIA" },
/* sv */ { IDS_ACIA_DEVICE_SV, "ACIA-enhet" },
/* tr */ { IDS_ACIA_DEVICE_TR, "ACIA aygt" },

/* en */ { IDS_ACIA_INTERRUPT,    "ACIA interrupt" },
/* da */ { IDS_ACIA_INTERRUPT_DA, "ACIA-interrupt" },
/* de */ { IDS_ACIA_INTERRUPT_DE, "ACIA Interrupt" },
/* fr */ { IDS_ACIA_INTERRUPT_FR, "Interruption ACIA" },
/* hu */ { IDS_ACIA_INTERRUPT_HU, "ACIA megszakts" },
/* it */ { IDS_ACIA_INTERRUPT_IT, "Interrupt ACIA" },
/* nl */ { IDS_ACIA_INTERRUPT_NL, "ACIA interrupt" },
/* pl */ { IDS_ACIA_INTERRUPT_PL, "" },  /* fuzzy */
/* sv */ { IDS_ACIA_INTERRUPT_SV, "ACIA-avbrott" },
/* tr */ { IDS_ACIA_INTERRUPT_TR, "ACIA kesmesi" },

/* en */ { IDS_ACIA_MODE,    "ACIA mode" },
/* da */ { IDS_ACIA_MODE_DA, "ACIA-tilstand" },
/* de */ { IDS_ACIA_MODE_DE, "ACIA Modus" },
/* fr */ { IDS_ACIA_MODE_FR, "" },  /* fuzzy */
/* hu */ { IDS_ACIA_MODE_HU, "ACIA md" },
/* it */ { IDS_ACIA_MODE_IT, "Modalit ACIA" },
/* nl */ { IDS_ACIA_MODE_NL, "ACIA modus" },
/* pl */ { IDS_ACIA_MODE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ACIA_MODE_SV, "ACIA-lge" },
/* tr */ { IDS_ACIA_MODE_TR, "ACIA modu" },

/* en */ { IDS_ACIA_SETTINGS,    "ACIA Settings" },
/* da */ { IDS_ACIA_SETTINGS_DA, "ACIA-indstillinger" },
/* de */ { IDS_ACIA_SETTINGS_DE, "ACIA Einstellungen" },
/* fr */ { IDS_ACIA_SETTINGS_FR, "Paramtres ACIA" },
/* hu */ { IDS_ACIA_SETTINGS_HU, "ACIA belltsai" },
/* it */ { IDS_ACIA_SETTINGS_IT, "Impostazioni ACIA" },
/* nl */ { IDS_ACIA_SETTINGS_NL, "ACIA instellingen" },
/* pl */ { IDS_ACIA_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_ACIA_SETTINGS_SV, "ACIA-instllningar" },
/* tr */ { IDS_ACIA_SETTINGS_TR, "ACIA Ayarlar" },

/* en */ { IDS_256K_ENABLED,    "256K Enabled" },
/* da */ { IDS_256K_ENABLED_DA, "256K aktiveret" },
/* de */ { IDS_256K_ENABLED_DE, "256K aktiviert" },
/* fr */ { IDS_256K_ENABLED_FR, "" },  /* fuzzy */
/* hu */ { IDS_256K_ENABLED_HU, "256K engedlyezve" },
/* it */ { IDS_256K_ENABLED_IT, "256K attivi" },
/* nl */ { IDS_256K_ENABLED_NL, "256K aan" },
/* pl */ { IDS_256K_ENABLED_PL, "" },  /* fuzzy */
/* sv */ { IDS_256K_ENABLED_SV, "256K aktiverat" },
/* tr */ { IDS_256K_ENABLED_TR, "256K Aktif" },

/* en */ { IDS_256K_BASE,    "256K Base" },
/* da */ { IDS_256K_BASE_DA, "256K-base" },
/* de */ { IDS_256K_BASE_DE, "256K Basis" },
/* fr */ { IDS_256K_BASE_FR, "" },  /* fuzzy */
/* hu */ { IDS_256K_BASE_HU, "256K bziscm" },
/* it */ { IDS_256K_BASE_IT, "Indirizzo base 256K" },
/* nl */ { IDS_256K_BASE_NL, "256K basis" },
/* pl */ { IDS_256K_BASE_PL, "" },  /* fuzzy */
/* sv */ { IDS_256K_BASE_SV, "256K-bas" },
/* tr */ { IDS_256K_BASE_TR, "256K Taban" },

/* en */ { IDS_256K_FILENAME,    "256K file" },
/* da */ { IDS_256K_FILENAME_DA, "256K-fil" },
/* de */ { IDS_256K_FILENAME_DE, "256K Datei" },
/* fr */ { IDS_256K_FILENAME_FR, "Fichier 256K" },
/* hu */ { IDS_256K_FILENAME_HU, "256K fjl" },
/* it */ { IDS_256K_FILENAME_IT, "File 256K" },
/* nl */ { IDS_256K_FILENAME_NL, "256K bestand" },
/* pl */ { IDS_256K_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_256K_FILENAME_SV, "256K-fil" },
/* tr */ { IDS_256K_FILENAME_TR, "256K dosyas" },

/* en */ { IDS_256K_FILENAME_SELECT,    "Select file for 256K" },
/* da */ { IDS_256K_FILENAME_SELECT_DA, "Angiv fil for 256K" },
/* de */ { IDS_256K_FILENAME_SELECT_DE, "Datei fr 256K auswhlen" },
/* fr */ { IDS_256K_FILENAME_SELECT_FR, "Slectionner fichier pour 256K" },
/* hu */ { IDS_256K_FILENAME_SELECT_HU, "Vlasszon fjlt a 256K-hoz" },
/* it */ { IDS_256K_FILENAME_SELECT_IT, "Seleziona file per 256K" },
/* nl */ { IDS_256K_FILENAME_SELECT_NL, "Selecteer bestand voor 256K" },
/* pl */ { IDS_256K_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_256K_FILENAME_SELECT_SV, "Ange fil fr 256K" },
/* tr */ { IDS_256K_FILENAME_SELECT_TR, "256K iin dosya sein" },

/* en */ { IDS_256K_SETTINGS,    "256K Settings" },
/* da */ { IDS_256K_SETTINGS_DA, "256K-indstillinger" },
/* de */ { IDS_256K_SETTINGS_DE, "256K Einstellungen" },
/* fr */ { IDS_256K_SETTINGS_FR, "Paramtres 256K" },
/* hu */ { IDS_256K_SETTINGS_HU, "256K belltsai" },
/* it */ { IDS_256K_SETTINGS_IT, "Impostazioni 256K" },
/* nl */ { IDS_256K_SETTINGS_NL, "256K instellingen" },
/* pl */ { IDS_256K_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_256K_SETTINGS_SV, "256K-instllningar" },
/* tr */ { IDS_256K_SETTINGS_TR, "256K Ayarlar" },

/* en */ { IDS_C64DTV_ROM_FILENAME_SELECT,    "Select file for C64DTV ROM" },
/* da */ { IDS_C64DTV_ROM_FILENAME_SELECT_DA, "Vlg fil for C64DTV-ROM" },
/* de */ { IDS_C64DTV_ROM_FILENAME_SELECT_DE, "Datei fr C64DTV ROM auswhlen" },
/* fr */ { IDS_C64DTV_ROM_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_C64DTV_ROM_FILENAME_SELECT_HU, "Vlasszon fjlt a C64DTV ROM-hoz" },
/* it */ { IDS_C64DTV_ROM_FILENAME_SELECT_IT, "Seleziona il file per la ROM C64DTV" },
/* nl */ { IDS_C64DTV_ROM_FILENAME_SELECT_NL, "Selecteer bestand voor C64DTV ROM" },
/* pl */ { IDS_C64DTV_ROM_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_C64DTV_ROM_FILENAME_SELECT_SV, "Vlj fil fr C64DTV-ROM" },
/* tr */ { IDS_C64DTV_ROM_FILENAME_SELECT_TR, "C64DTV ROM'u iin dosya sein" },

/* en */ { IDS_C64DTV_ROM_FILENAME,    "C64DTV ROM file" },
/* da */ { IDS_C64DTV_ROM_FILENAME_DA, "C64DTV-ROM-fil" },
/* de */ { IDS_C64DTV_ROM_FILENAME_DE, "C64DTV ROM Datei" },
/* fr */ { IDS_C64DTV_ROM_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_C64DTV_ROM_FILENAME_HU, "C64DTV ROM fjl" },
/* it */ { IDS_C64DTV_ROM_FILENAME_IT, "File ROM C64DTV" },
/* nl */ { IDS_C64DTV_ROM_FILENAME_NL, "C64DTV ROM bestand" },
/* pl */ { IDS_C64DTV_ROM_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_C64DTV_ROM_FILENAME_SV, "C64DTV-ROM-fil" },
/* tr */ { IDS_C64DTV_ROM_FILENAME_TR, "C64DTV ROM dosyas" },

/* en */ { IDS_C64DTV_REVISION,    "DTV revision" },
/* da */ { IDS_C64DTV_REVISION_DA, "DTV-revision" },
/* de */ { IDS_C64DTV_REVISION_DE, "DTV Revision" },
/* fr */ { IDS_C64DTV_REVISION_FR, "" },  /* fuzzy */
/* hu */ { IDS_C64DTV_REVISION_HU, "" },  /* fuzzy */
/* it */ { IDS_C64DTV_REVISION_IT, "Revisione DTV" },
/* nl */ { IDS_C64DTV_REVISION_NL, "DTV revisie" },
/* pl */ { IDS_C64DTV_REVISION_PL, "" },  /* fuzzy */
/* sv */ { IDS_C64DTV_REVISION_SV, "DTV-utgva" },
/* tr */ { IDS_C64DTV_REVISION_TR, "DTV revizyonu" },

/* en */ { IDS_C64DTV_WRITE_ENABLE,    "Writes to C64DTV ROM" },
/* da */ { IDS_C64DTV_WRITE_ENABLE_DA, "Skrivning til C64DTV-ROM" },
/* de */ { IDS_C64DTV_WRITE_ENABLE_DE, "Schreibzugriff auf C64DTV ROM" },
/* fr */ { IDS_C64DTV_WRITE_ENABLE_FR, "" },  /* fuzzy */
/* hu */ { IDS_C64DTV_WRITE_ENABLE_HU, "C64DTV ROM-ba rsok" },
/* it */ { IDS_C64DTV_WRITE_ENABLE_IT, "Scrivi sulla ROM C64DTV" },
/* nl */ { IDS_C64DTV_WRITE_ENABLE_NL, "Schrijven naar C64DTV ROM" },
/* pl */ { IDS_C64DTV_WRITE_ENABLE_PL, "" },  /* fuzzy */
/* sv */ { IDS_C64DTV_WRITE_ENABLE_SV, "Skrivningar till C64DTV-ROM" },
/* tr */ { IDS_C64DTV_WRITE_ENABLE_TR, "C64DTV ROM'una yazar" },

/* en */ { IDS_C64DTV_HUMMER_ADC,    "Hummer ADC" },
/* da */ { IDS_C64DTV_HUMMER_ADC_DA, "Hummer ADC" },
/* de */ { IDS_C64DTV_HUMMER_ADC_DE, "Hummer ADC" },
/* fr */ { IDS_C64DTV_HUMMER_ADC_FR, "" },  /* fuzzy */
/* hu */ { IDS_C64DTV_HUMMER_ADC_HU, "" },  /* fuzzy */
/* it */ { IDS_C64DTV_HUMMER_ADC_IT, "Hummer ADC" },
/* nl */ { IDS_C64DTV_HUMMER_ADC_NL, "Hummer ADC" },
/* pl */ { IDS_C64DTV_HUMMER_ADC_PL, "" },  /* fuzzy */
/* sv */ { IDS_C64DTV_HUMMER_ADC_SV, "Hummer A/D-omvandlare" },
/* tr */ { IDS_C64DTV_HUMMER_ADC_TR, "Hummer ADC" },

/* en */ { IDS_C64DTV_SETTINGS,    "C64DTV Settings" },
/* da */ { IDS_C64DTV_SETTINGS_DA, "C64DTV-indstillinger" },
/* de */ { IDS_C64DTV_SETTINGS_DE, "C64DTV Einstellungen" },
/* fr */ { IDS_C64DTV_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_C64DTV_SETTINGS_HU, "C64DTV belltsai" },
/* it */ { IDS_C64DTV_SETTINGS_IT, "Impostazioni C64DTV" },
/* nl */ { IDS_C64DTV_SETTINGS_NL, "C64DTV Instellingen" },
/* pl */ { IDS_C64DTV_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_C64DTV_SETTINGS_SV, "C64DTV-instllningar" },
/* tr */ { IDS_C64DTV_SETTINGS_TR, "C64DTV Ayarlar" },

/* en */ { IDS_MODEL_LINE,    "model line" },
/* da */ { IDS_MODEL_LINE_DA, "modeltype" },
/* de */ { IDS_MODEL_LINE_DE, "Modell Linie" },
/* fr */ { IDS_MODEL_LINE_FR, "" },  /* fuzzy */
/* hu */ { IDS_MODEL_LINE_HU, "modell sor" },
/* it */ { IDS_MODEL_LINE_IT, "impostazioni del modello" },
/* nl */ { IDS_MODEL_LINE_NL, "modellijn" },
/* pl */ { IDS_MODEL_LINE_PL, "" },  /* fuzzy */
/* sv */ { IDS_MODEL_LINE_SV, "modelltyp" },
/* tr */ { IDS_MODEL_LINE_TR, "model hatt" },

/* en */ { IDS_RAM_SIZE,    "RAM Size" },
/* da */ { IDS_RAM_SIZE_DA, "RAM-strrelse" },
/* de */ { IDS_RAM_SIZE_DE, "RAM Gre" },
/* fr */ { IDS_RAM_SIZE_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_SIZE_HU, "RAM mrete" },
/* it */ { IDS_RAM_SIZE_IT, "Dimensione RAM" },
/* nl */ { IDS_RAM_SIZE_NL, "RAM grootte" },
/* pl */ { IDS_RAM_SIZE_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_SIZE_SV, "RAM-storlek" },
/* tr */ { IDS_RAM_SIZE_TR, "RAM Boyutu" },

/* en */ { IDS_RAM_BLOCK_0400_0FFF,    "RAM Block $0400-$0FFF" },
/* da */ { IDS_RAM_BLOCK_0400_0FFF_DA, "RAM-blok $0400-$0FFF" },
/* de */ { IDS_RAM_BLOCK_0400_0FFF_DE, "RAM Block $0400-$0FFF" },
/* fr */ { IDS_RAM_BLOCK_0400_0FFF_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_BLOCK_0400_0FFF_HU, "Memria blokk $0400-$0FFF" },
/* it */ { IDS_RAM_BLOCK_0400_0FFF_IT, "Blocco RAM $0400-$0FFF" },
/* nl */ { IDS_RAM_BLOCK_0400_0FFF_NL, "RAM blok $0400-$0FFF" },
/* pl */ { IDS_RAM_BLOCK_0400_0FFF_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_BLOCK_0400_0FFF_SV, "RAM-block $0400-$0FFF" },
/* tr */ { IDS_RAM_BLOCK_0400_0FFF_TR, "RAM Blok $0400-$0FFF" },

/* en */ { IDS_RAM_BLOCK_0800_0FFF,    "RAM Block $0800-$0FFF" },
/* da */ { IDS_RAM_BLOCK_0800_0FFF_DA, "RAM-blok $0800-$0FFF" },
/* de */ { IDS_RAM_BLOCK_0800_0FFF_DE, "RAM Block $0800-$0FFF" },
/* fr */ { IDS_RAM_BLOCK_0800_0FFF_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_BLOCK_0800_0FFF_HU, "Memria blokk $0800-$0FFF" },
/* it */ { IDS_RAM_BLOCK_0800_0FFF_IT, "Blocco RAM $0800-$0FFF" },
/* nl */ { IDS_RAM_BLOCK_0800_0FFF_NL, "RAM blok $0800-$0FFF" },
/* pl */ { IDS_RAM_BLOCK_0800_0FFF_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_BLOCK_0800_0FFF_SV, "RAM-block $0800-$0FFF" },
/* tr */ { IDS_RAM_BLOCK_0800_0FFF_TR, "RAM Blok $0800-$0FFF" },

/* en */ { IDS_RAM_BLOCK_1000_1FFF,    "RAM Block $1000-$1FFF" },
/* da */ { IDS_RAM_BLOCK_1000_1FFF_DA, "RAM-blok $1000-$1FFF" },
/* de */ { IDS_RAM_BLOCK_1000_1FFF_DE, "RAM Block $1000-$1FFF" },
/* fr */ { IDS_RAM_BLOCK_1000_1FFF_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_BLOCK_1000_1FFF_HU, "Memria blokk $1000-$1FFF" },
/* it */ { IDS_RAM_BLOCK_1000_1FFF_IT, "Blocco RAM $1000-$1FFF" },
/* nl */ { IDS_RAM_BLOCK_1000_1FFF_NL, "RAM blok $1000-$1FFF" },
/* pl */ { IDS_RAM_BLOCK_1000_1FFF_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_BLOCK_1000_1FFF_SV, "RAM-block $1000-$1FFF" },
/* tr */ { IDS_RAM_BLOCK_1000_1FFF_TR, "RAM Blok $1000-$1FFF" },

/* en */ { IDS_RAM_BLOCK_2000_3FFF,    "RAM Block $2000-$3FFF" },
/* da */ { IDS_RAM_BLOCK_2000_3FFF_DA, "RAM-blok $2000-$3FFF" },
/* de */ { IDS_RAM_BLOCK_2000_3FFF_DE, "RAM Block $2000-$3FFF" },
/* fr */ { IDS_RAM_BLOCK_2000_3FFF_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_BLOCK_2000_3FFF_HU, "Memria blokk $2000-$3FFF" },
/* it */ { IDS_RAM_BLOCK_2000_3FFF_IT, "Blocco RAM $2000-$3FFF" },
/* nl */ { IDS_RAM_BLOCK_2000_3FFF_NL, "RAM blok $2000-$3FFF" },
/* pl */ { IDS_RAM_BLOCK_2000_3FFF_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_BLOCK_2000_3FFF_SV, "RAM-block $2000-$3FFF" },
/* tr */ { IDS_RAM_BLOCK_2000_3FFF_TR, "RAM Blok $2000-$3FFF" },

/* en */ { IDS_RAM_BLOCK_4000_5FFF,    "RAM Block $4000-$5FFF" },
/* da */ { IDS_RAM_BLOCK_4000_5FFF_DA, "RAM-blok $4000-$5FFF" },
/* de */ { IDS_RAM_BLOCK_4000_5FFF_DE, "RAM Block $4000-$5FFF" },
/* fr */ { IDS_RAM_BLOCK_4000_5FFF_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_BLOCK_4000_5FFF_HU, "Memria blokk $4000-$5FFF" },
/* it */ { IDS_RAM_BLOCK_4000_5FFF_IT, "Blocco RAM $4000-$5FFF" },
/* nl */ { IDS_RAM_BLOCK_4000_5FFF_NL, "RAM blok $4000-$5FFF" },
/* pl */ { IDS_RAM_BLOCK_4000_5FFF_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_BLOCK_4000_5FFF_SV, "RAM-block $4000-$5FFF" },
/* tr */ { IDS_RAM_BLOCK_4000_5FFF_TR, "RAM Blok $4000-$5FFF" },

/* en */ { IDS_RAM_BLOCK_6000_7FFF,    "RAM Block $6000-$7FFF" },
/* da */ { IDS_RAM_BLOCK_6000_7FFF_DA, "RAM-blok $6000-$7FFF" },
/* de */ { IDS_RAM_BLOCK_6000_7FFF_DE, "RAM Block $6000-$7FFF" },
/* fr */ { IDS_RAM_BLOCK_6000_7FFF_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_BLOCK_6000_7FFF_HU, "Memria blokk $6000-$7FFF" },
/* it */ { IDS_RAM_BLOCK_6000_7FFF_IT, "Blocco RAM $6000-$7FFF" },
/* nl */ { IDS_RAM_BLOCK_6000_7FFF_NL, "RAM blok $6000-$7FFF" },
/* pl */ { IDS_RAM_BLOCK_6000_7FFF_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_BLOCK_6000_7FFF_SV, "RAM-block $6000-$7FFF" },
/* tr */ { IDS_RAM_BLOCK_6000_7FFF_TR, "RAM Blok $6000-$7FFF" },

/* en */ { IDS_RAM_BLOCK_A000_BFFF,    "RAM Block $A000-$BFFF" },
/* da */ { IDS_RAM_BLOCK_A000_BFFF_DA, "RAM-blok $A000-$BFFF" },
/* de */ { IDS_RAM_BLOCK_A000_BFFF_DE, "RAM Block $A000-$BFFF" },
/* fr */ { IDS_RAM_BLOCK_A000_BFFF_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_BLOCK_A000_BFFF_HU, "Memria blokk $A000-$BFFF" },
/* it */ { IDS_RAM_BLOCK_A000_BFFF_IT, "Blocco RAM $A000-$BFFF" },
/* nl */ { IDS_RAM_BLOCK_A000_BFFF_NL, "RAM blok $A000-$BFFF" },
/* pl */ { IDS_RAM_BLOCK_A000_BFFF_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_BLOCK_A000_BFFF_SV, "RAM-block $A000-$BFFF" },
/* tr */ { IDS_RAM_BLOCK_A000_BFFF_TR, "RAM Blok $A000-$BFFF" },

/* en */ { IDS_RAM_BLOCK_C000_CFFF,    "RAM Block $C000-$CFFF" },
/* da */ { IDS_RAM_BLOCK_C000_CFFF_DA, "RAM-blok $C000-$CFFF" },
/* de */ { IDS_RAM_BLOCK_C000_CFFF_DE, "RAM Block $C000-$CFFF" },
/* fr */ { IDS_RAM_BLOCK_C000_CFFF_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_BLOCK_C000_CFFF_HU, "Memria blokk $C000-$CFFF" },
/* it */ { IDS_RAM_BLOCK_C000_CFFF_IT, "Blocco RAM $C000-$CFFF" },
/* nl */ { IDS_RAM_BLOCK_C000_CFFF_NL, "RAM blok $C000-$CFFF" },
/* pl */ { IDS_RAM_BLOCK_C000_CFFF_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_BLOCK_C000_CFFF_SV, "RAM-block $C000-$CFFF" },
/* tr */ { IDS_RAM_BLOCK_C000_CFFF_TR, "RAM Blok $C000-$CFFF" },

/* en */ { IDS_CBM2_SETTINGS,    "CBM2 Settings" },
/* da */ { IDS_CBM2_SETTINGS_DA, "CBM2-indstillinger" },
/* de */ { IDS_CBM2_SETTINGS_DE, "CBM2 Einstellungen" },
/* fr */ { IDS_CBM2_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_CBM2_SETTINGS_HU, "CBM2 Belltsai" },
/* it */ { IDS_CBM2_SETTINGS_IT, "Impostazioni CBM2" },
/* nl */ { IDS_CBM2_SETTINGS_NL, "CBM2 instellingen" },
/* pl */ { IDS_CBM2_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_CBM2_SETTINGS_SV, "CBM2-instllningar" },
/* tr */ { IDS_CBM2_SETTINGS_TR, "CBM2 Ayarlar" },

/* en */ { IDS_RESET_DATASETTE_WITH_CPU,    "Reset Datasette with CPU" },
/* da */ { IDS_RESET_DATASETTE_WITH_CPU_DA, "Reset Datasette ved CPU-reset" },
/* de */ { IDS_RESET_DATASETTE_WITH_CPU_DE, "Zurcksetzen des Bandlaufwerks bei CPU Reset" },
/* fr */ { IDS_RESET_DATASETTE_WITH_CPU_FR, "" },  /* fuzzy */
/* hu */ { IDS_RESET_DATASETTE_WITH_CPU_HU, "Alaphelyzetbe hozs CPU Reset esetn" },
/* it */ { IDS_RESET_DATASETTE_WITH_CPU_IT, "Reset del registratore al reset della CPU" },
/* nl */ { IDS_RESET_DATASETTE_WITH_CPU_NL, "Reset Datasette met CPU" },
/* pl */ { IDS_RESET_DATASETTE_WITH_CPU_PL, "" },  /* fuzzy */
/* sv */ { IDS_RESET_DATASETTE_WITH_CPU_SV, "Nollstll Datasette med CPU" },
/* tr */ { IDS_RESET_DATASETTE_WITH_CPU_TR, "CPU ile birlikte Teyp'i resetle" },

/* en */ { IDS_ADDITIONAL_DELAY,    "Additional Delay" },
/* da */ { IDS_ADDITIONAL_DELAY_DA, "Yderligere forsinkelse" },
/* de */ { IDS_ADDITIONAL_DELAY_DE, "Zustzliche Verzgerung" },
/* fr */ { IDS_ADDITIONAL_DELAY_FR, "Dlai additionnel" },
/* hu */ { IDS_ADDITIONAL_DELAY_HU, "Tbblet sznet" },
/* it */ { IDS_ADDITIONAL_DELAY_IT, "Ritardo aggiuntivo" },
/* nl */ { IDS_ADDITIONAL_DELAY_NL, "Extra vertraging" },
/* pl */ { IDS_ADDITIONAL_DELAY_PL, "" },  /* fuzzy */
/* sv */ { IDS_ADDITIONAL_DELAY_SV, "Ytterligare frdrjning" },
/* tr */ { IDS_ADDITIONAL_DELAY_TR, "Ekstra Bekletme" },

/* en */ { IDS_DELAY_AT_ZERO_VALUES,    "Delay at Zero Values" },
/* da */ { IDS_DELAY_AT_ZERO_VALUES_DA, "Forsinkelse ved nulvrdier" },
/* de */ { IDS_DELAY_AT_ZERO_VALUES_DE, "Zyklen Verzgerung bei Zero-Werte" },
/* fr */ { IDS_DELAY_AT_ZERO_VALUES_FR, "" },  /* fuzzy */
/* hu */ { IDS_DELAY_AT_ZERO_VALUES_HU, "Sznet nulla rtkeknl" },
/* it */ { IDS_DELAY_AT_ZERO_VALUES_IT, "Ritardo ai valori di zero" },
/* nl */ { IDS_DELAY_AT_ZERO_VALUES_NL, "Nul-waarden cycli vertraging" },
/* pl */ { IDS_DELAY_AT_ZERO_VALUES_PL, "" },  /* fuzzy */
/* sv */ { IDS_DELAY_AT_ZERO_VALUES_SV, "Frdrjni vid nollvrden" },
/* tr */ { IDS_DELAY_AT_ZERO_VALUES_TR, "Zfr Deerlerinde Bekletme" },

/* en */ { IDS_DATASETTE_SETTINGS,    "Datasette Settings" },
/* da */ { IDS_DATASETTE_SETTINGS_DA, "Datasetteindstillinger" },
/* de */ { IDS_DATASETTE_SETTINGS_DE, "Datasette Einstellungen" },
/* fr */ { IDS_DATASETTE_SETTINGS_FR, "Rglages datassette" },
/* hu */ { IDS_DATASETTE_SETTINGS_HU, "Magn belltsai" },
/* it */ { IDS_DATASETTE_SETTINGS_IT, "Impostazioni registratore" },
/* nl */ { IDS_DATASETTE_SETTINGS_NL, "Datasette instellingen" },
/* pl */ { IDS_DATASETTE_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_DATASETTE_SETTINGS_SV, "Datasetteinstllningar" },
/* tr */ { IDS_DATASETTE_SETTINGS_TR, "Teyp Ayarlar" },

/* en */ { IDS_NEVER_EXTEND,    "Never extend" },
/* da */ { IDS_NEVER_EXTEND_DA, "Udvid aldrig" },
/* de */ { IDS_NEVER_EXTEND_DE, "Nie Erweitern" },
/* fr */ { IDS_NEVER_EXTEND_FR, "Ne jamais &tendre" },
/* hu */ { IDS_NEVER_EXTEND_HU, "Nincs kiterjeszts" },
/* it */ { IDS_NEVER_EXTEND_IT, "Mai" },
/* nl */ { IDS_NEVER_EXTEND_NL, "Nooit uitbreiden" },
/* pl */ { IDS_NEVER_EXTEND_PL, "" },  /* fuzzy */
/* sv */ { IDS_NEVER_EXTEND_SV, "Utka aldrig" },
/* tr */ { IDS_NEVER_EXTEND_TR, "Asla geniletme" },

/* en */ { IDS_ASK_ON_EXTEND,    "Ask on extend" },
/* da */ { IDS_ASK_ON_EXTEND_DA, "Sprg ved udviddelse" },
/* de */ { IDS_ASK_ON_EXTEND_DE, "Bei Erweiterung Rckfrage" },
/* fr */ { IDS_ASK_ON_EXTEND_FR, "Demander avant d'tendre" },
/* hu */ { IDS_ASK_ON_EXTEND_HU, "Krds kiterjeszts esetn" },
/* it */ { IDS_ASK_ON_EXTEND_IT, "Chiedi all'accesso" },
/* nl */ { IDS_ASK_ON_EXTEND_NL, "Vragen bij uitbreiden" },
/* pl */ { IDS_ASK_ON_EXTEND_PL, "" },  /* fuzzy */
/* sv */ { IDS_ASK_ON_EXTEND_SV, "Frga vid utkning" },
/* tr */ { IDS_ASK_ON_EXTEND_TR, "Geniletirken sor" },

/* en */ { IDS_EXTEND_ON_ACCESS,    "Extend on access" },
/* da */ { IDS_EXTEND_ON_ACCESS_DA, "Udvid ved tilgang" },
/* de */ { IDS_EXTEND_ON_ACCESS_DE, "Erweitern wenn ntig" },
/* fr */ { IDS_EXTEND_ON_ACCESS_FR, "tendre  l'accs" },
/* hu */ { IDS_EXTEND_ON_ACCESS_HU, "Kiterjeszts hozzfrskor" },
/* it */ { IDS_EXTEND_ON_ACCESS_IT, "All'accesso" },
/* nl */ { IDS_EXTEND_ON_ACCESS_NL, "Uitbreiden bij toegang" },
/* pl */ { IDS_EXTEND_ON_ACCESS_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXTEND_ON_ACCESS_SV, "Utka vid tkomst" },
/* tr */ { IDS_EXTEND_ON_ACCESS_TR, "Eriildiinde genilet" },

/* en */ { IDS_NO_TRAPS,    "No traps" },
/* da */ { IDS_NO_TRAPS_DA, "Ingen traps" },
/* de */ { IDS_NO_TRAPS_DE, "Keine Traps" },
/* fr */ { IDS_NO_TRAPS_FR, "" },  /* fuzzy */
/* hu */ { IDS_NO_TRAPS_HU, "Folyamatos emulci" },
/* it */ { IDS_NO_TRAPS_IT, "Non rilevare" },
/* nl */ { IDS_NO_TRAPS_NL, "Geen traps" },
/* pl */ { IDS_NO_TRAPS_PL, "" },  /* fuzzy */
/* sv */ { IDS_NO_TRAPS_SV, "Ingen infngning" },
/* tr */ { IDS_NO_TRAPS_TR, "Trap Yok" },

/* en */ { IDS_SKIP_CYCLES,    "Skip cycles" },
/* da */ { IDS_SKIP_CYCLES_DA, "Spring over cykler" },
/* de */ { IDS_SKIP_CYCLES_DE, "Zyklen auslassen" },
/* fr */ { IDS_SKIP_CYCLES_FR, "Sauter des cycles" },
/* hu */ { IDS_SKIP_CYCLES_HU, "Ciklusok kihagysa" },
/* it */ { IDS_SKIP_CYCLES_IT, "Salta cicli" },
/* nl */ { IDS_SKIP_CYCLES_NL, "Sla cycli over" },
/* pl */ { IDS_SKIP_CYCLES_PL, "" },  /* fuzzy */
/* sv */ { IDS_SKIP_CYCLES_SV, "Hoppa cykler" },
/* tr */ { IDS_SKIP_CYCLES_TR, "Cyclelar atla" },

/* en */ { IDS_TRAP_IDLE,    "Trap idle" },
/* da */ { IDS_TRAP_IDLE_DA, "Fang inaktive" },
/* de */ { IDS_TRAP_IDLE_DE, "Trap idle" },
/* fr */ { IDS_TRAP_IDLE_FR, "Traper linactivit" },
/* hu */ { IDS_TRAP_IDLE_HU, "res ciklusok kihagysa" },
/* it */ { IDS_TRAP_IDLE_IT, "Rileva inattivit" },
/* nl */ { IDS_TRAP_IDLE_NL, "Trap idle" },
/* pl */ { IDS_TRAP_IDLE_PL, "" },  /* fuzzy */
/* sv */ { IDS_TRAP_IDLE_SV, "Fnga inaktiva" },
/* tr */ { IDS_TRAP_IDLE_TR, "Trap boa vakit geirme" },

/* en */ { IDS_DRIVE_TYPE,    "Drive type" },
/* da */ { IDS_DRIVE_TYPE_DA, "Drevtype" },
/* de */ { IDS_DRIVE_TYPE_DE, "Gerte Typ" },
/* fr */ { IDS_DRIVE_TYPE_FR, "" },  /* fuzzy */
/* hu */ { IDS_DRIVE_TYPE_HU, "Lemezegysg tpus" },
/* it */ { IDS_DRIVE_TYPE_IT, "Tipo drive" },
/* nl */ { IDS_DRIVE_TYPE_NL, "Drivesoort" },
/* pl */ { IDS_DRIVE_TYPE_PL, "" },  /* fuzzy */
/* sv */ { IDS_DRIVE_TYPE_SV, "Enhetstyp" },
/* tr */ { IDS_DRIVE_TYPE_TR, "Src tipi" },

/* en */ { IDS_40_TRACK_HANDLING,    "40 track handling" },
/* da */ { IDS_40_TRACK_HANDLING_DA, "Hndtering af 40 spor" },
/* de */ { IDS_40_TRACK_HANDLING_DE, "40 Spur Umgang" },
/* fr */ { IDS_40_TRACK_HANDLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_40_TRACK_HANDLING_HU, "40 sv kezelse" },
/* it */ { IDS_40_TRACK_HANDLING_IT, "Gestione 40 tracce" },
/* nl */ { IDS_40_TRACK_HANDLING_NL, "40-sporenondersteuning" },
/* pl */ { IDS_40_TRACK_HANDLING_PL, "" },  /* fuzzy */
/* sv */ { IDS_40_TRACK_HANDLING_SV, "Hantering av 40 spr" },
/* tr */ { IDS_40_TRACK_HANDLING_TR, "40 track ileme" },

/* en */ { IDS_DRIVE_EXPANSION,    "Drive expansion" },
/* da */ { IDS_DRIVE_EXPANSION_DA, "Drevudviddelse" },
/* de */ { IDS_DRIVE_EXPANSION_DE, "Laufwerk Erweiterung" },
/* fr */ { IDS_DRIVE_EXPANSION_FR, "" },  /* fuzzy */
/* hu */ { IDS_DRIVE_EXPANSION_HU, "Lemezegysg bvts" },
/* it */ { IDS_DRIVE_EXPANSION_IT, "Espasione del drive" },
/* nl */ { IDS_DRIVE_EXPANSION_NL, "Drive uitbreiding" },
/* pl */ { IDS_DRIVE_EXPANSION_PL, "" },  /* fuzzy */
/* sv */ { IDS_DRIVE_EXPANSION_SV, "Enhetsutkning" },
/* tr */ { IDS_DRIVE_EXPANSION_TR, "Src genilemesi" },

/* en */ { IDS_IDLE_METHOD,    "Idle method" },
/* da */ { IDS_IDLE_METHOD_DA, "Pausemetode" },
/* de */ { IDS_IDLE_METHOD_DE, "Idle Methode" },
/* fr */ { IDS_IDLE_METHOD_FR, "" },  /* fuzzy */
/* hu */ { IDS_IDLE_METHOD_HU, "resjrat md" },
/* it */ { IDS_IDLE_METHOD_IT, "Rileva inattivit" },
/* nl */ { IDS_IDLE_METHOD_NL, "Idlemethode" },
/* pl */ { IDS_IDLE_METHOD_PL, "" },  /* fuzzy */
/* sv */ { IDS_IDLE_METHOD_SV, "Pausmetod" },
/* tr */ { IDS_IDLE_METHOD_TR, "Boa vakit geirme metodu" },

/* en */ { IDS_PARALLEL_CABLE,    "Parallel cable" },
/* da */ { IDS_PARALLEL_CABLE_DA, "Parallelkabel" },
/* de */ { IDS_PARALLEL_CABLE_DE, "Parallel Kabel" },
/* fr */ { IDS_PARALLEL_CABLE_FR, "" },  /* fuzzy */
/* hu */ { IDS_PARALLEL_CABLE_HU, "Prhuzamos kbel" },
/* it */ { IDS_PARALLEL_CABLE_IT, "Cavo parallelo" },
/* nl */ { IDS_PARALLEL_CABLE_NL, "Parallelle kabel" },
/* pl */ { IDS_PARALLEL_CABLE_PL, "" },  /* fuzzy */
/* sv */ { IDS_PARALLEL_CABLE_SV, "Parallellkabel" },
/* tr */ { IDS_PARALLEL_CABLE_TR, "Paralel kablo" },

/* en */ { IDS_DRIVE_SETTINGS,    "Drive settings" },
/* da */ { IDS_DRIVE_SETTINGS_DA, "Diskettedrevsindstillinger" },
/* de */ { IDS_DRIVE_SETTINGS_DE, "Floppy Einstellungen" },
/* fr */ { IDS_DRIVE_SETTINGS_FR, "Paramtres des lecteurs" },
/* hu */ { IDS_DRIVE_SETTINGS_HU, "Lemezegysg belltsai" },
/* it */ { IDS_DRIVE_SETTINGS_IT, "Impostazioni drive" },
/* nl */ { IDS_DRIVE_SETTINGS_NL, "Drive instellingen" },
/* pl */ { IDS_DRIVE_SETTINGS_PL, "Ustawienia napdu" },
/* sv */ { IDS_DRIVE_SETTINGS_SV, "Diskettenhetsinstllningar" },
/* tr */ { IDS_DRIVE_SETTINGS_TR, "Src ayarlar" },

/* en */ { IDS_GEORAM_SIZE,    "GEO-RAM size" },
/* da */ { IDS_GEORAM_SIZE_DA, "GEO-RAM-strrelse" },
/* de */ { IDS_GEORAM_SIZE_DE, "GEO-RAM Gre" },
/* fr */ { IDS_GEORAM_SIZE_FR, "" },  /* fuzzy */
/* hu */ { IDS_GEORAM_SIZE_HU, "" },  /* fuzzy */
/* it */ { IDS_GEORAM_SIZE_IT, "Dimensione GEO-RAM" },
/* nl */ { IDS_GEORAM_SIZE_NL, "GEO-RAM grootte" },
/* pl */ { IDS_GEORAM_SIZE_PL, "" },  /* fuzzy */
/* sv */ { IDS_GEORAM_SIZE_SV, "GEO-RAM-storlek" },
/* tr */ { IDS_GEORAM_SIZE_TR, "GEO-RAM boyutu" },

/* en */ { IDS_GEORAM_FILENAME,    "GEO-RAM file" },
/* da */ { IDS_GEORAM_FILENAME_DA, "GEO-RAM-fil" },
/* de */ { IDS_GEORAM_FILENAME_DE, "GEO-RAM Datei" },
/* fr */ { IDS_GEORAM_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_GEORAM_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_GEORAM_FILENAME_IT, "File GEO-RAM" },
/* nl */ { IDS_GEORAM_FILENAME_NL, "GEO-RAM bestand" },
/* pl */ { IDS_GEORAM_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_GEORAM_FILENAME_SV, "GEO-RAM-fil" },
/* tr */ { IDS_GEORAM_FILENAME_TR, "GEO-RAM dosyas" },

/* en */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED,    "Save GEO-RAM image when changed" },
/* da */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_DA, "Gem GEO-RAM image ved ndringer" },
/* de */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_DE, "GEO-RAM Imagedatei bei nderung speichern" },
/* fr */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_IT, "Salva immagine GEO-RAM al cambio" },
/* nl */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_NL, "GEO-RAM bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_SV, "Spara GEO-RAM-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_GEORAM_IMAGE_WHEN_CHANGED_TR, "GEO-RAM imaj deitiinde kaydet" },

/* en */ { IDS_GEORAM_FILENAME_SELECT,    "Select file for GEO-RAM" },
/* da */ { IDS_GEORAM_FILENAME_SELECT_DA, "Vlg fil for GEO-RAM" },
/* de */ { IDS_GEORAM_FILENAME_SELECT_DE, "Datei fr GEO-RAM auswhlen" },
/* fr */ { IDS_GEORAM_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_GEORAM_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_GEORAM_FILENAME_SELECT_IT, "Seleziona file per GEO-RAM" },
/* nl */ { IDS_GEORAM_FILENAME_SELECT_NL, "Selecteer bestand voor GEO-RAM" },
/* pl */ { IDS_GEORAM_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_GEORAM_FILENAME_SELECT_SV, "Vlj fil fr GEO-RAM" },
/* tr */ { IDS_GEORAM_FILENAME_SELECT_TR, "GEO-RAM iin dosya sein" },

/* en */ { IDS_GEORAM_SETTINGS,    "GEO-RAM settings" },
/* da */ { IDS_GEORAM_SETTINGS_DA, "GEO-RAM-indstillinger" },
/* de */ { IDS_GEORAM_SETTINGS_DE, "GEO-RAM Einstellungen" },
/* fr */ { IDS_GEORAM_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_GEORAM_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_GEORAM_SETTINGS_IT, "Impostazioni GEO-RAM" },
/* nl */ { IDS_GEORAM_SETTINGS_NL, "GEO-RAM instellingen" },
/* pl */ { IDS_GEORAM_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_GEORAM_SETTINGS_SV, "GEO-RAM-instllningar" },
/* tr */ { IDS_GEORAM_SETTINGS_TR, "GEO-RAM ayarlar" },

/* en */ { IDS_EXPERT_MODE,    "Expert Cartridge mode" },
/* da */ { IDS_EXPERT_MODE_DA, "Expert Cartridge-tilstand" },
/* de */ { IDS_EXPERT_MODE_DE, "Expert Cartridge Modus" },
/* fr */ { IDS_EXPERT_MODE_FR, "" },  /* fuzzy */
/* hu */ { IDS_EXPERT_MODE_HU, "" },  /* fuzzy */
/* it */ { IDS_EXPERT_MODE_IT, "Modalit Expert Cartridge" },
/* nl */ { IDS_EXPERT_MODE_NL, "Expert Cartridge modus" },
/* pl */ { IDS_EXPERT_MODE_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXPERT_MODE_SV, "Expert Cartridge-lge" },
/* tr */ { IDS_EXPERT_MODE_TR, "Expert Kartuu modu" },

/* en */ { IDS_OFF,    "Off" },
/* da */ { IDS_OFF_DA, "Slukket" },
/* de */ { IDS_OFF_DE, "Aus" },
/* fr */ { IDS_OFF_FR, "Off" },
/* hu */ { IDS_OFF_HU, "Ki" },
/* it */ { IDS_OFF_IT, "No" },
/* nl */ { IDS_OFF_NL, "Uit" },
/* pl */ { IDS_OFF_PL, "Wycz" },
/* sv */ { IDS_OFF_SV, "Av" },
/* tr */ { IDS_OFF_TR, "Kapal" },

/* en */ { IDS_PRG,    "Prg" },
/* da */ { IDS_PRG_DA, "Prg" },
/* de */ { IDS_PRG_DE, "Prg" },
/* fr */ { IDS_PRG_FR, "Prg" },
/* hu */ { IDS_PRG_HU, "Prg" },
/* it */ { IDS_PRG_IT, "Prg" },
/* nl */ { IDS_PRG_NL, "Prg" },
/* pl */ { IDS_PRG_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRG_SV, "Prg" },
/* tr */ { IDS_PRG_TR, "Prg" },

/* en */ { IDS_ON,    "On" },
/* da */ { IDS_ON_DA, "Tndt" },
/* de */ { IDS_ON_DE, "Ein" },
/* fr */ { IDS_ON_FR, "On" },
/* hu */ { IDS_ON_HU, "Be" },
/* it */ { IDS_ON_IT, "S" },
/* nl */ { IDS_ON_NL, "Aan" },
/* pl */ { IDS_ON_PL, "Wcz" },
/* sv */ { IDS_ON_SV, "P" },
/* tr */ { IDS_ON_TR, "Ak" },

/* en */ { IDS_EXPERT_FILENAME,    "Expert Cartridge file" },
/* da */ { IDS_EXPERT_FILENAME_DA, "Expert Cartridge-fil" },
/* de */ { IDS_EXPERT_FILENAME_DE, "Expert Cartridge Imagedatei" },
/* fr */ { IDS_EXPERT_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_EXPERT_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_EXPERT_FILENAME_IT, "File Expert Cartridge" },
/* nl */ { IDS_EXPERT_FILENAME_NL, "Expert Cartridge bestand" },
/* pl */ { IDS_EXPERT_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXPERT_FILENAME_SV, "Expert Cartridge-fil" },
/* tr */ { IDS_EXPERT_FILENAME_TR, "Expert Kartuu dosyas" },

/* en */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED,    "Save Expert Cartridge image when changed" },
/* da */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_DA, "Gem Expert Cartridge image ved ndringer" },
/* de */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_DE, "Expert Cartridge Imagedatei bei nderungen speichern" },
/* fr */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_IT, "Salva immagine Expert Cartridge al cambio" },
/* nl */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_NL, "Expert Cartridge bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_SV, "Spara Expert Cartrdige-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_EXPERT_IMAGE_WHEN_CHANGED_TR, "Expert Kartu imajn deitiinde kaydet" },

/* en */ { IDS_EXPERT_FILENAME_SELECT,    "Select file for Expert Cartridge" },
/* da */ { IDS_EXPERT_FILENAME_SELECT_DA, "Vlg fil for Expert Cartridge" },
/* de */ { IDS_EXPERT_FILENAME_SELECT_DE, "Export Cartridge Imagedatei auswhlen" },
/* fr */ { IDS_EXPERT_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_EXPERT_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_EXPERT_FILENAME_SELECT_IT, "Seleziona file per Expert Cartridge" },
/* nl */ { IDS_EXPERT_FILENAME_SELECT_NL, "Selecteer bestand voor Expert Cartridge" },
/* pl */ { IDS_EXPERT_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXPERT_FILENAME_SELECT_SV, "Vlj fil fr Expert Cartridge" },
/* tr */ { IDS_EXPERT_FILENAME_SELECT_TR, "Expert Kartuu iin dosya sein" },

/* en */ { IDS_EXPERT_SETTINGS,    "Expert Cartridge settings" },
/* da */ { IDS_EXPERT_SETTINGS_DA, "Expert Cartridge-indstillinger" },
/* de */ { IDS_EXPERT_SETTINGS_DE, "Expert Cartridge Einstellungen" },
/* fr */ { IDS_EXPERT_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_EXPERT_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_EXPERT_SETTINGS_IT, "Impostazioni Expert Cartridge" },
/* nl */ { IDS_EXPERT_SETTINGS_NL, "Expert Cartridge instellingen" },
/* pl */ { IDS_EXPERT_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXPERT_SETTINGS_SV, "Instllningar fr Expert Cartridge" },
/* tr */ { IDS_EXPERT_SETTINGS_TR, "Expert Kartuu ayarlar" },

/* en */ { IDS_DQBB_FILENAME,    "DQBB file" },
/* da */ { IDS_DQBB_FILENAME_DA, "DQBB-fil" },
/* de */ { IDS_DQBB_FILENAME_DE, "DQBB Datei" },
/* fr */ { IDS_DQBB_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_DQBB_FILENAME_HU, "DQBB fjl" },
/* it */ { IDS_DQBB_FILENAME_IT, "File DQBB" },
/* nl */ { IDS_DQBB_FILENAME_NL, "DQBB bestand" },
/* pl */ { IDS_DQBB_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_DQBB_FILENAME_SV, "DQBB-fil" },
/* tr */ { IDS_DQBB_FILENAME_TR, "DQBB dosyas" },

/* en */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED,    "Save DQBB image when changed" },
/* da */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_DA, "Gem DQBB image ved ndringer" },
/* de */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_DE, "DQBB Imagedatei bei nderung speichern" },
/* fr */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_IT, "Salva immagine DQBB al cambio" },
/* nl */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_NL, "DQBB bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_SV, "Spara DQBB-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_DQBB_IMAGE_WHEN_CHANGED_TR, "DQBB imaj deitiinde kaydet" },

/* en */ { IDS_DQBB_FILENAME_SELECT,    "Select file for DQBB" },
/* da */ { IDS_DQBB_FILENAME_SELECT_DA, "Vlg fil for DQBB" },
/* de */ { IDS_DQBB_FILENAME_SELECT_DE, "Datei fr DQBB auswhlen" },
/* fr */ { IDS_DQBB_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_DQBB_FILENAME_SELECT_HU, "Vlasszon fjlt a DQBB-hez" },
/* it */ { IDS_DQBB_FILENAME_SELECT_IT, "Seleziona file per DQBB" },
/* nl */ { IDS_DQBB_FILENAME_SELECT_NL, "Selecteer bestand voor DQBB" },
/* pl */ { IDS_DQBB_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_DQBB_FILENAME_SELECT_SV, "Vlj fil fr DQBB" },
/* tr */ { IDS_DQBB_FILENAME_SELECT_TR, "DQBB iin dosya se" },

/* en */ { IDS_DQBB_SETTINGS,    "DQBB settings" },
/* da */ { IDS_DQBB_SETTINGS_DA, "DQBB-indstillinger" },
/* de */ { IDS_DQBB_SETTINGS_DE, "DQBB Einstellungen" },
/* fr */ { IDS_DQBB_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_DQBB_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_DQBB_SETTINGS_IT, "Impostazioni DQBB" },
/* nl */ { IDS_DQBB_SETTINGS_NL, "DQBB instellingen" },
/* pl */ { IDS_DQBB_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_DQBB_SETTINGS_SV, "DQBB-instllningar" },
/* tr */ { IDS_DQBB_SETTINGS_TR, "DQBB ayarlar" },

/* en */ { IDS_ISEPIC_SETTINGS,    "ISEPIC settings" },
/* da */ { IDS_ISEPIC_SETTINGS_DA, "ISEPIC-indstillinger" },
/* de */ { IDS_ISEPIC_SETTINGS_DE, "ISEPIC Einstellungen" },
/* fr */ { IDS_ISEPIC_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_ISEPIC_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_ISEPIC_SETTINGS_IT, "Impostazioni ISEPIC" },
/* nl */ { IDS_ISEPIC_SETTINGS_NL, "ISEPIC instellingen" },
/* pl */ { IDS_ISEPIC_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_ISEPIC_SETTINGS_SV, "ISEPIC-instllningar" },
/* tr */ { IDS_ISEPIC_SETTINGS_TR, "ISEPIC ayarlar" },

/* en */ { IDS_ISEPIC_SWITCH,    "ISEPIC switch" },
/* da */ { IDS_ISEPIC_SWITCH_DA, "ISEPIC-kontakt" },
/* de */ { IDS_ISEPIC_SWITCH_DE, "ISEPIC Schalter" },
/* fr */ { IDS_ISEPIC_SWITCH_FR, "" },  /* fuzzy */
/* hu */ { IDS_ISEPIC_SWITCH_HU, "" },  /* fuzzy */
/* it */ { IDS_ISEPIC_SWITCH_IT, "Interruttore ISEPIC" },
/* nl */ { IDS_ISEPIC_SWITCH_NL, "ISEPIC schakelaar" },
/* pl */ { IDS_ISEPIC_SWITCH_PL, "" },  /* fuzzy */
/* sv */ { IDS_ISEPIC_SWITCH_SV, "ISEPIC-omkopplare" },
/* tr */ { IDS_ISEPIC_SWITCH_TR, "ISEPIC anahtar" },

/* en */ { IDS_ISEPIC_FILENAME,    "ISEPIC file" },
/* da */ { IDS_ISEPIC_FILENAME_DA, "ISEPIC-fil" },
/* de */ { IDS_ISEPIC_FILENAME_DE, "ISEPIC Imagedatei" },
/* fr */ { IDS_ISEPIC_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_ISEPIC_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_ISEPIC_FILENAME_IT, "File ISEPIC" },
/* nl */ { IDS_ISEPIC_FILENAME_NL, "ISEPIC bestand" },
/* pl */ { IDS_ISEPIC_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_ISEPIC_FILENAME_SV, "ISEPIC-fil" },
/* tr */ { IDS_ISEPIC_FILENAME_TR, "ISEPIC dosyas" },

/* en */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED,    "Save ISEPIC image when changed" },
/* da */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_DA, "Gem ISEPIC image ved ndringer" },
/* de */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_DE, "ISEPIC Imagedatei bei nderung speichern" },
/* fr */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_IT, "Salva immagine ISEPIC al cambio" },
/* nl */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_NL, "ISEPIC bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_SV, "Spara ISEPIC-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_ISEPIC_IMAGE_WHEN_CHANGED_TR, "ISEPIC imaj deitiinde kaydet" },

/* en */ { IDS_ISEPIC_FILENAME_SELECT,    "Select file for ISEPIC" },
/* da */ { IDS_ISEPIC_FILENAME_SELECT_DA, "Vlg fil for ISEPIC" },
/* de */ { IDS_ISEPIC_FILENAME_SELECT_DE, "Datei fr ISEPIC auswhlen" },
/* fr */ { IDS_ISEPIC_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_ISEPIC_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_ISEPIC_FILENAME_SELECT_IT, "Seleziona file per ISEPIC" },
/* nl */ { IDS_ISEPIC_FILENAME_SELECT_NL, "Selecteer bestand voor ISEPIC" },
/* pl */ { IDS_ISEPIC_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_ISEPIC_FILENAME_SELECT_SV, "Vlj fil fr ISEPIC" },
/* tr */ { IDS_ISEPIC_FILENAME_SELECT_TR, "ISEPIC iin dosya sein" },

/* en */ { IDS_EASYFLASH_SETTINGS,    "EasyFlash settings" },
/* da */ { IDS_EASYFLASH_SETTINGS_DA, "EasyFlash-indstillinger" },
/* de */ { IDS_EASYFLASH_SETTINGS_DE, "EasyFlash Einstellungen" },
/* fr */ { IDS_EASYFLASH_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_EASYFLASH_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_EASYFLASH_SETTINGS_IT, "Impostazioni EasyFlash" },
/* nl */ { IDS_EASYFLASH_SETTINGS_NL, "EasyFlash instellingen" },
/* pl */ { IDS_EASYFLASH_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_EASYFLASH_SETTINGS_SV, "EasyFlash-instllningar" },
/* tr */ { IDS_EASYFLASH_SETTINGS_TR, "EasyFlash ayarlar" },

/* en */ { IDS_CONFIG_FILENAME_SELECT,    "Select config file" },
/* da */ { IDS_CONFIG_FILENAME_SELECT_DA, "Vlg konfigurationsfil" },
/* de */ { IDS_CONFIG_FILENAME_SELECT_DE, "Konfigurationsdateiname definieren" },
/* fr */ { IDS_CONFIG_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_CONFIG_FILENAME_SELECT_HU, "Vlassza ki a konfigurcis fjlt" },
/* it */ { IDS_CONFIG_FILENAME_SELECT_IT, "Seleziona il file di configurazione" },
/* nl */ { IDS_CONFIG_FILENAME_SELECT_NL, "Selecteer configuratie bestand" },
/* pl */ { IDS_CONFIG_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_CONFIG_FILENAME_SELECT_SV, "Ange instllningsfil" },
/* tr */ { IDS_CONFIG_FILENAME_SELECT_TR, "Konfigrasyon dosyasn sein" },

/* en */ { IDS_JOYSTICK_IN_PORT_1,    "Joystick in port #1" },
/* da */ { IDS_JOYSTICK_IN_PORT_1_DA, "Joystick i port 1" },
/* de */ { IDS_JOYSTICK_IN_PORT_1_DE, "Joystick in Port #1" },
/* fr */ { IDS_JOYSTICK_IN_PORT_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYSTICK_IN_PORT_1_HU, "Botkormny az 1-es porton" },
/* it */ { IDS_JOYSTICK_IN_PORT_1_IT, "Joystick nella porta #1" },
/* nl */ { IDS_JOYSTICK_IN_PORT_1_NL, "Joystick in poort #1" },
/* pl */ { IDS_JOYSTICK_IN_PORT_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOYSTICK_IN_PORT_1_SV, "Styrspak i spelport 1" },
/* tr */ { IDS_JOYSTICK_IN_PORT_1_TR, "Joystick port #1'de" },

/* en */ { IDS_JOYSTICK_IN_PORT_2,    "Joystick in port #2" },
/* da */ { IDS_JOYSTICK_IN_PORT_2_DA, "Joystick i port 2" },
/* de */ { IDS_JOYSTICK_IN_PORT_2_DE, "Joystick in Port #2" },
/* fr */ { IDS_JOYSTICK_IN_PORT_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYSTICK_IN_PORT_2_HU, "Botkormny a 2-es porton" },
/* it */ { IDS_JOYSTICK_IN_PORT_2_IT, "Joystick nella porta #2" },
/* nl */ { IDS_JOYSTICK_IN_PORT_2_NL, "Joystick in poort #2" },
/* pl */ { IDS_JOYSTICK_IN_PORT_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOYSTICK_IN_PORT_2_SV, "Styrspak i spelport 2" },
/* tr */ { IDS_JOYSTICK_IN_PORT_2_TR, "Joystick port #2'de" },

/* en */ { IDS_USERPORT_ADAPTER,    "Userport joystick adapter" },
/* da */ { IDS_USERPORT_ADAPTER_DA, "Brugerportjoystickadapter" },
/* de */ { IDS_USERPORT_ADAPTER_DE, "Userport Joystick Adapter" },
/* fr */ { IDS_USERPORT_ADAPTER_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_ADAPTER_HU, "Userport botkormny adapter" },
/* it */ { IDS_USERPORT_ADAPTER_IT, "Adattatore joystick su userport" },
/* nl */ { IDS_USERPORT_ADAPTER_NL, "Userport joystick adapter" },
/* pl */ { IDS_USERPORT_ADAPTER_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_ADAPTER_SV, "Adapter fr anvndarportstyrspakar" },
/* tr */ { IDS_USERPORT_ADAPTER_TR, "Userport joystick dntrc" },

/* en */ { IDS_USERPORT_ADAPTER_TYPE,    "Userport joystick adapter type" },
/* da */ { IDS_USERPORT_ADAPTER_TYPE_DA, "Brugerportjoystickadapter-type" },
/* de */ { IDS_USERPORT_ADAPTER_TYPE_DE, "Userport Joystick Adadptertype" },
/* fr */ { IDS_USERPORT_ADAPTER_TYPE_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_ADAPTER_TYPE_HU, "Userport botkormny adapter tpusa" },
/* it */ { IDS_USERPORT_ADAPTER_TYPE_IT, "Tipo adattatore joystick su userport" },
/* nl */ { IDS_USERPORT_ADAPTER_TYPE_NL, "Userport joystick adapter model" },
/* pl */ { IDS_USERPORT_ADAPTER_TYPE_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_ADAPTER_TYPE_SV, "Typ av adapter fr anvndarportstyrspakar" },
/* tr */ { IDS_USERPORT_ADAPTER_TYPE_TR, "Userport joystick dntrc tipi" },

/* en */ { IDS_JOYSTICK_IN_USERPORT_PORT_1,    "Joystick in extra port #1" },
/* da */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_DA, "Joystick i ekstra port #1" },
/* de */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_DE, "Joystick in extra Port #1" },
/* fr */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_HU, "" },  /* fuzzy */
/* it */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_IT, "Joystick nella porta supplementare #1" },
/* nl */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_NL, "Joystick in extra poort #1" },
/* pl */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_SV, "Styrspak i extraport #1" },
/* tr */ { IDS_JOYSTICK_IN_USERPORT_PORT_1_TR, "Joystick ekstra port #1'de" },

/* en */ { IDS_JOYSTICK_IN_USERPORT_PORT_2,    "Joystick in extra port #2" },
/* da */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_DA, "Joystick i ekstra port #2" },
/* de */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_DE, "Joystick in extra Port #2" },
/* fr */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_HU, "" },  /* fuzzy */
/* it */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_IT, "Joystick nella porta supplementare #2" },
/* nl */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_NL, "Joystick in extra poort #2" },
/* pl */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_SV, "Styrspak i extraport #2" },
/* tr */ { IDS_JOYSTICK_IN_USERPORT_PORT_2_TR, "Joystick ekstra port #2'de" },

/* en */ { IDS_SIDCART_JOY,    "SIDcart joystick" },
/* da */ { IDS_SIDCART_JOY_DA, "SIDcart joystick" },
/* de */ { IDS_SIDCART_JOY_DE, "SIDcart Joystick" },
/* fr */ { IDS_SIDCART_JOY_FR, "" },  /* fuzzy */
/* hu */ { IDS_SIDCART_JOY_HU, "SIDcart botkormny" },
/* it */ { IDS_SIDCART_JOY_IT, "Joystick SIDcart" },
/* nl */ { IDS_SIDCART_JOY_NL, "SIDcart joystick" },
/* pl */ { IDS_SIDCART_JOY_PL, "" },  /* fuzzy */
/* sv */ { IDS_SIDCART_JOY_SV, "SIDcart-styrspak" },
/* tr */ { IDS_SIDCART_JOY_TR, "SID kartuu joystick'i" },


/* en */ { IDS_JOYSTICK_IN_SIDCART_PORT,    "Joystick in SIDcart joystick port" },
/* da */ { IDS_JOYSTICK_IN_SIDCART_PORT_DA, "Joystick i SIDcart joystickport" },
/* de */ { IDS_JOYSTICK_IN_SIDCART_PORT_DE, "Joystick in SIDcart Joystick Port" },
/* fr */ { IDS_JOYSTICK_IN_SIDCART_PORT_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOYSTICK_IN_SIDCART_PORT_HU, "Botkormny a SIDcart porton" },
/* it */ { IDS_JOYSTICK_IN_SIDCART_PORT_IT, "Joystick nella porta joystick su SIDcart" },
/* nl */ { IDS_JOYSTICK_IN_SIDCART_PORT_NL, "Joystick in SIDcart joystick poort" },
/* pl */ { IDS_JOYSTICK_IN_SIDCART_PORT_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOYSTICK_IN_SIDCART_PORT_SV, "Styrspak i SIDcart-spelport" },
/* tr */ { IDS_JOYSTICK_IN_SIDCART_PORT_TR, "Joystick SID kartuu joystick portuna takl" },

/* en */ { IDS_JOYSTICK_SETTINGS,    "Joystick settings" },
/* da */ { IDS_JOYSTICK_SETTINGS_DA, "Joystick indstillinger" },
/* de */ { IDS_JOYSTICK_SETTINGS_DE, "Joystick Einstellungen" },
/* fr */ { IDS_JOYSTICK_SETTINGS_FR, "Paramtres des joysticks" },
/* hu */ { IDS_JOYSTICK_SETTINGS_HU, "Botkormny belltsai" },
/* it */ { IDS_JOYSTICK_SETTINGS_IT, "Impostazioni joystick" },
/* nl */ { IDS_JOYSTICK_SETTINGS_NL, "Joystick instellingen" },
/* pl */ { IDS_JOYSTICK_SETTINGS_PL, "Ustawienia joystcka" },
/* sv */ { IDS_JOYSTICK_SETTINGS_SV, "Instllningar fr styrspak" },
/* tr */ { IDS_JOYSTICK_SETTINGS_TR, "Joystick ayarlar" },

/* en */ { IDS_KEYPAD,    "Numpad" },
/* da */ { IDS_KEYPAD_DA, "Numerisk tastatur" },
/* de */ { IDS_KEYPAD_DE, "Ziffernblock" },
/* fr */ { IDS_KEYPAD_FR, "" },  /* fuzzy */
/* hu */ { IDS_KEYPAD_HU, "Numerikus billentyk" },
/* it */ { IDS_KEYPAD_IT, "Tastierino numerico" },
/* nl */ { IDS_KEYPAD_NL, "Numpad" },
/* pl */ { IDS_KEYPAD_PL, "" },  /* fuzzy */
/* sv */ { IDS_KEYPAD_SV, "Numeriskt tangentbord" },
/* tr */ { IDS_KEYPAD_TR, "Numpad" },

/* en */ { IDS_JOY_PORT_0,    "Joy Port 0" },
/* da */ { IDS_JOY_PORT_0_DA, "Joystickport 0" },
/* de */ { IDS_JOY_PORT_0_DE, "Joystick Port 0" },
/* fr */ { IDS_JOY_PORT_0_FR, "Port joystick 0" },
/* hu */ { IDS_JOY_PORT_0_HU, "Botkormny port 0" },
/* it */ { IDS_JOY_PORT_0_IT, "Joystick nella porta 0" },
/* nl */ { IDS_JOY_PORT_0_NL, "Joy Poort 0" },
/* pl */ { IDS_JOY_PORT_0_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOY_PORT_0_SV, "Spelport 0" },
/* tr */ { IDS_JOY_PORT_0_TR, "Joy Port 0" },

/* en */ { IDS_JOY_PORT_1,    "Joy Port 1" },
/* da */ { IDS_JOY_PORT_1_DA, "Joystickport 1" },
/* de */ { IDS_JOY_PORT_1_DE, "Joystick Port 1" },
/* fr */ { IDS_JOY_PORT_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOY_PORT_1_HU, "Botkormny port 1" },
/* it */ { IDS_JOY_PORT_1_IT, "Joystick nella porta 1" },
/* nl */ { IDS_JOY_PORT_1_NL, "Joy Poort 1" },
/* pl */ { IDS_JOY_PORT_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOY_PORT_1_SV, "Spelport 1" },
/* tr */ { IDS_JOY_PORT_1_TR, "Joy Port 1" },

/* en */ { IDS_JOY_PORT_2,    "Joy Port 2" },
/* da */ { IDS_JOY_PORT_2_DA, "Joystickport 2" },
/* de */ { IDS_JOY_PORT_2_DE, "Joystick Port 2" },
/* fr */ { IDS_JOY_PORT_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_JOY_PORT_2_HU, "Botkormny port 2" },
/* it */ { IDS_JOY_PORT_2_IT, "Joystick nella porta 2" },
/* nl */ { IDS_JOY_PORT_2_NL, "Joy Poort 2" },
/* pl */ { IDS_JOY_PORT_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOY_PORT_2_SV, "Spelport 2" },
/* tr */ { IDS_JOY_PORT_2_TR, "Joy Port 2" },

/* en */ { IDS_JOY_PORT_3,    "Joy Port 3" },
/* da */ { IDS_JOY_PORT_3_DA, "Joystickport 2" },
/* de */ { IDS_JOY_PORT_3_DE, "Joystick Port 3" },
/* fr */ { IDS_JOY_PORT_3_FR, "Port joystick 3" },
/* hu */ { IDS_JOY_PORT_3_HU, "Botkormny port 3" },
/* it */ { IDS_JOY_PORT_3_IT, "Joystick nella porta 3" },
/* nl */ { IDS_JOY_PORT_3_NL, "Joy Poort 3" },
/* pl */ { IDS_JOY_PORT_3_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOY_PORT_3_SV, "Spelport 2" },
/* tr */ { IDS_JOY_PORT_3_TR, "Joy Port 3" },

/* en */ { IDS_STOP_BLUE,    "Stop/Blue" },
/* da */ { IDS_STOP_BLUE_DA, "Stop/Bl" },
/* de */ { IDS_STOP_BLUE_DE, "Stop/Blau" },
/* fr */ { IDS_STOP_BLUE_FR, "Arrt/Bleu" },
/* hu */ { IDS_STOP_BLUE_HU, "Lellt/Kk" },
/* it */ { IDS_STOP_BLUE_IT, "Stop/Blu" },
/* nl */ { IDS_STOP_BLUE_NL, "Stop/Blauw" },
/* pl */ { IDS_STOP_BLUE_PL, "" },  /* fuzzy */
/* sv */ { IDS_STOP_BLUE_SV, "Stopp/Bl" },
/* tr */ { IDS_STOP_BLUE_TR, "Durdur/Mavi" },

/* en */ { IDS_SELECT_RED,    "Select/Red" },
/* da */ { IDS_SELECT_RED_DA, "Vlg/Rd" },
/* de */ { IDS_SELECT_RED_DE, "Auswahl/Rot" },
/* fr */ { IDS_SELECT_RED_FR, "Slectionner/Rouge" },
/* hu */ { IDS_SELECT_RED_HU, "Kivlaszt/Piros" },
/* it */ { IDS_SELECT_RED_IT, "Seleziona/Rosso" },
/* nl */ { IDS_SELECT_RED_NL, "Selecy/Rood" },
/* pl */ { IDS_SELECT_RED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_RED_SV, "Vlj/Rd" },
/* tr */ { IDS_SELECT_RED_TR, "Seim/Krmz" },

/* en */ { IDS_REPEAT_YELLOW,    "Repeat/Yellow" },
/* da */ { IDS_REPEAT_YELLOW_DA, "Gentag/Gul" },
/* de */ { IDS_REPEAT_YELLOW_DE, "Wiederhole/Gelb" },
/* fr */ { IDS_REPEAT_YELLOW_FR, "Rpter/Jaune" },
/* hu */ { IDS_REPEAT_YELLOW_HU, "Ismtel/Srga" },
/* it */ { IDS_REPEAT_YELLOW_IT, "Ripeti/Giallo" },
/* nl */ { IDS_REPEAT_YELLOW_NL, "Repeat/Geel" },
/* pl */ { IDS_REPEAT_YELLOW_PL, "" },  /* fuzzy */
/* sv */ { IDS_REPEAT_YELLOW_SV, "Repetera/Gul" },
/* tr */ { IDS_REPEAT_YELLOW_TR, "Tekrar/Sar" },

/* en */ { IDS_SHUFFLE_GREEN,    "Shuffle/Green" },
/* da */ { IDS_SHUFFLE_GREEN_DA, "Bland/Grn" },
/* de */ { IDS_SHUFFLE_GREEN_DE, "Mische/Grn" },
/* fr */ { IDS_SHUFFLE_GREEN_FR, "Mlanger/Vert" },
/* hu */ { IDS_SHUFFLE_GREEN_HU, "Vletlenszer/Zld" },
/* it */ { IDS_SHUFFLE_GREEN_IT, "Mischia/Verde" },
/* nl */ { IDS_SHUFFLE_GREEN_NL, "Shuffle/Groen" },
/* pl */ { IDS_SHUFFLE_GREEN_PL, "" },  /* fuzzy */
/* sv */ { IDS_SHUFFLE_GREEN_SV, "Blanda/Grn" },
/* tr */ { IDS_SHUFFLE_GREEN_TR, "Kartr/Yeil" },

/* en */ { IDS_FORWARD_CHARCOAL,    "Forward/Charcoal" },
/* da */ { IDS_FORWARD_CHARCOAL_DA, "Fremad/Grafit" },
/* de */ { IDS_FORWARD_CHARCOAL_DE, "Vorwrts/Kohle" },
/* fr */ { IDS_FORWARD_CHARCOAL_FR, "Avancer/Charcoal" },
/* hu */ { IDS_FORWARD_CHARCOAL_HU, "Elre/Fekete" },
/* it */ { IDS_FORWARD_CHARCOAL_IT, "Avanti/Carboncino" },
/* nl */ { IDS_FORWARD_CHARCOAL_NL, "Forward/Charcoal" },
/* pl */ { IDS_FORWARD_CHARCOAL_PL, "" },  /* fuzzy */
/* sv */ { IDS_FORWARD_CHARCOAL_SV, "Framt/Svart" },
/* tr */ { IDS_FORWARD_CHARCOAL_TR, "leri/Kmr" },

/* en */ { IDS_REVERSE_CHARCOAL,    "Reverse/Charcoal" },
/* da */ { IDS_REVERSE_CHARCOAL_DA, "Bagud/Grafit" },
/* de */ { IDS_REVERSE_CHARCOAL_DE, "Rckwrts/Kohle" },
/* fr */ { IDS_REVERSE_CHARCOAL_FR, "Reculer/Charcoal" },
/* hu */ { IDS_REVERSE_CHARCOAL_HU, "Vissza/Fekete" },
/* it */ { IDS_REVERSE_CHARCOAL_IT, "Indietro/Carboncino" },
/* nl */ { IDS_REVERSE_CHARCOAL_NL, "Reverse/Charcoal" },
/* pl */ { IDS_REVERSE_CHARCOAL_PL, "" },  /* fuzzy */
/* sv */ { IDS_REVERSE_CHARCOAL_SV, "Bakt/Svart" },
/* tr */ { IDS_REVERSE_CHARCOAL_TR, "Ters/Kmr" },

/* en */ { IDS_PLAY_PAUSE_GREY,    "Play-Pause/Grey" },
/* da */ { IDS_PLAY_PAUSE_GREY_DA, "Play-Pause/Gr" },
/* de */ { IDS_PLAY_PAUSE_GREY_DE, "Play-Pause/Grau" },
/* fr */ { IDS_PLAY_PAUSE_GREY_FR, "Play-Pause/Gris" },
/* hu */ { IDS_PLAY_PAUSE_GREY_HU, "Lejtszs-Megllts/Szrke" },
/* it */ { IDS_PLAY_PAUSE_GREY_IT, "Avvia-Pausa/Grigio" },
/* nl */ { IDS_PLAY_PAUSE_GREY_NL, "Play-Pause/Grijs" },
/* pl */ { IDS_PLAY_PAUSE_GREY_PL, "" },  /* fuzzy */
/* sv */ { IDS_PLAY_PAUSE_GREY_SV, "Spela-Paus/Gr" },
/* tr */ { IDS_PLAY_PAUSE_GREY_TR, "al-Duraklat/Gri" },

/* en */ { IDS_JOY_1_DEVICE,    "Joy 1 Device" },
/* da */ { IDS_JOY_1_DEVICE_DA, "Joystick 1 enhed" },
/* de */ { IDS_JOY_1_DEVICE_DE, "Joystick 1 Gert" },
/* fr */ { IDS_JOY_1_DEVICE_FR, "Priphrique joystick 1" },
/* hu */ { IDS_JOY_1_DEVICE_HU, "1-es botkormny eszkz" },
/* it */ { IDS_JOY_1_DEVICE_IT, "Dispositivo Joystick 1" },
/* nl */ { IDS_JOY_1_DEVICE_NL, "Joy 1 apparaat" },
/* pl */ { IDS_JOY_1_DEVICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOY_1_DEVICE_SV, "Enhet fr styrspak 1" },
/* tr */ { IDS_JOY_1_DEVICE_TR, "Joy 1 Aygt" },

/* en */ { IDS_JOY_2_DEVICE,    "Joy 2 Device" },
/* da */ { IDS_JOY_2_DEVICE_DA, "Joystick 2 enhed" },
/* de */ { IDS_JOY_2_DEVICE_DE, "Joystick 2 Gert" },
/* fr */ { IDS_JOY_2_DEVICE_FR, "Priphrique joystick 2" },
/* hu */ { IDS_JOY_2_DEVICE_HU, "2-es botkormny eszkz" },
/* it */ { IDS_JOY_2_DEVICE_IT, "Dispositivo Joystick 2" },
/* nl */ { IDS_JOY_2_DEVICE_NL, "Joy 2 apparaat" },
/* pl */ { IDS_JOY_2_DEVICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOY_2_DEVICE_SV, "Enhet fr styrspak 2" },
/* tr */ { IDS_JOY_2_DEVICE_TR, "Joy 2 Aygt" },

/* en */ { IDS_USERPORT_JOY_1_DEVICE,    "Userport Joy 1 Device" },
/* da */ { IDS_USERPORT_JOY_1_DEVICE_DA, "Brugerport Joystick 1 enhed" },
/* de */ { IDS_USERPORT_JOY_1_DEVICE_DE, "Userport Joystick 1 Gert" },
/* fr */ { IDS_USERPORT_JOY_1_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_JOY_1_DEVICE_HU, "Userport 1-es botkormny eszkz" },
/* it */ { IDS_USERPORT_JOY_1_DEVICE_IT, "Dispositivo joystick 1 su userport" },
/* nl */ { IDS_USERPORT_JOY_1_DEVICE_NL, "Userport Joy 1 apparaat" },
/* pl */ { IDS_USERPORT_JOY_1_DEVICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_JOY_1_DEVICE_SV, "Anvndarportspak 1 enhet" },
/* tr */ { IDS_USERPORT_JOY_1_DEVICE_TR, "Userport Joy 1 Aygt" },

/* en */ { IDS_USERPORT_JOY_2_DEVICE,    "Userport Joy 2 Device" },
/* da */ { IDS_USERPORT_JOY_2_DEVICE_DA, "Brugerport Joystick 2 enhed" },
/* de */ { IDS_USERPORT_JOY_2_DEVICE_DE, "Userport Joystick 2 Gert" },
/* fr */ { IDS_USERPORT_JOY_2_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_JOY_2_DEVICE_HU, "Userport 2-es botkormny eszkz" },
/* it */ { IDS_USERPORT_JOY_2_DEVICE_IT, "Dispositivo joystick 2 su userport" },
/* nl */ { IDS_USERPORT_JOY_2_DEVICE_NL, "Userport Joy 2 apparaat" },
/* pl */ { IDS_USERPORT_JOY_2_DEVICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_JOY_2_DEVICE_SV, "Anvndarportspak 2 enhet" },
/* tr */ { IDS_USERPORT_JOY_2_DEVICE_TR, "Userport Joy 2 Aygt" },

/* en */ { IDS_SIDCART_JOY_DEVICE,    "SIDcart Joy Device" },
/* da */ { IDS_SIDCART_JOY_DEVICE_DA, "SIDcart joystick-enhed" },
/* de */ { IDS_SIDCART_JOY_DEVICE_DE, "SIDcart Joystick Gert" },
/* fr */ { IDS_SIDCART_JOY_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SIDCART_JOY_DEVICE_HU, "SIDcart botkormny eszkz" },
/* it */ { IDS_SIDCART_JOY_DEVICE_IT, "Dispositivo Joystick SIDcart" },
/* nl */ { IDS_SIDCART_JOY_DEVICE_NL, "SIDcart Joy apparaat" },
/* pl */ { IDS_SIDCART_JOY_DEVICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SIDCART_JOY_DEVICE_SV, "SIDcart-spakenhet" },
/* tr */ { IDS_SIDCART_JOY_DEVICE_TR, "SID Kartuu Joy Aygt" },

/* en */ { IDS_JOY_1_FIRE,    "Joy 1 Fire" },
/* da */ { IDS_JOY_1_FIRE_DA, "Joystick 1 skydeknap" },
/* de */ { IDS_JOY_1_FIRE_DE, "Joystick 1 Feuer" },
/* fr */ { IDS_JOY_1_FIRE_FR, "Jeu joystick 1" },
/* hu */ { IDS_JOY_1_FIRE_HU, "1-es botkormny tz" },
/* it */ { IDS_JOY_1_FIRE_IT, "Fuoco Joystick 1" },
/* nl */ { IDS_JOY_1_FIRE_NL, "Joy 1 Vuur" },
/* pl */ { IDS_JOY_1_FIRE_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOY_1_FIRE_SV, "Fire fr styrspak 1" },
/* tr */ { IDS_JOY_1_FIRE_TR, "Joy 1 Ate" },

/* en */ { IDS_JOY_2_FIRE,    "Joy 2 Fire" },
/* da */ { IDS_JOY_2_FIRE_DA, "Joystick 2 skydeknap" },
/* de */ { IDS_JOY_2_FIRE_DE, "Joystick 2 Feuer" },
/* fr */ { IDS_JOY_2_FIRE_FR, "Jeu joystick 2" },
/* hu */ { IDS_JOY_2_FIRE_HU, "2-es botkormny tz" },
/* it */ { IDS_JOY_2_FIRE_IT, "Fuoco Joystick 2" },
/* nl */ { IDS_JOY_2_FIRE_NL, "Joy 2 Vuur" },
/* pl */ { IDS_JOY_2_FIRE_PL, "" },  /* fuzzy */
/* sv */ { IDS_JOY_2_FIRE_SV, "Fire fr styrspak 2" },
/* tr */ { IDS_JOY_2_FIRE_TR, "Joy 2 Ate" },

/* en */ { IDS_USERPORT_JOY_1_FIRE,    "Userport Joy 1 Fire" },
/* da */ { IDS_USERPORT_JOY_1_FIRE_DA, "Brugerport joystick 1 skydeknap" },
/* de */ { IDS_USERPORT_JOY_1_FIRE_DE, "Userport Joystick 1 Feuer" },
/* fr */ { IDS_USERPORT_JOY_1_FIRE_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_JOY_1_FIRE_HU, "1-es userport botkormny tz" },
/* it */ { IDS_USERPORT_JOY_1_FIRE_IT, "Fuoco joystick 1 su userport" },
/* nl */ { IDS_USERPORT_JOY_1_FIRE_NL, "Userport Joy 1 Vuur" },
/* pl */ { IDS_USERPORT_JOY_1_FIRE_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_JOY_1_FIRE_SV, "Anvndarportspak 1 fire" },
/* tr */ { IDS_USERPORT_JOY_1_FIRE_TR, "Userport Joy 1 Ate" },

/* en */ { IDS_USERPORT_JOY_2_FIRE,    "Userport Joy 2 Fire" },
/* da */ { IDS_USERPORT_JOY_2_FIRE_DA, "Brugerport joystick 2 skydeknap" },
/* de */ { IDS_USERPORT_JOY_2_FIRE_DE, "Userport Joystick 2 Feuer" },
/* fr */ { IDS_USERPORT_JOY_2_FIRE_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_JOY_2_FIRE_HU, "2-es userport botkormny tz" },
/* it */ { IDS_USERPORT_JOY_2_FIRE_IT, "Fuoco joystick 2 su userport" },
/* nl */ { IDS_USERPORT_JOY_2_FIRE_NL, "Userport Joy 2 Vuur" },
/* pl */ { IDS_USERPORT_JOY_2_FIRE_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_JOY_2_FIRE_SV, "Anvndarportspak 2 fire" },
/* tr */ { IDS_USERPORT_JOY_2_FIRE_TR, "Userport Joy 2 Ate" },

/* en */ { IDS_SIDCART_JOY_FIRE,    "SIDcart Joy Fire" },
/* da */ { IDS_SIDCART_JOY_FIRE_DA, "SIDcart joystick skydeknap" },
/* de */ { IDS_SIDCART_JOY_FIRE_DE, "SIDcart Joystick Feuer" },
/* fr */ { IDS_SIDCART_JOY_FIRE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SIDCART_JOY_FIRE_HU, "SIDcart botkormny tz" },
/* it */ { IDS_SIDCART_JOY_FIRE_IT, "Fuoco joystick su SIDcart" },
/* nl */ { IDS_SIDCART_JOY_FIRE_NL, "SIDcart Joy Vuur" },
/* pl */ { IDS_SIDCART_JOY_FIRE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SIDCART_JOY_FIRE_SV, "SIDcart-spak fire" },
/* tr */ { IDS_SIDCART_JOY_FIRE_TR, "SID kartuu Joy Ate" },

/* en */ { IDS_SET_INPUT_JOYSTICK_1,    "Joystick #1 emulation: (0:None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* da */ { IDS_SET_INPUT_JOYSTICK_1_DA, "Emulering af Joystick 1: (0: ingen, 1: numerisk, 2: tastest A/AI, 3: tastest B/AI)" },
/* de */ { IDS_SET_INPUT_JOYSTICK_1_DE, "Joystick #1 Emulation: (0:Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
/* fr */ { IDS_SET_INPUT_JOYSTICK_1_FR, "mulation Joystick #1: (0:Aucun, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* hu */ { IDS_SET_INPUT_JOYSTICK_1_HU, "#1-es botkormny emulci: (0: Nincs, 1: numerikus, 2: 'A' gombkszlet, 3: 'B' gombkszlet)" },
/* it */ { IDS_SET_INPUT_JOYSTICK_1_IT, "Emulazione joystick #1: (0: Nessuna, 1: Tastierino numerico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* nl */ { IDS_SET_INPUT_JOYSTICK_1_NL, "Emulatie joystick #1: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* pl */ { IDS_SET_INPUT_JOYSTICK_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_JOYSTICK_1_SV, "Emulering fr styrspak 1: (0: ingen, 1: numerisk, 2: tangentuppsttning A/AI, 3: tangentuppsttning B/AI)" },
/* tr */ { IDS_SET_INPUT_JOYSTICK_1_TR, "Joystick #1 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: Tu Seti B/AI)" },

/* en */ { IDS_SET_INPUT_JOYSTICK_2,    "Joystick #2 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* da */ { IDS_SET_INPUT_JOYSTICK_2_DA, "Emulering af Joystick 2: (0: ingen, 1: numerisk, 2: tastest A/AI, 3: tastest B/AI)" },
/* de */ { IDS_SET_INPUT_JOYSTICK_2_DE, "Joystick #2 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
/* fr */ { IDS_SET_INPUT_JOYSTICK_2_FR, "mulation joystick #2: (0: Aucune, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* hu */ { IDS_SET_INPUT_JOYSTICK_2_HU, "#2-es botkormny emulci: (0: Nincs, 1: numerikus, 2: 'A' gombkszlet, 3: 'B' gombkszlet)" },
/* it */ { IDS_SET_INPUT_JOYSTICK_2_IT, "Emulazione joystick #2: (0: Nessuna, 1: Tastierino numerico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* nl */ { IDS_SET_INPUT_JOYSTICK_2_NL, "Emulatie joystick #2: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* pl */ { IDS_SET_INPUT_JOYSTICK_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_JOYSTICK_2_SV, "Emulering fr styrspak 2: (0: ingen, 1: numerisk, 2: tangentuppsttning A/AI, 3: tangentuppsttning B/AI)" },
/* tr */ { IDS_SET_INPUT_JOYSTICK_2_TR, "Joystick #2 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: Tu Seti B/AI)" },

/* en */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1,    "Extra joystick #1 emulation: (0:None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_DA, "Emulering af Joystick 1: (0: ingen, 1: numerisk, 2: tastest A/AI, 3: tastest B/AI)" },
/* de */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_DE, "Extra Joystick #1 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
/* fr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_HU, "" },  /* fuzzy */
/* it */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_IT, "Emulazione joystick supplementare #1: (0: Nessuna, 1: Tastierino numerico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* nl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_NL, "Emulatie extra joystick #1: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_SV, "Emulering fr extra styrspak 1: (0: ingen, 1: numerisk, 2: tangentuppsttning A/AI, 3: tangentuppsttning B/AI)" },
/* tr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_1_TR, "Ekstra joystick #1 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: Tu Seti B/AI)" },

/* en */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2,    "Extra joystick #2 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_DA, "Emulering af Joystick 2: (0: ingen, 1: numerisk, 2: tastest A/AI, 3: tastest B/AI)" },
/* de */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_DE, "Extra Joystick #2 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
/* fr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_HU, "" },  /* fuzzy */
/* it */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_IT, "Emulazione joystick supplementare #2: (0: Nessuna, 1: Tastierino numerico, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* nl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_NL, "Emulatie extra joystick #2: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_SV, "Emulering fr extra styrspak 2: (0: ingen, 1: numerisk, 2: tangentuppsttning A/AI, 3: tangentuppsttning B/AI)" },
/* tr */ { IDS_SET_INPUT_EXTRA_JOYSTICK_2_TR, "Ekstra joystick #2 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: Tu Seti B/AI)" },

/* en */ { IDS_SET_INPUT_JOYLL_1,    "Joystick #1 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* da */ { IDS_SET_INPUT_JOYLL_1_DA, "Joystick 1 emularing: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
/* de */ { IDS_SET_INPUT_JOYLL_1_DE, "Joystick #1 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
/* fr */ { IDS_SET_INPUT_JOYLL_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_JOYLL_1_HU, "#1-es botkormny emulci: (0: nincs, 1: numerikus billentyk, 2-5: amiga botkormny 0-3)" },
/* it */ { IDS_SET_INPUT_JOYLL_1_IT, "Emulazione joystick #1: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
/* nl */ { IDS_SET_INPUT_JOYLL_1_NL, "Emulatie joystick #1: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* pl */ { IDS_SET_INPUT_JOYLL_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_JOYLL_1_SV, "Emulering fr styrspak 1: (0: ingen, 1: numerisk, 2-5: Amigastyrspak 0-3)" },
/* tr */ { IDS_SET_INPUT_JOYLL_1_TR, "Joystick #1 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

/* en */ { IDS_SET_INPUT_JOYLL_2,    "Joystick #2 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* da */ { IDS_SET_INPUT_JOYLL_2_DA, "Joystick 2 emularing: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
/* de */ { IDS_SET_INPUT_JOYLL_2_DE, "Joystick #2 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
/* fr */ { IDS_SET_INPUT_JOYLL_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_JOYLL_2_HU, "#2-es botkormny emulci: (0: nincs, 1: numerikus billentyk, 2-5: amiga botkormny 0-3)" },
/* it */ { IDS_SET_INPUT_JOYLL_2_IT, "Emulazione joystick #2: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
/* nl */ { IDS_SET_INPUT_JOYLL_2_NL, "Emulatie joystick #2: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* pl */ { IDS_SET_INPUT_JOYLL_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_JOYLL_2_SV, "Emulering fr styrspak 2: (0: ingen, 1: numerisk, 2-5: Amigastyrspak 0-3)" },
/* tr */ { IDS_SET_INPUT_JOYLL_2_TR, "Joystick #2 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

/* en */ { IDS_SET_INPUT_EXTRA_JOYLL_1,    "Extra joystick #1 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYLL_1_DA, "Ekstra joystick 1 emulering: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
/* de */ { IDS_SET_INPUT_EXTRA_JOYLL_1_DE, "Extra Joystick #1 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
/* fr */ { IDS_SET_INPUT_EXTRA_JOYLL_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_EXTRA_JOYLL_1_HU, "#1-es extra botkormny emulci (0: Nincs, 1: numerikus, 2-5: Amiga botkormny 0-3)" },
/* it */ { IDS_SET_INPUT_EXTRA_JOYLL_1_IT, "Emulazione joystick supplementare #1: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
/* nl */ { IDS_SET_INPUT_EXTRA_JOYLL_1_NL, "Emulatie extra joystick #1: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYLL_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_EXTRA_JOYLL_1_SV, "Emulering fr extra styrspak 1: (0: ingen, 1: numerisk, 2-5: Amigastyrspak 0-3)" },
/* tr */ { IDS_SET_INPUT_EXTRA_JOYLL_1_TR, "Ekstra joystick #1 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

/* en */ { IDS_SET_INPUT_EXTRA_JOYLL_2,    "Extra joystick #2 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* da */ { IDS_SET_INPUT_EXTRA_JOYLL_2_DA, "Ekstra joystick 2 emulering: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
/* de */ { IDS_SET_INPUT_EXTRA_JOYLL_2_DE, "Extra Joystick #2 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
/* fr */ { IDS_SET_INPUT_EXTRA_JOYLL_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_INPUT_EXTRA_JOYLL_2_HU, "#2-es extra botkormny emulci (0: Nincs, 1: numerikus, 2-5: Amiga botkormny 0-3)" },
/* it */ { IDS_SET_INPUT_EXTRA_JOYLL_2_IT, "Emulazione joystick supplementare #2: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
/* nl */ { IDS_SET_INPUT_EXTRA_JOYLL_2_NL, "Emulatie extra joystick #2: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
/* pl */ { IDS_SET_INPUT_EXTRA_JOYLL_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_SET_INPUT_EXTRA_JOYLL_2_SV, "Emulering fr extra styrspak 2: (0: ingen, 1: numerisk, 2-5: Amigastyrspak 0-3)" },
/* tr */ { IDS_SET_INPUT_EXTRA_JOYLL_2_TR, "Ekstra joystick #2 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

/* en */ { IDS_SAVE_SETTINGS_ON_EXIT,    "Save settings (resources) on exit" },
/* da */ { IDS_SAVE_SETTINGS_ON_EXIT_DA, "Gem indstillinger nr programmet afsluttes" },
/* de */ { IDS_SAVE_SETTINGS_ON_EXIT_DE, "Einstellungen (Ressourcen) beim Beenden speichern" },
/* fr */ { IDS_SAVE_SETTINGS_ON_EXIT_FR, "Sauvegarder les paramtres  la sortie" },
/* hu */ { IDS_SAVE_SETTINGS_ON_EXIT_HU, "Belltsok (erforrsok) mentse kilpskor" },
/* it */ { IDS_SAVE_SETTINGS_ON_EXIT_IT, "Salva impostazioni (risorse) in uscita" },
/* nl */ { IDS_SAVE_SETTINGS_ON_EXIT_NL, "Instellingen (resources) opslaan bij afsluiten" },
/* pl */ { IDS_SAVE_SETTINGS_ON_EXIT_PL, "Zapisz ustawienia (zasoby) przy wyjciu" },
/* sv */ { IDS_SAVE_SETTINGS_ON_EXIT_SV, "Spara instllningar (resurser) vid avslut" },
/* tr */ { IDS_SAVE_SETTINGS_ON_EXIT_TR, "kta ayarlar (kaynaklar) kaydet" },

/* en */ { IDS_NEVER_SAVE_SETTINGS_EXIT,    "Never save settings (resources) on exit" },
/* da */ { IDS_NEVER_SAVE_SETTINGS_EXIT_DA, "Gem aldrig indstillinger nr programmet afsluttes" },
/* de */ { IDS_NEVER_SAVE_SETTINGS_EXIT_DE, "Einstellungen beim Beenden nie speichern" },
/* fr */ { IDS_NEVER_SAVE_SETTINGS_EXIT_FR, "Ne jamais enregistrer les paramtres  la sortie" },
/* hu */ { IDS_NEVER_SAVE_SETTINGS_EXIT_HU, "Sose mentse a belltsokat (erforrsokat) kilpskor" },
/* it */ { IDS_NEVER_SAVE_SETTINGS_EXIT_IT, "Non salvare mai le impostazioni in uscita" },
/* nl */ { IDS_NEVER_SAVE_SETTINGS_EXIT_NL, "Instellingen (resources) niet opslaan bij afsluiten" },
/* pl */ { IDS_NEVER_SAVE_SETTINGS_EXIT_PL, "Nigdy nie zapisuj ustawie (zasobw) przy wyjciu" },
/* sv */ { IDS_NEVER_SAVE_SETTINGS_EXIT_SV, "Spara aldrig instllningar (resurser) vid avslut" },
/* tr */ { IDS_NEVER_SAVE_SETTINGS_EXIT_TR, "kta asla ayarlar (kaynaklar) kaydetme" },

/* en */ { IDS_CONFIRM_QUITING_VICE,    "Confirm quiting VICE" },
/* da */ { IDS_CONFIRM_QUITING_VICE_DA, "Bekrft programafslutning" },
/* de */ { IDS_CONFIRM_QUITING_VICE_DE, "Besttige beenden von VICE" },
/* fr */ { IDS_CONFIRM_QUITING_VICE_FR, "Demander une confirmation avant de quitter VICE" },
/* hu */ { IDS_CONFIRM_QUITING_VICE_HU, "Megersts kilps eltt" },
/* it */ { IDS_CONFIRM_QUITING_VICE_IT, "Conferma l'uscita da VICE" },
/* nl */ { IDS_CONFIRM_QUITING_VICE_NL, "Bevestigen van het aflsuiten van VICE" },
/* pl */ { IDS_CONFIRM_QUITING_VICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_CONFIRM_QUITING_VICE_SV, "Bekrfta fr att avsluta VICE" },
/* tr */ { IDS_CONFIRM_QUITING_VICE_TR, "VICE'dan karken teyit et" },

/* en */ { IDS_NEVER_CONFIRM_QUITING_VICE,    "Never confirm quiting VICE" },
/* da */ { IDS_NEVER_CONFIRM_QUITING_VICE_DA, "Bekrft ikke programafslutning" },
/* de */ { IDS_NEVER_CONFIRM_QUITING_VICE_DE, "Keine Besttigung beim Beenden von VICE" },
/* fr */ { IDS_NEVER_CONFIRM_QUITING_VICE_FR, "Ne pas demander de confirmation pour quitter VICE" },
/* hu */ { IDS_NEVER_CONFIRM_QUITING_VICE_HU, "Sosem kr megerstst kilps eltt" },
/* it */ { IDS_NEVER_CONFIRM_QUITING_VICE_IT, "Non confermare mai l'uscita da VICE" },
/* nl */ { IDS_NEVER_CONFIRM_QUITING_VICE_NL, "Niet bevestigen van het afsluiten van VICE" },
/* pl */ { IDS_NEVER_CONFIRM_QUITING_VICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_NEVER_CONFIRM_QUITING_VICE_SV, "Bekrfta inte fr att avsluta VICE" },
/* tr */ { IDS_NEVER_CONFIRM_QUITING_VICE_TR, "VICE'dan karken asla teyit etme" },

/* en */ { IDS_PET_REU_SIZE,    "PET REU size" },
/* da */ { IDS_PET_REU_SIZE_DA, "PET REU strrelse" },
/* de */ { IDS_PET_REU_SIZE_DE, "PET REU Gre" },
/* fr */ { IDS_PET_REU_SIZE_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_REU_SIZE_HU, "PET REU mrete" },
/* it */ { IDS_PET_REU_SIZE_IT, "Dimensione PET REU" },
/* nl */ { IDS_PET_REU_SIZE_NL, "PET REU grootte" },
/* pl */ { IDS_PET_REU_SIZE_PL, "" },  /* fuzzy */
/* sv */ { IDS_PET_REU_SIZE_SV, "Storlek p PET REU" },
/* tr */ { IDS_PET_REU_SIZE_TR, "PET REU boyutu" },

/* en */ { IDS_PET_REU_FILENAME,    "PET REU file" },
/* da */ { IDS_PET_REU_FILENAME_DA, "PET REU-fil" },
/* de */ { IDS_PET_REU_FILENAME_DE, "PET REU Datei" },
/* fr */ { IDS_PET_REU_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_REU_FILENAME_HU, "PET REU fjl" },
/* it */ { IDS_PET_REU_FILENAME_IT, "File PET REU" },
/* nl */ { IDS_PET_REU_FILENAME_NL, "PET REU bestand" },
/* pl */ { IDS_PET_REU_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_PET_REU_FILENAME_SV, "PET REU-fil" },
/* tr */ { IDS_PET_REU_FILENAME_TR, "PET REU dosyas" },

/* en */ { IDS_PET_REU_FILENAME_SELECT,    "Select file for PET REU" },
/* da */ { IDS_PET_REU_FILENAME_SELECT_DA, "Vlg fil for PET REU" },
/* de */ { IDS_PET_REU_FILENAME_SELECT_DE, "Datei fr PET REU auswhlen" },
/* fr */ { IDS_PET_REU_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_REU_FILENAME_SELECT_HU, "Vlasszon fjlt a PET REU-hoz" },
/* it */ { IDS_PET_REU_FILENAME_SELECT_IT, "Seleziona il file per il PET REU" },
/* nl */ { IDS_PET_REU_FILENAME_SELECT_NL, "Selecteer bestand voor PET REU" },
/* pl */ { IDS_PET_REU_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_PET_REU_FILENAME_SELECT_SV, "Vlj fil fr PET REU" },
/* tr */ { IDS_PET_REU_FILENAME_SELECT_TR, "PET REU iin dosya sein" },

/* en */ { IDS_PET_REU_SETTINGS,    "PET REU Settings" },
/* da */ { IDS_PET_REU_SETTINGS_DA, "PET REU-indstillinger" },
/* de */ { IDS_PET_REU_SETTINGS_DE, "PET REU Einstellungen" },
/* fr */ { IDS_PET_REU_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_REU_SETTINGS_HU, "PET REU belltsai" },
/* it */ { IDS_PET_REU_SETTINGS_IT, "Impostazioni PET REU" },
/* nl */ { IDS_PET_REU_SETTINGS_NL, "PET REU instellingen" },
/* pl */ { IDS_PET_REU_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_PET_REU_SETTINGS_SV, "PET REU-Instllningar" },
/* tr */ { IDS_PET_REU_SETTINGS_TR, "PET REU Ayarlar" },

/* en */ { IDS_V364_SPEECH_FILENAME,    "V364 Speech file" },
/* da */ { IDS_V364_SPEECH_FILENAME_DA, "V364 Speech fil" },
/* de */ { IDS_V364_SPEECH_FILENAME_DE, "V364 Stimme Datei" },
/* fr */ { IDS_V364_SPEECH_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_V364_SPEECH_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_V364_SPEECH_FILENAME_IT, "File V364 Speech" },
/* nl */ { IDS_V364_SPEECH_FILENAME_NL, "V364 Spraak bestand" },
/* pl */ { IDS_V364_SPEECH_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_V364_SPEECH_FILENAME_SV, "Fil fr V364-rst" },
/* tr */ { IDS_V364_SPEECH_FILENAME_TR, "V364 Speech dosyas" },

/* en */ { IDS_V364_SPEECH_FILENAME_SELECT,    "Select file for V364 Speech" },
/* da */ { IDS_V364_SPEECH_FILENAME_SELECT_DA, "Angiv fil for V364 Speech" },
/* de */ { IDS_V364_SPEECH_FILENAME_SELECT_DE, "Datei fr V364 Stimme auswhlen" },
/* fr */ { IDS_V364_SPEECH_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_V364_SPEECH_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_V364_SPEECH_FILENAME_SELECT_IT, "Seleziona file per V364 Speech" },
/* nl */ { IDS_V364_SPEECH_FILENAME_SELECT_NL, "Selecteer bestand voor V364 Spraak" },
/* pl */ { IDS_V364_SPEECH_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_V364_SPEECH_FILENAME_SELECT_SV, "Vlj fil fr V364-rst" },
/* tr */ { IDS_V364_SPEECH_FILENAME_SELECT_TR, "V364 Speech iin dosya sein" },

/* en */ { IDS_V364_SPEECH_SETTINGS,    "V364 Speech Settings" },
/* da */ { IDS_V364_SPEECH_SETTINGS_DA, "V364 Speech indstillinger" },
/* de */ { IDS_V364_SPEECH_SETTINGS_DE, "V364 Stimme Einstellungen" },
/* fr */ { IDS_V364_SPEECH_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_V364_SPEECH_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_V364_SPEECH_SETTINGS_IT, "Impostazioni V364" },
/* nl */ { IDS_V364_SPEECH_SETTINGS_NL, "V364 Spraak instellingen" },
/* pl */ { IDS_V364_SPEECH_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_V364_SPEECH_SETTINGS_SV, "V364-rstinstllningar" },
/* tr */ { IDS_V364_SPEECH_SETTINGS_TR, "V364 Speech Ayarlar" },

/* en */ { IDS_PET_DWW_FILENAME,    "PET DWW file" },
/* da */ { IDS_PET_DWW_FILENAME_DA, "PET DWW fil" },
/* de */ { IDS_PET_DWW_FILENAME_DE, "PET DWW Datei" },
/* fr */ { IDS_PET_DWW_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_DWW_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_DWW_FILENAME_IT, "File PET DWW" },
/* nl */ { IDS_PET_DWW_FILENAME_NL, "PET DWW bestand" },
/* pl */ { IDS_PET_DWW_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_PET_DWW_FILENAME_SV, "PET DWW-fil" },
/* tr */ { IDS_PET_DWW_FILENAME_TR, "PET DWW dosyas" },

/* en */ { IDS_PET_DWW_FILENAME_SELECT,    "Select file for PET DWW" },
/* da */ { IDS_PET_DWW_FILENAME_SELECT_DA, "Vlg fil for PET DWW" },
/* de */ { IDS_PET_DWW_FILENAME_SELECT_DE, "Datei fr PET DWW auswhlen" },
/* fr */ { IDS_PET_DWW_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_DWW_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_DWW_FILENAME_SELECT_IT, "Seleziona file per il PET DWW" },
/* nl */ { IDS_PET_DWW_FILENAME_SELECT_NL, "Selecteer bestand voor PET DWW" },
/* pl */ { IDS_PET_DWW_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_PET_DWW_FILENAME_SELECT_SV, "Vlj fil fr PET DWW" },
/* tr */ { IDS_PET_DWW_FILENAME_SELECT_TR, "PET DWW iin dosya sein" },

/* en */ { IDS_PET_DWW_SETTINGS,    "PET DWW Settings" },
/* da */ { IDS_PET_DWW_SETTINGS_DA, "PET DWW-indstillinger" },
/* de */ { IDS_PET_DWW_SETTINGS_DE, "PET DWW Einstellungen" },
/* fr */ { IDS_PET_DWW_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_DWW_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_PET_DWW_SETTINGS_IT, "Impostazioni PET DWW" },
/* nl */ { IDS_PET_DWW_SETTINGS_NL, "PET DWW instellingen" },
/* pl */ { IDS_PET_DWW_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_PET_DWW_SETTINGS_SV, "PET DWW-Instllningar" },
/* tr */ { IDS_PET_DWW_SETTINGS_TR, "PET DWW Ayarlar" },

/* en */ { IDS_PLUS256K_SETTINGS,    "PLUS256K Settings" },
/* da */ { IDS_PLUS256K_SETTINGS_DA, "PLUS256K-indstillinger" },
/* de */ { IDS_PLUS256K_SETTINGS_DE, "PLUS256K Einstellungen" },
/* fr */ { IDS_PLUS256K_SETTINGS_FR, "Paramtres 256K" },
/* hu */ { IDS_PLUS256K_SETTINGS_HU, "PLUS256K belltsai" },
/* it */ { IDS_PLUS256K_SETTINGS_IT, "Impostazioni PLUS256K" },
/* nl */ { IDS_PLUS256K_SETTINGS_NL, "PLUS256K instellingen" },
/* pl */ { IDS_PLUS256K_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_PLUS256K_SETTINGS_SV, "PLUS256K-instllningar" },
/* tr */ { IDS_PLUS256K_SETTINGS_TR, "PLUS256K Ayarlar" },

/* en */ { IDS_PLUS60K_BASE,    "PLUS60K Base" },
/* da */ { IDS_PLUS60K_BASE_DA, "Baseadresse for PLUS60K" },
/* de */ { IDS_PLUS60K_BASE_DE, "PLUS60K Basis Adresse" },
/* fr */ { IDS_PLUS60K_BASE_FR, "Base PLUS60K" },
/* hu */ { IDS_PLUS60K_BASE_HU, "PLUS60K bziscme" },
/* it */ { IDS_PLUS60K_BASE_IT, "Indirizzo base PLUS60K" },
/* nl */ { IDS_PLUS60K_BASE_NL, "PLUS60K basisadres" },
/* pl */ { IDS_PLUS60K_BASE_PL, "" },  /* fuzzy */
/* sv */ { IDS_PLUS60K_BASE_SV, "Basadress fr PLUS60K" },
/* tr */ { IDS_PLUS60K_BASE_TR, "PLUS60K Taban" },

/* en */ { IDS_PLUS60K_FILENAME,    "PLUS60K file" },
/* da */ { IDS_PLUS60K_FILENAME_DA, "PLUS60K-fil" },
/* de */ { IDS_PLUS60K_FILENAME_DE, "PLUS60K Datei" },
/* fr */ { IDS_PLUS60K_FILENAME_FR, "Fichier POLUS60K" },
/* hu */ { IDS_PLUS60K_FILENAME_HU, "PLUS60K fjl" },
/* it */ { IDS_PLUS60K_FILENAME_IT, "File PLUS60K" },
/* nl */ { IDS_PLUS60K_FILENAME_NL, "PLUS60K bestand" },
/* pl */ { IDS_PLUS60K_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_PLUS60K_FILENAME_SV, "PLUS60K-fil" },
/* tr */ { IDS_PLUS60K_FILENAME_TR, "PLUS60K dosyas" },

/* en */ { IDS_PLUS60K_FILENAME_SELECT,    "Select file for PLUS60K" },
/* da */ { IDS_PLUS60K_FILENAME_SELECT_DA, "Vlg fil for PLUS60K" },
/* de */ { IDS_PLUS60K_FILENAME_SELECT_DE, "Datei fr PLUS60K auswhlen" },
/* fr */ { IDS_PLUS60K_FILENAME_SELECT_FR, "Slectionner fichier pour PLUS60K" },
/* hu */ { IDS_PLUS60K_FILENAME_SELECT_HU, "Vlasszon fjlt a PLUS60K-hoz" },
/* it */ { IDS_PLUS60K_FILENAME_SELECT_IT, "Seleziona file per PLUS60K" },
/* nl */ { IDS_PLUS60K_FILENAME_SELECT_NL, "Selecteer bestand voor PLUS60K" },
/* pl */ { IDS_PLUS60K_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_PLUS60K_FILENAME_SELECT_SV, "Ange fil fr PLUS60K" },
/* tr */ { IDS_PLUS60K_FILENAME_SELECT_TR, "PLUS60K iin dosya sein" },

/* en */ { IDS_PLUS60K_SETTINGS,    "PLUS60K Settings" },
/* da */ { IDS_PLUS60K_SETTINGS_DA, "PLUS60K-indstillinger" },
/* de */ { IDS_PLUS60K_SETTINGS_DE, "PLUS60K Einstellungen" },
/* fr */ { IDS_PLUS60K_SETTINGS_FR, "Paramtres PLUS60K" },
/* hu */ { IDS_PLUS60K_SETTINGS_HU, "PLUS60K belltsai" },
/* it */ { IDS_PLUS60K_SETTINGS_IT, "Impostazioni PLUS256K" },
/* nl */ { IDS_PLUS60K_SETTINGS_NL, "PLUS60K instellingen" },
/* pl */ { IDS_PLUS60K_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_PLUS60K_SETTINGS_SV, "PLUS60K-instllningar" },
/* tr */ { IDS_PLUS60K_SETTINGS_TR, "PLUS60K Ayarlar" },

/* en */ { IDS_VALUE_FIRST_BYTE,    "Value of first byte" },
/* da */ { IDS_VALUE_FIRST_BYTE_DA, "Vrdi p frste byte" },
/* de */ { IDS_VALUE_FIRST_BYTE_DE, "Wert erstes Byte" },
/* fr */ { IDS_VALUE_FIRST_BYTE_FR, "Valeur du premier octet" },
/* hu */ { IDS_VALUE_FIRST_BYTE_HU, "Els bjt rtke" },
/* it */ { IDS_VALUE_FIRST_BYTE_IT, "Valore del primo byte" },
/* nl */ { IDS_VALUE_FIRST_BYTE_NL, "Waarde van eerste byte" },
/* pl */ { IDS_VALUE_FIRST_BYTE_PL, "" },  /* fuzzy */
/* sv */ { IDS_VALUE_FIRST_BYTE_SV, "Vrde p frsta byte" },
/* tr */ { IDS_VALUE_FIRST_BYTE_TR, "lk byte deeri" },

/* en */ { IDS_LENGTH_CONSTANT_VALUES,    "Length of constant values" },
/* da */ { IDS_LENGTH_CONSTANT_VALUES_DA, "Lngde af konstant vrdi" },
/* de */ { IDS_LENGTH_CONSTANT_VALUES_DE, "Lnge der konstaten Werte" },
/* fr */ { IDS_LENGTH_CONSTANT_VALUES_FR, "Longeur des valeurs constantes" },
/* hu */ { IDS_LENGTH_CONSTANT_VALUES_HU, "lland rtkek hossza" },
/* it */ { IDS_LENGTH_CONSTANT_VALUES_IT, "Lunghezza dei valori costanti" },
/* nl */ { IDS_LENGTH_CONSTANT_VALUES_NL, "Lengte van constante waarden" },
/* pl */ { IDS_LENGTH_CONSTANT_VALUES_PL, "" },  /* fuzzy */
/* sv */ { IDS_LENGTH_CONSTANT_VALUES_SV, "Lngd p konstanta vrden" },
/* tr */ { IDS_LENGTH_CONSTANT_VALUES_TR, "Sabit deerlerin uzunluu" },

/* en */ { IDS_LENGTH_CONSTANT_PATTERN,    "Length of constant pattern" },
/* da */ { IDS_LENGTH_CONSTANT_PATTERN_DA, "Lngde af konstant mnster" },
/* de */ { IDS_LENGTH_CONSTANT_PATTERN_DE, "Lnge des konstanten Musters" },
/* fr */ { IDS_LENGTH_CONSTANT_PATTERN_FR, "Longeur des contantes pattern" },
/* hu */ { IDS_LENGTH_CONSTANT_PATTERN_HU, "lland minta hossza" },
/* it */ { IDS_LENGTH_CONSTANT_PATTERN_IT, "Lunghezza dei pattern costanti" },
/* nl */ { IDS_LENGTH_CONSTANT_PATTERN_NL, "Lengte van constant patroon" },
/* pl */ { IDS_LENGTH_CONSTANT_PATTERN_PL, "" },  /* fuzzy */
/* sv */ { IDS_LENGTH_CONSTANT_PATTERN_SV, "Lngd p konstant mnster" },
/* tr */ { IDS_LENGTH_CONSTANT_PATTERN_TR, "Sabit desenlerin uzunluu" },

/* en */ { IDS_RAM_SETTINGS,    "RAM settings" },
/* da */ { IDS_RAM_SETTINGS_DA, "RAM-indstillinger" },
/* de */ { IDS_RAM_SETTINGS_DE, "RAM Einstellungen" },
/* fr */ { IDS_RAM_SETTINGS_FR, "Paramtres de la RAM" },
/* hu */ { IDS_RAM_SETTINGS_HU, "RAM belltsai" },
/* it */ { IDS_RAM_SETTINGS_IT, "Impostazioni RAM" },
/* nl */ { IDS_RAM_SETTINGS_NL, "RAM instellingen" },
/* pl */ { IDS_RAM_SETTINGS_PL, "Ustawienia RAM" },
/* sv */ { IDS_RAM_SETTINGS_SV, "RAM-instllningar" },
/* tr */ { IDS_RAM_SETTINGS_TR, "RAM ayarlar" },

/* en */ { IDS_READ_WRITE,    "read/write" },
/* da */ { IDS_READ_WRITE_DA, "skrivbar" },
/* de */ { IDS_READ_WRITE_DE, "lese/schreibe" },
/* fr */ { IDS_READ_WRITE_FR, "lecture/criture" },
/* hu */ { IDS_READ_WRITE_HU, "rhat/olvashat" },
/* it */ { IDS_READ_WRITE_IT, "lettura/scrittura" },
/* nl */ { IDS_READ_WRITE_NL, "lees/schrijf" },
/* pl */ { IDS_READ_WRITE_PL, "" },  /* fuzzy */
/* sv */ { IDS_READ_WRITE_SV, "skrivbar" },
/* tr */ { IDS_READ_WRITE_TR, "oku/yaz" },

/* en */ { IDS_READ_ONLY,    "read-only" },
/* da */ { IDS_READ_ONLY_DA, "skrivebeskyttet" },
/* de */ { IDS_READ_ONLY_DE, "Schreibgschutz" },
/* fr */ { IDS_READ_ONLY_FR, "lecture seule" },
/* hu */ { IDS_READ_ONLY_HU, "csak olvashat" },
/* it */ { IDS_READ_ONLY_IT, "a sola lettura" },
/* nl */ { IDS_READ_ONLY_NL, "Alleen lezen" },
/* pl */ { IDS_READ_ONLY_PL, "" },  /* fuzzy */
/* sv */ { IDS_READ_ONLY_SV, "skrivskyddad" },
/* tr */ { IDS_READ_ONLY_TR, "salt-okunur" },

/* en */ { IDS_RAMCART_READ_WRITE,    "RamCart Read/Write" },
/* da */ { IDS_RAMCART_READ_WRITE_DA, "RamCart ls/skriv" },
/* de */ { IDS_RAMCART_READ_WRITE_DE, "RamCart Lesen/Schreiben" },
/* fr */ { IDS_RAMCART_READ_WRITE_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAMCART_READ_WRITE_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_READ_WRITE_IT, "RamCart in lettura/scrittura" },
/* nl */ { IDS_RAMCART_READ_WRITE_NL, "RamCart lees/schrijf" },
/* pl */ { IDS_RAMCART_READ_WRITE_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAMCART_READ_WRITE_SV, "Skrivbart RamCart" },
/* tr */ { IDS_RAMCART_READ_WRITE_TR, "RamCart Oku/Yaz" },

/* en */ { IDS_RAMCART_SIZE,    "RamCart size" },
/* da */ { IDS_RAMCART_SIZE_DA, "RamCart-strrelse" },
/* de */ { IDS_RAMCART_SIZE_DE, "RamCart Gre" },
/* fr */ { IDS_RAMCART_SIZE_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAMCART_SIZE_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_SIZE_IT, "Dimensione RamCart" },
/* nl */ { IDS_RAMCART_SIZE_NL, "RamCart grootte" },
/* pl */ { IDS_RAMCART_SIZE_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAMCART_SIZE_SV, "RamCart-storlek" },
/* tr */ { IDS_RAMCART_SIZE_TR, "RamCart boyutu" },

/* en */ { IDS_RAMCART_FILENAME,    "RamCart file" },
/* da */ { IDS_RAMCART_FILENAME_DA, "RamCart fil" },
/* de */ { IDS_RAMCART_FILENAME_DE, "RamCart Datei" },
/* fr */ { IDS_RAMCART_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAMCART_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_FILENAME_IT, "File RamCart" },
/* nl */ { IDS_RAMCART_FILENAME_NL, "RamCart bestand" },
/* pl */ { IDS_RAMCART_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAMCART_FILENAME_SV, "RamCart-fil" },
/* tr */ { IDS_RAMCART_FILENAME_TR, "RamCart dosyas" },

/* en */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED,    "Save RamCart image when changed" },
/* da */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_DA, "Gem RamCart image ved ndringer" },
/* de */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_DE, "RamCart Imagedatei bei nderung speichern" },
/* fr */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_IT, "Salva immagine RamCart al cambio" },
/* nl */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_NL, "Ramcart bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_SV, "Spara RamCart-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_RAMCART_IMAGE_WHEN_CHANGED_TR, "RamCart imaj deitiinde kaydet" },

/* en */ { IDS_RAMCART_FILENAME_SELECT,    "Select file for RamCart" },
/* da */ { IDS_RAMCART_FILENAME_SELECT_DA, "Vlg fil for RamCart" },
/* de */ { IDS_RAMCART_FILENAME_SELECT_DE, "Datei fr RamCart auswhlen" },
/* fr */ { IDS_RAMCART_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAMCART_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_FILENAME_SELECT_IT, "Seleziona file per RamCart" },
/* nl */ { IDS_RAMCART_FILENAME_SELECT_NL, "Selecteer bestand voor RamCart" },
/* pl */ { IDS_RAMCART_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAMCART_FILENAME_SELECT_SV, "Vlj fil fr RamCart" },
/* tr */ { IDS_RAMCART_FILENAME_SELECT_TR, "RamCart iin dosya sein" },

/* en */ { IDS_RAMCART_SETTINGS,    "RamCart settings" },
/* da */ { IDS_RAMCART_SETTINGS_DA, "RamCart-indstillinger" },
/* de */ { IDS_RAMCART_SETTINGS_DE, "RamCart Einstellungen" },
/* fr */ { IDS_RAMCART_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAMCART_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_RAMCART_SETTINGS_IT, "Impostazioni RamCart " },
/* nl */ { IDS_RAMCART_SETTINGS_NL, "RamCart instellingen" },
/* pl */ { IDS_RAMCART_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAMCART_SETTINGS_SV, "RamCart-instllningar" },
/* tr */ { IDS_RAMCART_SETTINGS_TR, "RamCart ayarlar" },

/* en */ { IDS_REU_SIZE,    "REU size" },
/* da */ { IDS_REU_SIZE_DA, "REU strrelse" },
/* de */ { IDS_REU_SIZE_DE, "REU Gre" },
/* fr */ { IDS_REU_SIZE_FR, "Taille du REU" },
/* hu */ { IDS_REU_SIZE_HU, "REU mrete" },
/* it */ { IDS_REU_SIZE_IT, "Dimensione REU" },
/* nl */ { IDS_REU_SIZE_NL, "REU grootte" },
/* pl */ { IDS_REU_SIZE_PL, "Rozmiar REU" },
/* sv */ { IDS_REU_SIZE_SV, "Storlek p minnesexpansion" },
/* tr */ { IDS_REU_SIZE_TR, "REU boyutu" },

/* en */ { IDS_REU_FILENAME,    "REU file" },
/* da */ { IDS_REU_FILENAME_DA, "REU-fil" },
/* de */ { IDS_REU_FILENAME_DE, "REU Datei" },
/* fr */ { IDS_REU_FILENAME_FR, "Fichier REU" },
/* hu */ { IDS_REU_FILENAME_HU, "REU fjl" },
/* it */ { IDS_REU_FILENAME_IT, "File del REU" },
/* nl */ { IDS_REU_FILENAME_NL, "REU bestand" },
/* pl */ { IDS_REU_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_REU_FILENAME_SV, "REU-fil" },
/* tr */ { IDS_REU_FILENAME_TR, "REU dosyas" },

/* en */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED,    "Save REU image when changed" },
/* da */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_DA, "Gem REU image ved ndringer" },
/* de */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_DE, "REU Imagedatei bei nderung speichern" },
/* fr */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_IT, "Salva immagine REU al cambio" },
/* nl */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_NL, "RUE bestand opslaan indien gewijzigd" },
/* pl */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_SV, "Spara REU-avbildning vid ndringar" },
/* tr */ { IDS_SAVE_REU_IMAGE_WHEN_CHANGED_TR, "REU imaj deitiinde kaydet" },

/* en */ { IDS_REU_FILENAME_SELECT,    "Select file for REU" },
/* da */ { IDS_REU_FILENAME_SELECT_DA, "Vlg fil for REU" },
/* de */ { IDS_REU_FILENAME_SELECT_DE, "Datei fr REU auswhlen" },
/* fr */ { IDS_REU_FILENAME_SELECT_FR, "Slectionner fichier pour REU" },
/* hu */ { IDS_REU_FILENAME_SELECT_HU, "Vlasszon fjlt a REU-hoz" },
/* it */ { IDS_REU_FILENAME_SELECT_IT, "Seleziona il file per il REU" },
/* nl */ { IDS_REU_FILENAME_SELECT_NL, "Selecteer bestand voor REU" },
/* pl */ { IDS_REU_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_REU_FILENAME_SELECT_SV, "Vlj fil fr REU" },
/* tr */ { IDS_REU_FILENAME_SELECT_TR, "REU iin dosya sein" },

/* en */ { IDS_REU_SETTINGS,    "REU Settings" },
/* da */ { IDS_REU_SETTINGS_DA, "REU-indstillinger" },
/* de */ { IDS_REU_SETTINGS_DE, "REU Einstellungen" },
/* fr */ { IDS_REU_SETTINGS_FR, "Paramtres REU" },
/* hu */ { IDS_REU_SETTINGS_HU, "REU belltsai" },
/* it */ { IDS_REU_SETTINGS_IT, "Impostazioni REU" },
/* nl */ { IDS_REU_SETTINGS_NL, "REU instellingen" },
/* pl */ { IDS_REU_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_REU_SETTINGS_SV, "REU-Instllningar" },
/* tr */ { IDS_REU_SETTINGS_TR, "REU Ayarlar" },

/* en */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT,    "Select printer dump file" },
/* da */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_DA, "Vlg udskriftsdumpfil" },
/* de */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_DE, "Drucker Ausgabedatei definieren" },
/* fr */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_FR, "Slectionnez le fichier de sortie d'imprimante" },
/* hu */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_HU, "Vlassza ki a nyomtat kimeneti fjlt" },
/* it */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_IT, "Seleziona file su cui stampare" },
/* nl */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_NL, "Selecteer printerdumpbestand" },
/* pl */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_PL, "Wybierz drukark do dump'owania pliku" },
/* sv */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_SV, "Vlj utskriftsdumpfil" },
/* tr */ { IDS_PRINTER_OUTPUT_FILENAME_SELECT_TR, "Yazc dkm dosyasn sein" },

/* en */ { IDS_PRINTER_4_EMULATION,    "Printer #4 emulation" },
/* da */ { IDS_PRINTER_4_EMULATION_DA, "Printer #4 emulering" },
/* de */ { IDS_PRINTER_4_EMULATION_DE, "Drucker #4 Emulation" },
/* fr */ { IDS_PRINTER_4_EMULATION_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_4_EMULATION_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_EMULATION_IT, "Emulazione stampante #4" },
/* nl */ { IDS_PRINTER_4_EMULATION_NL, "Printer #4 emulatie" },
/* pl */ { IDS_PRINTER_4_EMULATION_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_4_EMULATION_SV, "Skrivaremulering fr enhet 4" },
/* tr */ { IDS_PRINTER_4_EMULATION_TR, "Yazc #4 emlasyonu" },

/* en */ { IDS_PRINTER_5_EMULATION,    "Printer #5 emulation" },
/* da */ { IDS_PRINTER_5_EMULATION_DA, "Printer #5 emulering" },
/* de */ { IDS_PRINTER_5_EMULATION_DE, "Drucker #5 Emulation" },
/* fr */ { IDS_PRINTER_5_EMULATION_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_5_EMULATION_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_EMULATION_IT, "Emulazione stampante #5" },
/* nl */ { IDS_PRINTER_5_EMULATION_NL, "Printer #5 emulatie" },
/* pl */ { IDS_PRINTER_5_EMULATION_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_5_EMULATION_SV, "Skrivaremulering fr enhet 5" },
/* tr */ { IDS_PRINTER_5_EMULATION_TR, "Yazc #5 emlasyonu" },

/* en */ { IDS_USERPORT_PRINTER_EMULATION,    "Userport printer emulation" },
/* da */ { IDS_USERPORT_PRINTER_EMULATION_DA, "Emulering af printer p brugerporten" },
/* de */ { IDS_USERPORT_PRINTER_EMULATION_DE, "Userport Drucker Emulation" },
/* fr */ { IDS_USERPORT_PRINTER_EMULATION_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_PRINTER_EMULATION_HU, "" },  /* fuzzy */
/* it */ { IDS_USERPORT_PRINTER_EMULATION_IT, "Stampante su userport: emulazione" },
/* nl */ { IDS_USERPORT_PRINTER_EMULATION_NL, "Userport printer emulatie" },
/* pl */ { IDS_USERPORT_PRINTER_EMULATION_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_PRINTER_EMULATION_SV, "Emulering av skrivare p anvndarporten" },
/* tr */ { IDS_USERPORT_PRINTER_EMULATION_TR, "Userport yazcs emlasyonu" },

/* en */ { IDS_PRINTER_4_DRIVER,    "Printer #4 driver" },
/* da */ { IDS_PRINTER_4_DRIVER_DA, "Printer #4 driver" },
/* de */ { IDS_PRINTER_4_DRIVER_DE, "Drucker #4 Treiber" },
/* fr */ { IDS_PRINTER_4_DRIVER_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_4_DRIVER_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_DRIVER_IT, "Driver stampante #4" },
/* nl */ { IDS_PRINTER_4_DRIVER_NL, "Printer #4 stuurprogramma" },
/* pl */ { IDS_PRINTER_4_DRIVER_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_4_DRIVER_SV, "Skrivardrivrutin fr enhet 4" },
/* tr */ { IDS_PRINTER_4_DRIVER_TR, "Yazc #4 srcs" },

/* en */ { IDS_PRINTER_5_DRIVER,    "Printer #5 driver" },
/* da */ { IDS_PRINTER_5_DRIVER_DA, "Printer #5 driver" },
/* de */ { IDS_PRINTER_5_DRIVER_DE, "Drucker #5 Treiber" },
/* fr */ { IDS_PRINTER_5_DRIVER_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_5_DRIVER_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_DRIVER_IT, "Driver stampante #5" },
/* nl */ { IDS_PRINTER_5_DRIVER_NL, "Printer #5 stuurprogramma" },
/* pl */ { IDS_PRINTER_5_DRIVER_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_5_DRIVER_SV, "Skrivardrivrutin fr enhet 5" },
/* tr */ { IDS_PRINTER_5_DRIVER_TR, "Yazc #5 srcs" },

/* en */ { IDS_USERPORT_PRINTER_DRIVER,    "Userport printer driver" },
/* da */ { IDS_USERPORT_PRINTER_DRIVER_DA, "Printerdriver for brugerporten" },
/* de */ { IDS_USERPORT_PRINTER_DRIVER_DE, "Userport Drucker Treiber" },
/* fr */ { IDS_USERPORT_PRINTER_DRIVER_FR, "Pilote de l'imprimante sur port utilisateur" },
/* hu */ { IDS_USERPORT_PRINTER_DRIVER_HU, "Userport-os nyomtat meghajt" },
/* it */ { IDS_USERPORT_PRINTER_DRIVER_IT, "Stampante su userport: driver" },
/* nl */ { IDS_USERPORT_PRINTER_DRIVER_NL, "Userport printer stuurprogramma" },
/* pl */ { IDS_USERPORT_PRINTER_DRIVER_PL, "Port sterownika drukarki" },
/* sv */ { IDS_USERPORT_PRINTER_DRIVER_SV, "Skrivardrivrutin fr anvndarporten" },
/* tr */ { IDS_USERPORT_PRINTER_DRIVER_TR, "Userport yazcs srcs" },

/* en */ { IDS_PRINTER_4_OUTPUT_TYPE,    "Printer #4 output type" },
/* da */ { IDS_PRINTER_4_OUTPUT_TYPE_DA, "Printer #4 uddatatype" },
/* de */ { IDS_PRINTER_4_OUTPUT_TYPE_DE, "Drucker #4 Ausgabetyp" },
/* fr */ { IDS_PRINTER_4_OUTPUT_TYPE_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_4_OUTPUT_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_OUTPUT_TYPE_IT, "Tipo di output stampante #4" },
/* nl */ { IDS_PRINTER_4_OUTPUT_TYPE_NL, "Printer #4 uitvoer soort" },
/* pl */ { IDS_PRINTER_4_OUTPUT_TYPE_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_4_OUTPUT_TYPE_SV, "Utdatatyp fr skrivare 4" },
/* tr */ { IDS_PRINTER_4_OUTPUT_TYPE_TR, "Yazc #4 kt tipi" },

/* en */ { IDS_PRINTER_5_OUTPUT_TYPE,    "Printer #5 output type" },
/* da */ { IDS_PRINTER_5_OUTPUT_TYPE_DA, "Printer #5 uddatatype" },
/* de */ { IDS_PRINTER_5_OUTPUT_TYPE_DE, "Drucker #5 Ausgabetyp" },
/* fr */ { IDS_PRINTER_5_OUTPUT_TYPE_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_5_OUTPUT_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_OUTPUT_TYPE_IT, "Tipo di output stampante #5" },
/* nl */ { IDS_PRINTER_5_OUTPUT_TYPE_NL, "Printer #5 uitvoer soort" },
/* pl */ { IDS_PRINTER_5_OUTPUT_TYPE_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_5_OUTPUT_TYPE_SV, "Utdatatyp fr skrivare 5" },
/* tr */ { IDS_PRINTER_5_OUTPUT_TYPE_TR, "Yazc #5 kt tipi" },

/* en */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE,    "Userport printer output type" },
/* da */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_DA, "Printer uddatatype p brugerporten" },
/* de */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_DE, "Userport Drucker Ausgabetyp" },
/* fr */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_IT, "Tipo di output stampante su userport" },
/* nl */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_NL, "Userport printer uitvoer soort" },
/* pl */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_SV, "Utdatatyp fr anvndarportskrivare" },
/* tr */ { IDS_USERPORT_PRINTER_OUTPUT_TYPE_TR, "Userport yazcs kt tipi" },

/* en */ { IDS_PRINTER_4_OUTPUT_DEVICE,    "Printer #4 output device" },
/* da */ { IDS_PRINTER_4_OUTPUT_DEVICE_DA, "Printer #4 uddataenhed" },
/* de */ { IDS_PRINTER_4_OUTPUT_DEVICE_DE, "Drucker #4 Ausgabegert" },
/* fr */ { IDS_PRINTER_4_OUTPUT_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_4_OUTPUT_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_OUTPUT_DEVICE_IT, "Dispositivo di output stampante #4" },
/* nl */ { IDS_PRINTER_4_OUTPUT_DEVICE_NL, "Printer #4 uitvoer apparaat" },
/* pl */ { IDS_PRINTER_4_OUTPUT_DEVICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_4_OUTPUT_DEVICE_SV, "Textutenhet fr skrivare 4" },
/* tr */ { IDS_PRINTER_4_OUTPUT_DEVICE_TR, "Yazc #4 kt aygt" },

/* en */ { IDS_PRINTER_5_OUTPUT_DEVICE,    "Printer #5 output device" },
/* da */ { IDS_PRINTER_5_OUTPUT_DEVICE_DA, "Printer #5 uddataenhed" },
/* de */ { IDS_PRINTER_5_OUTPUT_DEVICE_DE, "Drucker #5 Ausgabegert" },
/* fr */ { IDS_PRINTER_5_OUTPUT_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_5_OUTPUT_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_OUTPUT_DEVICE_IT, "Dispositivo di output stampante #5" },
/* nl */ { IDS_PRINTER_5_OUTPUT_DEVICE_NL, "Printer #5 uitvoer apparaat" },
/* pl */ { IDS_PRINTER_5_OUTPUT_DEVICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_5_OUTPUT_DEVICE_SV, "Textutenhet fr skrivare 5" },
/* tr */ { IDS_PRINTER_5_OUTPUT_DEVICE_TR, "Yazc #5 kt aygt" },

/* en */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE,    "Userport printer output device" },
/* da */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_DA, "Brugerport printer uddataenhed" },
/* de */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_DE, "Userport Drucker Ausgabegert" },
/* fr */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_HU, "" },  /* fuzzy */
/* it */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_IT, "Dispositivo di output stampante su userport" },
/* nl */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_NL, "Userport printer uitvoer apparaat" },
/* pl */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_SV, "Textutenhet fr anvndarportskrivare" },
/* tr */ { IDS_USERPORT_PRINTER_OUTPUT_DEVICE_TR, "Userport yazcs kt aygt" },

/* en */ { IDS_PRINTER_4_SEND_FORMFEED,    "Send formfeed to printer #4" },
/* da */ { IDS_PRINTER_4_SEND_FORMFEED_DA, "Send sideskift til printer #4" },
/* de */ { IDS_PRINTER_4_SEND_FORMFEED_DE, "Seitenvorschub zu Drucker #4 senden" },
/* fr */ { IDS_PRINTER_4_SEND_FORMFEED_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_4_SEND_FORMFEED_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_4_SEND_FORMFEED_IT, "Invia formfeed alla stampante #4" },
/* nl */ { IDS_PRINTER_4_SEND_FORMFEED_NL, "Zend formfeed naar printer #4" },
/* pl */ { IDS_PRINTER_4_SEND_FORMFEED_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_4_SEND_FORMFEED_SV, "Snd sidmatning till skrivare 4" },
/* tr */ { IDS_PRINTER_4_SEND_FORMFEED_TR, "Yazc #4'e sayfa ilerletme gnder" },

/* en */ { IDS_PRINTER_5_SEND_FORMFEED,    "Send formfeed to printer #5" },
/* da */ { IDS_PRINTER_5_SEND_FORMFEED_DA, "Send sideskift til printer #5" },
/* de */ { IDS_PRINTER_5_SEND_FORMFEED_DE, "Seitenvorschub zu Drucker #5 senden" },
/* fr */ { IDS_PRINTER_5_SEND_FORMFEED_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_5_SEND_FORMFEED_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_5_SEND_FORMFEED_IT, "Invia formfeed alla stampante #5" },
/* nl */ { IDS_PRINTER_5_SEND_FORMFEED_NL, "Zend formfeed naar printer #5" },
/* pl */ { IDS_PRINTER_5_SEND_FORMFEED_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_5_SEND_FORMFEED_SV, "Snd sidmatning till skrivare 5" },
/* tr */ { IDS_PRINTER_5_SEND_FORMFEED_TR, "Yazc #5'e sayfa ilerletme gnder" },

/* en */ { IDS_USERPORT_PRINTER_SEND_FORMFEED,    "Send formfeed to userport printer" },
/* da */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_DA, "Send sideskift til brugerports-printer" },
/* de */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_DE, "Seitenvorschub zui Userport Drucker senden" },
/* fr */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_HU, "" },  /* fuzzy */
/* it */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_IT, "Invia formfeed alla stampante su userport" },
/* nl */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_NL, "Zend formfeed naar userport printer" },
/* pl */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_SV, "Snd sidmatning till anvndarportskrivare" },
/* tr */ { IDS_USERPORT_PRINTER_SEND_FORMFEED_TR, "Userport yazcs'na sayfa ilerletme gnder" },

/* en */ { IDS_PRINTER_DEVICE_1_FILENAME,    "Printer device #1 output" },
/* da */ { IDS_PRINTER_DEVICE_1_FILENAME_DA, "Printer enhed #1 uddata" },
/* de */ { IDS_PRINTER_DEVICE_1_FILENAME_DE, "Drucker Gert #1 Ausgabe" },
/* fr */ { IDS_PRINTER_DEVICE_1_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_DEVICE_1_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_DEVICE_1_FILENAME_IT, "Output stampante #1..." },
/* nl */ { IDS_PRINTER_DEVICE_1_FILENAME_NL, "Printer apparaat #1 uitvoer" },
/* pl */ { IDS_PRINTER_DEVICE_1_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_DEVICE_1_FILENAME_SV, "Utdata fr skrivarenhet 1" },
/* tr */ { IDS_PRINTER_DEVICE_1_FILENAME_TR, "Yazc aygt #1 kts" },

/* en */ { IDS_PRINTER_DEVICE_2_FILENAME,    "Printer device #2 output" },
/* da */ { IDS_PRINTER_DEVICE_2_FILENAME_DA, "Printer enhed #2 uddata" },
/* de */ { IDS_PRINTER_DEVICE_2_FILENAME_DE, "Drucker Gert #2 Ausgabe" },
/* fr */ { IDS_PRINTER_DEVICE_2_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_DEVICE_2_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_DEVICE_2_FILENAME_IT, "Output stampante #2..." },
/* nl */ { IDS_PRINTER_DEVICE_2_FILENAME_NL, "Printer apparaat #2 uitvoer" },
/* pl */ { IDS_PRINTER_DEVICE_2_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_DEVICE_2_FILENAME_SV, "Utdata fr skrivarenhet 2" },
/* tr */ { IDS_PRINTER_DEVICE_2_FILENAME_TR, "Yazc aygt #2 kts" },

/* en */ { IDS_PRINTER_DEVICE_3_FILENAME,    "Printer device #3 output" },
/* da */ { IDS_PRINTER_DEVICE_3_FILENAME_DA, "Printer enhed #3 uddata" },
/* de */ { IDS_PRINTER_DEVICE_3_FILENAME_DE, "Drucker Gert #3 Ausgabe" },
/* fr */ { IDS_PRINTER_DEVICE_3_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_PRINTER_DEVICE_3_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_PRINTER_DEVICE_3_FILENAME_IT, "Output stampante #3..." },
/* nl */ { IDS_PRINTER_DEVICE_3_FILENAME_NL, "Printer apparaat #3 uitvoer" },
/* pl */ { IDS_PRINTER_DEVICE_3_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_PRINTER_DEVICE_3_FILENAME_SV, "Utdata fr skrivarenhet 3" },
/* tr */ { IDS_PRINTER_DEVICE_3_FILENAME_TR, "Yazc aygt #3 kts" },

/* en */ { IDS_ENABLE_IEC_PRINTER_4,    "IEC emulation for printer #4" },
/* da */ { IDS_ENABLE_IEC_PRINTER_4_DA, "IEC-emulering for printer #4" },
/* de */ { IDS_ENABLE_IEC_PRINTER_4_DE, "IEC Gerte Emulation fr Drucker #4" },
/* fr */ { IDS_ENABLE_IEC_PRINTER_4_FR, "" },  /* fuzzy */
/* hu */ { IDS_ENABLE_IEC_PRINTER_4_HU, "" },  /* fuzzy */
/* it */ { IDS_ENABLE_IEC_PRINTER_4_IT, "Emulazione IEC per la stampante #4" },
/* nl */ { IDS_ENABLE_IEC_PRINTER_4_NL, "IEC emulatie voor apparaat #4" },
/* pl */ { IDS_ENABLE_IEC_PRINTER_4_PL, "" },  /* fuzzy */
/* sv */ { IDS_ENABLE_IEC_PRINTER_4_SV, "IEC-emulering fr skrivare 4" },
/* tr */ { IDS_ENABLE_IEC_PRINTER_4_TR, "Yazc #4 iin IEC emlasyonu" },

/* en */ { IDS_ENABLE_IEC_PRINTER_5,    "IEC emulation for printer #5" },
/* da */ { IDS_ENABLE_IEC_PRINTER_5_DA, "IEC-emulering for printer #5" },
/* de */ { IDS_ENABLE_IEC_PRINTER_5_DE, "IEC Gerte Emulation fr Drucker #5" },
/* fr */ { IDS_ENABLE_IEC_PRINTER_5_FR, "" },  /* fuzzy */
/* hu */ { IDS_ENABLE_IEC_PRINTER_5_HU, "" },  /* fuzzy */
/* it */ { IDS_ENABLE_IEC_PRINTER_5_IT, "Emulazione IEC per la stampante #5" },
/* nl */ { IDS_ENABLE_IEC_PRINTER_5_NL, "IEC emulatie voor apparaat #5" },
/* pl */ { IDS_ENABLE_IEC_PRINTER_5_PL, "" },  /* fuzzy */
/* sv */ { IDS_ENABLE_IEC_PRINTER_5_SV, "IEC-emulering fr skrivare 5" },
/* tr */ { IDS_ENABLE_IEC_PRINTER_5_TR, "Yazc #5 iin IEC emlasyonu" },

/* en */ { IDS_PRINTER_SETTINGS,    "Printer settings" },
/* da */ { IDS_PRINTER_SETTINGS_DA, "Printerindstillinger" },
/* de */ { IDS_PRINTER_SETTINGS_DE, "Drucker Einstellungen" },
/* fr */ { IDS_PRINTER_SETTINGS_FR, "Paramtres d'imprimante" },
/* hu */ { IDS_PRINTER_SETTINGS_HU, "Nyomtat belltsai" },
/* it */ { IDS_PRINTER_SETTINGS_IT, "Impostazioni stampanti" },
/* nl */ { IDS_PRINTER_SETTINGS_NL, "Printer instellingen" },
/* pl */ { IDS_PRINTER_SETTINGS_PL, "Ustawienia drukarki" },
/* sv */ { IDS_PRINTER_SETTINGS_SV, "Skrivarinstllningar" },
/* tr */ { IDS_PRINTER_SETTINGS_TR, "Yazc ayarlar" },

/* en */ { IDS_MAGIC_VOICE_FILENAME,    "Magic Voice file" },
/* da */ { IDS_MAGIC_VOICE_FILENAME_DA, "Magic Voice-fil" },
/* de */ { IDS_MAGIC_VOICE_FILENAME_DE, "Magic Voice Datei" },
/* fr */ { IDS_MAGIC_VOICE_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_MAGIC_VOICE_FILENAME_HU, "" },  /* fuzzy */
/* it */ { IDS_MAGIC_VOICE_FILENAME_IT, "File Magic Voice" },
/* nl */ { IDS_MAGIC_VOICE_FILENAME_NL, "Magic Voice bestand" },
/* pl */ { IDS_MAGIC_VOICE_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_MAGIC_VOICE_FILENAME_SV, "Magic Voice-fil" },
/* tr */ { IDS_MAGIC_VOICE_FILENAME_TR, "Magic Voice dosyas" },

/* en */ { IDS_MAGIC_VOICE_FILENAME_SELECT,    "Select file for Magic Voice" },
/* da */ { IDS_MAGIC_VOICE_FILENAME_SELECT_DA, "Vlg fil for Magic Voice" },
/* de */ { IDS_MAGIC_VOICE_FILENAME_SELECT_DE, "Datei fr Magic Voice auswhlen" },
/* fr */ { IDS_MAGIC_VOICE_FILENAME_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_MAGIC_VOICE_FILENAME_SELECT_HU, "" },  /* fuzzy */
/* it */ { IDS_MAGIC_VOICE_FILENAME_SELECT_IT, "Seleziona file per Magic Voice" },
/* nl */ { IDS_MAGIC_VOICE_FILENAME_SELECT_NL, "Selecteer bestand voor Magic Voice" },
/* pl */ { IDS_MAGIC_VOICE_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_MAGIC_VOICE_FILENAME_SELECT_SV, "Vlj fil fr Magic Voice" },
/* tr */ { IDS_MAGIC_VOICE_FILENAME_SELECT_TR, "Magic Voice iin dosya sein" },

/* en */ { IDS_MAGIC_VOICE_SETTINGS,    "Magic Voice settings" },
/* da */ { IDS_MAGIC_VOICE_SETTINGS_DA, "Magic Voice indstillinger" },
/* de */ { IDS_MAGIC_VOICE_SETTINGS_DE, "Magic Voice Einstellungen" },
/* fr */ { IDS_MAGIC_VOICE_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_MAGIC_VOICE_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_MAGIC_VOICE_SETTINGS_IT, "Impostazioni Magic Voice" },
/* nl */ { IDS_MAGIC_VOICE_SETTINGS_NL, "Magic Voice instellingen" },
/* pl */ { IDS_MAGIC_VOICE_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_MAGIC_VOICE_SETTINGS_SV, "Magic Voice-instllningar" },
/* tr */ { IDS_MAGIC_VOICE_SETTINGS_TR, "Magic Voice ayarlar" },

/* en */ { IDS_USERPORT_RS232,    "Userport RS232" },
/* da */ { IDS_USERPORT_RS232_DA, "Brugerport RS232" },
/* de */ { IDS_USERPORT_RS232_DE, "Userport RS232" },
/* fr */ { IDS_USERPORT_RS232_FR, "" },  /* fuzzy */
/* hu */ { IDS_USERPORT_RS232_HU, "Userport RS232" },
/* it */ { IDS_USERPORT_RS232_IT, "Userport RS232" },
/* nl */ { IDS_USERPORT_RS232_NL, "Userport RS232" },
/* pl */ { IDS_USERPORT_RS232_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_RS232_SV, "Anvndarport-RS232" },
/* tr */ { IDS_USERPORT_RS232_TR, "Userport RS232" },

/* en */ { IDS_USERPORT_DEVICE,    "Userport RS232 device" },
/* da */ { IDS_USERPORT_DEVICE_DA, "Brugerportens RS232-enhed" },
/* de */ { IDS_USERPORT_DEVICE_DE, "Userport RS232 Gert" },
/* fr */ { IDS_USERPORT_DEVICE_FR, "Priphrique de port utilisateur RS232" },
/* hu */ { IDS_USERPORT_DEVICE_HU, "Userport RS232 eszkz" },
/* it */ { IDS_USERPORT_DEVICE_IT, "Dispositivo RS232 su userport" },
/* nl */ { IDS_USERPORT_DEVICE_NL, "Userport RS232 apparaat" },
/* pl */ { IDS_USERPORT_DEVICE_PL, "Urzdzenie portu RS232" },
/* sv */ { IDS_USERPORT_DEVICE_SV, "Anvndarportens RS232-enhet" },
/* tr */ { IDS_USERPORT_DEVICE_TR, "Userport RS232 aygt" },

/* en */ { IDS_USERPORT_BAUD_RATE,    "Userport RS232 baud rate" },
/* da */ { IDS_USERPORT_BAUD_RATE_DA, "Brugerportens RS232-baudhastighet" },
/* de */ { IDS_USERPORT_BAUD_RATE_DE, "Userport RS232 Baud Rate" },
/* fr */ { IDS_USERPORT_BAUD_RATE_FR, "Priphrique de port utilisateur RS232" },
/* hu */ { IDS_USERPORT_BAUD_RATE_HU, "Userport RS232 tviteli rta" },
/* it */ { IDS_USERPORT_BAUD_RATE_IT, "Velocit RS232 su userport" },
/* nl */ { IDS_USERPORT_BAUD_RATE_NL, "Userport RS232 baudrate" },
/* pl */ { IDS_USERPORT_BAUD_RATE_PL, "" },  /* fuzzy */
/* sv */ { IDS_USERPORT_BAUD_RATE_SV, "Anvndarportens RS232-baudhastighet" },
/* tr */ { IDS_USERPORT_BAUD_RATE_TR, "Userport RS232 baud rate" },

/* en */ { IDS_RS232_USERPORT_SETTINGS,    "RS232 Userport Settings" },
/* da */ { IDS_RS232_USERPORT_SETTINGS_DA, "RS232-brugerportindstillinger" },
/* de */ { IDS_RS232_USERPORT_SETTINGS_DE, "RS232 Userport Einstellungen" },
/* fr */ { IDS_RS232_USERPORT_SETTINGS_FR, "Paramtres RS232 Userport" },
/* hu */ { IDS_RS232_USERPORT_SETTINGS_HU, "RS232 Userport belltsai" },
/* it */ { IDS_RS232_USERPORT_SETTINGS_IT, "Impostazioni RS232 su userport" },
/* nl */ { IDS_RS232_USERPORT_SETTINGS_NL, "RS232 Userport instellingen" },
/* pl */ { IDS_RS232_USERPORT_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_RS232_USERPORT_SETTINGS_SV, "RS232-anvndarportinstllningar" },
/* tr */ { IDS_RS232_USERPORT_SETTINGS_TR, "RS232 Userport Ayarlar" },

/* en */ { IDS_FAST,    "Fast" },
/* da */ { IDS_FAST_DA, "Hurtig" },
/* de */ { IDS_FAST_DE, "Schnell" },
/* fr */ { IDS_FAST_FR, "" },  /* fuzzy */
/* hu */ { IDS_FAST_HU, "" },  /* fuzzy */
/* it */ { IDS_FAST_IT, "Veloce" },
/* nl */ { IDS_FAST_NL, "Snel" },
/* pl */ { IDS_FAST_PL, "" },  /* fuzzy */
/* sv */ { IDS_FAST_SV, "Snabbt" },
/* tr */ { IDS_FAST_TR, "Hzl" },

/* en */ { IDS_INTERPOLATING,    "Interpolating" },
/* da */ { IDS_INTERPOLATING_DA, "Interpolerende" },
/* de */ { IDS_INTERPOLATING_DE, "Interpolierend" },
/* fr */ { IDS_INTERPOLATING_FR, "" },  /* fuzzy */
/* hu */ { IDS_INTERPOLATING_HU, "" },  /* fuzzy */
/* it */ { IDS_INTERPOLATING_IT, "Interpolazione" },
/* nl */ { IDS_INTERPOLATING_NL, "Interpoleren" },
/* pl */ { IDS_INTERPOLATING_PL, "" },  /* fuzzy */
/* sv */ { IDS_INTERPOLATING_SV, "Interpolerande" },
/* tr */ { IDS_INTERPOLATING_TR, "Ara deer bulma" },

/* en */ { IDS_RESAMPLING,    "Resampling" },
/* da */ { IDS_RESAMPLING_DA, "Resampling" },
/* de */ { IDS_RESAMPLING_DE, "Resampling" },
/* fr */ { IDS_RESAMPLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_RESAMPLING_HU, "" },  /* fuzzy */
/* it */ { IDS_RESAMPLING_IT, "Ricampionamento" },
/* nl */ { IDS_RESAMPLING_NL, "Resampling" },
/* pl */ { IDS_RESAMPLING_PL, "" },  /* fuzzy */
/* sv */ { IDS_RESAMPLING_SV, "Omsamplande" },
/* tr */ { IDS_RESAMPLING_TR, "Yeniden rnekleme" },

/* en */ { IDS_FAST_RESAMPLING,    "Fast resampling" },
/* da */ { IDS_FAST_RESAMPLING_DA, "Hurtig omsampling" },
/* de */ { IDS_FAST_RESAMPLING_DE, "Schnelles Resampling" },
/* fr */ { IDS_FAST_RESAMPLING_FR, "" },  /* fuzzy */
/* hu */ { IDS_FAST_RESAMPLING_HU, "" },  /* fuzzy */
/* it */ { IDS_FAST_RESAMPLING_IT, "Ricampionamento veloce" },
/* nl */ { IDS_FAST_RESAMPLING_NL, "Snelle resampling" },
/* pl */ { IDS_FAST_RESAMPLING_PL, "" },  /* fuzzy */
/* sv */ { IDS_FAST_RESAMPLING_SV, "Snabb omsampling" },
/* tr */ { IDS_FAST_RESAMPLING_TR, "Hzl yeniden rnekleme" },

/* en */ { IDS_SID_STEREO,    "SID Stereo" },
/* da */ { IDS_SID_STEREO_DA, "SID-stereo" },
/* de */ { IDS_SID_STEREO_DE, "SID Stereo" },
/* fr */ { IDS_SID_STEREO_FR, "SID Stro" },
/* hu */ { IDS_SID_STEREO_HU, "SID sztere" },
/* it */ { IDS_SID_STEREO_IT, "Stereo SID" },
/* nl */ { IDS_SID_STEREO_NL, "Stereo SID" },
/* pl */ { IDS_SID_STEREO_PL, "" },  /* fuzzy */
/* sv */ { IDS_SID_STEREO_SV, "SID-stereo" },
/* tr */ { IDS_SID_STEREO_TR, "Stereo SID" },

/* en */ { IDS_STEREO_SID_AT,    "Stereo SID at" },
/* da */ { IDS_STEREO_SID_AT_DA, "Stereo-SID p" },
/* de */ { IDS_STEREO_SID_AT_DE, "Stereo SID bei" },
/* fr */ { IDS_STEREO_SID_AT_FR, "SID Stro " },
/* hu */ { IDS_STEREO_SID_AT_HU, "Sztere SID itt:" },
/* it */ { IDS_STEREO_SID_AT_IT, "Stereo SID a" },
/* nl */ { IDS_STEREO_SID_AT_NL, "Stereo SID op" },
/* pl */ { IDS_STEREO_SID_AT_PL, "" },  /* fuzzy */
/* sv */ { IDS_STEREO_SID_AT_SV, "Stereo-SID p" },
/* tr */ { IDS_STEREO_SID_AT_TR, "Stereo SID konumu" },

/* en */ { IDS_SID_FILTERS,    "SID filters" },
/* da */ { IDS_SID_FILTERS_DA, "SID-filtre" },
/* de */ { IDS_SID_FILTERS_DE, "SID Filter" },
/* fr */ { IDS_SID_FILTERS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SID_FILTERS_HU, "" },  /* fuzzy */
/* it */ { IDS_SID_FILTERS_IT, "Filtri SID" },
/* nl */ { IDS_SID_FILTERS_NL, "SID filters" },
/* pl */ { IDS_SID_FILTERS_PL, "" },  /* fuzzy */
/* sv */ { IDS_SID_FILTERS_SV, "SID-filter" },
/* tr */ { IDS_SID_FILTERS_TR, "SID filtreleri" },

/* en */ { IDS_SAMPLE_METHOD,    "Sample method" },
/* da */ { IDS_SAMPLE_METHOD_DA, "Samplingmetode" },
/* de */ { IDS_SAMPLE_METHOD_DE, "Sample Methode" },
/* fr */ { IDS_SAMPLE_METHOD_FR, "Mthode d'chantillonnage" },
/* hu */ { IDS_SAMPLE_METHOD_HU, "Mintavtelezs mdja" },
/* it */ { IDS_SAMPLE_METHOD_IT, "Metodo di campionamento" },
/* nl */ { IDS_SAMPLE_METHOD_NL, "Sample methode" },
/* pl */ { IDS_SAMPLE_METHOD_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAMPLE_METHOD_SV, "Samplingsmetod" },
/* tr */ { IDS_SAMPLE_METHOD_TR, "rnekleme metodu" },

/* en */ { IDS_PASSBAND_0_90,    "Passband (0-90%)" },
/* da */ { IDS_PASSBAND_0_90_DA, "Pasbnd (0-90%)" },
/* de */ { IDS_PASSBAND_0_90_DE, "Passband (0-90%)" },
/* fr */ { IDS_PASSBAND_0_90_FR, "Bande passante (0-90%)" },
/* hu */ { IDS_PASSBAND_0_90_HU, "teresztsg (0-90%)" },
/* it */ { IDS_PASSBAND_0_90_IT, "Passabanda (0-90%)" },
/* nl */ { IDS_PASSBAND_0_90_NL, "Passband (0-90%)" },
/* pl */ { IDS_PASSBAND_0_90_PL, "" },  /* fuzzy */
/* sv */ { IDS_PASSBAND_0_90_SV, "Passband (0-90%)" },
/* tr */ { IDS_PASSBAND_0_90_TR, "Passband (0-90%)" },

/* en */ { IDS_NOT_IMPLEMENTED_YET,    "Not implemented yet!" },
/* da */ { IDS_NOT_IMPLEMENTED_YET_DA, "Ikke implementeret endnu!" },
/* de */ { IDS_NOT_IMPLEMENTED_YET_DE, "Noch nicht implementiert!" },
/* fr */ { IDS_NOT_IMPLEMENTED_YET_FR, "Pas encore implment!" },
/* hu */ { IDS_NOT_IMPLEMENTED_YET_HU, "Mg nem implementlt!" },
/* it */ { IDS_NOT_IMPLEMENTED_YET_IT, "Non ancora implementato!" },
/* nl */ { IDS_NOT_IMPLEMENTED_YET_NL, "Nog niet ondersteund!" },
/* pl */ { IDS_NOT_IMPLEMENTED_YET_PL, "" },  /* fuzzy */
/* sv */ { IDS_NOT_IMPLEMENTED_YET_SV, "Ej implementerat nnu!" },
/* tr */ { IDS_NOT_IMPLEMENTED_YET_TR, "Henz tamamlanmad!" },

/* en */ { IDS_SID_SETTINGS,    "SID settings" },
/* da */ { IDS_SID_SETTINGS_DA, "SID-indstillinger" },
/* de */ { IDS_SID_SETTINGS_DE, "SID Einstellungen" },
/* fr */ { IDS_SID_SETTINGS_FR, "Paramtres SID" },
/* hu */ { IDS_SID_SETTINGS_HU, "SID belltsai" },
/* it */ { IDS_SID_SETTINGS_IT, "Impostazioni SID" },
/* nl */ { IDS_SID_SETTINGS_NL, "SID instellingen" },
/* pl */ { IDS_SID_SETTINGS_PL, "Ustawienia ukadu SID" },
/* sv */ { IDS_SID_SETTINGS_SV, "SID-instllningar" },
/* tr */ { IDS_SID_SETTINGS_TR, "SID ayarlar" },

/* en */ { IDS_FLEXIBLE,    "Flexible" },
/* da */ { IDS_FLEXIBLE_DA, "Fleksibel" },
/* de */ { IDS_FLEXIBLE_DE, "Flexibel" },
/* fr */ { IDS_FLEXIBLE_FR, "Flexible" },
/* hu */ { IDS_FLEXIBLE_HU, "Rugalmas" },
/* it */ { IDS_FLEXIBLE_IT, "Flessibile" },
/* nl */ { IDS_FLEXIBLE_NL, "Flexibel" },
/* pl */ { IDS_FLEXIBLE_PL, "" },  /* fuzzy */
/* sv */ { IDS_FLEXIBLE_SV, "Flexibel" },
/* tr */ { IDS_FLEXIBLE_TR, "Esnek" },

/* en */ { IDS_ADJUSTING,    "Adjusting" },
/* da */ { IDS_ADJUSTING_DA, "Tilpassende" },
/* de */ { IDS_ADJUSTING_DE, "Anpassend" },
/* fr */ { IDS_ADJUSTING_FR, "Ajust" },
/* hu */ { IDS_ADJUSTING_HU, "Igazod" },
/* it */ { IDS_ADJUSTING_IT, "Adattabile" },
/* nl */ { IDS_ADJUSTING_NL, "Aanpassend" },
/* pl */ { IDS_ADJUSTING_PL, "" },  /* fuzzy */
/* sv */ { IDS_ADJUSTING_SV, "Anpassande" },
/* tr */ { IDS_ADJUSTING_TR, "Dzeltme" },

/* en */ { IDS_EXACT,    "Exact" },
/* da */ { IDS_EXACT_DA, "Njagtig" },
/* de */ { IDS_EXACT_DE, "Exakt" },
/* fr */ { IDS_EXACT_FR, "Exact" },
/* hu */ { IDS_EXACT_HU, "Pontos" },
/* it */ { IDS_EXACT_IT, "Esatta" },
/* nl */ { IDS_EXACT_NL, "Exact" },
/* pl */ { IDS_EXACT_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXACT_SV, "Exakt" },
/* tr */ { IDS_EXACT_TR, "Aynen" },

/* en */ { IDS_SAMPLE_RATE,    "Sample rate" },
/* da */ { IDS_SAMPLE_RATE_DA, "Samplingfrekvens" },
/* de */ { IDS_SAMPLE_RATE_DE, "Sample Rate" },
/* fr */ { IDS_SAMPLE_RATE_FR, "Taux d'chantillonage" },
/* hu */ { IDS_SAMPLE_RATE_HU, "Mintavtelezsi rta" },
/* it */ { IDS_SAMPLE_RATE_IT, "Frequenza di campionamento" },
/* nl */ { IDS_SAMPLE_RATE_NL, "Sample snelheid" },
/* pl */ { IDS_SAMPLE_RATE_PL, "Prdko sampli" },
/* sv */ { IDS_SAMPLE_RATE_SV, "Samplingshastighet" },
/* tr */ { IDS_SAMPLE_RATE_TR, "rnek hz" },

/* en */ { IDS_BUFFER_SIZE,    "Buffer size" },
/* da */ { IDS_BUFFER_SIZE_DA, "Bufferstrrelse" },
/* de */ { IDS_BUFFER_SIZE_DE, "Puffergre" },
/* fr */ { IDS_BUFFER_SIZE_FR, "Taille du tampon" },
/* hu */ { IDS_BUFFER_SIZE_HU, "Puffer mret" },
/* it */ { IDS_BUFFER_SIZE_IT, "Dimensione buffer" },
/* nl */ { IDS_BUFFER_SIZE_NL, "Buffergrootte" },
/* pl */ { IDS_BUFFER_SIZE_PL, "Rozmiar buffora" },
/* sv */ { IDS_BUFFER_SIZE_SV, "Buffertstorlek" },
/* tr */ { IDS_BUFFER_SIZE_TR, "Arabellek boyutu" },

/* en */ { IDS_FRAGMENT_SIZE,    "Fragment size" },
/* da */ { IDS_FRAGMENT_SIZE_DA, "Fragmentstrrelse" },
/* de */ { IDS_FRAGMENT_SIZE_DE, "Fragmentgre" },
/* fr */ { IDS_FRAGMENT_SIZE_FR, "" },  /* fuzzy */
/* hu */ { IDS_FRAGMENT_SIZE_HU, "Tredk mrete" },
/* it */ { IDS_FRAGMENT_SIZE_IT, "Dimensione frammento" },
/* nl */ { IDS_FRAGMENT_SIZE_NL, "Fragment grootte" },
/* pl */ { IDS_FRAGMENT_SIZE_PL, "" },  /* fuzzy */
/* sv */ { IDS_FRAGMENT_SIZE_SV, "Fragmentstorlek" },
/* tr */ { IDS_FRAGMENT_SIZE_TR, "Para boyutu" },

/* en */ { IDS_SPEED_ADJUSTMENT,    "Speed Adjustment" },
/* da */ { IDS_SPEED_ADJUSTMENT_DA, "Hastighedsjustering" },
/* de */ { IDS_SPEED_ADJUSTMENT_DE, "Geschwindigkeitsanpassung" },
/* fr */ { IDS_SPEED_ADJUSTMENT_FR, "Ajustement de vitesse" },
/* hu */ { IDS_SPEED_ADJUSTMENT_HU, "Sebessg bellts" },
/* it */ { IDS_SPEED_ADJUSTMENT_IT, "Variazione velocit" },
/* nl */ { IDS_SPEED_ADJUSTMENT_NL, "Snelheidsaanpassing" },
/* pl */ { IDS_SPEED_ADJUSTMENT_PL, "" },  /* fuzzy */
/* sv */ { IDS_SPEED_ADJUSTMENT_SV, "Hastighetsjusering" },
/* tr */ { IDS_SPEED_ADJUSTMENT_TR, "Hz Ayarlamas" },

/* en */ { IDS_SOUND_SETTINGS,    "Sound settings" },
/* da */ { IDS_SOUND_SETTINGS_DA, "Lydindstillinger" },
/* de */ { IDS_SOUND_SETTINGS_DE, "Sound Einstellungen" },
/* fr */ { IDS_SOUND_SETTINGS_FR, "Paramtres son" },
/* hu */ { IDS_SOUND_SETTINGS_HU, "Hang belltsai" },
/* it */ { IDS_SOUND_SETTINGS_IT, "Impostazioni audio" },
/* nl */ { IDS_SOUND_SETTINGS_NL, "Geluidsinstellingen" },
/* pl */ { IDS_SOUND_SETTINGS_PL, "Ustawienia dwiku" },
/* sv */ { IDS_SOUND_SETTINGS_SV, "Ljudinstllningar" },
/* tr */ { IDS_SOUND_SETTINGS_TR, "Ses ayarlar" },

/* en */ { IDS_VIC_SETTINGS,    "VIC settings" },
/* da */ { IDS_VIC_SETTINGS_DA, "VIC-indstillinger" },
/* de */ { IDS_VIC_SETTINGS_DE, "VIC Einstellungen" },
/* fr */ { IDS_VIC_SETTINGS_FR, "Paramtres VIC" },
/* hu */ { IDS_VIC_SETTINGS_HU, "VIC belltsai" },
/* it */ { IDS_VIC_SETTINGS_IT, "Impostazioni VIC" },
/* nl */ { IDS_VIC_SETTINGS_NL, "VIC instellingen" },
/* pl */ { IDS_VIC_SETTINGS_PL, "Ustawienia VIC" },
/* sv */ { IDS_VIC_SETTINGS_SV, "VIC-instllningar" },
/* tr */ { IDS_VIC_SETTINGS_TR, "VIC ayarlar" },

/* en */ { IDS_SPRITE_SPRITE_COL,    "Sprite-sprite collisions" },
/* da */ { IDS_SPRITE_SPRITE_COL_DA, "Sprite-til-sprite-kollision" },
/* de */ { IDS_SPRITE_SPRITE_COL_DE, "Sprite-sprite Kollisionen" },
/* fr */ { IDS_SPRITE_SPRITE_COL_FR, "" },  /* fuzzy */
/* hu */ { IDS_SPRITE_SPRITE_COL_HU, "" },  /* fuzzy */
/* it */ { IDS_SPRITE_SPRITE_COL_IT, "Collisioni sprite-sprite" },
/* nl */ { IDS_SPRITE_SPRITE_COL_NL, "Sprite-sprite botsingen" },
/* pl */ { IDS_SPRITE_SPRITE_COL_PL, "" },  /* fuzzy */
/* sv */ { IDS_SPRITE_SPRITE_COL_SV, "Sprite-till-sprite-kollision" },
/* tr */ { IDS_SPRITE_SPRITE_COL_TR, "Yartk-yaratk arpmalar" },

/* en */ { IDS_SPRITE_BACKGROUND_COL,    "Sprite-background collisions" },
/* da */ { IDS_SPRITE_BACKGROUND_COL_DA, "Sprite-til-baggrunds-kollision" },
/* de */ { IDS_SPRITE_BACKGROUND_COL_DE, "Sprite-Hintergrund Kollisionen" },
/* fr */ { IDS_SPRITE_BACKGROUND_COL_FR, "" },  /* fuzzy */
/* hu */ { IDS_SPRITE_BACKGROUND_COL_HU, "" },  /* fuzzy */
/* it */ { IDS_SPRITE_BACKGROUND_COL_IT, "Collisioni sprite-sfondo" },
/* nl */ { IDS_SPRITE_BACKGROUND_COL_NL, "Sprite-achtergrond botsingen" },
/* pl */ { IDS_SPRITE_BACKGROUND_COL_PL, "" },  /* fuzzy */
/* sv */ { IDS_SPRITE_BACKGROUND_COL_SV, "Sprite-till-bakgrund-kollision" },
/* tr */ { IDS_SPRITE_BACKGROUND_COL_TR, "Yaratk-arkaplan arpmalar" },

/* en */ { IDS_NEW_LUMINANCES,    "New luminances" },
/* da */ { IDS_NEW_LUMINANCES_DA, "Nye lysstyrker" },
/* de */ { IDS_NEW_LUMINANCES_DE, "Neue Helligkeitsemulation" },
/* fr */ { IDS_NEW_LUMINANCES_FR, "" },  /* fuzzy */
/* hu */ { IDS_NEW_LUMINANCES_HU, "" },  /* fuzzy */
/* it */ { IDS_NEW_LUMINANCES_IT, "Nuove luminanze" },
/* nl */ { IDS_NEW_LUMINANCES_NL, "Nieuwe kleuren" },
/* pl */ { IDS_NEW_LUMINANCES_PL, "" },  /* fuzzy */
/* sv */ { IDS_NEW_LUMINANCES_SV, "Nya ljusstyrkor" },
/* tr */ { IDS_NEW_LUMINANCES_TR, "Yeni parlaklklar" },

/* en */ { IDS_VICII_SETTINGS,    "VIC-II settings" },
/* da */ { IDS_VICII_SETTINGS_DA, "VIC-II-indstillinger" },
/* de */ { IDS_VICII_SETTINGS_DE, "VIC-II Einstellungen" },
/* fr */ { IDS_VICII_SETTINGS_FR, "Paramtres VIC-II" },
/* hu */ { IDS_VICII_SETTINGS_HU, "VIC-II belltsai" },
/* it */ { IDS_VICII_SETTINGS_IT, "Impostazioni VIC-II" },
/* nl */ { IDS_VICII_SETTINGS_NL, "VIC-II instellingen" },
/* pl */ { IDS_VICII_SETTINGS_PL, "Ustawienia VIC-II" },
/* sv */ { IDS_VICII_SETTINGS_SV, "VIC-II-instllningar" },
/* tr */ { IDS_VICII_SETTINGS_TR, "VIC-II ayarlar" },

/* en */ { IDS_ATTACH_TAPE_IMAGE,    "Attach tape image" },
/* da */ { IDS_ATTACH_TAPE_IMAGE_DA, "Tilslut bnd-image" },
/* de */ { IDS_ATTACH_TAPE_IMAGE_DE, "Band Image einlegen" },
/* fr */ { IDS_ATTACH_TAPE_IMAGE_FR, "Insrer une image de datassette" },
/* hu */ { IDS_ATTACH_TAPE_IMAGE_HU, "Szalag kpms csatolsa" },
/* it */ { IDS_ATTACH_TAPE_IMAGE_IT, "Seleziona immagine cassetta" },
/* nl */ { IDS_ATTACH_TAPE_IMAGE_NL, "Koppel tapebestand aan" },
/* pl */ { IDS_ATTACH_TAPE_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_TAPE_IMAGE_SV, "Anslut bandavbildningsfil" },
/* tr */ { IDS_ATTACH_TAPE_IMAGE_TR, "Teyp imajn yerletir" },

/* en */ { IDS_AUTOSTART_IMAGE,    "Autostart disk/tape image" },
/* da */ { IDS_AUTOSTART_IMAGE_DA, "Autostart disk-/bnd-image" },
/* de */ { IDS_AUTOSTART_IMAGE_DE, "Autostart von Disk/Band Image" },
/* fr */ { IDS_AUTOSTART_IMAGE_FR, "Dmarrer automatiquement une image de disque/datassette" },
/* hu */ { IDS_AUTOSTART_IMAGE_HU, "Lemez/szalag kpms automatikus indtsa" },
/* it */ { IDS_AUTOSTART_IMAGE_IT, "Avvia automaticamente immagine disco/cassetta" },
/* nl */ { IDS_AUTOSTART_IMAGE_NL, "Autostart disk-/tapebestand" },
/* pl */ { IDS_AUTOSTART_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_IMAGE_SV, "Autostarta disk-/bandavbildningsfil" },
/* tr */ { IDS_AUTOSTART_IMAGE_TR, "Disk/Teyp imajn otomatik balat" },

/* en */ { IDS_IDE64_FILENAME_1,    "HD image #1 file" },
/* da */ { IDS_IDE64_FILENAME_1_DA, "HD-imagefil #1" },
/* de */ { IDS_IDE64_FILENAME_1_DE, "HD Image #1 Datei" },
/* fr */ { IDS_IDE64_FILENAME_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_IDE64_FILENAME_1_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_FILENAME_1_IT, "File immagine #1 HD" },
/* nl */ { IDS_IDE64_FILENAME_1_NL, "HD bestand #1" },
/* pl */ { IDS_IDE64_FILENAME_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_FILENAME_1_SV, "HD-avbildningsfil 1" },
/* tr */ { IDS_IDE64_FILENAME_1_TR, "HD imaj #1 dosyas" },

/* en */ { IDS_IDE64_FILENAME_2,    "HD image #2 file" },
/* da */ { IDS_IDE64_FILENAME_2_DA, "HD-imagefil #2" },
/* de */ { IDS_IDE64_FILENAME_2_DE, "HD Image #2 Datei" },
/* fr */ { IDS_IDE64_FILENAME_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_IDE64_FILENAME_2_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_FILENAME_2_IT, "File immagine #2 HD" },
/* nl */ { IDS_IDE64_FILENAME_2_NL, "HD bestand #2" },
/* pl */ { IDS_IDE64_FILENAME_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_FILENAME_2_SV, "HD-avbildningsfil 2" },
/* tr */ { IDS_IDE64_FILENAME_2_TR, "HD imaj #2 dosyas" },

/* en */ { IDS_IDE64_FILENAME_3,    "HD image #3 file" },
/* da */ { IDS_IDE64_FILENAME_3_DA, "HD-imagefil #3" },
/* de */ { IDS_IDE64_FILENAME_3_DE, "HD Image #3 Datei" },
/* fr */ { IDS_IDE64_FILENAME_3_FR, "" },  /* fuzzy */
/* hu */ { IDS_IDE64_FILENAME_3_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_FILENAME_3_IT, "File immagine #3 HD" },
/* nl */ { IDS_IDE64_FILENAME_3_NL, "HD bestand #3" },
/* pl */ { IDS_IDE64_FILENAME_3_PL, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_FILENAME_3_SV, "HD-avbildningsfil 3" },
/* tr */ { IDS_IDE64_FILENAME_3_TR, "HD imaj #3 dosyas" },

/* en */ { IDS_IDE64_FILENAME_4,    "HD image #4 file" },
/* da */ { IDS_IDE64_FILENAME_4_DA, "HD-imagefil #4" },
/* de */ { IDS_IDE64_FILENAME_4_DE, "HD Image #4 Datei" },
/* fr */ { IDS_IDE64_FILENAME_4_FR, "" },  /* fuzzy */
/* hu */ { IDS_IDE64_FILENAME_4_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_FILENAME_4_IT, "File immagine #4 HD" },
/* nl */ { IDS_IDE64_FILENAME_4_NL, "HD bestand #4" },
/* pl */ { IDS_IDE64_FILENAME_4_PL, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_FILENAME_4_SV, "HD-avbildningsfil 4" },
/* tr */ { IDS_IDE64_FILENAME_4_TR, "HD imaj #4 dosyas" },

/* en */ { IDS_IDE64_FILENAME_SELECT,    "Select HD image file" },
/* da */ { IDS_IDE64_FILENAME_SELECT_DA, "Angiv HD-imagefil" },
/* de */ { IDS_IDE64_FILENAME_SELECT_DE, "HD Image Datei auswhlen" },
/* fr */ { IDS_IDE64_FILENAME_SELECT_FR, "Slectionnez le fichier image du D.D." },
/* hu */ { IDS_IDE64_FILENAME_SELECT_HU, "Vlassza ki a merevlemez kpms fjlt" },
/* it */ { IDS_IDE64_FILENAME_SELECT_IT, "Seleziona il file immagine HD" },
/* nl */ { IDS_IDE64_FILENAME_SELECT_NL, "Selecteer HD bestand" },
/* pl */ { IDS_IDE64_FILENAME_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_FILENAME_SELECT_SV, "Ange HD-avbildningsfil" },
/* tr */ { IDS_IDE64_FILENAME_SELECT_TR, "HD imaj dosyas se" },

/* en */ { IDS_IDE64_V4,    "IDE64 V4" },
/* da */ { IDS_IDE64_V4_DA, "IDE64 V4" },
/* de */ { IDS_IDE64_V4_DE, "IDE64 V4" },
/* fr */ { IDS_IDE64_V4_FR, "" },  /* fuzzy */
/* hu */ { IDS_IDE64_V4_HU, "" },  /* fuzzy */
/* it */ { IDS_IDE64_V4_IT, "IDE64 V4" },
/* nl */ { IDS_IDE64_V4_NL, "IDE64 V4" },
/* pl */ { IDS_IDE64_V4_PL, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_V4_SV, "IDE64 V4" },
/* tr */ { IDS_IDE64_V4_TR, "IDE64 V4" },

/* en */ { IDS_AUTODETECT,    "Autodetect" },
/* da */ { IDS_AUTODETECT_DA, "Autodetektr" },
/* de */ { IDS_AUTODETECT_DE, "Automatische Erkennung" },
/* fr */ { IDS_AUTODETECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTODETECT_HU, "Automatikus rzkels" },
/* it */ { IDS_AUTODETECT_IT, "Rileva automaticamente" },
/* nl */ { IDS_AUTODETECT_NL, "Autodetectie" },
/* pl */ { IDS_AUTODETECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTODETECT_SV, "Autodetektera" },
/* tr */ { IDS_AUTODETECT_TR, "Otomatik algla" },

/* en */ { IDS_CYLINDERS,    "Cylinders" },
/* da */ { IDS_CYLINDERS_DA, "Cylindrer" },
/* de */ { IDS_CYLINDERS_DE, "Zylinder" },
/* fr */ { IDS_CYLINDERS_FR, "Cylindres" },
/* hu */ { IDS_CYLINDERS_HU, "Svok" },
/* it */ { IDS_CYLINDERS_IT, "Cilindri" },
/* nl */ { IDS_CYLINDERS_NL, "Cylinders" },
/* pl */ { IDS_CYLINDERS_PL, "" },  /* fuzzy */
/* sv */ { IDS_CYLINDERS_SV, "Cylindrar" },
/* tr */ { IDS_CYLINDERS_TR, "Silindirler" },

/* en */ { IDS_HEADS,    "Heads" },
/* da */ { IDS_HEADS_DA, "Hoveder" },
/* de */ { IDS_HEADS_DE, "Kpfe" },
/* fr */ { IDS_HEADS_FR, "Ttes" },
/* hu */ { IDS_HEADS_HU, "Fejek" },
/* it */ { IDS_HEADS_IT, "Testine" },
/* nl */ { IDS_HEADS_NL, "Koppen" },
/* pl */ { IDS_HEADS_PL, "" },  /* fuzzy */
/* sv */ { IDS_HEADS_SV, "Huvuden" },
/* tr */ { IDS_HEADS_TR, "Kafalar" },

/* en */ { IDS_SECTORS,    "Sectors" },
/* da */ { IDS_SECTORS_DA, "Sektorer" },
/* de */ { IDS_SECTORS_DE, "Sektoren" },
/* fr */ { IDS_SECTORS_FR, "Secteurs" },
/* hu */ { IDS_SECTORS_HU, "Szektorok" },
/* it */ { IDS_SECTORS_IT, "Settori" },
/* nl */ { IDS_SECTORS_NL, "Sectors" },
/* pl */ { IDS_SECTORS_PL, "" },  /* fuzzy */
/* sv */ { IDS_SECTORS_SV, "Sektorer" },
/* tr */ { IDS_SECTORS_TR, "Sektrler" },

/* en */ { IDS_IDE64_SETTINGS,    "IDE64 settings" },
/* da */ { IDS_IDE64_SETTINGS_DA, "IDE64-indstillinger" },
/* de */ { IDS_IDE64_SETTINGS_DE, "IDE64 Einstellungen" },
/* fr */ { IDS_IDE64_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_IDE64_SETTINGS_HU, "IDE64 belltsai" },
/* it */ { IDS_IDE64_SETTINGS_IT, "Impostazioni IDE64" },
/* nl */ { IDS_IDE64_SETTINGS_NL, "IDE64 instellingen" },
/* pl */ { IDS_IDE64_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_IDE64_SETTINGS_SV, "IDE64-instllningar" },
/* tr */ { IDS_IDE64_SETTINGS_TR, "IDE64 ayarlar" },

/* en */ { IDS_BIOS_REVISION,    "BIOS Revision" },
/* da */ { IDS_BIOS_REVISION_DA, "BIOS-revision" },
/* de */ { IDS_BIOS_REVISION_DE, "BIOS Revision" },
/* fr */ { IDS_BIOS_REVISION_FR, "" },  /* fuzzy */
/* hu */ { IDS_BIOS_REVISION_HU, "BIOS vltozat" },
/* it */ { IDS_BIOS_REVISION_IT, "Revisione BIOS" },
/* nl */ { IDS_BIOS_REVISION_NL, "BIOS revisie" },
/* pl */ { IDS_BIOS_REVISION_PL, "" },  /* fuzzy */
/* sv */ { IDS_BIOS_REVISION_SV, "BIOS-utgva" },
/* tr */ { IDS_BIOS_REVISION_TR, "BIOS Revizyonu" },

/* en */ { IDS_BIOS_FLASH_JUMPER,    "BIOS Flash Jumper" },
/* da */ { IDS_BIOS_FLASH_JUMPER_DA, "BIOS-flashjumper" },
/* de */ { IDS_BIOS_FLASH_JUMPER_DE, "BIOS Flashjumper" },
/* fr */ { IDS_BIOS_FLASH_JUMPER_FR, "Flash Jumper BIOS" },
/* hu */ { IDS_BIOS_FLASH_JUMPER_HU, "BIOS Flash jumper" },
/* it */ { IDS_BIOS_FLASH_JUMPER_IT, "Flash Jumper del BIOS" },
/* nl */ { IDS_BIOS_FLASH_JUMPER_NL, "BIOS Flash Jumper" },
/* pl */ { IDS_BIOS_FLASH_JUMPER_PL, "" },  /* fuzzy */
/* sv */ { IDS_BIOS_FLASH_JUMPER_SV, "BIOS-flashbygel" },
/* tr */ { IDS_BIOS_FLASH_JUMPER_TR, "BIOS Flash Jumper" },

/* en */ { IDS_SAVE_BIOS_WHEN_CHANGED,    "Save BIOS when changed" },
/* da */ { IDS_SAVE_BIOS_WHEN_CHANGED_DA, "Gem BIOS ved ndringer" },
/* de */ { IDS_SAVE_BIOS_WHEN_CHANGED_DE, "BIOS bei nderung speichern" },
/* fr */ { IDS_SAVE_BIOS_WHEN_CHANGED_FR, "Enregistrer le BIOS lorsque modifi" },
/* hu */ { IDS_SAVE_BIOS_WHEN_CHANGED_HU, "BIOS mentse vltozs utn" },
/* it */ { IDS_SAVE_BIOS_WHEN_CHANGED_IT, "Salva BIOS al cambio" },
/* nl */ { IDS_SAVE_BIOS_WHEN_CHANGED_NL, "Sla de MMC64 BIOS op als er veranderingen zijn gemaakt" },
/* pl */ { IDS_SAVE_BIOS_WHEN_CHANGED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_BIOS_WHEN_CHANGED_SV, "Spara BIOS vid ndring" },
/* tr */ { IDS_SAVE_BIOS_WHEN_CHANGED_TR, "BIOS deitiinde kaydet" },

/* en */ { IDS_BIOS_FILE,    "BIOS File" },
/* da */ { IDS_BIOS_FILE_DA, "BIOS-fil" },
/* de */ { IDS_BIOS_FILE_DE, "BIOS Datei" },
/* fr */ { IDS_BIOS_FILE_FR, "Fichier du BIOS" },
/* hu */ { IDS_BIOS_FILE_HU, "BIOS fjl" },
/* it */ { IDS_BIOS_FILE_IT, "File BIOS" },
/* nl */ { IDS_BIOS_FILE_NL, "BIOS bestand" },
/* pl */ { IDS_BIOS_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_BIOS_FILE_SV, "BIOS-fil" },
/* tr */ { IDS_BIOS_FILE_TR, "BIOS Dosyas" },

/* en */ { IDS_SELECT_BIOS_FILE,    "Select BIOS file" },
/* da */ { IDS_SELECT_BIOS_FILE_DA, "Vlg BIOS-fil" },
/* de */ { IDS_SELECT_BIOS_FILE_DE, "BIOS Datei whlen" },
/* fr */ { IDS_SELECT_BIOS_FILE_FR, "Slectionner le fichier du BIOS" },
/* hu */ { IDS_SELECT_BIOS_FILE_HU, "Vlasszon BIOS fjlt" },
/* it */ { IDS_SELECT_BIOS_FILE_IT, "Seleziona file BIOS" },
/* nl */ { IDS_SELECT_BIOS_FILE_NL, "Selecteer BIOS bestand" },
/* pl */ { IDS_SELECT_BIOS_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_BIOS_FILE_SV, "Vlj BIOS-fil" },
/* tr */ { IDS_SELECT_BIOS_FILE_TR, "BIOS dosyas sein" },

/* en */ { IDS_MMC64_IMAGE_READ_ONLY,    "MMC/SD Image read-only" },
/* da */ { IDS_MMC64_IMAGE_READ_ONLY_DA, "MMC/SD-image skrivebeskyttet" },
/* de */ { IDS_MMC64_IMAGE_READ_ONLY_DE, "MMC/SD Image Schreibschutz" },
/* fr */ { IDS_MMC64_IMAGE_READ_ONLY_FR, "Image MMC/SD en lecture seule" },
/* hu */ { IDS_MMC64_IMAGE_READ_ONLY_HU, "MMC/SD kpms csak olvashat" },
/* it */ { IDS_MMC64_IMAGE_READ_ONLY_IT, "Immagine MMC/SD in sola lettura" },
/* nl */ { IDS_MMC64_IMAGE_READ_ONLY_NL, "MMC/SD bestand alleen-lezen" },
/* pl */ { IDS_MMC64_IMAGE_READ_ONLY_PL, "" },  /* fuzzy */
/* sv */ { IDS_MMC64_IMAGE_READ_ONLY_SV, "MMC/SD-avbildning skrivskyddad" },
/* tr */ { IDS_MMC64_IMAGE_READ_ONLY_TR, "Salt Okunur MMC/SD Imaj" },

/* en */ { IDS_MMC64_IMAGE_FILE,    "MMC/SD Image File" },
/* da */ { IDS_MMC64_IMAGE_FILE_DA, "MMC/SD-image" },
/* de */ { IDS_MMC64_IMAGE_FILE_DE, "MMC/SD Image Name" },
/* fr */ { IDS_MMC64_IMAGE_FILE_FR, "Nom d'image MMC/SD" },
/* hu */ { IDS_MMC64_IMAGE_FILE_HU, "MMC/SD kpms fjl" },
/* it */ { IDS_MMC64_IMAGE_FILE_IT, "File immagine MMC/SD" },
/* nl */ { IDS_MMC64_IMAGE_FILE_NL, "MMC/SD bestand" },
/* pl */ { IDS_MMC64_IMAGE_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_MMC64_IMAGE_FILE_SV, "MMC/SD-avbildningsfil" },
/* tr */ { IDS_MMC64_IMAGE_FILE_TR, "MMC/SD Imaj Dosyas" },

/* en */ { IDS_SD_TYPE,    "Card type" },
/* da */ { IDS_SD_TYPE_DA, "Korttype" },
/* de */ { IDS_SD_TYPE_DE, "Card Typ" },
/* fr */ { IDS_SD_TYPE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SD_TYPE_HU, "" },  /* fuzzy */
/* it */ { IDS_SD_TYPE_IT, "Tipo card" },
/* nl */ { IDS_SD_TYPE_NL, "Card soort" },
/* pl */ { IDS_SD_TYPE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SD_TYPE_SV, "Korttyp" },
/* tr */ { IDS_SD_TYPE_TR, "Kart tipi" },

/* en */ { IDS_SELECT_MMC64_IMAGE_FILE,    "Select MMC/SD image file" },
/* da */ { IDS_SELECT_MMC64_IMAGE_FILE_DA, "Vlg MMC/SD-image" },
/* de */ { IDS_SELECT_MMC64_IMAGE_FILE_DE, "MMC/SD Image Date whlen" },
/* fr */ { IDS_SELECT_MMC64_IMAGE_FILE_FR, "Slectionnez le fichier image du MMC/SD" },
/* hu */ { IDS_SELECT_MMC64_IMAGE_FILE_HU, "Vlassza ki az MMC/SD kpms fjlt" },
/* it */ { IDS_SELECT_MMC64_IMAGE_FILE_IT, "Seleziona file immagine MMC/SD" },
/* nl */ { IDS_SELECT_MMC64_IMAGE_FILE_NL, "Selecteer MMC/SD bestand" },
/* pl */ { IDS_SELECT_MMC64_IMAGE_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_MMC64_IMAGE_FILE_SV, "Ange MMC/SD-avbildningsfil" },
/* tr */ { IDS_SELECT_MMC64_IMAGE_FILE_TR, "MMC/SD imaj dosyas sein" },

/* en */ { IDS_MMC64_SETTINGS,    "MMC64 settings" },
/* da */ { IDS_MMC64_SETTINGS_DA, "MMC64-indstillinger" },
/* de */ { IDS_MMC64_SETTINGS_DE, "MMC64 Einstellungen" },
/* fr */ { IDS_MMC64_SETTINGS_FR, "Paramtres MMC64..." },
/* hu */ { IDS_MMC64_SETTINGS_HU, "MMC64 belltsai" },
/* it */ { IDS_MMC64_SETTINGS_IT, "Impostazioni MMC64" },
/* nl */ { IDS_MMC64_SETTINGS_NL, "MMC64 instellingen" },
/* pl */ { IDS_MMC64_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_MMC64_SETTINGS_SV, "MMC64-instllningar..." },
/* tr */ { IDS_MMC64_SETTINGS_TR, "MMC64 ayarlar" },

/* en */ { IDS_SELECT_EEPROM_FILE,    "Select EEPROM file" },
/* da */ { IDS_SELECT_EEPROM_FILE_DA, "Vlg EEPROM-fil" },
/* de */ { IDS_SELECT_EEPROM_FILE_DE, "EEPROM Datei whlen" },
/* fr */ { IDS_SELECT_EEPROM_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_EEPROM_FILE_HU, "" },  /* fuzzy */
/* it */ { IDS_SELECT_EEPROM_FILE_IT, "Seleziona file EEPROM" },
/* nl */ { IDS_SELECT_EEPROM_FILE_NL, "Selecteer EEPROM bestand" },
/* pl */ { IDS_SELECT_EEPROM_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_EEPROM_FILE_SV, "Vlj EEPROM-fil" },
/* tr */ { IDS_SELECT_EEPROM_FILE_TR, "EEPROM dosyas sein" },

/* en */ { IDS_SELECT_CARD_IMAGE_FILE,    "Select card image file" },
/* da */ { IDS_SELECT_CARD_IMAGE_FILE_DA, "Angiv kortimagefil" },
/* de */ { IDS_SELECT_CARD_IMAGE_FILE_DE, "Card Image Datei auswhlen" },
/* fr */ { IDS_SELECT_CARD_IMAGE_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_CARD_IMAGE_FILE_HU, "" },  /* fuzzy */
/* it */ { IDS_SELECT_CARD_IMAGE_FILE_IT, "Seleziona file immagine card" },
/* nl */ { IDS_SELECT_CARD_IMAGE_FILE_NL, "Selecteer card bestand" },
/* pl */ { IDS_SELECT_CARD_IMAGE_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_CARD_IMAGE_FILE_SV, "Ange kortavbildningsfil" },
/* tr */ { IDS_SELECT_CARD_IMAGE_FILE_TR, "Kart imaj dosyas se" },

/* en */ { IDS_CARD_FILE,    "Card Image File" },
/* da */ { IDS_CARD_FILE_DA, "Kortimagefil" },
/* de */ { IDS_CARD_FILE_DE, "Card Image Datei" },
/* fr */ { IDS_CARD_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDS_CARD_FILE_HU, "" },  /* fuzzy */
/* it */ { IDS_CARD_FILE_IT, "File immagine card" },
/* nl */ { IDS_CARD_FILE_NL, "Card bestand" },
/* pl */ { IDS_CARD_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_CARD_FILE_SV, "Kortavbildningsfil" },
/* tr */ { IDS_CARD_FILE_TR, "Kart Imaj Dosyas" },

/* en */ { IDS_CARD_READ_WRITE,    "Card read/write" },
/* da */ { IDS_CARD_READ_WRITE_DA, "Kort ls/skriv" },
/* de */ { IDS_CARD_READ_WRITE_DE, "Card lese/schreibe" },
/* fr */ { IDS_CARD_READ_WRITE_FR, "" },  /* fuzzy */
/* hu */ { IDS_CARD_READ_WRITE_HU, "" },  /* fuzzy */
/* it */ { IDS_CARD_READ_WRITE_IT, "Card in lettura/scrittura" },
/* nl */ { IDS_CARD_READ_WRITE_NL, "Card lees/schrijf" },
/* pl */ { IDS_CARD_READ_WRITE_PL, "" },  /* fuzzy */
/* sv */ { IDS_CARD_READ_WRITE_SV, "Skrivbart kort" },
/* tr */ { IDS_CARD_READ_WRITE_TR, "Kart oku/yaz" },

/* en */ { IDS_EEPROM_FILE,    "EEPROM Image File" },
/* da */ { IDS_EEPROM_FILE_DA, "EEPROM image-fil" },
/* de */ { IDS_EEPROM_FILE_DE, "EEPROM Image Datei" },
/* fr */ { IDS_EEPROM_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDS_EEPROM_FILE_HU, "" },  /* fuzzy */
/* it */ { IDS_EEPROM_FILE_IT, "File immagine EEPROM" },
/* nl */ { IDS_EEPROM_FILE_NL, "EEPROM bestand" },
/* pl */ { IDS_EEPROM_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_EEPROM_FILE_SV, "EEPROM-avbildningsfil" },
/* tr */ { IDS_EEPROM_FILE_TR, "EEPROM maj Dosyas" },

/* en */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED,    "Save EEPROM image when changed" },
/* da */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_DA, "Gem EEPROM image ved ndringer" },
/* de */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_DE, "GEO-RAM Imagedatei bei nderung speichern" },
/* fr */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_FR, "" },  /* fuzzy */
/* hu */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_HU, "" },  /* fuzzy */
/* it */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_IT, "Salva immagine EEPROM al cambio" },
/* nl */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_NL, "GEO-RAM bestand opslaan indien gewijzigd" },
/* pl */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_PL, "" },  /* fuzzy */
/* sv */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_SV, "Spara EEPROM-avbildning vid ndringar" },
/* tr */ { IDS_WRITE_TO_EEPROM_WHEN_CHANGED_TR, "EEPROM imaj deitiinde kaydet" },

/* en */ { IDS_EEPROM_READ_WRITE,    "EEPROM read/write" },
/* da */ { IDS_EEPROM_READ_WRITE_DA, "EEPROM ls/skriv" },
/* de */ { IDS_EEPROM_READ_WRITE_DE, "EEPROM lese/schreibe" },
/* fr */ { IDS_EEPROM_READ_WRITE_FR, "" },  /* fuzzy */
/* hu */ { IDS_EEPROM_READ_WRITE_HU, "" },  /* fuzzy */
/* it */ { IDS_EEPROM_READ_WRITE_IT, "EEPROM in lettura/scrittura" },
/* nl */ { IDS_EEPROM_READ_WRITE_NL, "EEPROM lees/schrijf" },
/* pl */ { IDS_EEPROM_READ_WRITE_PL, "" },  /* fuzzy */
/* sv */ { IDS_EEPROM_READ_WRITE_SV, "Skrivbar EEPROM" },
/* tr */ { IDS_EEPROM_READ_WRITE_TR, "EEPROM oku/yaz" },

/* en */ { IDS_RESCUE_MODE,    "Rescue mode" },
/* da */ { IDS_RESCUE_MODE_DA, "Fejlsikret tilstand" },
/* de */ { IDS_RESCUE_MODE_DE, "Rescue Modus" },
/* fr */ { IDS_RESCUE_MODE_FR, "" },  /* fuzzy */
/* hu */ { IDS_RESCUE_MODE_HU, "" },  /* fuzzy */
/* it */ { IDS_RESCUE_MODE_IT, "Modalit ripristino" },
/* nl */ { IDS_RESCUE_MODE_NL, "Reddingsmodus" },
/* pl */ { IDS_RESCUE_MODE_PL, "" },  /* fuzzy */
/* sv */ { IDS_RESCUE_MODE_SV, "Rddningslge" },
/* tr */ { IDS_RESCUE_MODE_TR, "Kurtarma modu" },

/* en */ { IDS_MMCREPLAY_SETTINGS,    "MMC Replay settings" },
/* da */ { IDS_MMCREPLAY_SETTINGS_DA, "MMC Replay-indstillinger" },
/* de */ { IDS_MMCREPLAY_SETTINGS_DE, "MMC Replay Einstellungen" },
/* fr */ { IDS_MMCREPLAY_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_MMCREPLAY_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_MMCREPLAY_SETTINGS_IT, "Impostazioni MMC Replay" },
/* nl */ { IDS_MMCREPLAY_SETTINGS_NL, "MMC Replay instellingen" },
/* pl */ { IDS_MMCREPLAY_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_MMCREPLAY_SETTINGS_SV, "MMC Replay-instllningar" },
/* tr */ { IDS_MMCREPLAY_SETTINGS_TR, "MMC Replay ayarlar" },

/* en */ { IDS_SELECT_GENERIC,    "Select generic cartridge image" },
/* da */ { IDS_SELECT_GENERIC_DA, "Vlg standardcartridgeimage" },
/* de */ { IDS_SELECT_GENERIC_DE, "Unverselles Erweiterungsmodul Image Datei whlen" },
/* fr */ { IDS_SELECT_GENERIC_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_GENERIC_HU, "" },  /* fuzzy */
/* it */ { IDS_SELECT_GENERIC_IT, "Seleziona immagine cartuccia generica" },
/* nl */ { IDS_SELECT_GENERIC_NL, "Selecteer algemeen cartridge bestand" },
/* pl */ { IDS_SELECT_GENERIC_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_GENERIC_SV, "Vlj generisk insticksmodulavbildning" },
/* tr */ { IDS_SELECT_GENERIC_TR, "Jenerik kartu imaj se" },

/* en */ { IDS_SELECT_FP,    "Select Vic Flash Plugin image" },
/* da */ { IDS_SELECT_FP_DA, "Vlg Vic Flash Plugin-image" },
/* de */ { IDS_SELECT_FP_DE, "Vic Flash Plugin Image auswhlen" },
/* fr */ { IDS_SELECT_FP_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_FP_HU, "" },  /* fuzzy */
/* it */ { IDS_SELECT_FP_IT, "Seleziona immagine Vic Flash Plugin " },
/* nl */ { IDS_SELECT_FP_NL, "Selecteer Vic Flash Plugin bestand" },
/* pl */ { IDS_SELECT_FP_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_FP_SV, "Vlj avbildning fr Vic Flash-insticksmodul" },
/* tr */ { IDS_SELECT_FP_TR, "Vic Flash Plugin imaj se" },

/* en */ { IDS_SELECT_MEGACART,    "Select Mega-Cart image" },
/* da */ { IDS_SELECT_MEGACART_DA, "Vlg MegaCart-imagefil" },
/* de */ { IDS_SELECT_MEGACART_DE, "Mega-Cart Image Date whlen" },
/* fr */ { IDS_SELECT_MEGACART_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_MEGACART_HU, "Vlassza ki a Mega-Cart kpmst" },
/* it */ { IDS_SELECT_MEGACART_IT, "Seleziona immagine Mega-Cart" },
/* nl */ { IDS_SELECT_MEGACART_NL, "Selecteer Mega-Cart bestand" },
/* pl */ { IDS_SELECT_MEGACART_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_MEGACART_SV, "Vlj Mega-Cart-modulfil" },
/* tr */ { IDS_SELECT_MEGACART_TR, "Mega-Cart imaj se" },

/* en */ { IDS_SELECT_FINAL_EXPANSION,    "Select Final Expansion image" },
/* da */ { IDS_SELECT_FINAL_EXPANSION_DA, "Vlg Final Expansion-imagefil" },
/* de */ { IDS_SELECT_FINAL_EXPANSION_DE, "Final Expansion Image Datei auswhlen" },
/* fr */ { IDS_SELECT_FINAL_EXPANSION_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_FINAL_EXPANSION_HU, "Vlassza ki a Final Expansion kpmst" },
/* it */ { IDS_SELECT_FINAL_EXPANSION_IT, "Seleziona immagine Final Expansion" },
/* nl */ { IDS_SELECT_FINAL_EXPANSION_NL, "Selecteer Final Expansion bestand" },
/* pl */ { IDS_SELECT_FINAL_EXPANSION_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_FINAL_EXPANSION_SV, "Vlj avbildning fr Final Expansion" },
/* tr */ { IDS_SELECT_FINAL_EXPANSION_TR, "Final Expansion imaj se" },

/* en */ { IDS_SELECT_CARTRIDGE_IMAGE,    "Select cartridge file" },
/* da */ { IDS_SELECT_CARTRIDGE_IMAGE_DA, "Vlg cartridge-fil" },
/* de */ { IDS_SELECT_CARTRIDGE_IMAGE_DE, "Erweiterungsmodul Image Datei whlen" },
/* fr */ { IDS_SELECT_CARTRIDGE_IMAGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_CARTRIDGE_IMAGE_HU, "Cartridge fjl kivlasztsa" },
/* it */ { IDS_SELECT_CARTRIDGE_IMAGE_IT, "Seleziona file cartuccia" },
/* nl */ { IDS_SELECT_CARTRIDGE_IMAGE_NL, "Selecteer cartridge bestand" },
/* pl */ { IDS_SELECT_CARTRIDGE_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_CARTRIDGE_IMAGE_SV, "Vlj insticksmodulfil" },
/* tr */ { IDS_SELECT_CARTRIDGE_IMAGE_TR, "Kartu dosyasn se" },

/* en */ { IDS_SID_CART,    "SID Cart" },
/* da */ { IDS_SID_CART_DA, "SID-cartridge" },
/* de */ { IDS_SID_CART_DE, "SID Modul" },
/* fr */ { IDS_SID_CART_FR, "SID Cart" },
/* hu */ { IDS_SID_CART_HU, "SID krtya" },
/* it */ { IDS_SID_CART_IT, "Cartuccia SID" },
/* nl */ { IDS_SID_CART_NL, "SID cart" },
/* pl */ { IDS_SID_CART_PL, "" },  /* fuzzy */
/* sv */ { IDS_SID_CART_SV, "SID-modul" },
/* tr */ { IDS_SID_CART_TR, "SID Kartuu" },

/* en */ { IDS_SID_ENGINE_MODEL,    "SID model" },
/* da */ { IDS_SID_ENGINE_MODEL_DA, "SID-model" },
/* de */ { IDS_SID_ENGINE_MODEL_DE, "SID Modell" },
/* fr */ { IDS_SID_ENGINE_MODEL_FR, "" },  /* fuzzy */
/* hu */ { IDS_SID_ENGINE_MODEL_HU, "SID modell" },
/* it */ { IDS_SID_ENGINE_MODEL_IT, "Modello SID" },
/* nl */ { IDS_SID_ENGINE_MODEL_NL, "SID model" },
/* pl */ { IDS_SID_ENGINE_MODEL_PL, "" },  /* fuzzy */
/* sv */ { IDS_SID_ENGINE_MODEL_SV, "SID-modell" },
/* tr */ { IDS_SID_ENGINE_MODEL_TR, "SID modeli" },

/* en */ { IDS_SID_ADDRESS,    "SID address" },
/* da */ { IDS_SID_ADDRESS_DA, "SID-adresse" },
/* de */ { IDS_SID_ADDRESS_DE, "SID Adresse" },
/* fr */ { IDS_SID_ADDRESS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SID_ADDRESS_HU, "SID cm" },
/* it */ { IDS_SID_ADDRESS_IT, "Indirizzo SID" },
/* nl */ { IDS_SID_ADDRESS_NL, "SID adres" },
/* pl */ { IDS_SID_ADDRESS_PL, "" },  /* fuzzy */
/* sv */ { IDS_SID_ADDRESS_SV, "SID-adress" },
/* tr */ { IDS_SID_ADDRESS_TR, "SID adresi" },

/* en */ { IDS_SID_CLOCK,    "SID clock" },
/* da */ { IDS_SID_CLOCK_DA, "SID-klok" },
/* de */ { IDS_SID_CLOCK_DE, "SID Takt" },
/* fr */ { IDS_SID_CLOCK_FR, "Horloge SID" },
/* hu */ { IDS_SID_CLOCK_HU, "SID rajel" },
/* it */ { IDS_SID_CLOCK_IT, "Clock SID" },
/* nl */ { IDS_SID_CLOCK_NL, "SID klok" },
/* pl */ { IDS_SID_CLOCK_PL, "" },  /* fuzzy */
/* sv */ { IDS_SID_CLOCK_SV, "SID-klocka" },
/* tr */ { IDS_SID_CLOCK_TR, "SID saati" },

/* en */ { IDS_SID_DIGIBLASTER,    "Digiblaster add-on" },
/* da */ { IDS_SID_DIGIBLASTER_DA, "Digiblaster udviddelse" },
/* de */ { IDS_SID_DIGIBLASTER_DE, "Digiblaster add-on" },
/* fr */ { IDS_SID_DIGIBLASTER_FR, "" },  /* fuzzy */
/* hu */ { IDS_SID_DIGIBLASTER_HU, "Digiblaster kiterjeszts" },
/* it */ { IDS_SID_DIGIBLASTER_IT, "Estensione digiblaster" },
/* nl */ { IDS_SID_DIGIBLASTER_NL, "Digiblaster add-on" },
/* pl */ { IDS_SID_DIGIBLASTER_PL, "" },  /* fuzzy */
/* sv */ { IDS_SID_DIGIBLASTER_SV, "Digiblaster-tillgg" },
/* tr */ { IDS_SID_DIGIBLASTER_TR, "Digiblaster eklentisi" },

/* en */ { IDS_SIDCART_SETTINGS,    "SID cart settings" },
/* da */ { IDS_SIDCART_SETTINGS_DA, "SID-cartridgeindstillinger" },
/* de */ { IDS_SIDCART_SETTINGS_DE, "SID Modul Einstellungen" },
/* fr */ { IDS_SIDCART_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SIDCART_SETTINGS_HU, "SID krtya belltsai..." },
/* it */ { IDS_SIDCART_SETTINGS_IT, "Impostazioni cartuccia SID" },
/* nl */ { IDS_SIDCART_SETTINGS_NL, "SID cart instellingen" },
/* pl */ { IDS_SIDCART_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_SIDCART_SETTINGS_SV, "SID-modulinstllningarg" },
/* tr */ { IDS_SIDCART_SETTINGS_TR, "SID kartuu ayarlar" },

/* en */ { IDS_LOAD_FLIP_LIST_FILE,    "Load flip list file" },
/* da */ { IDS_LOAD_FLIP_LIST_FILE_DA, "Indls bladrelistefil" },
/* de */ { IDS_LOAD_FLIP_LIST_FILE_DE, "Fliplist Datei laden" },
/* fr */ { IDS_LOAD_FLIP_LIST_FILE_FR, "Charger un fichier de groupement de disques" },
/* hu */ { IDS_LOAD_FLIP_LIST_FILE_HU, "Lemezlista betltse" },
/* it */ { IDS_LOAD_FLIP_LIST_FILE_IT, "Carica file fliplist" },
/* nl */ { IDS_LOAD_FLIP_LIST_FILE_NL, "Laad fliplijstbestand" },
/* pl */ { IDS_LOAD_FLIP_LIST_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_LOAD_FLIP_LIST_FILE_SV, "Ls vallistefil" },
/* tr */ { IDS_LOAD_FLIP_LIST_FILE_TR, "Sralama listesi dosyasn ykle" },

/* en */ { IDS_CANNOT_READ_FLIP_LIST,    "Cannot read flip list file" },
/* da */ { IDS_CANNOT_READ_FLIP_LIST_DA, "Kunne ikke lse bladrelistefil" },
/* de */ { IDS_CANNOT_READ_FLIP_LIST_DE, "Lesen von Fliplist Datei fehlgeschlagen" },
/* fr */ { IDS_CANNOT_READ_FLIP_LIST_FR, "" },  /* fuzzy */
/* hu */ { IDS_CANNOT_READ_FLIP_LIST_HU, "Nem lehet olvasni a lemezlista fjlt" },
/* it */ { IDS_CANNOT_READ_FLIP_LIST_IT, "Non  possibile caricare il file della flip list" },
/* nl */ { IDS_CANNOT_READ_FLIP_LIST_NL, "Kan het fliplijstbestand niet lezen" },
/* pl */ { IDS_CANNOT_READ_FLIP_LIST_PL, "" },  /* fuzzy */
/* sv */ { IDS_CANNOT_READ_FLIP_LIST_SV, "Kunde inte lsa vallistefil" },
/* tr */ { IDS_CANNOT_READ_FLIP_LIST_TR, "Sralama listesi dosyas okunamad" },

/* en */ { IDS_SAVE_FLIP_LIST_FILE,    "Save flip list file" },
/* da */ { IDS_SAVE_FLIP_LIST_FILE_DA, "Gem bladrelistefil" },
/* de */ { IDS_SAVE_FLIP_LIST_FILE_DE, "Fliplist Datei speichern" },
/* fr */ { IDS_SAVE_FLIP_LIST_FILE_FR, "Enregistrer le fichier de groupement de disques actuel" },
/* hu */ { IDS_SAVE_FLIP_LIST_FILE_HU, "Lemezlista mentse fjlba" },
/* it */ { IDS_SAVE_FLIP_LIST_FILE_IT, "Salva file fliplist" },
/* nl */ { IDS_SAVE_FLIP_LIST_FILE_NL, "Fliplijstbestand opslaan" },
/* pl */ { IDS_SAVE_FLIP_LIST_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_FLIP_LIST_FILE_SV, "Spara vallistefil" },
/* tr */ { IDS_SAVE_FLIP_LIST_FILE_TR, "Sralama listesi dosyasn kaydet" },

/* en */ { IDS_CANNOT_WRITE_FLIP_LIST,    "Cannot write flip list file" },
/* da */ { IDS_CANNOT_WRITE_FLIP_LIST_DA, "Kunne ikke skrive bladrelistefil" },
/* de */ { IDS_CANNOT_WRITE_FLIP_LIST_DE, "Schreiben von Fliplist Datei fehlgeschlagen" },
/* fr */ { IDS_CANNOT_WRITE_FLIP_LIST_FR, "Impossible d'crire le fichier de groupement de disques" },
/* hu */ { IDS_CANNOT_WRITE_FLIP_LIST_HU, "Nem sikerlt a lemezlistt fjlba rni" },
/* it */ { IDS_CANNOT_WRITE_FLIP_LIST_IT, "Non  possibile scrivere il file della flip list" },
/* nl */ { IDS_CANNOT_WRITE_FLIP_LIST_NL, "Kan fliplijstbestand niet schrijven" },
/* pl */ { IDS_CANNOT_WRITE_FLIP_LIST_PL, "" },  /* fuzzy */
/* sv */ { IDS_CANNOT_WRITE_FLIP_LIST_SV, "Kan inte skriva vallistefil" },
/* tr */ { IDS_CANNOT_WRITE_FLIP_LIST_TR, "Sralama listesi dosyas yazlamad" },

/* en */ { IDS_ATTACH_FUNCTION_LOW_CART,    "Attach cartridge image for Function Low" },
/* da */ { IDS_ATTACH_FUNCTION_LOW_CART_DA, "Tilslut cartridge for Function Lav" },
/* de */ { IDS_ATTACH_FUNCTION_LOW_CART_DE, "Funktions ROM (low) Erweiterungsmodul einlegen" },
/* fr */ { IDS_ATTACH_FUNCTION_LOW_CART_FR, "Insrer une cartouche Fonction basse" },
/* hu */ { IDS_ATTACH_FUNCTION_LOW_CART_HU, "Cartridge kpms csatolsa Function Low-hoz" },
/* it */ { IDS_ATTACH_FUNCTION_LOW_CART_IT, "Seleziona immagine cartuccia per la Function Low" },
/* nl */ { IDS_ATTACH_FUNCTION_LOW_CART_NL, "Koppel cartridge bestand voor 'Function Low'" },
/* pl */ { IDS_ATTACH_FUNCTION_LOW_CART_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_FUNCTION_LOW_CART_SV, "Anslut insticksmodulfil fr funktion lg" },
/* tr */ { IDS_ATTACH_FUNCTION_LOW_CART_TR, "Function Low iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_FUNCTION_HIGH_CART,    "Attach cartridge image for Function High" },
/* da */ { IDS_ATTACH_FUNCTION_HIGH_CART_DA, "Tilslut cartridge for Function Hj" },
/* de */ { IDS_ATTACH_FUNCTION_HIGH_CART_DE, "Funktions ROM (high) Erweiterungsmodul einlegen" },
/* fr */ { IDS_ATTACH_FUNCTION_HIGH_CART_FR, "Insrer une cartouche Fonction haute" },
/* hu */ { IDS_ATTACH_FUNCTION_HIGH_CART_HU, "Cartridge kpms csatolsa Function High-hez" },
/* it */ { IDS_ATTACH_FUNCTION_HIGH_CART_IT, "Seleziona immagine cartuccia per la Function High" },
/* nl */ { IDS_ATTACH_FUNCTION_HIGH_CART_NL, "Koppel cartridge bestand voor 'Function High'" },
/* pl */ { IDS_ATTACH_FUNCTION_HIGH_CART_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_FUNCTION_HIGH_CART_SV, "Anslut insticksmodulfil fr funktion hg" },
/* tr */ { IDS_ATTACH_FUNCTION_HIGH_CART_TR, "Function High iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART1_LOW,    "Attach cartridge image for Cartridge1 Low" },
/* da */ { IDS_ATTACH_CART1_LOW_DA, "Tilslut cartridge image for Cartridge1 Lav" },
/* de */ { IDS_ATTACH_CART1_LOW_DE, "Cartridge1 (low) Erweiterungsmodul einlegen" },
/* fr */ { IDS_ATTACH_CART1_LOW_FR, "Insrer une cartouche pour Cartouche1 basse" },
/* hu */ { IDS_ATTACH_CART1_LOW_HU, "Cartridge kpms csatolsa als Cartridge1-hez" },
/* it */ { IDS_ATTACH_CART1_LOW_IT, "Seleziona immagine cartuccia per la Cartridge Low" },
/* nl */ { IDS_ATTACH_CART1_LOW_NL, "Koppel cartridge bestand voor 'Cartridge1 Low'" },
/* pl */ { IDS_ATTACH_CART1_LOW_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_CART1_LOW_SV, "Anslut insticksmodulfil fr modul1 lg" },
/* tr */ { IDS_ATTACH_CART1_LOW_TR, "Kartu1 Low iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART1_HIGH,    "Attach cartridge image for Cartridge1 High" },
/* da */ { IDS_ATTACH_CART1_HIGH_DA, "Tilslut cartridge image for Cartridge1 Hj" },
/* de */ { IDS_ATTACH_CART1_HIGH_DE, "Cartridge1 (high) Erweiterungsmodul einlegen" },
/* fr */ { IDS_ATTACH_CART1_HIGH_FR, "Insrer une cartouche pour Cartouche1 haute" },
/* hu */ { IDS_ATTACH_CART1_HIGH_HU, "Cartridge kpms csatolsa fels Cartridge1-hez" },
/* it */ { IDS_ATTACH_CART1_HIGH_IT, "Seleziona immagine cartuccia per la Cartridge1 High" },
/* nl */ { IDS_ATTACH_CART1_HIGH_NL, "Koppel cartridge bestand voor 'Cartridge1 High'" },
/* pl */ { IDS_ATTACH_CART1_HIGH_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_CART1_HIGH_SV, "Anslut insticksmodulfil fr modul1 hg" },
/* tr */ { IDS_ATTACH_CART1_HIGH_TR, "Kartu1 High iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART2_LOW,    "Attach cartridge image for Cartridge2 Low" },
/* da */ { IDS_ATTACH_CART2_LOW_DA, "Tilslut cartridge image for Cartridge2 Lav" },
/* de */ { IDS_ATTACH_CART2_LOW_DE, "Cartridge2 (low) Erweiterungsmodul einlegen" },
/* fr */ { IDS_ATTACH_CART2_LOW_FR, "Insrer une cartouche pour Cartouche2 basse" },
/* hu */ { IDS_ATTACH_CART2_LOW_HU, "Cartridge kpms csatolsa als Cartridge2-hz" },
/* it */ { IDS_ATTACH_CART2_LOW_IT, "Seleziona immagine cartuccia per la Cartridge2 Low" },
/* nl */ { IDS_ATTACH_CART2_LOW_NL, "Koppel cartridge bestand voor 'Cartridge2 Low'" },
/* pl */ { IDS_ATTACH_CART2_LOW_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_CART2_LOW_SV, "Anslut insticksmodulfil fr modul2 lg" },
/* tr */ { IDS_ATTACH_CART2_LOW_TR, "Kartu2 Low iin kartu imaj yerletirin" },

/* en */ { IDS_ATTACH_CART2_HIGH,    "Attach cartridge image for Cartridge2 High" },
/* da */ { IDS_ATTACH_CART2_HIGH_DA, "Tilslut cartridge image for Cartridge2 Hj" },
/* de */ { IDS_ATTACH_CART2_HIGH_DE, "Cartridge1 (high) Erweiterungsmodul einlegen" },
/* fr */ { IDS_ATTACH_CART2_HIGH_FR, "Insrer une cartouche pour Cartouche2 haute" },
/* hu */ { IDS_ATTACH_CART2_HIGH_HU, "Cartridge kpms csatolsa fels Cartridge2-hz" },
/* it */ { IDS_ATTACH_CART2_HIGH_IT, "Seleziona immagine cartuccia per la Cartridge2 High" },
/* nl */ { IDS_ATTACH_CART2_HIGH_NL, "Koppel cartridge bestand voor 'Cartridge2 High'" },
/* pl */ { IDS_ATTACH_CART2_HIGH_PL, "" },  /* fuzzy */
/* sv */ { IDS_ATTACH_CART2_HIGH_SV, "Anslut insticksmodulfil fr modul2 hg" },
/* tr */ { IDS_ATTACH_CART2_HIGH_TR, "Kartu2 High iin kartu imaj yerletirin" },

/* en */ { IDS_SAVE_SNAPSHOT_IMAGE,    "Save snapshot image" },
/* da */ { IDS_SAVE_SNAPSHOT_IMAGE_DA, "Gem snapshot" },
/* de */ { IDS_SAVE_SNAPSHOT_IMAGE_DE, "Snapshot Datei speichern" },
/* fr */ { IDS_SAVE_SNAPSHOT_IMAGE_FR, "Enregistrer le fichier de sauvegarde" },
/* hu */ { IDS_SAVE_SNAPSHOT_IMAGE_HU, "Pillanatkp fjl mentse" },
/* it */ { IDS_SAVE_SNAPSHOT_IMAGE_IT, "Salva immagine snapshot" },
/* nl */ { IDS_SAVE_SNAPSHOT_IMAGE_NL, "Momentopnamebestand opslaan" },
/* pl */ { IDS_SAVE_SNAPSHOT_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_SNAPSHOT_IMAGE_SV, "Spara gonblicksbildfil" },
/* tr */ { IDS_SAVE_SNAPSHOT_IMAGE_TR, "Anlk grnt imajn kaydet" },

/* en */ { IDS_LOAD_SNAPSHOT_IMAGE,    "Load snapshot image" },
/* da */ { IDS_LOAD_SNAPSHOT_IMAGE_DA, "Indls snapshot" },
/* de */ { IDS_LOAD_SNAPSHOT_IMAGE_DE, "Snapshot laden" },
/* fr */ { IDS_LOAD_SNAPSHOT_IMAGE_FR, "Charger le fichier de sauvegarde" },
/* hu */ { IDS_LOAD_SNAPSHOT_IMAGE_HU, "Pillanatkp betltse" },
/* it */ { IDS_LOAD_SNAPSHOT_IMAGE_IT, "Carica immagine snapshot" },
/* nl */ { IDS_LOAD_SNAPSHOT_IMAGE_NL, "Laad momentopnamebestand" },
/* pl */ { IDS_LOAD_SNAPSHOT_IMAGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_LOAD_SNAPSHOT_IMAGE_SV, "Lser in gonblicksbild" },
/* tr */ { IDS_LOAD_SNAPSHOT_IMAGE_TR, "Anlk grnt imajn ykle" },

/* en */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS,    "Save currently attached disk images" },
/* da */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_DA, "Gem tilsluttede disk-images" },
/* de */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_DE, "Aktuell eingelegte Diskimages speichern" },
/* fr */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_HU, "A jelenleg csatolt lemezek mentse" },
/* it */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_IT, "Salva immagini dischi attualmente selezionati" },
/* nl */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_NL, "Opslaan huidige gekoppelde schijfbestanden" },
/* pl */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_SV, "Spara anslutna diskettavbildningar" },
/* tr */ { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_TR, "Halihazrda yerletirilmi disk imajlarn kaydet" },

/* en */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS,    "Save currently loaded ROM images" },
/* da */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_DA, "Gem tilsluttede ROM-images" },
/* de */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_DE, "Aktuelle ROMs speichern" },
/* fr */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_HU, "A jelenleg betlttt ROM-ok mentse" },
/* it */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_IT, "Salva immagini ROM attualmente caricate" },
/* nl */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_NL, "Opslaan huidig gekoppelde ROMs" },
/* pl */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_SV, "Spara inlsta ROM-avbildningar" },
/* tr */ { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_TR, "Halihazrda yklenmi ROM imajlarn kaydet" },

/* en */ { IDS_CANNOT_WRITE_SNAPSHOT_S,    "Cannot write snapshot file `%s'." },
/* da */ { IDS_CANNOT_WRITE_SNAPSHOT_S_DA, "Kunne ikke gemme snapshot \"%s\"." },
/* de */ { IDS_CANNOT_WRITE_SNAPSHOT_S_DE, "Kann Snapshot Datei `%s' nicht speichern." },
/* fr */ { IDS_CANNOT_WRITE_SNAPSHOT_S_FR, "" },  /* fuzzy */
/* hu */ { IDS_CANNOT_WRITE_SNAPSHOT_S_HU, "Nem sikerlt a pillanatkp rsa %s fjlba." },
/* it */ { IDS_CANNOT_WRITE_SNAPSHOT_S_IT, "Non  possibile scrivere il file di snapshot `%s'." },
/* nl */ { IDS_CANNOT_WRITE_SNAPSHOT_S_NL, "Kan momentopnamebestand `%s' niet schrijven." },
/* pl */ { IDS_CANNOT_WRITE_SNAPSHOT_S_PL, "" },  /* fuzzy */
/* sv */ { IDS_CANNOT_WRITE_SNAPSHOT_S_SV, "Kan inte skriva gonblicksbildfil \"%s\"." },
/* tr */ { IDS_CANNOT_WRITE_SNAPSHOT_S_TR, "Anlk grnt dosyas yazlamad `%s'." },

/* en */ { IDS_CANNOT_READ_SNAPSHOT_IMG,    "Cannot read snapshot image" },
/* da */ { IDS_CANNOT_READ_SNAPSHOT_IMG_DA, "Kunne ikke indlse snapshot fil" },
/* de */ { IDS_CANNOT_READ_SNAPSHOT_IMG_DE, "Kann Snapshot Datei nicht laden" },
/* fr */ { IDS_CANNOT_READ_SNAPSHOT_IMG_FR, "Impossible de charger l'instantan." },
/* hu */ { IDS_CANNOT_READ_SNAPSHOT_IMG_HU, "A pillanatkp fjl nem olvashat" },
/* it */ { IDS_CANNOT_READ_SNAPSHOT_IMG_IT, "Non  possibile leggere l'immagine dello snapshot" },
/* nl */ { IDS_CANNOT_READ_SNAPSHOT_IMG_NL, "Kan momentopnamebestand niet lezen" },
/* pl */ { IDS_CANNOT_READ_SNAPSHOT_IMG_PL, "" },  /* fuzzy */
/* sv */ { IDS_CANNOT_READ_SNAPSHOT_IMG_SV, "Kan inte lsa in gonblicksbildfil" },
/* tr */ { IDS_CANNOT_READ_SNAPSHOT_IMG_TR, "Anlk grnt dosyas okunamad." },

/* en */ { IDS_SNAPSHOT_FILE,    "snapshot file" },
/* da */ { IDS_SNAPSHOT_FILE_DA, "snapshot-fil" },
/* de */ { IDS_SNAPSHOT_FILE_DE, "Snapshot Datei" },
/* fr */ { IDS_SNAPSHOT_FILE_FR, "Fichier de sauvegarde" },
/* hu */ { IDS_SNAPSHOT_FILE_HU, "pillanatkp fjl" },
/* it */ { IDS_SNAPSHOT_FILE_IT, "File snapshot" },
/* nl */ { IDS_SNAPSHOT_FILE_NL, "momentopnamebestand" },
/* pl */ { IDS_SNAPSHOT_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SNAPSHOT_FILE_SV, "gonblicksbildfil" },
/* tr */ { IDS_SNAPSHOT_FILE_TR, "Anlk grnt dosyas" },

/* en */ { IDS_SELECT_SNAPSHOT_FILE,    "Select snapshot file" },
/* da */ { IDS_SELECT_SNAPSHOT_FILE_DA, "Vlg snapshot-fil" },
/* de */ { IDS_SELECT_SNAPSHOT_FILE_DE, "Snapshot Datei whlen" },
/* fr */ { IDS_SELECT_SNAPSHOT_FILE_FR, "Slectionner le fichier de sauvegarde" },
/* hu */ { IDS_SELECT_SNAPSHOT_FILE_HU, "Vlasszon pillanatkp fjlt" },
/* it */ { IDS_SELECT_SNAPSHOT_FILE_IT, "Seleziona file snapshot" },
/* nl */ { IDS_SELECT_SNAPSHOT_FILE_NL, "Selecteer momentopnamebestand" },
/* pl */ { IDS_SELECT_SNAPSHOT_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_SNAPSHOT_FILE_SV, "Vlj gonblicksbildfil" },
/* tr */ { IDS_SELECT_SNAPSHOT_FILE_TR, "Anlk grnt dosyas sein" },

/* en */ { IDS_CRT_EMULATION,    "CRT emulation" },
/* da */ { IDS_CRT_EMULATION_DA, "CRT-emulering" },
/* de */ { IDS_CRT_EMULATION_DE, "CRT Emulation" },
/* fr */ { IDS_CRT_EMULATION_FR, "" },  /* fuzzy */
/* hu */ { IDS_CRT_EMULATION_HU, "" },  /* fuzzy */
/* it */ { IDS_CRT_EMULATION_IT, "Emulazione CRT" },
/* nl */ { IDS_CRT_EMULATION_NL, "CRT emulatie" },
/* pl */ { IDS_CRT_EMULATION_PL, "" },  /* fuzzy */
/* sv */ { IDS_CRT_EMULATION_SV, "CRT-emulering" },
/* tr */ { IDS_CRT_EMULATION_TR, "CRT emlasyonu" },

/* en */ { IDS_SCALE2X,    "Scale2x" },
/* da */ { IDS_SCALE2X_DA, "Scale2x" },
/* de */ { IDS_SCALE2X_DE, "Scale2x" },
/* fr */ { IDS_SCALE2X_FR, "Scale2x" },
/* hu */ { IDS_SCALE2X_HU, "lsimts" },
/* it */ { IDS_SCALE2X_IT, "Scale2x" },
/* nl */ { IDS_SCALE2X_NL, "Schaal2x" },
/* pl */ { IDS_SCALE2X_PL, "" },  /* fuzzy */
/* sv */ { IDS_SCALE2X_SV, "Scale2x" },
/* tr */ { IDS_SCALE2X_TR, "2x Genilet" },

/* en */ { IDS_RENDER_FILTER,    "Render filter" },
/* da */ { IDS_RENDER_FILTER_DA, "Renderingsfilter" },
/* de */ { IDS_RENDER_FILTER_DE, "Render Filter" },
/* fr */ { IDS_RENDER_FILTER_FR, "" },  /* fuzzy */
/* hu */ { IDS_RENDER_FILTER_HU, "" },  /* fuzzy */
/* it */ { IDS_RENDER_FILTER_IT, "Filtro renderer" },
/* nl */ { IDS_RENDER_FILTER_NL, "Render filter" },
/* pl */ { IDS_RENDER_FILTER_PL, "" },  /* fuzzy */
/* sv */ { IDS_RENDER_FILTER_SV, "Rendrerarfilter" },
/* tr */ { IDS_RENDER_FILTER_TR, "mge oluturma filtresi" },

/* en */ { IDS_EXTERNAL_PALETTE_SELECT,    "Select External Palette file" },
/* da */ { IDS_EXTERNAL_PALETTE_SELECT_DA, "Brug ekstern palette-fil" },
/* de */ { IDS_EXTERNAL_PALETTE_SELECT_DE, "Benutze externe Palette (Datei)" },
/* fr */ { IDS_EXTERNAL_PALETTE_SELECT_FR, "Utiliser une palette externe (fichier)" },
/* hu */ { IDS_EXTERNAL_PALETTE_SELECT_HU, "Vlasszon kls paletta fjlt" },
/* it */ { IDS_EXTERNAL_PALETTE_SELECT_IT, "Seleziona file palette esterna" },
/* nl */ { IDS_EXTERNAL_PALETTE_SELECT_NL, "Selecteer extern paletbestand" },
/* pl */ { IDS_EXTERNAL_PALETTE_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXTERNAL_PALETTE_SELECT_SV, "Anvnd en extern palett (fil)" },
/* tr */ { IDS_EXTERNAL_PALETTE_SELECT_TR, "Harici Palet dosyas sein" },

/* en */ { IDS_GAMMA_0_4,    "Gamma (0..4)" },
/* da */ { IDS_GAMMA_0_4_DA, "Gamma (0..4)" },
/* de */ { IDS_GAMMA_0_4_DE, "Gamma (0..4)" },
/* fr */ { IDS_GAMMA_0_4_FR, "" },  /* fuzzy */
/* hu */ { IDS_GAMMA_0_4_HU, "" },  /* fuzzy */
/* it */ { IDS_GAMMA_0_4_IT, "Gamma (0..4)" },
/* nl */ { IDS_GAMMA_0_4_NL, "Gamma (0..4)" },
/* pl */ { IDS_GAMMA_0_4_PL, "" },  /* fuzzy */
/* sv */ { IDS_GAMMA_0_4_SV, "Gamma (0..4)" },
/* tr */ { IDS_GAMMA_0_4_TR, "Gama (0..4)" },

/* en */ { IDS_SCANLINE_SHADE_0_1,    "Scanline shade (0..1)" },
/* da */ { IDS_SCANLINE_SHADE_0_1_DA, "Skanlinjeskygge (0..1)" },
/* de */ { IDS_SCANLINE_SHADE_0_1_DE, "Scanline Schatten (0..1)" },
/* fr */ { IDS_SCANLINE_SHADE_0_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_SCANLINE_SHADE_0_1_HU, "" },  /* fuzzy */
/* it */ { IDS_SCANLINE_SHADE_0_1_IT, "Ombra scanline (0..1)" },
/* nl */ { IDS_SCANLINE_SHADE_0_1_NL, "Scanlijnschaduw (0..1)" },
/* pl */ { IDS_SCANLINE_SHADE_0_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_SCANLINE_SHADE_0_1_SV, "Skuggning av skannlinjer (0..1)" },
/* tr */ { IDS_SCANLINE_SHADE_0_1_TR, "Tarama satr nans (0..1)" },

/* en */ { IDS_BLUR_0_1,    "Blur (0..1)" },
/* da */ { IDS_BLUR_0_1_DA, "Udtvring (0..1)" },
/* de */ { IDS_BLUR_0_1_DE, "Unschrfe (0..1)" },
/* fr */ { IDS_BLUR_0_1_FR, "" },  /* fuzzy */
/* hu */ { IDS_BLUR_0_1_HU, "" },  /* fuzzy */
/* it */ { IDS_BLUR_0_1_IT, "Sfuocatura (0..1)" },
/* nl */ { IDS_BLUR_0_1_NL, "Wazigheid (0..1)" },
/* pl */ { IDS_BLUR_0_1_PL, "" },  /* fuzzy */
/* sv */ { IDS_BLUR_0_1_SV, "Suddighet (0..1)" },
/* tr */ { IDS_BLUR_0_1_TR, "Bulanklk (0..1)" },

/* en */ { IDS_TINT_0_2,    "Tint (0..2)" },
/* da */ { IDS_TINT_0_2_DA, "Farvetone (0..2)" },
/* de */ { IDS_TINT_0_2_DE, "Farbton (0..2)" },
/* fr */ { IDS_TINT_0_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_TINT_0_2_HU, "Szn (0..2)" },
/* it */ { IDS_TINT_0_2_IT, "Sfumatura (0..2)" },
/* nl */ { IDS_TINT_0_2_NL, "Tint (0..2)" },
/* pl */ { IDS_TINT_0_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_TINT_0_2_SV, "Frgton (0..2)" },
/* tr */ { IDS_TINT_0_2_TR, "Ton (0..2)" },

/* en */ { IDS_ODDLINE_PHASE_0_2,    "Odd lines phase (0..2)" },
/* da */ { IDS_ODDLINE_PHASE_0_2_DA, "Fase for ulige linjer (0..2)" },
/* de */ { IDS_ODDLINE_PHASE_0_2_DE, "Ungerade Zeilenphase (0..2)" },
/* fr */ { IDS_ODDLINE_PHASE_0_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_ODDLINE_PHASE_0_2_HU, "Pratlan sorok fzisa (0..2)" },
/* it */ { IDS_ODDLINE_PHASE_0_2_IT, "Fase linee dispari (0..2)" },
/* nl */ { IDS_ODDLINE_PHASE_0_2_NL, "Oneven lijnen fase (0..2)" },
/* pl */ { IDS_ODDLINE_PHASE_0_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_ODDLINE_PHASE_0_2_SV, "Fas fr udda linjer (0..2)" },
/* tr */ { IDS_ODDLINE_PHASE_0_2_TR, "Tek satrlar faz (0..2)" },

/* en */ { IDS_ODDLINE_OFFSET_0_2,    "Odd lines offset (0..2)" },
/* da */ { IDS_ODDLINE_OFFSET_0_2_DA, "Offset for ulige linjer (0..2)" },
/* de */ { IDS_ODDLINE_OFFSET_0_2_DE, "Ungerader Zeilenoffset (0..2)" },
/* fr */ { IDS_ODDLINE_OFFSET_0_2_FR, "" },  /* fuzzy */
/* hu */ { IDS_ODDLINE_OFFSET_0_2_HU, "Pratlan sorok offszetje (0..2)" },
/* it */ { IDS_ODDLINE_OFFSET_0_2_IT, "Offset linee dispari (0..2)" },
/* nl */ { IDS_ODDLINE_OFFSET_0_2_NL, "Oneven lijnen compensatie (0..2)" },
/* pl */ { IDS_ODDLINE_OFFSET_0_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_ODDLINE_OFFSET_0_2_SV, "Utjmning fr udda linjer (0..2)" },
/* tr */ { IDS_ODDLINE_OFFSET_0_2_TR, "Tek satrlar ofseti (0..2)" },

/* en */ { IDS_VICII_EXTERNAL_PALETTE,    "External VICII palette" },
/* da */ { IDS_VICII_EXTERNAL_PALETTE_DA, "Ekstern VICII palette" },
/* de */ { IDS_VICII_EXTERNAL_PALETTE_DE, "Externe VICII Palette" },
/* fr */ { IDS_VICII_EXTERNAL_PALETTE_FR, "" },  /* fuzzy */
/* hu */ { IDS_VICII_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_VICII_EXTERNAL_PALETTE_IT, "Palette VICII esterna" },
/* nl */ { IDS_VICII_EXTERNAL_PALETTE_NL, "Extern VICII palet" },
/* pl */ { IDS_VICII_EXTERNAL_PALETTE_PL, "" },  /* fuzzy */
/* sv */ { IDS_VICII_EXTERNAL_PALETTE_SV, "Extern VICII-palett" },
/* tr */ { IDS_VICII_EXTERNAL_PALETTE_TR, "Harici VICII paleti" },

/* en */ { IDS_VIC_EXTERNAL_PALETTE,    "External VIC palette" },
/* da */ { IDS_VIC_EXTERNAL_PALETTE_DA, "Ekstern VIC palette" },
/* de */ { IDS_VIC_EXTERNAL_PALETTE_DE, "Externe VIC Palette" },
/* fr */ { IDS_VIC_EXTERNAL_PALETTE_FR, "" },  /* fuzzy */
/* hu */ { IDS_VIC_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_VIC_EXTERNAL_PALETTE_IT, "Palette VIC esterna" },
/* nl */ { IDS_VIC_EXTERNAL_PALETTE_NL, "Extern VIC palet" },
/* pl */ { IDS_VIC_EXTERNAL_PALETTE_PL, "" },  /* fuzzy */
/* sv */ { IDS_VIC_EXTERNAL_PALETTE_SV, "Extern VIC-palett" },
/* tr */ { IDS_VIC_EXTERNAL_PALETTE_TR, "Harici VIC paleti" },

/* en */ { IDS_TED_EXTERNAL_PALETTE,    "External TED palette" },
/* da */ { IDS_TED_EXTERNAL_PALETTE_DA, "Ekstern TED palette" },
/* de */ { IDS_TED_EXTERNAL_PALETTE_DE, "Externe TED Palette" },
/* fr */ { IDS_TED_EXTERNAL_PALETTE_FR, "" },  /* fuzzy */
/* hu */ { IDS_TED_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_TED_EXTERNAL_PALETTE_IT, "Palette TED esterna" },
/* nl */ { IDS_TED_EXTERNAL_PALETTE_NL, "Extern TED palet" },
/* pl */ { IDS_TED_EXTERNAL_PALETTE_PL, "" },  /* fuzzy */
/* sv */ { IDS_TED_EXTERNAL_PALETTE_SV, "Extern TED-palett" },
/* tr */ { IDS_TED_EXTERNAL_PALETTE_TR, "Harici TED paleti" },

/* en */ { IDS_VDC_EXTERNAL_PALETTE,    "External VDC palette" },
/* da */ { IDS_VDC_EXTERNAL_PALETTE_DA, "Ekstern VDC palette" },
/* de */ { IDS_VDC_EXTERNAL_PALETTE_DE, "Externe VDC Palette" },
/* fr */ { IDS_VDC_EXTERNAL_PALETTE_FR, "" },  /* fuzzy */
/* hu */ { IDS_VDC_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_VDC_EXTERNAL_PALETTE_IT, "Palette VDC esterna" },
/* nl */ { IDS_VDC_EXTERNAL_PALETTE_NL, "Extern VDC palet" },
/* pl */ { IDS_VDC_EXTERNAL_PALETTE_PL, "" },  /* fuzzy */
/* sv */ { IDS_VDC_EXTERNAL_PALETTE_SV, "Extern VDC-palett" },
/* tr */ { IDS_VDC_EXTERNAL_PALETTE_TR, "Harici VDC paleti" },

/* en */ { IDS_CRTC_EXTERNAL_PALETTE,    "External CRTC palette" },
/* da */ { IDS_CRTC_EXTERNAL_PALETTE_DA, "Ekstern CRTC palette" },
/* de */ { IDS_CRTC_EXTERNAL_PALETTE_DE, "Externe CRTC Palette" },
/* fr */ { IDS_CRTC_EXTERNAL_PALETTE_FR, "" },  /* fuzzy */
/* hu */ { IDS_CRTC_EXTERNAL_PALETTE_HU, "" },  /* fuzzy */
/* it */ { IDS_CRTC_EXTERNAL_PALETTE_IT, "Palette CRTC esterna" },
/* nl */ { IDS_CRTC_EXTERNAL_PALETTE_NL, "Extern CRTC palet" },
/* pl */ { IDS_CRTC_EXTERNAL_PALETTE_PL, "" },  /* fuzzy */
/* sv */ { IDS_CRTC_EXTERNAL_PALETTE_SV, "Extern CRTC-palett" },
/* tr */ { IDS_CRTC_EXTERNAL_PALETTE_TR, "Harici CRTC paleti" },

/* en */ { IDS_VICII_PALETTE_NAME,    "VICII palette file" },
/* da */ { IDS_VICII_PALETTE_NAME_DA, "VICII-palettefil" },
/* de */ { IDS_VICII_PALETTE_NAME_DE, "VICII Paletten Datei" },
/* fr */ { IDS_VICII_PALETTE_NAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_VICII_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_VICII_PALETTE_NAME_IT, "File palette VICII" },
/* nl */ { IDS_VICII_PALETTE_NAME_NL, "VICII palet bestand" },
/* pl */ { IDS_VICII_PALETTE_NAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_VICII_PALETTE_NAME_SV, "VICII-palettfil" },
/* tr */ { IDS_VICII_PALETTE_NAME_TR, "VICII palet dosyas" },

/* en */ { IDS_VIC_PALETTE_NAME,    "VIC palette file" },
/* da */ { IDS_VIC_PALETTE_NAME_DA, "VIC-palettefil" },
/* de */ { IDS_VIC_PALETTE_NAME_DE, "VIC Paletten Datei" },
/* fr */ { IDS_VIC_PALETTE_NAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_VIC_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_VIC_PALETTE_NAME_IT, "File palette VIC" },
/* nl */ { IDS_VIC_PALETTE_NAME_NL, "VIC palet bestand" },
/* pl */ { IDS_VIC_PALETTE_NAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_VIC_PALETTE_NAME_SV, "VIC-palettfil" },
/* tr */ { IDS_VIC_PALETTE_NAME_TR, "VIC palet dosyas" },

/* en */ { IDS_TED_PALETTE_NAME,    "TED palette file" },
/* da */ { IDS_TED_PALETTE_NAME_DA, "TED-palettefil" },
/* de */ { IDS_TED_PALETTE_NAME_DE, "TED Paletten Datei" },
/* fr */ { IDS_TED_PALETTE_NAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_TED_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_TED_PALETTE_NAME_IT, "File palette TED" },
/* nl */ { IDS_TED_PALETTE_NAME_NL, "TED palet bestand" },
/* pl */ { IDS_TED_PALETTE_NAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_TED_PALETTE_NAME_SV, "TED-palettfil" },
/* tr */ { IDS_TED_PALETTE_NAME_TR, "TED palet dosyas" },

/* en */ { IDS_VDC_PALETTE_NAME,    "VDC palette file" },
/* da */ { IDS_VDC_PALETTE_NAME_DA, "VDC-palettefil" },
/* de */ { IDS_VDC_PALETTE_NAME_DE, "VDC Paletten Datei" },
/* fr */ { IDS_VDC_PALETTE_NAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_VDC_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_VDC_PALETTE_NAME_IT, "File palette VDC" },
/* nl */ { IDS_VDC_PALETTE_NAME_NL, "VDC palet bestand" },
/* pl */ { IDS_VDC_PALETTE_NAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_VDC_PALETTE_NAME_SV, "VDC-palettfil" },
/* tr */ { IDS_VDC_PALETTE_NAME_TR, "VDC palet dosyas" },

/* en */ { IDS_CRTC_PALETTE_NAME,    "CRTC palette file" },
/* da */ { IDS_CRTC_PALETTE_NAME_DA, "CRTC-palettefil" },
/* de */ { IDS_CRTC_PALETTE_NAME_DE, "CRTC Paletten Datei" },
/* fr */ { IDS_CRTC_PALETTE_NAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_CRTC_PALETTE_NAME_HU, "" },  /* fuzzy */
/* it */ { IDS_CRTC_PALETTE_NAME_IT, "File palette CRTC" },
/* nl */ { IDS_CRTC_PALETTE_NAME_NL, "CRTC palet bestand" },
/* pl */ { IDS_CRTC_PALETTE_NAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_CRTC_PALETTE_NAME_SV, "CRTC-palettfil" },
/* tr */ { IDS_CRTC_PALETTE_NAME_TR, "CRTC palet dosyas" },

/* en */ { IDS_SATURATION_0_2,    "Saturation (0..2)" },
/* da */ { IDS_SATURATION_0_2_DA, "Mtning (0..2)" },
/* de */ { IDS_SATURATION_0_2_DE, "Sttigung (0..2)" },
/* fr */ { IDS_SATURATION_0_2_FR, "Saturation (0..2)" },
/* hu */ { IDS_SATURATION_0_2_HU, "Teltettsg (0..2)" },
/* it */ { IDS_SATURATION_0_2_IT, "Saturazione (0..2)" },
/* nl */ { IDS_SATURATION_0_2_NL, "Verzadiging (0..2)" },
/* pl */ { IDS_SATURATION_0_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_SATURATION_0_2_SV, "Mttnad (0..2)" },
/* tr */ { IDS_SATURATION_0_2_TR, "Doygunluk (0..2)" },

/* en */ { IDS_CONTRAST_0_2,    "Contrast (0..2)" },
/* da */ { IDS_CONTRAST_0_2_DA, "Kontrast (0..2)" },
/* de */ { IDS_CONTRAST_0_2_DE, "Kontrast (0..2)" },
/* fr */ { IDS_CONTRAST_0_2_FR, "Contraste (0..2)" },
/* hu */ { IDS_CONTRAST_0_2_HU, "Kontraszt (0..2)" },
/* it */ { IDS_CONTRAST_0_2_IT, "Contrasto (0..2)" },
/* nl */ { IDS_CONTRAST_0_2_NL, "Contrast (0..2)" },
/* pl */ { IDS_CONTRAST_0_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_CONTRAST_0_2_SV, "Kontrast (0..2)" },
/* tr */ { IDS_CONTRAST_0_2_TR, "Kartlk (0..2)" },

/* en */ { IDS_BRIGHTNESS_0_2,    "Brightness (0..2)" },
/* da */ { IDS_BRIGHTNESS_0_2_DA, "Lysstyrke (0..2)" },
/* de */ { IDS_BRIGHTNESS_0_2_DE, "Helligkeit (0..2)" },
/* fr */ { IDS_BRIGHTNESS_0_2_FR, "Luminosit (0..2)" },
/* hu */ { IDS_BRIGHTNESS_0_2_HU, "Fnyessg (0..2)" },
/* it */ { IDS_BRIGHTNESS_0_2_IT, "Luminosit (0..2)" },
/* nl */ { IDS_BRIGHTNESS_0_2_NL, "Helderheid (0..2)" },
/* pl */ { IDS_BRIGHTNESS_0_2_PL, "" },  /* fuzzy */
/* sv */ { IDS_BRIGHTNESS_0_2_SV, "Ljusstyrka (0..2)" },
/* tr */ { IDS_BRIGHTNESS_0_2_TR, "Parlaklk (0..2)" },

/* en */ { IDS_VIDEO_SETTINGS,    "Video settings" },
/* da */ { IDS_VIDEO_SETTINGS_DA, "Grafikindstillinger" },
/* de */ { IDS_VIDEO_SETTINGS_DE, "Video Einstellungen" },
/* fr */ { IDS_VIDEO_SETTINGS_FR, "Paramtres vido" },
/* hu */ { IDS_VIDEO_SETTINGS_HU, "Vide belltsai" },
/* it */ { IDS_VIDEO_SETTINGS_IT, "Impostazioni video" },
/* nl */ { IDS_VIDEO_SETTINGS_NL, "Video instellingen" },
/* pl */ { IDS_VIDEO_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_VIDEO_SETTINGS_SV, "Grafikinstllningar" },
/* tr */ { IDS_VIDEO_SETTINGS_TR, "Grnt ayarlar" },

/* en */ { IDS_AUTO_FROM_ROM,    "Auto (from ROM)" },
/* da */ { IDS_AUTO_FROM_ROM_DA, "Automatisk (fra ROM)" },
/* de */ { IDS_AUTO_FROM_ROM_DE, "Automatisch (von ROM)" },
/* fr */ { IDS_AUTO_FROM_ROM_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTO_FROM_ROM_HU, "Automatikus (ROM-bl)" },
/* it */ { IDS_AUTO_FROM_ROM_IT, "Auto (dalla ROM)" },
/* nl */ { IDS_AUTO_FROM_ROM_NL, "Automatisch (van ROM)" },
/* pl */ { IDS_AUTO_FROM_ROM_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTO_FROM_ROM_SV, "Automatisk (frn ROM)" },
/* tr */ { IDS_AUTO_FROM_ROM_TR, "Otomatik (ROM'dan)" },

/* en */ { IDS_40_COLUMNS,    "40 Columns" },
/* da */ { IDS_40_COLUMNS_DA, "40 kolonner" },
/* de */ { IDS_40_COLUMNS_DE, "40 Spalten" },
/* fr */ { IDS_40_COLUMNS_FR, "" },  /* fuzzy */
/* hu */ { IDS_40_COLUMNS_HU, "40 Oszlop" },
/* it */ { IDS_40_COLUMNS_IT, "40 Colonne" },
/* nl */ { IDS_40_COLUMNS_NL, "40 Kolommen" },
/* pl */ { IDS_40_COLUMNS_PL, "" },  /* fuzzy */
/* sv */ { IDS_40_COLUMNS_SV, "40 kolumner" },
/* tr */ { IDS_40_COLUMNS_TR, "40 Stun" },

/* en */ { IDS_80_COLUMNS,    "80 Columns" },
/* da */ { IDS_80_COLUMNS_DA, "80 kolonner" },
/* de */ { IDS_80_COLUMNS_DE, "80 Spalten" },
/* fr */ { IDS_80_COLUMNS_FR, "" },  /* fuzzy */
/* hu */ { IDS_80_COLUMNS_HU, "80 Oszlop" },
/* it */ { IDS_80_COLUMNS_IT, "80 Colonne" },
/* nl */ { IDS_80_COLUMNS_NL, "80 Kolommen" },
/* pl */ { IDS_80_COLUMNS_PL, "" },  /* fuzzy */
/* sv */ { IDS_80_COLUMNS_SV, "80 kolumner" },
/* tr */ { IDS_80_COLUMNS_TR, "80 Stun" },

/* en */ { IDS_256_BYTE,    "256 Byte" },
/* da */ { IDS_256_BYTE_DA, "256 byte" },
/* de */ { IDS_256_BYTE_DE, "256 Byte" },
/* fr */ { IDS_256_BYTE_FR, "" },  /* fuzzy */
/* hu */ { IDS_256_BYTE_HU, "256 Bjt" },
/* it */ { IDS_256_BYTE_IT, "256 Byte" },
/* nl */ { IDS_256_BYTE_NL, "256 Byte" },
/* pl */ { IDS_256_BYTE_PL, "" },  /* fuzzy */
/* sv */ { IDS_256_BYTE_SV, "256 byte" },
/* tr */ { IDS_256_BYTE_TR, "256 Byte" },

/* en */ { IDS_2_KBYTE,    "2 kByte" },
/* da */ { IDS_2_KBYTE_DA, "2 kbyte" },
/* de */ { IDS_2_KBYTE_DE, "2 kByte" },
/* fr */ { IDS_2_KBYTE_FR, "" },  /* fuzzy */
/* hu */ { IDS_2_KBYTE_HU, "2 kBjt" },
/* it */ { IDS_2_KBYTE_IT, "2 kByte" },
/* nl */ { IDS_2_KBYTE_NL, "2 kByte" },
/* pl */ { IDS_2_KBYTE_PL, "" },  /* fuzzy */
/* sv */ { IDS_2_KBYTE_SV, "2 kbyte" },
/* tr */ { IDS_2_KBYTE_TR, "2 kByte" },

/* en */ { IDS_GRAPHICS,    "Graphics" },
/* da */ { IDS_GRAPHICS_DA, "Grafisk" },
/* de */ { IDS_GRAPHICS_DE, "Grafik" },
/* fr */ { IDS_GRAPHICS_FR, "" },  /* fuzzy */
/* hu */ { IDS_GRAPHICS_HU, "Grafikus" },
/* it */ { IDS_GRAPHICS_IT, "Grafica" },
/* nl */ { IDS_GRAPHICS_NL, "Grafiek" },
/* pl */ { IDS_GRAPHICS_PL, "" },  /* fuzzy */
/* sv */ { IDS_GRAPHICS_SV, "Grafisk" },
/* tr */ { IDS_GRAPHICS_TR, "Grafikler" },

/* en */ { IDS_TEXT,    "Text" },
/* da */ { IDS_TEXT_DA, "Tekst" },
/* de */ { IDS_TEXT_DE, "Text" },
/* fr */ { IDS_TEXT_FR, "" },  /* fuzzy */
/* hu */ { IDS_TEXT_HU, "" },  /* fuzzy */
/* it */ { IDS_TEXT_IT, "Testo" },
/* nl */ { IDS_TEXT_NL, "Tekst" },
/* pl */ { IDS_TEXT_PL, "" },  /* fuzzy */
/* sv */ { IDS_TEXT_SV, "Text" },
/* tr */ { IDS_TEXT_TR, "Metin" },

/* en */ { IDS_BUSINESS_UK,    "Business (UK)" },
/* da */ { IDS_BUSINESS_UK_DA, "Business (Storbritannien)" },
/* de */ { IDS_BUSINESS_UK_DE, "Business (UK)" },
/* fr */ { IDS_BUSINESS_UK_FR, "" },  /* fuzzy */
/* hu */ { IDS_BUSINESS_UK_HU, "Hivatalos (UK)" },
/* it */ { IDS_BUSINESS_UK_IT, "Business (UK)" },
/* nl */ { IDS_BUSINESS_UK_NL, "Zakelijk (UK)" },
/* pl */ { IDS_BUSINESS_UK_PL, "" },  /* fuzzy */
/* sv */ { IDS_BUSINESS_UK_SV, "Business (Storbritannien)" },
/* tr */ { IDS_BUSINESS_UK_TR, "Business (UK)" },

/* en */ { IDS_SET_PET_MODEL,    "Set PET Model" },
/* da */ { IDS_SET_PET_MODEL_DA, "Vlg PET-model" },
/* de */ { IDS_SET_PET_MODEL_DE, "Whle PET Modell" },
/* fr */ { IDS_SET_PET_MODEL_FR, "" },  /* fuzzy */
/* hu */ { IDS_SET_PET_MODEL_HU, "PET modell kivlasztsa" },
/* it */ { IDS_SET_PET_MODEL_IT, "Imposta modello di PET" },
/* nl */ { IDS_SET_PET_MODEL_NL, "Stel PET model in" },
/* pl */ { IDS_SET_PET_MODEL_PL, "" },  /* fuzzy */
/* sv */ { IDS_SET_PET_MODEL_SV, "Vlj PET-modell" },
/* tr */ { IDS_SET_PET_MODEL_TR, "PET Modelini Belirle" },

/* en */ { IDS_MEMORY,    "Memory" },
/* da */ { IDS_MEMORY_DA, "Hukommelse" },
/* de */ { IDS_MEMORY_DE, "Speicher" },
/* fr */ { IDS_MEMORY_FR, "Mmoire" },
/* hu */ { IDS_MEMORY_HU, "Memria" },
/* it */ { IDS_MEMORY_IT, "Memoria" },
/* nl */ { IDS_MEMORY_NL, "Geheugen" },
/* pl */ { IDS_MEMORY_PL, "" },  /* fuzzy */
/* sv */ { IDS_MEMORY_SV, "Minne" },
/* tr */ { IDS_MEMORY_TR, "Bellek" },

/* en */ { IDS_VIDEO_SIZE,    "Video size" },
/* da */ { IDS_VIDEO_SIZE_DA, "Skrmbredde" },
/* de */ { IDS_VIDEO_SIZE_DE, "Videospeichergre" },
/* fr */ { IDS_VIDEO_SIZE_FR, "Taille vido" },
/* hu */ { IDS_VIDEO_SIZE_HU, "Vide mret" },
/* it */ { IDS_VIDEO_SIZE_IT, "Dimensione video" },
/* nl */ { IDS_VIDEO_SIZE_NL, "Videogrootte" },
/* pl */ { IDS_VIDEO_SIZE_PL, "Rozmiar video" },
/* sv */ { IDS_VIDEO_SIZE_SV, "Skrmbredd" },
/* tr */ { IDS_VIDEO_SIZE_TR, "Grnt boyutu" },

/* en */ { IDS_IO_SIZE,    "I/O size" },
/* da */ { IDS_IO_SIZE_DA, "I/O-strrelse" },
/* de */ { IDS_IO_SIZE_DE, "I/O Gre" },
/* fr */ { IDS_IO_SIZE_FR, "Taille d'E/S" },
/* hu */ { IDS_IO_SIZE_HU, "I/O mret" },
/* it */ { IDS_IO_SIZE_IT, "Dimensione I/O" },
/* nl */ { IDS_IO_SIZE_NL, "I/O grootte" },
/* pl */ { IDS_IO_SIZE_PL, "Rozmiar I/O" },
/* sv */ { IDS_IO_SIZE_SV, "I/O-utrymme" },
/* tr */ { IDS_IO_SIZE_TR, "G/ boyutu" },

/* en */ { IDS_KEYBOARD,    "Keyboard" },
/* da */ { IDS_KEYBOARD_DA, "Tastatur" },
/* de */ { IDS_KEYBOARD_DE, "Tastatur" },
/* fr */ { IDS_KEYBOARD_FR, "" },  /* fuzzy */
/* hu */ { IDS_KEYBOARD_HU, "Billentyzet" },
/* it */ { IDS_KEYBOARD_IT, "Tastiera" },
/* nl */ { IDS_KEYBOARD_NL, "Toetsenbord" },
/* pl */ { IDS_KEYBOARD_PL, "" },  /* fuzzy */
/* sv */ { IDS_KEYBOARD_SV, "Tangentbord" },
/* tr */ { IDS_KEYBOARD_TR, "Klavye" },

/* en */ { IDS_CRTC_CHIP,    "CRTC chip" },
/* da */ { IDS_CRTC_CHIP_DA, "CRTC-kreds" },
/* de */ { IDS_CRTC_CHIP_DE, "CRTC Chip" },
/* fr */ { IDS_CRTC_CHIP_FR, "" },  /* fuzzy */
/* hu */ { IDS_CRTC_CHIP_HU, "CRTC csip" },
/* it */ { IDS_CRTC_CHIP_IT, "Chip CRTC" },
/* nl */ { IDS_CRTC_CHIP_NL, "CRTC chip" },
/* pl */ { IDS_CRTC_CHIP_PL, "" },  /* fuzzy */
/* sv */ { IDS_CRTC_CHIP_SV, "CRTC-krets" },
/* tr */ { IDS_CRTC_CHIP_TR, "CRTC ipi" },

/* en */ { IDS_SUPERPET_IO,    "SuperPET I/O enable (disables 8x96)" },
/* da */ { IDS_SUPERPET_IO_DA, "Aktivr SuperPET-I/O (deaktiverer 8x96)" },
/* de */ { IDS_SUPERPET_IO_DE, "SuperPET I/O aktivieren (deaktiviert 8x96)" },
/* fr */ { IDS_SUPERPET_IO_FR, "" },  /* fuzzy */
/* hu */ { IDS_SUPERPET_IO_HU, "SuperPET I/O engedlyezse (8x96-ot tiltja)" },
/* it */ { IDS_SUPERPET_IO_IT, "Attiva I/O SuperPET (disattiva 8x96)" },
/* nl */ { IDS_SUPERPET_IO_NL, "SuperPET I/O activeren (zet 8x96 uit)" },
/* pl */ { IDS_SUPERPET_IO_PL, "" },  /* fuzzy */
/* sv */ { IDS_SUPERPET_IO_SV, "Aktivera SuperPET-I/O (inaktiverar 8x96)" },
/* tr */ { IDS_SUPERPET_IO_TR, "SuperPET G/ aktif et (8x96'y pasifletir)" },

/* en */ { IDS_9xxx_AS_RAM,    "$9*** as RAM" },
/* da */ { IDS_9xxx_AS_RAM_DA, "$9*** som RAM" },
/* de */ { IDS_9xxx_AS_RAM_DE, "$9*** als RAM" },
/* fr */ { IDS_9xxx_AS_RAM_FR, "" },  /* fuzzy */
/* hu */ { IDS_9xxx_AS_RAM_HU, "$9*** RAM-knt" },
/* it */ { IDS_9xxx_AS_RAM_IT, "$9*** come RAM" },
/* nl */ { IDS_9xxx_AS_RAM_NL, "$9*** als RAM" },
/* pl */ { IDS_9xxx_AS_RAM_PL, "" },  /* fuzzy */
/* sv */ { IDS_9xxx_AS_RAM_SV, "$9*** som RAM" },
/* tr */ { IDS_9xxx_AS_RAM_TR, "RAM olarak $9***" },

/* en */ { IDS_Axxx_AS_RAM,    "$A*** as RAM" },
/* da */ { IDS_Axxx_AS_RAM_DA, "$A*** som RAM" },
/* de */ { IDS_Axxx_AS_RAM_DE, "$A*** als RAM" },
/* fr */ { IDS_Axxx_AS_RAM_FR, "" },  /* fuzzy */
/* hu */ { IDS_Axxx_AS_RAM_HU, "$A*** RAM-knt" },
/* it */ { IDS_Axxx_AS_RAM_IT, "$A*** come RAM" },
/* nl */ { IDS_Axxx_AS_RAM_NL, "$A*** als RAM" },
/* pl */ { IDS_Axxx_AS_RAM_PL, "" },  /* fuzzy */
/* sv */ { IDS_Axxx_AS_RAM_SV, "$A*** som RAM" },
/* tr */ { IDS_Axxx_AS_RAM_TR, "RAM olarak $A***" },

/* en */ { IDS_PET_SETTINGS,    "PET settings" },
/* da */ { IDS_PET_SETTINGS_DA, "PET-indstillinger" },
/* de */ { IDS_PET_SETTINGS_DE, "PET Einstellungen" },
/* fr */ { IDS_PET_SETTINGS_FR, "Paramtres PET" },
/* hu */ { IDS_PET_SETTINGS_HU, "PET belltsai" },
/* it */ { IDS_PET_SETTINGS_IT, "Impostazioni PET" },
/* nl */ { IDS_PET_SETTINGS_NL, "PET instellingen" },
/* pl */ { IDS_PET_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_PET_SETTINGS_SV, "PET-instllningar" },
/* tr */ { IDS_PET_SETTINGS_TR, "PET ayarlar" },

/* en */ { IDS_CURRENT_MODEL,    "Current Model" },
/* da */ { IDS_CURRENT_MODEL_DA, "Nuvrende model" },
/* de */ { IDS_CURRENT_MODEL_DE, "Aktuelles Modell" },
/* fr */ { IDS_CURRENT_MODEL_FR, "" },  /* fuzzy */
/* hu */ { IDS_CURRENT_MODEL_HU, "Jelenlegi modell" },
/* it */ { IDS_CURRENT_MODEL_IT, "Modello attuale" },
/* nl */ { IDS_CURRENT_MODEL_NL, "Huidig model" },
/* pl */ { IDS_CURRENT_MODEL_PL, "" },  /* fuzzy */
/* sv */ { IDS_CURRENT_MODEL_SV, "Aktuell modell" },
/* tr */ { IDS_CURRENT_MODEL_TR, "Geerli Model" },

/* en */ { IDS_PET_MODEL,    "PET Model" },
/* da */ { IDS_PET_MODEL_DA, "PET-model" },
/* de */ { IDS_PET_MODEL_DE, "PET Modell" },
/* fr */ { IDS_PET_MODEL_FR, "" },  /* fuzzy */
/* hu */ { IDS_PET_MODEL_HU, "PET modell" },
/* it */ { IDS_PET_MODEL_IT, "Modello PET" },
/* nl */ { IDS_PET_MODEL_NL, "PET model" },
/* pl */ { IDS_PET_MODEL_PL, "" },  /* fuzzy */
/* sv */ { IDS_PET_MODEL_SV, "PET-modell" },
/* tr */ { IDS_PET_MODEL_TR, "PET Modeli" },

/* en */ { IDS_PLUS4_SETTINGS,    "Plus4 settings" },
/* da */ { IDS_PLUS4_SETTINGS_DA, "Plus4-indstillinger" },
/* de */ { IDS_PLUS4_SETTINGS_DE, "Plus4 Einstellungen" },
/* fr */ { IDS_PLUS4_SETTINGS_FR, "Paramtres Plus4" },
/* hu */ { IDS_PLUS4_SETTINGS_HU, "Plus4 belltsai" },
/* it */ { IDS_PLUS4_SETTINGS_IT, "Impostazioni Plus4" },
/* nl */ { IDS_PLUS4_SETTINGS_NL, "Plus4 instellingen" },
/* pl */ { IDS_PLUS4_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_PLUS4_SETTINGS_SV, "Plus4-instllningar" },
/* tr */ { IDS_PLUS4_SETTINGS_TR, "Plus4 ayarlar" },

/* en */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME,    "Select Internal Function ROM file" },
/* da */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_DA, "Vlg image for intern funktions-ROM" },
/* de */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_DE, "Internes Funktions ROM Image Datei auswhlen" },
/* fr */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_HU, "Adja meg a bels Function ROM kpms nevt" },
/* it */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_IT, "Seleziona file function ROM interna" },
/* nl */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_NL, "Selecteer intern functie ROM bestand" },
/* pl */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_SV, "Vlj avbildning fr internt funktions-ROM" },
/* tr */ { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_TR, "Dahili Function ROM dosyas sein" },

/* en */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME,    "Select External Function ROM file" },
/* da */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_DA, "Vlg image for ekstern funktions-ROM" },
/* de */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_DE, "Externes Funktions ROM Image Datei auswhlen" },
/* fr */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_HU, "Adja meg a kls Function ROM kpms nevt" },
/* it */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_IT, "Seleziona file function ROM esterna" },
/* nl */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_NL, "Selecteer extern functie ROM bestand" },
/* pl */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_SV, "Vlj avbildning fr externt funktions-ROM" },
/* tr */ { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_TR, "Harici Function ROM dosyas sein" },

/* en */ { IDS_MACHINE_TYPE,    "Machine type" },
/* da */ { IDS_MACHINE_TYPE_DA, "Maskintype" },
/* de */ { IDS_MACHINE_TYPE_DE, "Maschinen Typ" },
/* fr */ { IDS_MACHINE_TYPE_FR, "Type de machine" },
/* hu */ { IDS_MACHINE_TYPE_HU, "Gp tpus" },
/* it */ { IDS_MACHINE_TYPE_IT, "Tipo macchina" },
/* nl */ { IDS_MACHINE_TYPE_NL, "Machinesoort" },
/* pl */ { IDS_MACHINE_TYPE_PL, "Typ maszyny" },
/* sv */ { IDS_MACHINE_TYPE_SV, "Maskintyp" },
/* tr */ { IDS_MACHINE_TYPE_TR, "Makine tipi" },

/* en */ { IDS_INTERNAL_FUNCTION_ROM,    "Internal Function ROM" },
/* da */ { IDS_INTERNAL_FUNCTION_ROM_DA, "Intern funktions-ROM" },
/* de */ { IDS_INTERNAL_FUNCTION_ROM_DE, "Internes Funktions ROM" },
/* fr */ { IDS_INTERNAL_FUNCTION_ROM_FR, "Image ROM Fonction interne" },
/* hu */ { IDS_INTERNAL_FUNCTION_ROM_HU, "Bels Function ROM" },
/* it */ { IDS_INTERNAL_FUNCTION_ROM_IT, "Function ROM interna" },
/* nl */ { IDS_INTERNAL_FUNCTION_ROM_NL, "Interne functie ROM" },
/* pl */ { IDS_INTERNAL_FUNCTION_ROM_PL, "" },  /* fuzzy */
/* sv */ { IDS_INTERNAL_FUNCTION_ROM_SV, "Internt funktions-ROM" },
/* tr */ { IDS_INTERNAL_FUNCTION_ROM_TR, "Uluslararas Function ROM" },

/* en */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME,    "Internal Function ROM file" },
/* da */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_DA, "Intern funktions-ROM" },
/* de */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_DE, "Interne Funktions ROM Datei" },
/* fr */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_HU, "Bels Function ROM fjl" },
/* it */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_IT, "File function ROM interna" },
/* nl */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_NL, "Intern functie ROM bestand" },
/* pl */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_SV, "Internt funktions-ROM" },
/* tr */ { IDS_INTERNAL_FUNCTION_ROM_FILENAME_TR, "Dahili Function ROM dosyas" },

/* en */ { IDS_EXTERNAL_FUNCTION_ROM,    "External Function ROM" },
/* da */ { IDS_EXTERNAL_FUNCTION_ROM_DA, "Extern funktions-ROM" },
/* de */ { IDS_EXTERNAL_FUNCTION_ROM_DE, "Externes Funktions ROM" },
/* fr */ { IDS_EXTERNAL_FUNCTION_ROM_FR, "Image ROM Fonction externe" },
/* hu */ { IDS_EXTERNAL_FUNCTION_ROM_HU, "Kls Function ROM" },
/* it */ { IDS_EXTERNAL_FUNCTION_ROM_IT, "Function ROM esterna" },
/* nl */ { IDS_EXTERNAL_FUNCTION_ROM_NL, "Externe functie ROM" },
/* pl */ { IDS_EXTERNAL_FUNCTION_ROM_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXTERNAL_FUNCTION_ROM_SV, "Externt funktions-ROM" },
/* tr */ { IDS_EXTERNAL_FUNCTION_ROM_TR, "Harici Function ROM" },

/* en */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME,    "External Function ROM file" },
/* da */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_DA, "Extern funktions-ROM" },
/* de */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_DE, "Externe Funktions ROM Datei" },
/* fr */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_HU, "Kls Function ROM fjl" },
/* it */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_IT, "File function ROM esterna" },
/* nl */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_NL, "Extern functie ROM bestand" },
/* pl */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_SV, "Externt funktions-ROM" },
/* tr */ { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_TR, "Harici Function ROM dosyas" },

/* en */ { IDS_RAM_BANKS_2_AND_3,    "RAM banks 2 & 3" },
/* da */ { IDS_RAM_BANKS_2_AND_3_DA, "RAM bank 2 & 3" },
/* de */ { IDS_RAM_BANKS_2_AND_3_DE, "RAM Bnkte 2 & 3" },
/* fr */ { IDS_RAM_BANKS_2_AND_3_FR, "" },  /* fuzzy */
/* hu */ { IDS_RAM_BANKS_2_AND_3_HU, "2-es s 3-as RAM bankok" },
/* it */ { IDS_RAM_BANKS_2_AND_3_IT, "Banchi RAM 2 & 3" },
/* nl */ { IDS_RAM_BANKS_2_AND_3_NL, "RAM banken 2 & 3" },
/* pl */ { IDS_RAM_BANKS_2_AND_3_PL, "" },  /* fuzzy */
/* sv */ { IDS_RAM_BANKS_2_AND_3_SV, "RAM-bank 2 & 3" },
/* tr */ { IDS_RAM_BANKS_2_AND_3_TR, "RAM banklar 2 & 3" },

/* en */ { IDS_C128_SETTINGS,    "C128 settings" },
/* da */ { IDS_C128_SETTINGS_DA, "C128-indstillinger" },
/* de */ { IDS_C128_SETTINGS_DE, "C128 Einstellungen" },
/* fr */ { IDS_C128_SETTINGS_FR, "Paramtres C128" },
/* hu */ { IDS_C128_SETTINGS_HU, "C128 belltsai" },
/* it */ { IDS_C128_SETTINGS_IT, "Impostazioni C128" },
/* nl */ { IDS_C128_SETTINGS_NL, "C128 instellingen" },
/* pl */ { IDS_C128_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_C128_SETTINGS_SV, "C128-instllningar" },
/* tr */ { IDS_C128_SETTINGS_TR, "C128 ayarlar" },

/* en */ { IDS_SELECT_ROM_FILE,    "Select ROM file" },
/* da */ { IDS_SELECT_ROM_FILE_DA, "Vlg ROM-fil" },
/* de */ { IDS_SELECT_ROM_FILE_DE, "ROM Datei whlen" },
/* fr */ { IDS_SELECT_ROM_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_ROM_FILE_HU, "Vlasszon ROM fjlt" },
/* it */ { IDS_SELECT_ROM_FILE_IT, "Seleziona file ROM" },
/* nl */ { IDS_SELECT_ROM_FILE_NL, "Selecteer ROM bestand" },
/* pl */ { IDS_SELECT_ROM_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_ROM_FILE_SV, "Vlj ROM-fil" },
/* tr */ { IDS_SELECT_ROM_FILE_TR, "ROM dosyas sein" },

/* en */ { IDS_COMPUTER_ROM_SETTINGS,    "Computer ROM settings" },
/* da */ { IDS_COMPUTER_ROM_SETTINGS_DA, "Computer ROM-indstillinger" },
/* de */ { IDS_COMPUTER_ROM_SETTINGS_DE, "Computer ROM Einstellungen" },
/* fr */ { IDS_COMPUTER_ROM_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_COMPUTER_ROM_SETTINGS_HU, "Szmtgp ROM belltsai" },
/* it */ { IDS_COMPUTER_ROM_SETTINGS_IT, "Impostazioni ROM del computer" },
/* nl */ { IDS_COMPUTER_ROM_SETTINGS_NL, "Computer ROM instellingen" },
/* pl */ { IDS_COMPUTER_ROM_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_COMPUTER_ROM_SETTINGS_SV, "ROM-instllningar fr dator" },
/* tr */ { IDS_COMPUTER_ROM_SETTINGS_TR, "Bilgisayar ROM ayarlar" },

/* en */ { IDS_DRIVE_ROM_SETTINGS,    "Drive ROM settings" },
/* da */ { IDS_DRIVE_ROM_SETTINGS_DA, "Drev ROM-indstillinger" },
/* de */ { IDS_DRIVE_ROM_SETTINGS_DE, "Floppy ROM Einstellungen" },
/* fr */ { IDS_DRIVE_ROM_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_DRIVE_ROM_SETTINGS_HU, "Lemezegysg ROM belltsai" },
/* it */ { IDS_DRIVE_ROM_SETTINGS_IT, "Impostazioni ROM del drive" },
/* nl */ { IDS_DRIVE_ROM_SETTINGS_NL, "Drive ROM instellingen" },
/* pl */ { IDS_DRIVE_ROM_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_DRIVE_ROM_SETTINGS_SV, "ROM-instllningar fr diskettenhet" },
/* tr */ { IDS_DRIVE_ROM_SETTINGS_TR, "Src ROM ayarlar" },

/* en */ { IDS_DIGIMAX_ENABLED,    "DigiMAX Enabled" },
/* da */ { IDS_DIGIMAX_ENABLED_DA, "DigiMAX aktivret" },
/* de */ { IDS_DIGIMAX_ENABLED_DE, "DigiMAX aktiviert" },
/* fr */ { IDS_DIGIMAX_ENABLED_FR, "" },  /* fuzzy */
/* hu */ { IDS_DIGIMAX_ENABLED_HU, "" },  /* fuzzy */
/* it */ { IDS_DIGIMAX_ENABLED_IT, "DigiMAX attivato" },
/* nl */ { IDS_DIGIMAX_ENABLED_NL, "DigiMAX Aan/Uit" },
/* pl */ { IDS_DIGIMAX_ENABLED_PL, "" },  /* fuzzy */
/* sv */ { IDS_DIGIMAX_ENABLED_SV, "DigiMAX aktiverad" },
/* tr */ { IDS_DIGIMAX_ENABLED_TR, "DigiMAX' Aktif Et" },

/* en */ { IDS_DIGIMAX_BASE,    "DigiMAX base" },
/* da */ { IDS_DIGIMAX_BASE_DA, "DigiMAX-base" },
/* de */ { IDS_DIGIMAX_BASE_DE, "DigiMAX Basis" },
/* fr */ { IDS_DIGIMAX_BASE_FR, "" },  /* fuzzy */
/* hu */ { IDS_DIGIMAX_BASE_HU, "" },  /* fuzzy */
/* it */ { IDS_DIGIMAX_BASE_IT, "Indirizzo base DigiMAX" },
/* nl */ { IDS_DIGIMAX_BASE_NL, "DigiMAX basisadres" },
/* pl */ { IDS_DIGIMAX_BASE_PL, "" },  /* fuzzy */
/* sv */ { IDS_DIGIMAX_BASE_SV, "DigiMAX-bas" },
/* tr */ { IDS_DIGIMAX_BASE_TR, "DigiMAX taban" },

/* en */ { IDS_DIGIMAX_SETTINGS,    "DigiMAX settings" },
/* da */ { IDS_DIGIMAX_SETTINGS_DA, "DigiMAX-indstillinger" },
/* de */ { IDS_DIGIMAX_SETTINGS_DE, "DigiMAX Einstellungen" },
/* fr */ { IDS_DIGIMAX_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_DIGIMAX_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_DIGIMAX_SETTINGS_IT, "Impostazioni DigiMAX" },
/* nl */ { IDS_DIGIMAX_SETTINGS_NL, "DigiMAX instellingen" },
/* pl */ { IDS_DIGIMAX_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_DIGIMAX_SETTINGS_SV, "DigiMAX-instllningar" },
/* tr */ { IDS_DIGIMAX_SETTINGS_TR, "DigiMAX ayarlar" },

/* en */ { IDS_SFX_SE_ENABLED,    "SFX Sound Expander Enabled" },
/* da */ { IDS_SFX_SE_ENABLED_DA, "SFX Sound Expander Aktiveret" },
/* de */ { IDS_SFX_SE_ENABLED_DE, "SFX Sound Expander aktiviert" },
/* fr */ { IDS_SFX_SE_ENABLED_FR, "" },  /* fuzzy */
/* hu */ { IDS_SFX_SE_ENABLED_HU, "SFX Sound Expander engedlyezve" },
/* it */ { IDS_SFX_SE_ENABLED_IT, "Attiva SFX Sound Expander" },
/* nl */ { IDS_SFX_SE_ENABLED_NL, "SFX Sound Expander Aan/Uit" },
/* pl */ { IDS_SFX_SE_ENABLED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SFX_SE_ENABLED_SV, "SFX Sound Expander aktiverad" },
/* tr */ { IDS_SFX_SE_ENABLED_TR, "SFX Sound Expander Aktif" },

/* en */ { IDS_SFX_SE_CHIP,    "SFX Sound Expander Chip" },
/* da */ { IDS_SFX_SE_CHIP_DA, "SFX Sound Expander chip" },
/* de */ { IDS_SFX_SE_CHIP_DE, "SFX Sound Expander Chip" },
/* fr */ { IDS_SFX_SE_CHIP_FR, "" },  /* fuzzy */
/* hu */ { IDS_SFX_SE_CHIP_HU, "SFX Sound Expander csip" },
/* it */ { IDS_SFX_SE_CHIP_IT, "Chip SFX Sound Expander" },
/* nl */ { IDS_SFX_SE_CHIP_NL, "SFX Sound Expander Chip" },
/* pl */ { IDS_SFX_SE_CHIP_PL, "" },  /* fuzzy */
/* sv */ { IDS_SFX_SE_CHIP_SV, "SFX Sound Expander-krets" },
/* tr */ { IDS_SFX_SE_CHIP_TR, "SFX Sound Expander ipi" },

/* en */ { IDS_SFX_SE_SETTINGS,    "SFX Sound Expander Settings" },
/* da */ { IDS_SFX_SE_SETTINGS_DA, "SFX Sound Expander-indstillinger" },
/* de */ { IDS_SFX_SE_SETTINGS_DE, "SFX Sound Expander Einstellungen" },
/* fr */ { IDS_SFX_SE_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SFX_SE_SETTINGS_HU, "SFX Sounder Expander belltsok" },
/* it */ { IDS_SFX_SE_SETTINGS_IT, "Impostazioni SFX Sound Expander" },
/* nl */ { IDS_SFX_SE_SETTINGS_NL, "SFX Sound Expander instellingen" },
/* pl */ { IDS_SFX_SE_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_SFX_SE_SETTINGS_SV, "Instllningar fr SFX Sound Expander" },
/* tr */ { IDS_SFX_SE_SETTINGS_TR, "SFX Sound Expander Ayarlar" },

/* en */ { IDS_SOUND_RECORDING_STOPPED,    "Sound Recording stopped..." },
/* da */ { IDS_SOUND_RECORDING_STOPPED_DA, "Lydoptagelse stoppet..." },
/* de */ { IDS_SOUND_RECORDING_STOPPED_DE, "Tonaufnahme gestoppt..." },
/* fr */ { IDS_SOUND_RECORDING_STOPPED_FR, "" },  /* fuzzy */
/* hu */ { IDS_SOUND_RECORDING_STOPPED_HU, "Hangfelvtel lelltva..." },
/* it */ { IDS_SOUND_RECORDING_STOPPED_IT, "Registrazione audio interrotta..." },
/* nl */ { IDS_SOUND_RECORDING_STOPPED_NL, "Geluidsopname gestopt..." },
/* pl */ { IDS_SOUND_RECORDING_STOPPED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SOUND_RECORDING_STOPPED_SV, "Ljudinspelning stoppad..." },
/* tr */ { IDS_SOUND_RECORDING_STOPPED_TR, "Ses Kayd durduruldu" },

/* en */ { IDS_SOUND_RECORDING_STARTED,    "Sound Recording started..." },
/* da */ { IDS_SOUND_RECORDING_STARTED_DA, "Lydoptagelse startet..." },
/* de */ { IDS_SOUND_RECORDING_STARTED_DE, "Tonaufnahme gestartet" },
/* fr */ { IDS_SOUND_RECORDING_STARTED_FR, "" },  /* fuzzy */
/* hu */ { IDS_SOUND_RECORDING_STARTED_HU, "Hangfelvtel elindtva..." },
/* it */ { IDS_SOUND_RECORDING_STARTED_IT, "Registrazione audio avviata..." },
/* nl */ { IDS_SOUND_RECORDING_STARTED_NL, "Geluidsopname gestart..." },
/* pl */ { IDS_SOUND_RECORDING_STARTED_PL, "" },  /* fuzzy */
/* sv */ { IDS_SOUND_RECORDING_STARTED_SV, "Ljudinspelning startad..." },
/* tr */ { IDS_SOUND_RECORDING_STARTED_TR, "Ses Kayd balad..." },

/* en */ { IDS_SELECT_RECORD_FILE,    "Select Sound Record File" },
/* da */ { IDS_SELECT_RECORD_FILE_DA, "Vlg lydoptagelsesfil" },
/* de */ { IDS_SELECT_RECORD_FILE_DE, "Tonaufnahmedatei definieren" },
/* fr */ { IDS_SELECT_RECORD_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SELECT_RECORD_FILE_HU, "Vlassza ki a hangfelvtel kimeneti fjlt" },
/* it */ { IDS_SELECT_RECORD_FILE_IT, "Seleziona file per registrazione audio" },
/* nl */ { IDS_SELECT_RECORD_FILE_NL, "Selecteer geluidsopnamebestand" },
/* pl */ { IDS_SELECT_RECORD_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SELECT_RECORD_FILE_SV, "Vlj ljudinspelningsfil" },
/* tr */ { IDS_SELECT_RECORD_FILE_TR, "Ses Kayt Dosyas Sein" },

/* en */ { IDS_SOUND_RECORD_FORMAT,    "Sound Record Format" },
/* da */ { IDS_SOUND_RECORD_FORMAT_DA, "Format for lydoptagelse" },
/* de */ { IDS_SOUND_RECORD_FORMAT_DE, "Tonaufnahmeformat" },
/* fr */ { IDS_SOUND_RECORD_FORMAT_FR, "" },  /* fuzzy */
/* hu */ { IDS_SOUND_RECORD_FORMAT_HU, "Hangfelvtel formtuma" },
/* it */ { IDS_SOUND_RECORD_FORMAT_IT, "Formato registrazione audio" },
/* nl */ { IDS_SOUND_RECORD_FORMAT_NL, "Geluidsopname Formaat..." },
/* pl */ { IDS_SOUND_RECORD_FORMAT_PL, "" },  /* fuzzy */
/* sv */ { IDS_SOUND_RECORD_FORMAT_SV, "Format fr ljudinspelning" },
/* tr */ { IDS_SOUND_RECORD_FORMAT_TR, "Ses Kayt Biimi" },

/* en */ { IDS_SOUND_RECORD_FILE,    "Sound Record File" },
/* da */ { IDS_SOUND_RECORD_FILE_DA, "Lydoptagelsesfil" },
/* de */ { IDS_SOUND_RECORD_FILE_DE, "Tonaufnahmedatei" },
/* fr */ { IDS_SOUND_RECORD_FILE_FR, "" },  /* fuzzy */
/* hu */ { IDS_SOUND_RECORD_FILE_HU, "Hangfelvtel fjl" },
/* it */ { IDS_SOUND_RECORD_FILE_IT, "File registrazione audio" },
/* nl */ { IDS_SOUND_RECORD_FILE_NL, "Geluid opnamebestand" },
/* pl */ { IDS_SOUND_RECORD_FILE_PL, "" },  /* fuzzy */
/* sv */ { IDS_SOUND_RECORD_FILE_SV, "Ljudinspelningsfil" },
/* tr */ { IDS_SOUND_RECORD_FILE_TR, "Ses Kayt Dosyas" },

/* en */ { IDS_SOUND_RECORD_SETTINGS,    "Sound record settings" },
/* da */ { IDS_SOUND_RECORD_SETTINGS_DA, "Lydoptagelsesindstillinger" },
/* de */ { IDS_SOUND_RECORD_SETTINGS_DE, "Tonaufnahme Einstellungen" },
/* fr */ { IDS_SOUND_RECORD_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_SOUND_RECORD_SETTINGS_HU, "Hangfelvtel belltsai" },
/* it */ { IDS_SOUND_RECORD_SETTINGS_IT, "Impostazioni registrazione audio" },
/* nl */ { IDS_SOUND_RECORD_SETTINGS_NL, "Geluidsopname instellingen" },
/* pl */ { IDS_SOUND_RECORD_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_SOUND_RECORD_SETTINGS_SV, "Instllningar fr ljudinspelning" },
/* tr */ { IDS_SOUND_RECORD_SETTINGS_TR, "Ses kayt ayarlar" },

/* en */ { IDS_SMALL,    "Small" },
/* da */ { IDS_SMALL_DA, "Lille" },
/* de */ { IDS_SMALL_DE, "Klein" },
/* fr */ { IDS_SMALL_FR, "" },  /* fuzzy */
/* hu */ { IDS_SMALL_HU, "Kicsi" },
/* it */ { IDS_SMALL_IT, "Piccolo" },
/* nl */ { IDS_SMALL_NL, "Klein" },
/* pl */ { IDS_SMALL_PL, "" },  /* fuzzy */
/* sv */ { IDS_SMALL_SV, "Liten" },
/* tr */ { IDS_SMALL_TR, "Kk" },

/* en */ { IDS_MEDIUM,    "Medium" },
/* da */ { IDS_MEDIUM_DA, "Medium" },
/* de */ { IDS_MEDIUM_DE, "Mittel" },
/* fr */ { IDS_MEDIUM_FR, "" },  /* fuzzy */
/* hu */ { IDS_MEDIUM_HU, "Kzepes" },
/* it */ { IDS_MEDIUM_IT, "Medio" },
/* nl */ { IDS_MEDIUM_NL, "Middelmatig" },
/* pl */ { IDS_MEDIUM_PL, "" },  /* fuzzy */
/* sv */ { IDS_MEDIUM_SV, "Medium" },
/* tr */ { IDS_MEDIUM_TR, "Orta" },

/* en */ { IDS_LARGE,    "Large" },
/* da */ { IDS_LARGE_DA, "Stor" },
/* de */ { IDS_LARGE_DE, "Gro" },
/* fr */ { IDS_LARGE_FR, "" },  /* fuzzy */
/* hu */ { IDS_LARGE_HU, "Nagy" },
/* it */ { IDS_LARGE_IT, "Grande" },
/* nl */ { IDS_LARGE_NL, "Groot" },
/* pl */ { IDS_LARGE_PL, "" },  /* fuzzy */
/* sv */ { IDS_LARGE_SV, "Stor" },
/* tr */ { IDS_LARGE_TR, "Byk" },

/* en */ { IDS_BORDER_MODE,    "Border mode" },
/* da */ { IDS_BORDER_MODE_DA, "Ramme-tilstand" },
/* de */ { IDS_BORDER_MODE_DE, "Rahmen Modus" },
/* fr */ { IDS_BORDER_MODE_FR, "" },  /* fuzzy */
/* hu */ { IDS_BORDER_MODE_HU, "Keret md" },
/* it */ { IDS_BORDER_MODE_IT, "Modalit del bordo" },
/* nl */ { IDS_BORDER_MODE_NL, "Bordermodus" },
/* pl */ { IDS_BORDER_MODE_PL, "" },  /* fuzzy */
/* sv */ { IDS_BORDER_MODE_SV, "Ramlge" },
/* tr */ { IDS_BORDER_MODE_TR, "ereve modu" },

/* en */ { IDMS_NORMAL,    "Normal" },
/* da */ { IDMS_NORMAL_DA, "Normal" },
/* de */ { IDMS_NORMAL_DE, "Normal" },
/* fr */ { IDMS_NORMAL_FR, "" },  /* fuzzy */
/* hu */ { IDMS_NORMAL_HU, "Norml" },
/* it */ { IDMS_NORMAL_IT, "Normale" },
/* nl */ { IDMS_NORMAL_NL, "Normaal" },
/* pl */ { IDMS_NORMAL_PL, "" },  /* fuzzy */
/* sv */ { IDMS_NORMAL_SV, "Normal" },
/* tr */ { IDMS_NORMAL_TR, "Normal" },

/* en */ { IDS_FULL,    "Full" },
/* da */ { IDS_FULL_DA, "Fuld" },
/* de */ { IDS_FULL_DE, "Full" },
/* fr */ { IDS_FULL_FR, "" },  /* fuzzy */
/* hu */ { IDS_FULL_HU, "Teljes" },
/* it */ { IDS_FULL_IT, "Intero" },
/* nl */ { IDS_FULL_NL, "&Volledig" },
/* pl */ { IDS_FULL_PL, "" },  /* fuzzy */
/* sv */ { IDS_FULL_SV, "Full" },
/* tr */ { IDS_FULL_TR, "Tam" },

/* en */ { IDS_DEBUG,    "Debug" },
/* da */ { IDS_DEBUG_DA, "Debug" },
/* de */ { IDS_DEBUG_DE, "Debug" },
/* fr */ { IDS_DEBUG_FR, "" },  /* fuzzy */
/* hu */ { IDS_DEBUG_HU, "Nyomkvets" },
/* it */ { IDS_DEBUG_IT, "Debug" },
/* nl */ { IDS_DEBUG_NL, "Debug" },
/* pl */ { IDS_DEBUG_PL, "" },  /* fuzzy */
/* sv */ { IDS_DEBUG_SV, "Felsk" },
/* tr */ { IDS_DEBUG_TR, "Hata Ayklama" },

/* en */ { IDS_VOLUME,    "Volume (0-100%)" },
/* da */ { IDS_VOLUME_DA, "Volume (0-100 %)" },
/* de */ { IDS_VOLUME_DE, "Lautstrke (0-100%)" },
/* fr */ { IDS_VOLUME_FR, "Volume (0-100%)" },
/* hu */ { IDS_VOLUME_HU, "Hanger (0-100%)" },
/* it */ { IDS_VOLUME_IT, "Volume (0-100%)" },
/* nl */ { IDS_VOLUME_NL, "Volume (0-100%)" },
/* pl */ { IDS_VOLUME_PL, "" },  /* fuzzy */
/* sv */ { IDS_VOLUME_SV, "Volym (0-100 %)" },
/* tr */ { IDS_VOLUME_TR, "Ses Dzeyi (0-100%)" },

/* en */ { IDS_MOUSE_TYPE,    "Mouse type" },
/* da */ { IDS_MOUSE_TYPE_DA, "Mussetype" },
/* de */ { IDS_MOUSE_TYPE_DE, "Maustyp" },
/* fr */ { IDS_MOUSE_TYPE_FR, "Type de souris" },
/* hu */ { IDS_MOUSE_TYPE_HU, "Egr tpusa" },
/* it */ { IDS_MOUSE_TYPE_IT, "Tipo di mouse" },
/* nl */ { IDS_MOUSE_TYPE_NL, "Muis soort" },
/* pl */ { IDS_MOUSE_TYPE_PL, "" },  /* fuzzy */
/* sv */ { IDS_MOUSE_TYPE_SV, "Mustyp" },
/* tr */ { IDS_MOUSE_TYPE_TR, "Mouse tipi" },

/* en */ { IDS_MOUSE_SETTINGS,    "Mouse Settings" },
/* da */ { IDS_MOUSE_SETTINGS_DA, "Musseindstillinger" },
/* de */ { IDS_MOUSE_SETTINGS_DE, "Maus Einstellungen" },
/* fr */ { IDS_MOUSE_SETTINGS_FR, "Paramtres de souris" },
/* hu */ { IDS_MOUSE_SETTINGS_HU, "Egr belltsok" },
/* it */ { IDS_MOUSE_SETTINGS_IT, "Impostazioni mouse" },
/* nl */ { IDS_MOUSE_SETTINGS_NL, "Muis instellingen" },
/* pl */ { IDS_MOUSE_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_MOUSE_SETTINGS_SV, "Musinstllningar" },
/* tr */ { IDS_MOUSE_SETTINGS_TR, "Mouse Ayarlar" },

/* en */ { IDS_MOUSE_PORT,    "Mouse port" },
/* da */ { IDS_MOUSE_PORT_DA, "Musseport" },
/* de */ { IDS_MOUSE_PORT_DE, "Maus Port" },
/* fr */ { IDS_MOUSE_PORT_FR, "Port de la souris" },
/* hu */ { IDS_MOUSE_PORT_HU, "Egr port" },
/* it */ { IDS_MOUSE_PORT_IT, "Porta del mouse" },
/* nl */ { IDS_MOUSE_PORT_NL, "Muis poort" },
/* pl */ { IDS_MOUSE_PORT_PL, "" },  /* fuzzy */
/* sv */ { IDS_MOUSE_PORT_SV, "Musport" },
/* tr */ { IDS_MOUSE_PORT_TR, "Mouse portu" },

/* en */ { IDS_MOUSE_1351,    "1351 mouse" },
/* da */ { IDS_MOUSE_1351_DA, "1351-mus" },
/* de */ { IDS_MOUSE_1351_DE, "1351 Maus" },
/* fr */ { IDS_MOUSE_1351_FR, "Souris 1351" },
/* hu */ { IDS_MOUSE_1351_HU, "1351 egr" },
/* it */ { IDS_MOUSE_1351_IT, "Mouse 1351" },
/* nl */ { IDS_MOUSE_1351_NL, "1351 muis" },
/* pl */ { IDS_MOUSE_1351_PL, "" },  /* fuzzy */
/* sv */ { IDS_MOUSE_1351_SV, "1351-mus" },
/* tr */ { IDS_MOUSE_1351_TR, "1351 mouse" },

/* en */ { IDS_MOUSE_NEOS,    "NEOS mouse" },
/* da */ { IDS_MOUSE_NEOS_DA, "NEOS-mus" },
/* de */ { IDS_MOUSE_NEOS_DE, "NEOS Maus" },
/* fr */ { IDS_MOUSE_NEOS_FR, "Souris NEOS" },
/* hu */ { IDS_MOUSE_NEOS_HU, "NEOS egr" },
/* it */ { IDS_MOUSE_NEOS_IT, "Mouse NEOS" },
/* nl */ { IDS_MOUSE_NEOS_NL, "NEOS muis" },
/* pl */ { IDS_MOUSE_NEOS_PL, "" },  /* fuzzy */
/* sv */ { IDS_MOUSE_NEOS_SV, "NEOS-mus" },
/* tr */ { IDS_MOUSE_NEOS_TR, "NEOS mouse" },

/* en */ { IDS_MOUSE_AMIGA,    "Amiga mouse" },
/* da */ { IDS_MOUSE_AMIGA_DA, "Amigamus" },
/* de */ { IDS_MOUSE_AMIGA_DE, "Amiga Maus" },
/* fr */ { IDS_MOUSE_AMIGA_FR, "Souris Amiga" },
/* hu */ { IDS_MOUSE_AMIGA_HU, "Amiga egr" },
/* it */ { IDS_MOUSE_AMIGA_IT, "Mouse Amiga" },
/* nl */ { IDS_MOUSE_AMIGA_NL, "Amiga muis" },
/* pl */ { IDS_MOUSE_AMIGA_PL, "" },  /* fuzzy */
/* sv */ { IDS_MOUSE_AMIGA_SV, "Amigamus" },
/* tr */ { IDS_MOUSE_AMIGA_TR, "Amiga mouse" },

/* en */ { IDS_MOUSE_PADDLES,    "Paddles" },
/* da */ { IDS_MOUSE_PADDLES_DA, "Paddles" },
/* de */ { IDS_MOUSE_PADDLES_DE, "Paddles" },
/* fr */ { IDS_MOUSE_PADDLES_FR, "" },  /* fuzzy */
/* hu */ { IDS_MOUSE_PADDLES_HU, "" },  /* fuzzy */
/* it */ { IDS_MOUSE_PADDLES_IT, "Paddle" },
/* nl */ { IDS_MOUSE_PADDLES_NL, "Paddles" },
/* pl */ { IDS_MOUSE_PADDLES_PL, "" },  /* fuzzy */
/* sv */ { IDS_MOUSE_PADDLES_SV, "Paddlar" },
/* tr */ { IDS_MOUSE_PADDLES_TR, "Paddlelar" },

/* en */ { IDS_AUTOSTART_VIRTUAL_FS,    "Virtual FS" },
/* da */ { IDS_AUTOSTART_VIRTUAL_FS_DA, "Virtuelt FS" },
/* de */ { IDS_AUTOSTART_VIRTUAL_FS_DE, "Virtual FS" },
/* fr */ { IDS_AUTOSTART_VIRTUAL_FS_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTOSTART_VIRTUAL_FS_HU, "Virtulis fjlrendszer" },
/* it */ { IDS_AUTOSTART_VIRTUAL_FS_IT, "Virtual FS" },
/* nl */ { IDS_AUTOSTART_VIRTUAL_FS_NL, "Virtueel Bestandssysteem" },
/* pl */ { IDS_AUTOSTART_VIRTUAL_FS_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_VIRTUAL_FS_SV, "Virtuellt FS" },
/* tr */ { IDS_AUTOSTART_VIRTUAL_FS_TR, "Sanal FS" },

/* en */ { IDS_AUTOSTART_INJECT,    "Inject to RAM" },
/* da */ { IDS_AUTOSTART_INJECT_DA, "Indskyd til RAM" },
/* de */ { IDS_AUTOSTART_INJECT_DE, "Inject ins RAM" },
/* fr */ { IDS_AUTOSTART_INJECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTOSTART_INJECT_HU, "" },  /* fuzzy */
/* it */ { IDS_AUTOSTART_INJECT_IT, "Immetti su RAM" },
/* nl */ { IDS_AUTOSTART_INJECT_NL, "injecteer in RAM" },
/* pl */ { IDS_AUTOSTART_INJECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_INJECT_SV, "Lgg in i RAM" },
/* tr */ { IDS_AUTOSTART_INJECT_TR, "RAM'e enjekte et" },

/* en */ { IDS_AUTOSTART_DISK,    "Disk image" },
/* da */ { IDS_AUTOSTART_DISK_DA, "Diskimage" },
/* de */ { IDS_AUTOSTART_DISK_DE, "Disk Image" },
/* fr */ { IDS_AUTOSTART_DISK_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTOSTART_DISK_HU, "Lemez kpms" },
/* it */ { IDS_AUTOSTART_DISK_IT, "Immagine disco" },
/* nl */ { IDS_AUTOSTART_DISK_NL, "Disk bestand" },
/* pl */ { IDS_AUTOSTART_DISK_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_DISK_SV, "Diskavbildning" },
/* tr */ { IDS_AUTOSTART_DISK_TR, "Disk imaj" },

/* en */ { IDS_AUTOSTART_DISK_IMAGE_SELECT,    "Select file for PRG autostart disk" },
/* da */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_DA, "Vlg fil for PRG autostartdiskette" },
/* de */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_DE, "Datei fr PRG Autostart auswhlen" },
/* fr */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_HU, "Vlasszon lemezfjlt a PRG automatikus indtshoz" },
/* it */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_IT, "Seleziona file per avvio automatico PRG" },
/* nl */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_NL, "Selecteer bestand voor PRG autostart disk" },
/* pl */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_SV, "Vlj fil fr PRG-autostartdisk" },
/* tr */ { IDS_AUTOSTART_DISK_IMAGE_SELECT_TR, "PRG otomatik balatma iin dosya sein" },

/* en */ { IDS_WARP_ON_AUTOSTART,    "Autostart warp" },
/* da */ { IDS_WARP_ON_AUTOSTART_DA, "Autostart i warp-tilstand" },
/* de */ { IDS_WARP_ON_AUTOSTART_DE, "Autostart Warp" },
/* fr */ { IDS_WARP_ON_AUTOSTART_FR, "" },  /* fuzzy */
/* hu */ { IDS_WARP_ON_AUTOSTART_HU, "Automatikus indts hipergyors" },
/* it */ { IDS_WARP_ON_AUTOSTART_IT, "Avvio automatico in turbo" },
/* nl */ { IDS_WARP_ON_AUTOSTART_NL, "Autostart warp" },
/* pl */ { IDS_WARP_ON_AUTOSTART_PL, "" },  /* fuzzy */
/* sv */ { IDS_WARP_ON_AUTOSTART_SV, "Starta warp automatiskt" },
/* tr */ { IDS_WARP_ON_AUTOSTART_TR, "Warp modunda otomatik balat" },

/* en */ { IDS_RUN_WITH_COLON,    "Use ':' with RUN" },
/* da */ { IDS_RUN_WITH_COLON_DA, "Brug \":\" med RUN" },
/* de */ { IDS_RUN_WITH_COLON_DE, "Verwende ':' mit RUN" },
/* fr */ { IDS_RUN_WITH_COLON_FR, "" },  /* fuzzy */
/* hu */ { IDS_RUN_WITH_COLON_HU, "" },  /* fuzzy */
/* it */ { IDS_RUN_WITH_COLON_IT, "Usa ':' con RUN" },
/* nl */ { IDS_RUN_WITH_COLON_NL, "Gebruik ':' met RUN" },
/* pl */ { IDS_RUN_WITH_COLON_PL, "" },  /* fuzzy */
/* sv */ { IDS_RUN_WITH_COLON_SV, "Anvnd \":\" med RUN" },
/* tr */ { IDS_RUN_WITH_COLON_TR, "ALITIR ile ':' kullan" },

/* en */ { IDS_AUTOSTART_PRG_MODE,    "PRG autostart mode" },
/* da */ { IDS_AUTOSTART_PRG_MODE_DA, "PRG-autostarttilstand" },
/* de */ { IDS_AUTOSTART_PRG_MODE_DE, "PRG Autostartmodus" },
/* fr */ { IDS_AUTOSTART_PRG_MODE_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTOSTART_PRG_MODE_HU, "PRG automatikus indts md" },
/* it */ { IDS_AUTOSTART_PRG_MODE_IT, "Avvio automatico PRG" },
/* nl */ { IDS_AUTOSTART_PRG_MODE_NL, "PRG autostart modus" },
/* pl */ { IDS_AUTOSTART_PRG_MODE_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_PRG_MODE_SV, "Autostartlge fr PRG" },
/* tr */ { IDS_AUTOSTART_PRG_MODE_TR, "PRG otomatik balatma modu" },

/* en */ { IDS_AUTOSTART_LOAD_TO_BASIC_START,    "Load to BASIC start" },
/* da */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_DA, "Indls ved BASIC start" },
/* de */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_DE, "Lade an Basic Start" },
/* fr */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_HU, "" },  /* fuzzy */
/* it */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_IT, "Carica all'inizio del BASIC" },
/* nl */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_NL, "Laad naar BASIC start" },
/* pl */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_SV, "Ls till BASIC-start" },
/* tr */ { IDS_AUTOSTART_LOAD_TO_BASIC_START_TR, "BASIC balangcna ykle" },

/* en */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME,    "PRG autostart disk image" },
/* da */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_DA, "PRG Autostart disk-image" },
/* de */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_DE, "PRG Autostart Disk Image" },
/* fr */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_HU, "PRG automatikus indts kpms" },
/* it */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_IT, "Immagine disco avvio automatico PRG" },
/* nl */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_NL, "PRG autostart disk bestand" },
/* pl */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_SV, "Autostartdiskavbildning fr PRG" },
/* tr */ { IDS_AUTOSTART_DISK_IMAGE_FILENAME_TR, "PRG otomatik balatma disk imaj" },

/* en */ { IDS_AUTOSTART_SETTINGS,    "Autostart settings" },
/* da */ { IDS_AUTOSTART_SETTINGS_DA, "Autostart-indstillinger" },
/* de */ { IDS_AUTOSTART_SETTINGS_DE, "Autostart Einstellungen" },
/* fr */ { IDS_AUTOSTART_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_AUTOSTART_SETTINGS_HU, "Autostart belltsai" },
/* it */ { IDS_AUTOSTART_SETTINGS_IT, "Impostazioni avvio automatico" },
/* nl */ { IDS_AUTOSTART_SETTINGS_NL, "Autostart instellingen" },
/* pl */ { IDS_AUTOSTART_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_AUTOSTART_SETTINGS_SV, "Autostartinstllningar" },
/* tr */ { IDS_AUTOSTART_SETTINGS_TR, "Otomatik balatma ayarlar" },

/* en */ { IDS_ERROR_SAVING_EASYFLASH_CRT,    "Error saving EasyFlash crt file" },
/* da */ { IDS_ERROR_SAVING_EASYFLASH_CRT_DA, "Fejl under skrivning af EasyFlash CRT-fil" },
/* de */ { IDS_ERROR_SAVING_EASYFLASH_CRT_DE, "Fehler beim Speichern der EasyFlash CRT Datei" },
/* fr */ { IDS_ERROR_SAVING_EASYFLASH_CRT_FR, "" },  /* fuzzy */
/* hu */ { IDS_ERROR_SAVING_EASYFLASH_CRT_HU, "Hiba az EasyFlash crt fjl mentse kzben" },
/* it */ { IDS_ERROR_SAVING_EASYFLASH_CRT_IT, "Errore durante il salvataggio del file crt EasyFlash" },
/* nl */ { IDS_ERROR_SAVING_EASYFLASH_CRT_NL, "Kan het EasyFlash crt bestand niet opslaan" },
/* pl */ { IDS_ERROR_SAVING_EASYFLASH_CRT_PL, "" },  /* fuzzy */
/* sv */ { IDS_ERROR_SAVING_EASYFLASH_CRT_SV, "Fel vid skrivning av EasyFlash-crt-fil." },
/* tr */ { IDS_ERROR_SAVING_EASYFLASH_CRT_TR, "EasyFlash crt dosyas kayt hatas" },

/* en */ { IDS_EASYFLASH_JUMPER,    "EasyFlash jumper" },
/* da */ { IDS_EASYFLASH_JUMPER_DA, "EasyFlashjumper" },
/* de */ { IDS_EASYFLASH_JUMPER_DE, "EasyFlash Jumper" },
/* fr */ { IDS_EASYFLASH_JUMPER_FR, "" },  /* fuzzy */
/* hu */ { IDS_EASYFLASH_JUMPER_HU, "EasyFlash jumper" },
/* it */ { IDS_EASYFLASH_JUMPER_IT, "Ponticello EasyFlash" },
/* nl */ { IDS_EASYFLASH_JUMPER_NL, "EasyFlash jumper" },
/* pl */ { IDS_EASYFLASH_JUMPER_PL, "" },  /* fuzzy */
/* sv */ { IDS_EASYFLASH_JUMPER_SV, "EasyFlash-bygel" },
/* tr */ { IDS_EASYFLASH_JUMPER_TR, "EasyFlash jumper" },

/* en */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH,    "Save to EasyFlash CRT file on detach" },
/* da */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_DA, "Gem til EasyFlash CRT-fil ved afbrydelse" },
/* de */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_DE, "EasyFlash CRT Imagedatei beim entfernen speichern" },
/* fr */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_HU, "EasyFlash CRT fjl mentse levlasztskor" },
/* it */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_IT, "Salva su file CRT EasyFlash alla rimozione" },
/* nl */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_NL, "Sla op naar het EasyFlash CRT bestand bij ontkoppelen" },
/* pl */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_SV, "Spara till EasyFlash-CRT-fil vid frnkoppling" },
/* tr */ { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_TR, "kartldnda EasyFlash CRT dosyasna kaydet" },

/* en */ { IDS_SAVE_EASYFLASH_CRT_NOW,    "Save to EasyFlash CRT now" },
/* da */ { IDS_SAVE_EASYFLASH_CRT_NOW_DA, "Gem til EasyFlash CRT nu" },
/* de */ { IDS_SAVE_EASYFLASH_CRT_NOW_DE, "EasyFlash CRT Imagedatei jetzt speichern" },
/* fr */ { IDS_SAVE_EASYFLASH_CRT_NOW_FR, "" },  /* fuzzy */
/* hu */ { IDS_SAVE_EASYFLASH_CRT_NOW_HU, "EasyFlash CRT fjl mentse most" },
/* it */ { IDS_SAVE_EASYFLASH_CRT_NOW_IT, "Salva su CRT EasyFlash ora" },
/* nl */ { IDS_SAVE_EASYFLASH_CRT_NOW_NL, "Sla nu op naar het EasyFlash CRT bestand" },
/* pl */ { IDS_SAVE_EASYFLASH_CRT_NOW_PL, "" },  /* fuzzy */
/* sv */ { IDS_SAVE_EASYFLASH_CRT_NOW_SV, "Spara till EasyFlash-CRT nu" },
/* tr */ { IDS_SAVE_EASYFLASH_CRT_NOW_TR, "Hemen EasyFlash CRT'ye kaydet" },

/* en */ { IDS_6569_PAL,    "6569 (PAL)" },
/* da */ { IDS_6569_PAL_DA, "6569 (PAL)" },
/* de */ { IDS_6569_PAL_DE, "6569 (PAL)" },
/* fr */ { IDS_6569_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDS_6569_PAL_HU, "" },  /* fuzzy */
/* it */ { IDS_6569_PAL_IT, "6569 (PAL)" },
/* nl */ { IDS_6569_PAL_NL, "6569 (PAL)" },
/* pl */ { IDS_6569_PAL_PL, "" },  /* fuzzy */
/* sv */ { IDS_6569_PAL_SV, "6569 (PAL)" },
/* tr */ { IDS_6569_PAL_TR, "6569 (PAL)" },

/* en */ { IDS_8565_PAL,    "8565 (PAL)" },
/* da */ { IDS_8565_PAL_DA, "8565 (PAL)" },
/* de */ { IDS_8565_PAL_DE, "8565 (PAL)" },
/* fr */ { IDS_8565_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDS_8565_PAL_HU, "" },  /* fuzzy */
/* it */ { IDS_8565_PAL_IT, "8565 (PAL)" },
/* nl */ { IDS_8565_PAL_NL, "8565 (PAL)" },
/* pl */ { IDS_8565_PAL_PL, "" },  /* fuzzy */
/* sv */ { IDS_8565_PAL_SV, "8565 (PAL)" },
/* tr */ { IDS_8565_PAL_TR, "8565 (PAL)" },

/* en */ { IDS_6569R1_OLD_PAL,    "6569R1 (old PAL)" },
/* da */ { IDS_6569R1_OLD_PAL_DA, "6569R1 (gammel PAL)" },
/* de */ { IDS_6569R1_OLD_PAL_DE, "6569R1 (alt PAL)" },
/* fr */ { IDS_6569R1_OLD_PAL_FR, "" },  /* fuzzy */
/* hu */ { IDS_6569R1_OLD_PAL_HU, "" },  /* fuzzy */
/* it */ { IDS_6569R1_OLD_PAL_IT, "6569R1 (PAL vecchio)" },
/* nl */ { IDS_6569R1_OLD_PAL_NL, "6569R1 (oud PAL)" },
/* pl */ { IDS_6569R1_OLD_PAL_PL, "" },  /* fuzzy */
/* sv */ { IDS_6569R1_OLD_PAL_SV, "6569R1 (gammal PAL)" },
/* tr */ { IDS_6569R1_OLD_PAL_TR, "6569R1 (eski PAL)" },

/* en */ { IDS_6567_NTSC,    "6567 (NTSC)" },
/* da */ { IDS_6567_NTSC_DA, "6567 (NTSC)" },
/* de */ { IDS_6567_NTSC_DE, "6567 (NTSC)" },
/* fr */ { IDS_6567_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDS_6567_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDS_6567_NTSC_IT, "6567 (NTSC)" },
/* nl */ { IDS_6567_NTSC_NL, "6567 (NTSC)" },
/* pl */ { IDS_6567_NTSC_PL, "" },  /* fuzzy */
/* sv */ { IDS_6567_NTSC_SV, "6567 (NTSC)" },
/* tr */ { IDS_6567_NTSC_TR, "6567 (NTSC)" },

/* en */ { IDS_8562_NTSC,    "8562 (NTSC)" },
/* da */ { IDS_8562_NTSC_DA, "8562 (NTSC)" },
/* de */ { IDS_8562_NTSC_DE, "8562 (NTSC)" },
/* fr */ { IDS_8562_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDS_8562_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDS_8562_NTSC_IT, "8562 (NTSC)" },
/* nl */ { IDS_8562_NTSC_NL, "8562 (NTSC)" },
/* pl */ { IDS_8562_NTSC_PL, "" },  /* fuzzy */
/* sv */ { IDS_8562_NTSC_SV, "8562 (NTSC)" },
/* tr */ { IDS_8562_NTSC_TR, "8562 (NTSC)" },

/* en */ { IDS_6567R56A_OLD_NTSC,    "6567R56A (old NTSC)" },
/* da */ { IDS_6567R56A_OLD_NTSC_DA, "6567R56A (gammel NTSC)" },
/* de */ { IDS_6567R56A_OLD_NTSC_DE, "6567R56A (alt NTSC)" },
/* fr */ { IDS_6567R56A_OLD_NTSC_FR, "" },  /* fuzzy */
/* hu */ { IDS_6567R56A_OLD_NTSC_HU, "" },  /* fuzzy */
/* it */ { IDS_6567R56A_OLD_NTSC_IT, "6567R56A (NTSC vecchio)" },
/* nl */ { IDS_6567R56A_OLD_NTSC_NL, "6567R56A (oud NTSC)" },
/* pl */ { IDS_6567R56A_OLD_NTSC_PL, "" },  /* fuzzy */
/* sv */ { IDS_6567R56A_OLD_NTSC_SV, "6567R56A (gammal NTSC)" },
/* tr */ { IDS_6567R56A_OLD_NTSC_TR, "6567R56A (eski NTSC)" },

/* en */ { IDS_6572_PAL_N,    "6572 (PAL-N)" },
/* da */ { IDS_6572_PAL_N_DA, "6572 (PAL-N)" },
/* de */ { IDS_6572_PAL_N_DE, "6572 (PAL-N)" },
/* fr */ { IDS_6572_PAL_N_FR, "" },  /* fuzzy */
/* hu */ { IDS_6572_PAL_N_HU, "" },  /* fuzzy */
/* it */ { IDS_6572_PAL_N_IT, "6572 (PAL-N)" },
/* nl */ { IDS_6572_PAL_N_NL, "6572 (PAL-N)" },
/* pl */ { IDS_6572_PAL_N_PL, "" },  /* fuzzy */
/* sv */ { IDS_6572_PAL_N_SV, "6572 (PAL-N)" },
/* tr */ { IDS_6572_PAL_N_TR, "6572 (PAL-N)" },

/* en */ { IDS_6526_OLD,    "6526 (old)" },
/* da */ { IDS_6526_OLD_DA, "6526 (gammel)" },
/* de */ { IDS_6526_OLD_DE, "6526 (alt)" },
/* fr */ { IDS_6526_OLD_FR, "" },  /* fuzzy */
/* hu */ { IDS_6526_OLD_HU, "" },  /* fuzzy */
/* it */ { IDS_6526_OLD_IT, "6526 (vecchio)" },
/* nl */ { IDS_6526_OLD_NL, "6526 (oud)" },
/* pl */ { IDS_6526_OLD_PL, "" },  /* fuzzy */
/* sv */ { IDS_6526_OLD_SV, "6526 (gammal)" },
/* tr */ { IDS_6526_OLD_TR, "6526 (eski)" },

/* en */ { IDS_6526A_NEW,    "6526A (new)" },
/* da */ { IDS_6526A_NEW_DA, "6526A (ny)" },
/* de */ { IDS_6526A_NEW_DE, "6526A (neu)" },
/* fr */ { IDS_6526A_NEW_FR, "" },  /* fuzzy */
/* hu */ { IDS_6526A_NEW_HU, "" },  /* fuzzy */
/* it */ { IDS_6526A_NEW_IT, "6526A (nuovo)" },
/* nl */ { IDS_6526A_NEW_NL, "6526A (nieuw)" },
/* pl */ { IDS_6526A_NEW_PL, "" },  /* fuzzy */
/* sv */ { IDS_6526A_NEW_SV, "6526A (ny)" },
/* tr */ { IDS_6526A_NEW_TR, "6526A (yeni)" },

/* en */ { IDS_DISCRETE,    "Discrete" },
/* da */ { IDS_DISCRETE_DA, "Diskret" },
/* de */ { IDS_DISCRETE_DE, "Diskret" },
/* fr */ { IDS_DISCRETE_FR, "" },  /* fuzzy */
/* hu */ { IDS_DISCRETE_HU, "" },  /* fuzzy */
/* it */ { IDS_DISCRETE_IT, "Discreto" },
/* nl */ { IDS_DISCRETE_NL, "Diskreet" },
/* pl */ { IDS_DISCRETE_PL, "" },  /* fuzzy */
/* sv */ { IDS_DISCRETE_SV, "Diskret" },
/* tr */ { IDS_DISCRETE_TR, "Balanty kes" },

/* en */ { IDS_CUSTOM_IC,    "Custom IC" },
/* da */ { IDS_CUSTOM_IC_DA, "Egen IC" },
/* de */ { IDS_CUSTOM_IC_DE, "Benutzerdefinierte IC" },
/* fr */ { IDS_CUSTOM_IC_FR, "" },  /* fuzzy */
/* hu */ { IDS_CUSTOM_IC_HU, "" },  /* fuzzy */
/* it */ { IDS_CUSTOM_IC_IT, "IC personalizzato" },
/* nl */ { IDS_CUSTOM_IC_NL, "Aangepast IC" },
/* pl */ { IDS_CUSTOM_IC_PL, "" },  /* fuzzy */
/* sv */ { IDS_CUSTOM_IC_SV, "Egen krets" },
/* tr */ { IDS_CUSTOM_IC_TR, "zel IC" },

/* en */ { IDS_VICII_MODEL,    "VIC-II model" },
/* da */ { IDS_VICII_MODEL_DA, "VIC-II-model" },
/* de */ { IDS_VICII_MODEL_DE, "VIC-II Modell" },
/* fr */ { IDS_VICII_MODEL_FR, "" },  /* fuzzy */
/* hu */ { IDS_VICII_MODEL_HU, "" },  /* fuzzy */
/* it */ { IDS_VICII_MODEL_IT, "Modello VIC-II" },
/* nl */ { IDS_VICII_MODEL_NL, "VIC-II model" },
/* pl */ { IDS_VICII_MODEL_PL, "" },  /* fuzzy */
/* sv */ { IDS_VICII_MODEL_SV, "VIC II-modell" },
/* tr */ { IDS_VICII_MODEL_TR, "VIC-II modeli" },

/* en */ { IDS_CIA1_MODEL,    "CIA 1 model" },
/* da */ { IDS_CIA1_MODEL_DA, "CIA 1 model" },
/* de */ { IDS_CIA1_MODEL_DE, "CIA 1 Modell" },
/* fr */ { IDS_CIA1_MODEL_FR, "" },  /* fuzzy */
/* hu */ { IDS_CIA1_MODEL_HU, "" },  /* fuzzy */
/* it */ { IDS_CIA1_MODEL_IT, "Modello CIA 1" },
/* nl */ { IDS_CIA1_MODEL_NL, "CIA 1 model" },
/* pl */ { IDS_CIA1_MODEL_PL, "" },  /* fuzzy */
/* sv */ { IDS_CIA1_MODEL_SV, "CIA 1-modell" },
/* tr */ { IDS_CIA1_MODEL_TR, "CIA 1 modeli" },

/* en */ { IDS_CIA2_MODEL,    "CIA 2 model" },
/* da */ { IDS_CIA2_MODEL_DA, "CIA 2 model" },
/* de */ { IDS_CIA2_MODEL_DE, "CIA 2 Modell" },
/* fr */ { IDS_CIA2_MODEL_FR, "" },  /* fuzzy */
/* hu */ { IDS_CIA2_MODEL_HU, "" },  /* fuzzy */
/* it */ { IDS_CIA2_MODEL_IT, "Modello CIA 2" },
/* nl */ { IDS_CIA2_MODEL_NL, "CIA 2 model" },
/* pl */ { IDS_CIA2_MODEL_PL, "" },  /* fuzzy */
/* sv */ { IDS_CIA2_MODEL_SV, "CIA 2-modell" },
/* tr */ { IDS_CIA2_MODEL_TR, "CIA 2 modeli" },

/* en */ { IDS_GLUE_LOGIC,    "Glue logic" },
/* da */ { IDS_GLUE_LOGIC_DA, "Glue logic" },
/* de */ { IDS_GLUE_LOGIC_DE, "Glue Logik" },
/* fr */ { IDS_GLUE_LOGIC_FR, "Glue logic" },
/* hu */ { IDS_GLUE_LOGIC_HU, "" },  /* fuzzy */
/* it */ { IDS_GLUE_LOGIC_IT, "Glue logic" },
/* nl */ { IDS_GLUE_LOGIC_NL, "Glue logic" },
/* pl */ { IDS_GLUE_LOGIC_PL, "" },  /* fuzzy */
/* sv */ { IDS_GLUE_LOGIC_SV, "Klisterlogik" },
/* tr */ { IDS_GLUE_LOGIC_TR, "Glue logic" },

/* en */ { IDS_C64_MODEL_SETTINGS,    "C64 model settings" },
/* da */ { IDS_C64_MODEL_SETTINGS_DA, "C64-model indstillinger" },
/* de */ { IDS_C64_MODEL_SETTINGS_DE, "C64 Modell Einstellungen" },
/* fr */ { IDS_C64_MODEL_SETTINGS_FR, "" },  /* fuzzy */
/* hu */ { IDS_C64_MODEL_SETTINGS_HU, "" },  /* fuzzy */
/* it */ { IDS_C64_MODEL_SETTINGS_IT, "Impostazioni modello C64" },
/* nl */ { IDS_C64_MODEL_SETTINGS_NL, "C64 model instellingen" },
/* pl */ { IDS_C64_MODEL_SETTINGS_PL, "" },  /* fuzzy */
/* sv */ { IDS_C64_MODEL_SETTINGS_SV, "C64-modellinstllningar" },
/* tr */ { IDS_C64_MODEL_SETTINGS_TR, "C64 model ayarlar" },

};
