/* ChemicalEnergy.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.chemical;

import org.grinvin.graphs.GraphBundleView;
import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantManager;
import org.grinvin.invariants.UnknownInvariantException;
import org.grinvin.invariants.computers.AbstractInvariantComputer;
import org.grinvin.invariants.values.ListOfRealsValue;
import org.grinvin.invariants.values.RealValue;

/**
 * Invariant computer which returns the chemical energy of the graph.
 */
public class ChemicalEnergy extends AbstractInvariantComputer {
    
    public RealValue compute (GraphBundleView bundle) {
        Invariant inv;
        try {
            inv = InvariantManager.getInstance().getInvariant("org.grinvin.invariants.Eigenvalues");
        } catch (UnknownInvariantException ex) {
            throw new RuntimeException("This invariant couldn't be computed.", ex);
        }
        ListOfRealsValue circ = (ListOfRealsValue)bundle.getInvariantValue(inv);
        double[] eigenValues = circ.getValues();

        if(eigenValues.length == 0 || eigenValues.length % 2 != 0)
            //chemical energy only defined for n-electron \pi-system (n even)
            return RealValue.undefinedValue(this);
        double energy = 0.0;
        for(int i = 0; i<eigenValues.length/2; i++)
            energy += eigenValues[i];
        return new RealValue (2*energy, this);
    }
    
    public String getInvariantId () {
        return "org.grinvin.invariants.ChemicalEnergy";
    }
    
}
