/* ParameterEditor.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.params;


/**
 * Helper object for editing parameter values of a certain type. This type is
 * only implicitely associated to this editor. Knows how to 
 * convert values from and to a textual representation and how to 
 * delegate parameter value editing to an 
 * appropriate {@link ParameterComponent}.
 */
public interface ParameterEditor {
    
    /**
     * Convert the given string to a parameter value. The resulting object
     * belongs to the type  which is implicitely associated with this editor.
     */
    public Object fromText (String string);
    
    /**
     * Convert the given parameter value to a textual representation. May throw
     * an exception when the given value does not belong to the type  which is 
     * implicitely associated with this editor.
     */
    public String toText (Object value);
    
    /**
     * Return a stand alone component which can be used to edit a parameter 
     * of the type which is implicitely associated with this editor. 
     * This component should be an extension of 
     * {@link java.awt.Component} or preferably of
     * {@link javax.swing.JComponent}.
     */
    public ParameterComponent getEditorComponent ();
    
}
