<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
  graph2svg.xslt
  =========================================================================
  This file is part of the GrInvIn project - http://www.grinvin.org
  
  Copyright (C) 2005-2008 Universiteit Gent
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or (at
  your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  A copy of the GNU General Public License can be found in the file
  LICENSE.txt provided with the source distribution of this program (see
  the META-INF directory in the source jar). This license can also be
  found on the GNU website at http://www.gnu.org/licenses/gpl.html.
  
  If you did not receive a copy of the GNU General Public License along
  with this program, contact the lead developer, or write to the Free
  Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
-->

<xsl:transform version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:svg="http://www.w3.org/2000/svg">
    <xsl:param name="linefactor" select="1"/>
    <xsl:param name="radius" select="1"/>
    <xsl:param name="height" select="30"/>
    <xsl:param name="width" select="30"/>
    <xsl:param name="x" select="0"/>
    <xsl:param name="y" select="0"/>
    <xsl:param name="scale" select="10"/>
    <xsl:key name="vertex" match="coordinates" use="@id"/>

    <xsl:template match="root">
        <svg:svg width="{$width}" height="{$height}">
            <xsl:apply-templates select="graph"/>
            <xsl:apply-templates select="embedding"/>
        </svg:svg>
    </xsl:template>
    <xsl:template match="coordinates">
        <svg:circle r="{0.75*$linefactor*$radius}" style="stroke:black; stroke-width:{0.5*$linefactor}; fill:white;" cx="{number(double[1]/@value)*$scale + $width*0.5 + $x}" cy="{$height*0.5 - number(double[2]/@value)*$scale - $y}"/>
    </xsl:template>
    <xsl:template match="edge">
        <svg:line style="stroke:black; stroke-width:{0.5*$linefactor}; fill:none;" x1="{number(key('vertex',@from)/double[1]/@value)*$scale + $width*0.5 + $x}" y1="{$height*0.5 - number(key('vertex',@from)/double[2]/@value)*$scale - $y}" x2="{number(key('vertex',@to)/double[1]/@value)*$scale + $width*0.5 + $x}" y2="{$height*0.5 - number(key('vertex',@to)/double[2]/@value)*$scale - $y}"/>
    </xsl:template>
</xsl:transform>
