/* InvariantListHelpManager.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.help.CSH.Manager;
import javax.help.HelpSet;

import org.grinvin.gui.components.InvariantListComponent;
import org.grinvin.invariants.Invariant;

/**
 * Provides dynamic map ID assignment for a list of invariants.
 */
public class InvariantListHelpManager implements Manager {
    
    private InvariantListComponent list;
    
    /** Creates a new instance of InvariantListHelpManager */
    public InvariantListHelpManager(InvariantListComponent list) {
        this.list = list;
    }
    
    public HelpSet getHelpSet(Object object, AWTEvent aWTEvent) {
        return HelpManager.getHelpSet();
    }
    
    public String getHelpIDString(Object object, AWTEvent aWTEvent) {
        if(object.equals(list)){
            if(aWTEvent instanceof MouseEvent){
                MouseEvent e = (MouseEvent) aWTEvent;
                Point parentPosition = ((Component)e.getSource()).getLocationOnScreen();
                Point listPosition = list.getLocationOnScreen();
                e.translatePoint(parentPosition.x - listPosition.x, parentPosition.y - listPosition.y);
                int selectedIndex = list.locationToIndex(e.getPoint());
                if(selectedIndex >= 0) {
                    list.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
                    return validateID(((Invariant)(list.getSelectedValue())).getId());
                }
                return null;
            } else if (aWTEvent instanceof ActionEvent) {
                Object selection = list.getSelectedValue();
                if(selection==null)
                    return null;
                return validateID(((Invariant)selection).getId());
            }
            return null;
        } else
            return null;
    }
    
    private String validateID(String id) {
        HelpSet hs = HelpManager.getHelpSet();
        if(hs.getCombinedMap().isValidID(id, hs))
            return id;
        else if(id.indexOf('?')>-1)
            return validateID(id.substring(0, id.indexOf('?')));
        else
            return null;
    }
}
