/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIVE.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgValExpand(const char * const name, char * dflt);

	Return the data of the value of the specified name parsed as 
	expandable string.
	If name == NULL, the currently scanned value is processed.

	Return:
		dlft: on error
		else: pointer to internal buffer with comment

ob: cfgValExpand
su: inifile/2
sh: Return a value as expandable string
lo: Return the data of the specified value parsed as expandable string.\par
	If \para{name} == NULL, the current value is processed.
va: dflt: on error
	\item else: pointer to internal buffer with expanded string
wa: The returned string must not be modified.
re: cfgValInteger
fi: cfgive.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIVE.C 1.4 2001/02/27 01:27:46 ska Exp ska $";
#endif

char *cfgValExpand(const char * const name, char * const dflt)
{	DBG_ENTER("cfgValExpand", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\", dflt=\"%s\"", name, dflt) )

	chkHeap
	if(cfgHasValue(name) == 0			/* fetch the value */
	 && !I(decomposed))				/* not parsed already */
		I(type) |= CFG_TEXPAND;		/* mark as expandable */
	chkHeap
	DBG_RETURN_BS( cfgi_parseVal(0) == 0	/* decompose the fetched value */
		?	I(data)				/* success */
		:	dflt)				/* failure */
}
